/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigInteger;
import java.util.ArrayList;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.cast.ArrayAttributeCastNodeGen;
import org.jruby.truffle.core.cast.TaintResultNode;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.encoding.EncodingOperations;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.ConcatRope;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.RepeatingRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeBuffer;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.rope.SubstringRope;
import org.jruby.truffle.core.rubinius.RubiniusPrimitive;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.core.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.core.string.StringGuards;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.StringSupport;

public abstract class StringPrimitiveNodes {

    @RubiniusPrimitive(name="string_from_bytearray", needsSelf=false, lowerFixnumParameters={1, 2})
    public static abstract class StringFromByteArrayPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubiniusByteArray(bytes)"})
        public DynamicObject stringFromByteArray(DynamicObject bytes, int start, int count) {
            ByteList byteList = Layouts.BYTE_ARRAY.getBytes(bytes);
            return this.createString(new ByteList(byteList, start, count));
        }
    }

    @RubiniusPrimitive(name="string_substring", lowerFixnumParameters={0, 1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringSubstringPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public abstract Object execute(VirtualFrame var1, DynamicObject var2, int var3, int var4);

        @Specialization(guards={"!indexTriviallyOutOfBounds(string, beg, len)"})
        public Object stringSubstring(DynamicObject string, int beg, int len, @Cached(value="createBinaryProfile()") ConditionProfile negativeIndexProfile, @Cached(value="createBinaryProfile()") ConditionProfile stillNegativeIndexProfile, @Cached(value="createBinaryProfile()") ConditionProfile tooLargeTotalProfile, @Cached(value="createBinaryProfile()") ConditionProfile singleByteOptimizableProfile, @Cached(value="createBinaryProfile()") ConditionProfile mutableRopeProfile, @Cached(value="createBinaryProfile()") ConditionProfile foundSingleByteOptimizableDescendentProfile) {
            Rope rope = StringOperations.rope(string);
            int index = beg;
            int length = len;
            if (negativeIndexProfile.profile(index < 0) && stillNegativeIndexProfile.profile((index += rope.characterLength()) < 0)) {
                return this.nil();
            }
            if (tooLargeTotalProfile.profile(index + length > rope.characterLength())) {
                length = rope.characterLength() - index;
            }
            if (singleByteOptimizableProfile.profile(length == 0 || rope.isSingleByteOptimizable())) {
                if (mutableRopeProfile.profile(rope instanceof RopeBuffer)) {
                    return this.makeBuffer(string, index, length);
                }
                return this.makeRope(string, rope, index, length);
            }
            Rope searched = this.searchForSingleByteOptimizableDescendant(rope, index, length);
            if (foundSingleByteOptimizableDescendentProfile.profile(searched.isSingleByteOptimizable())) {
                return this.makeRope(string, searched, index, length);
            }
            return this.stringSubstringMultitByte(string, index, length);
        }

        @CompilerDirectives.TruffleBoundary
        private Rope searchForSingleByteOptimizableDescendant(Rope base, int index, int length) {
            if (base.isSingleByteOptimizable()) {
                return base;
            }
            if (base instanceof LeafRope) {
                return base;
            }
            if (base instanceof SubstringRope) {
                SubstringRope substringRope = (SubstringRope)base;
                return this.searchForSingleByteOptimizableDescendant(substringRope.getChild(), index + substringRope.getOffset(), length);
            }
            if (base instanceof ConcatRope) {
                ConcatRope concatRope = (ConcatRope)base;
                Rope left = concatRope.getLeft();
                Rope right = concatRope.getRight();
                if (index < left.byteLength()) {
                    return this.searchForSingleByteOptimizableDescendant(left, index, length);
                }
                if (index >= left.byteLength()) {
                    return this.searchForSingleByteOptimizableDescendant(right, index - left.byteLength(), length);
                }
                return concatRope;
            }
            if (base instanceof RepeatingRope) {
                RepeatingRope repeatingRope = (RepeatingRope)base;
                if (index + length < repeatingRope.getChild().byteLength()) {
                    return this.searchForSingleByteOptimizableDescendant(repeatingRope.getChild(), index, length);
                }
                return repeatingRope;
            }
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("Don't know how to traverse rope type: " + base.getClass().getName());
        }

        @CompilerDirectives.TruffleBoundary
        private Object stringSubstringMultitByte(DynamicObject string, int beg, int len) {
            int p;
            Rope rope = StringOperations.rope(string);
            int length = rope.byteLength();
            boolean isMutableRope = rope instanceof RopeBuffer;
            Encoding enc = rope.getEncoding();
            int s = 0;
            int end = s + length;
            byte[] bytes = rope.getBytes();
            if (beg < 0) {
                if (len > -beg) {
                    len = -beg;
                }
                if (-beg * enc.maxLength() < length >>> 3) {
                    beg = -beg;
                    int e = end;
                    while (beg-- > len && (e = enc.prevCharHead(bytes, s, e, e)) != -1) {
                    }
                    int p2 = e;
                    if (p2 == -1) {
                        return this.nil();
                    }
                    while (len-- > 0 && (p2 = enc.prevCharHead(bytes, s, p2, e)) != -1) {
                    }
                    if (p2 == -1) {
                        return this.nil();
                    }
                    if (isMutableRope) {
                        return this.makeBuffer(string, p2 - s, e - p2);
                    }
                    return this.makeRope(string, rope, p2 - s, e - p2);
                }
                if ((beg += rope.characterLength()) < 0) {
                    return this.nil();
                }
            } else if (beg > 0 && beg > rope.characterLength()) {
                return this.nil();
            }
            if (len == 0) {
                p = 0;
            } else if (StringOperations.isCodeRangeValid(string) && enc instanceof UTF8Encoding) {
                p = StringSupport.utf8Nth((byte[])bytes, (int)s, (int)end, (int)beg);
                len = StringSupport.utf8Offset((byte[])bytes, (int)p, (int)end, (int)len);
            } else if (enc.isFixedWidth()) {
                int w = enc.maxLength();
                p = s + beg * w;
                if (p > end) {
                    p = end;
                    len = 0;
                } else {
                    len = len * w > end - p ? end - p : (len *= w);
                }
            } else {
                p = StringSupport.nth((Encoding)enc, (byte[])bytes, (int)s, (int)end, (int)beg);
                len = p == end ? 0 : StringSupport.offset((Encoding)enc, (byte[])bytes, (int)p, (int)end, (int)len);
            }
            if (isMutableRope) {
                return this.makeBuffer(string, p - s, len);
            }
            return this.makeRope(string, rope, p - s, len);
        }

        @Specialization(guards={"indexTriviallyOutOfBounds(string, beg, len)"})
        public Object stringSubstringNegativeLength(DynamicObject string, int beg, int len) {
            return this.nil();
        }

        protected static boolean indexTriviallyOutOfBounds(DynamicObject string, int index, int length) {
            assert (RubyGuards.isRubyString(string));
            return length < 0 || index > StringOperations.rope(string).characterLength();
        }

        private DynamicObject makeRope(DynamicObject string, Rope rope, int beg, int len) {
            assert (RubyGuards.isRubyString(string));
            if (this.allocateNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.allocateNode = this.insert(AllocateObjectNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            if (this.makeSubstringNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.makeSubstringNode = this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            DynamicObject ret = this.allocateNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, beg, len), null);
            this.taintResultNode.maybeTaint(string, ret);
            return ret;
        }

        private DynamicObject makeBuffer(DynamicObject string, int beg, int len) {
            assert (RubyGuards.isRubyString(string));
            RopeBuffer buffer = (RopeBuffer)StringOperations.rope(string);
            if (this.allocateNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.allocateNode = this.insert(AllocateObjectNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            DynamicObject ret = this.allocateNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), new RopeBuffer(new ByteList(buffer.getByteList(), beg, len), buffer.getCodeRange(), buffer.isSingleByteOptimizable(), len), null);
            this.taintResultNode.maybeTaint(string, ret);
            return ret;
        }
    }

    @RubiniusPrimitive(name="string_byte_append")
    public static abstract class StringByteAppendPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeConcatNode makeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode = RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null);

        public StringByteAppendPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(other)"})
        public DynamicObject stringByteAppend(DynamicObject string, DynamicObject other) {
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            LeafRope rightConverted = this.makeLeafRopeNode.executeMake(right.getBytes(), left.getEncoding(), left.getCodeRange(), NotProvided.INSTANCE);
            StringOperations.setRope(string, this.makeConcatNode.executeMake(left, rightConverted, left.getEncoding()));
            return string;
        }
    }

    @RubiniusPrimitive(name="string_to_inum")
    public static abstract class StringToInumPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object stringToInum(DynamicObject string, int fixBase, boolean strict) {
            try {
                RubyInteger result = ConvertBytes.byteListToInum19((Ruby)this.getContext().getJRubyRuntime(), (ByteList)StringOperations.getByteListReadOnly(string), (int)fixBase, (boolean)strict);
                return this.toTruffle((IRubyObject)result);
            }
            catch (RaiseException e) {
                throw new org.jruby.truffle.language.control.RaiseException(this.getContext().getJRubyInterop().toTruffle(e.getException(), this));
            }
        }

        private Object toTruffle(IRubyObject object) {
            if (object instanceof RubyFixnum) {
                long value = ((RubyFixnum)object).getLongValue();
                if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                    return value;
                }
                return (int)value;
            }
            if (object instanceof RubyBignum) {
                BigInteger value = ((RubyBignum)object).getBigIntegerValue();
                return this.createBignum(value);
            }
            throw new UnsupportedOperationException();
        }
    }

    @RubiniusPrimitive(name="string_splice", needsSelf=false, lowerFixnumParameters={2, 3})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringSplicePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeConcatNode appendMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode prependMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode leftMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeConcatNode rightMakeConcatNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode prependMakeSubstringNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode leftMakeSubstringNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode rightMakeSubstringNode;

        @Specialization(guards={"indexAtStartBound(spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)"})
        public Object splicePrepend(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding) {
            if (this.prependMakeSubstringNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.prependMakeSubstringNode = this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.prependMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.prependMakeConcatNode = this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope original = StringOperations.rope(string);
            Rope left = StringOperations.rope(other);
            Rope right = this.prependMakeSubstringNode.executeMake(original, byteCountToReplace, original.byteLength() - byteCountToReplace);
            StringOperations.setRope(string, this.prependMakeConcatNode.executeMake(left, right, encoding));
            return string;
        }

        @Specialization(guards={"indexAtEndBound(string, spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)"})
        public Object spliceAppend(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding) {
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            if (this.appendMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.appendMakeConcatNode = this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            StringOperations.setRope(string, this.appendMakeConcatNode.executeMake(left, right, encoding));
            return string;
        }

        @Specialization(guards={"!indexAtEitherBounds(string, spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)", "!isRopeBuffer(string)"})
        public DynamicObject splice(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding, @Cached(value="createBinaryProfile()") ConditionProfile insertStringIsEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile splitRightIsEmptyProfile) {
            if (this.leftMakeSubstringNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftMakeSubstringNode = this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.rightMakeSubstringNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.rightMakeSubstringNode = this.insert(RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null));
            }
            if (this.leftMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftMakeConcatNode = this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            if (this.rightMakeConcatNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.rightMakeConcatNode = this.insert(RopeNodesFactory.MakeConcatNodeGen.create(null, null, null));
            }
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            Rope source = StringOperations.rope(string);
            Rope insert = StringOperations.rope(other);
            int rightSideStartingIndex = spliceByteIndex + byteCountToReplace;
            Rope splitLeft = this.leftMakeSubstringNode.executeMake(source, 0, spliceByteIndex);
            Rope splitRight = this.rightMakeSubstringNode.executeMake(source, rightSideStartingIndex, source.byteLength() - rightSideStartingIndex);
            Rope joinedLeft = insertStringIsEmptyProfile.profile(insert.isEmpty()) ? splitLeft : this.leftMakeConcatNode.executeMake(splitLeft, insert, encoding);
            Rope joinedRight = splitRightIsEmptyProfile.profile(splitRight.isEmpty()) ? joinedLeft : this.rightMakeConcatNode.executeMake(joinedLeft, splitRight, encoding);
            StringOperations.setRope(string, joinedRight);
            return string;
        }

        @Specialization(guards={"!indexAtEitherBounds(string, spliceByteIndex)", "isRubyString(other)", "isRubyEncoding(rubyEncoding)", "isRopeBuffer(string)", "isSingleByteOptimizable(string)"})
        public DynamicObject spliceBuffer(DynamicObject string, DynamicObject other, int spliceByteIndex, int byteCountToReplace, DynamicObject rubyEncoding, @Cached(value="createBinaryProfile()") ConditionProfile sameCodeRangeProfile, @Cached(value="createBinaryProfile()") ConditionProfile brokenCodeRangeProfile) {
            Encoding encoding = EncodingOperations.getEncoding(rubyEncoding);
            RopeBuffer source = (RopeBuffer)StringOperations.rope(string);
            Rope insert = StringOperations.rope(other);
            int rightSideStartingIndex = spliceByteIndex + byteCountToReplace;
            ByteList byteList = new ByteList(source.byteLength() + insert.byteLength() - byteCountToReplace);
            byteList.append(source.getByteList(), 0, spliceByteIndex);
            byteList.append(insert.getBytes());
            byteList.append(source.getByteList(), rightSideStartingIndex, source.byteLength() - rightSideStartingIndex);
            byteList.setEncoding(encoding);
            RopeBuffer buffer = new RopeBuffer(byteList, RopeNodes.MakeConcatNode.commonCodeRange(source.getCodeRange(), insert.getCodeRange(), sameCodeRangeProfile, brokenCodeRangeProfile), source.isSingleByteOptimizable() && insert.isSingleByteOptimizable(), source.characterLength() + insert.characterLength() - byteCountToReplace);
            StringOperations.setRope(string, buffer);
            return string;
        }

        protected boolean indexAtStartBound(int index) {
            return index == 0;
        }

        protected boolean indexAtEndBound(DynamicObject string, int index) {
            assert (RubyGuards.isRubyString(string));
            return index == StringOperations.rope(string).byteLength();
        }

        protected boolean indexAtEitherBounds(DynamicObject string, int index) {
            assert (RubyGuards.isRubyString(string));
            return this.indexAtStartBound(index) || this.indexAtEndBound(string, index);
        }

        protected boolean isRopeBuffer(DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return StringOperations.rope(string) instanceof RopeBuffer;
        }
    }

    @RubiniusPrimitive(name="string_pattern", lowerFixnumParameters={0, 1})
    public static abstract class StringPatternPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode;
        @Node.Child
        private RopeNodes.MakeRepeatingNode makeRepeatingNode;

        public StringPatternPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
            this.makeLeafRopeNode = RopeNodes.MakeLeafRopeNode.create();
            this.makeRepeatingNode = RopeNodes.MakeRepeatingNode.create();
        }

        @Specialization(guards={"value >= 0"})
        public DynamicObject stringPatternZero(DynamicObject stringClass, int size, int value) {
            Rope repeatingRope = this.makeRepeatingNode.executeMake(RopeConstants.ASCII_8BIT_SINGLE_BYTE_ROPES[value], size);
            return this.allocateObjectNode.allocate(stringClass, repeatingRope, null);
        }

        @Specialization(guards={"isRubyString(string)", "patternFitsEvenly(string, size)"})
        public DynamicObject stringPatternFitsEvenly(DynamicObject stringClass, int size, DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            Rope repeatingRope = this.makeRepeatingNode.executeMake(rope, size / rope.byteLength());
            return this.allocateObjectNode.allocate(stringClass, repeatingRope, null);
        }

        @Specialization(guards={"isRubyString(string)", "!patternFitsEvenly(string, size)"})
        @CompilerDirectives.TruffleBoundary
        public DynamicObject stringPattern(DynamicObject stringClass, int size, DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = new byte[size];
            if (!rope.isEmpty()) {
                for (int n = 0; n < size; n += rope.byteLength()) {
                    System.arraycopy(rope.getBytes(), 0, bytes, n, Math.min(rope.byteLength(), size - n));
                }
            }
            CodeRange codeRange = rope.getCodeRange() == CodeRange.CR_7BIT ? CodeRange.CR_7BIT : CodeRange.CR_UNKNOWN;
            Object characterLength = codeRange == CodeRange.CR_7BIT ? Integer.valueOf(size) : NotProvided.INSTANCE;
            return this.allocateObjectNode.allocate(stringClass, this.makeLeafRopeNode.executeMake(bytes, StringOperations.encoding(string), codeRange, characterLength), null);
        }

        protected boolean patternFitsEvenly(DynamicObject string, int size) {
            assert (RubyGuards.isRubyString(string));
            int byteLength = StringOperations.rope(string).byteLength();
            return byteLength > 0 && size % byteLength == 0;
        }
    }

    @RubiniusPrimitive(name="string_rindex", lowerFixnumParameters={1})
    public static abstract class StringRindexPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.GetByteNode patternGetByteNode = RopeNodes.GetByteNode.create();
        @Node.Child
        private RopeNodes.GetByteNode stringGetByteNode = RopeNodes.GetByteNode.create();

        public StringRindexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringRindex(DynamicObject string, DynamicObject pattern, int start) {
            int pos = start;
            if (pos < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.language.control.RaiseException(this.coreExceptions().argumentError("negative start given", this));
            }
            Rope stringRope = StringOperations.rope(string);
            Rope patternRope = StringOperations.rope(pattern);
            int total = stringRope.byteLength();
            int matchSize = patternRope.byteLength();
            if (pos >= total) {
                pos = total - 1;
            }
            switch (matchSize) {
                case 0: {
                    return start;
                }
                case 1: {
                    int matcher = this.patternGetByteNode.executeGetByte(patternRope, 0);
                    while (pos >= 0) {
                        if (this.stringGetByteNode.executeGetByte(stringRope, pos) == matcher) {
                            return pos;
                        }
                        --pos;
                    }
                    return this.nil();
                }
            }
            if (total - pos < matchSize) {
                pos = total - matchSize;
            }
            for (int cur = pos; cur >= 0; --cur) {
                if (ByteList.memcmp((byte[])stringRope.getBytes(), (int)cur, (byte[])patternRope.getBytes(), (int)0, (int)matchSize) != 0) continue;
                return cur;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_copy_from", needsSelf=false, lowerFixnumParameters={2, 3, 4})
    public static abstract class StringCopyFromPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(other)", "size >= 0", "!offsetTooLarge(start, other)", "!offsetTooLargeRaw(dest, string)"})
        public DynamicObject stringCopyFrom(DynamicObject string, DynamicObject other, int start, int size, int dest, @Cached(value="createBinaryProfile()") ConditionProfile negativeStartOffsetProfile, @Cached(value="createBinaryProfile()") ConditionProfile sizeTooLargeInReplacementProfile, @Cached(value="createBinaryProfile()") ConditionProfile negativeDestinationOffsetProfile, @Cached(value="createBinaryProfile()") ConditionProfile sizeTooLargeInStringProfile) {
            int src = start;
            int dst = dest;
            int cnt = size;
            Rope otherRope = StringOperations.rope(other);
            int osz = otherRope.byteLength();
            if (negativeStartOffsetProfile.profile(src < 0)) {
                src = 0;
            }
            if (sizeTooLargeInReplacementProfile.profile(cnt > osz - src)) {
                cnt = osz - src;
            }
            ByteList stringBytes = RopeOperations.toByteListCopy(Layouts.STRING.getRope(string));
            int sz = stringBytes.unsafeBytes().length - stringBytes.begin();
            if (negativeDestinationOffsetProfile.profile(dst < 0)) {
                dst = 0;
            }
            if (sizeTooLargeInStringProfile.profile(cnt > sz - dst)) {
                cnt = sz - dst;
            }
            System.arraycopy(otherRope.getBytes(), src, stringBytes.getUnsafeBytes(), stringBytes.begin() + dest, cnt);
            StringOperations.setRope(string, StringOperations.ropeFromByteList(stringBytes));
            return string;
        }

        @Specialization(guards={"isRubyString(other)", "size < 0 || (offsetTooLarge(start, other) || offsetTooLargeRaw(dest, string))"})
        public DynamicObject stringCopyFromWithNegativeSize(DynamicObject string, DynamicObject other, int start, int size, int dest) {
            return string;
        }

        protected boolean offsetTooLarge(int offset, DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            return offset >= Layouts.STRING.getRope(string).byteLength();
        }

        protected boolean offsetTooLargeRaw(int offset, DynamicObject string) {
            assert (RubyGuards.isRubyString(string));
            Rope rope = StringOperations.rope(string);
            return offset >= rope.byteLength();
        }
    }

    @RubiniusPrimitive(name="string_previous_byte_index")
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringPreviousByteIndexPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"index < 0"})
        @CompilerDirectives.TruffleBoundary
        public Object stringPreviousByteIndexNegativeIndex(DynamicObject string, int index) {
            throw new org.jruby.truffle.language.control.RaiseException(this.coreExceptions().argumentError("negative index given", this));
        }

        @Specialization(guards={"index == 0"})
        public Object stringPreviousByteIndexZeroIndex(DynamicObject string, int index) {
            return this.nil();
        }

        @Specialization(guards={"index > 0", "isSingleByteOptimizable(string)"})
        public int stringPreviousByteIndexSingleByteOptimizable(DynamicObject string, int index) {
            return index - 1;
        }

        @Specialization(guards={"index > 0", "!isSingleByteOptimizable(string)", "isFixedWidthEncoding(string)"})
        public int stringPreviousByteIndexFixedWidthEncoding(DynamicObject string, int index, @Cached(value="createBinaryProfile()") ConditionProfile firstCharacterProfile) {
            Encoding encoding = StringOperations.encoding(string);
            if (firstCharacterProfile.profile(index < encoding.maxLength())) {
                return 0;
            }
            return (index / encoding.maxLength() - 1) * encoding.maxLength();
        }

        @Specialization(guards={"index > 0", "!isSingleByteOptimizable(string)", "!isFixedWidthEncoding(string)"})
        @CompilerDirectives.TruffleBoundary
        public Object stringPreviousByteIndex(DynamicObject string, int index) {
            Rope rope = StringOperations.rope(string);
            boolean p = false;
            int end = 0 + rope.byteLength();
            int b = rope.getEncoding().prevCharHead(rope.getBytes(), 0, 0 + index, end);
            if (b == -1) {
                return this.nil();
            }
            return b - 0;
        }
    }

    @RubiniusPrimitive(name="string_byte_index", needsSelf=false, lowerFixnumParameters={0, 1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringByteIndexPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public Object stringByteIndexSingleByte(DynamicObject string, int index, int start, @Cached(value="createBinaryProfile()") ConditionProfile indexTooLargeProfile) {
            if (indexTooLargeProfile.profile(index > StringOperations.rope(string).byteLength())) {
                return this.nil();
            }
            return index;
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public Object stringByteIndex(DynamicObject string, int index, int start, @Cached(value="createBinaryProfile()") ConditionProfile indexTooLargeProfile, @Cached(value="createBinaryProfile()") ConditionProfile invalidByteProfile) {
            int i;
            Rope rope = StringOperations.rope(string);
            Encoding enc = rope.getEncoding();
            int p = 0;
            int e = p + rope.byteLength();
            int k = index;
            if (k < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.language.control.RaiseException(this.coreExceptions().argumentError("character index is negative", this));
            }
            for (i = 0; i < k && p < e; ++i) {
                int c = StringSupport.preciseLength((Encoding)enc, (byte[])rope.getBytes(), (int)p, (int)e);
                if (invalidByteProfile.profile(!StringSupport.MBCLEN_CHARFOUND_P((int)c))) {
                    ++p;
                    continue;
                }
                p += StringSupport.MBCLEN_CHARFOUND_LEN((int)c);
            }
            if (indexTooLargeProfile.profile(i < k)) {
                return this.nil();
            }
            return p;
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringByteIndex(DynamicObject string, DynamicObject pattern, int offset, @Cached(value="createBinaryProfile()") ConditionProfile emptyPatternProfile, @Cached(value="createBinaryProfile()") ConditionProfile brokenCodeRangeProfile) {
            if (offset < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.language.control.RaiseException(this.coreExceptions().argumentError("negative start given", this));
            }
            Rope stringRope = StringOperations.rope(string);
            Rope patternRope = StringOperations.rope(pattern);
            if (emptyPatternProfile.profile(patternRope.isEmpty())) {
                return offset;
            }
            if (brokenCodeRangeProfile.profile(stringRope.getCodeRange() == CodeRange.CR_BROKEN)) {
                return this.nil();
            }
            Encoding encoding = StringOperations.checkEncoding(this.getContext(), string, pattern, this);
            int p = 0;
            int e = p + stringRope.byteLength();
            int pp = 0;
            int pe = pp + patternRope.byteLength();
            byte[] stringBytes = stringRope.getBytes();
            byte[] patternBytes = patternRope.getBytes();
            int s = p;
            int ss = pp;
            while (p < e) {
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                        ++p;
                        ++pp;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        int c = StringSupport.preciseLength((Encoding)encoding, (byte[])stringBytes, (int)s, (int)e);
                        if (StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                            return s;
                        }
                        return this.nil();
                    }
                }
                s = ++p;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_character_index", needsSelf=false, lowerFixnumParameters={2})
    public static abstract class StringCharacterIndexPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringCharacterIndex(DynamicObject string, DynamicObject pattern, int offset) {
            int index;
            int c;
            if (offset < 0) {
                return this.nil();
            }
            Rope stringRope = StringOperations.rope(string);
            Rope patternRope = StringOperations.rope(pattern);
            int total = stringRope.byteLength();
            int p = 0;
            int e = p + total;
            int pp = 0;
            int pe = pp + patternRope.byteLength();
            byte[] stringBytes = stringRope.getBytes();
            byte[] patternBytes = patternRope.getBytes();
            if (stringRope.isSingleByteOptimizable()) {
                int s = p += offset;
                int ss = pp;
                while (p < e) {
                    if (stringBytes[p] == patternBytes[pp]) {
                        while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                            ++p;
                            ++pp;
                        }
                        if (pp < pe) {
                            p = s;
                            pp = ss;
                        } else {
                            return s;
                        }
                    }
                    s = ++p;
                }
                return this.nil();
            }
            Encoding enc = stringRope.getEncoding();
            for (index = 0; p < e && index < offset; p += c, ++index) {
                c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e);
                if (StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    continue;
                }
                return this.nil();
            }
            int s = p;
            int ss = pp;
            while (p < e) {
                c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e);
                if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    return this.nil();
                }
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe) {
                        boolean breakOut = false;
                        int pc = p + c;
                        while (p < e && p < pc && pp < pe) {
                            if (stringBytes[p] == patternBytes[pp]) {
                                ++p;
                                ++pp;
                                continue;
                            }
                            breakOut = true;
                            break;
                        }
                        if (!breakOut && StringSupport.MBCLEN_CHARFOUND_P((int)(c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e)))) continue;
                        break;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        return index;
                    }
                }
                s = p += c;
                ++index;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_byte_character_index", needsSelf=false)
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringByteCharacterIndexNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        public abstract int executeStringByteCharacterIndex(VirtualFrame var1, DynamicObject var2, int var3, int var4);

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public int stringByteCharacterIndexSingleByte(DynamicObject string, int index, int start) {
            return index;
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)", "isFixedWidthEncoding(string)"})
        public int stringByteCharacterIndexFixedWidth(DynamicObject string, int index, int start) {
            return index / StringOperations.encoding(string).minLength();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)", "!isFixedWidthEncoding(string)", "isValidUtf8(string)"})
        public int stringByteCharacterIndexValidUtf8(DynamicObject string, int index, int start) {
            return this.stringByteCharacterIndex(string, index, start);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isSingleByteOptimizable(string)", "!isFixedWidthEncoding(string)", "!isValidUtf8(string)"})
        public int stringByteCharacterIndex(DynamicObject string, int index, int start) {
            Rope rope = StringOperations.rope(string);
            byte[] bytes = rope.getBytes();
            Encoding encoding = rope.getEncoding();
            int p = start;
            int end = bytes.length;
            int charIndex = 0;
            while (p < end && index > 0) {
                int charLen = StringSupport.length((Encoding)encoding, (byte[])bytes, (int)p, (int)end);
                p += charLen;
                index -= charLen;
                ++charIndex;
            }
            return charIndex;
        }
    }

    @RubiniusPrimitive(name="string_character_byte_index", needsSelf=false, lowerFixnumParameters={0, 1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class CharacterByteIndexNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        public abstract int executeInt(VirtualFrame var1, DynamicObject var2, int var3, int var4);

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public int stringCharacterByteIndex(DynamicObject string, int index, int start) {
            return start + index;
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public int stringCharacterByteIndexMultiByteEncoding(DynamicObject string, int index, int start) {
            Rope rope = StringOperations.rope(string);
            return StringSupport.nth((Encoding)rope.getEncoding(), (byte[])rope.getBytes(), (int)start, (int)rope.byteLength(), (int)index);
        }
    }

    @RubiniusPrimitive(name="string_index", lowerFixnumParameters={1})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringIndexPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        StringByteCharacterIndexNode byteIndexToCharIndexNode;

        @Specialization(guards={"isRubyString(pattern)", "isBrokenCodeRange(pattern)"})
        public DynamicObject stringIndexBrokenCodeRange(DynamicObject string, DynamicObject pattern, int start) {
            return this.nil();
        }

        @Specialization(guards={"isRubyString(pattern)", "!isBrokenCodeRange(pattern)"})
        public Object stringIndex(VirtualFrame frame, DynamicObject string, DynamicObject pattern, int start) {
            if (this.byteIndexToCharIndexNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.byteIndexToCharIndexNode = this.insert(StringPrimitiveNodesFactory.StringByteCharacterIndexNodeFactory.create(new RubyNode[0]));
            }
            int charIndex = this.byteIndexToCharIndexNode.executeStringByteCharacterIndex(frame, string, start, 0);
            int index = this.index(StringOperations.rope(string), StringOperations.rope(pattern), charIndex, StringOperations.encoding(string));
            if (index == -1) {
                return this.nil();
            }
            return index;
        }

        @CompilerDirectives.TruffleBoundary
        private int index(Rope source, Rope other, int offset, Encoding enc) {
            int sourceLen = source.characterLength();
            int otherLen = other.characterLength();
            if (offset < 0 && (offset += sourceLen) < 0) {
                return -1;
            }
            if (sourceLen - offset < otherLen) {
                return -1;
            }
            byte[] bytes = source.getBytes();
            int p = 0;
            int end = p + source.byteLength();
            if (offset != 0) {
                offset = source.isSingleByteOptimizable() ? offset : StringSupport.offset((Encoding)enc, (byte[])bytes, (int)p, (int)end, (int)offset);
                p += offset;
            }
            if (otherLen == 0) {
                return offset;
            }
            int pos;
            while ((pos = this.indexOf(source, other, p)) >= 0) {
                int t = enc.rightAdjustCharHead(bytes, p, p + (pos -= p), end);
                if (t == p + pos) {
                    return pos + offset;
                }
                if ((sourceLen -= t - p) <= 0) {
                    return -1;
                }
                offset += t - p;
                p = t;
            }
            return pos;
        }

        @CompilerDirectives.TruffleBoundary
        private int indexOf(Rope sourceRope, Rope otherRope, int fromIndex) {
            byte[] source = sourceRope.getBytes();
            boolean sourceOffset = false;
            int sourceCount = sourceRope.byteLength();
            byte[] target = otherRope.getBytes();
            boolean targetOffset = false;
            int targetCount = otherRope.byteLength();
            if (fromIndex >= sourceCount) {
                return targetCount == 0 ? sourceCount : -1;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (targetCount == 0) {
                return fromIndex;
            }
            byte first = target[0];
            int max = 0 + (sourceCount - targetCount);
            for (int i = 0 + fromIndex; i <= max; ++i) {
                if (source[i] != first) {
                    while (++i <= max && source[i] != first) {
                    }
                }
                if (i > max) continue;
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && source[j] == target[k]) {
                    ++j;
                    ++k;
                }
                if (j != end) continue;
                return i - 0;
            }
            return -1;
        }
    }

    @RubiniusPrimitive(name="string_to_f", needsSelf=false)
    public static abstract class StringToFPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object stringToF(DynamicObject string) {
            try {
                return Double.parseDouble(string.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    @RubiniusPrimitive(name="string_from_codepoint", needsSelf=false)
    public static abstract class StringFromCodepointPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyEncoding(encoding)", "isSimple(code, encoding)"})
        public DynamicObject stringFromCodepointSimple(int code, DynamicObject encoding, @Cached(value="createBinaryProfile()") ConditionProfile isUTF8Profile, @Cached(value="createBinaryProfile()") ConditionProfile isUSAsciiProfile, @Cached(value="createBinaryProfile()") ConditionProfile isAscii8BitProfile) {
            Encoding realEncoding = EncodingOperations.getEncoding(encoding);
            LeafRope rope = isUTF8Profile.profile(realEncoding == UTF8Encoding.INSTANCE) ? RopeConstants.UTF8_SINGLE_BYTE_ROPES[code] : (isUSAsciiProfile.profile(realEncoding == USASCIIEncoding.INSTANCE) ? RopeConstants.US_ASCII_SINGLE_BYTE_ROPES[code] : (isAscii8BitProfile.profile(realEncoding == ASCIIEncoding.INSTANCE) ? RopeConstants.ASCII_8BIT_SINGLE_BYTE_ROPES[code] : RopeOperations.create(new byte[]{(byte)code}, realEncoding, CodeRange.CR_UNKNOWN)));
            return this.createString(rope);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyEncoding(encoding)", "!isSimple(code, encoding)"})
        public DynamicObject stringFromCodepoint(int code, DynamicObject encoding) {
            int length;
            try {
                length = EncodingOperations.getEncoding(encoding).codeToMbcLength(code);
            }
            catch (EncodingException e) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.language.control.RaiseException(this.coreExceptions().rangeError(code, encoding, this));
            }
            if (length <= 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.language.control.RaiseException(this.coreExceptions().rangeError(code, encoding, this));
            }
            byte[] bytes = new byte[length];
            try {
                EncodingOperations.getEncoding(encoding).codeToMbc(code, bytes, 0);
            }
            catch (EncodingException e) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.language.control.RaiseException(this.coreExceptions().rangeError(code, encoding, this));
            }
            return this.createString(new ByteList(bytes, EncodingOperations.getEncoding(encoding)));
        }

        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject stringFromCodepointSimple(long code, DynamicObject encoding, @Cached(value="createBinaryProfile()") ConditionProfile isUTF8Profile, @Cached(value="createBinaryProfile()") ConditionProfile isUSAsciiProfile, @Cached(value="createBinaryProfile()") ConditionProfile isAscii8BitProfile) {
            if (code < Integer.MIN_VALUE || code > Integer.MAX_VALUE) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            return this.stringFromCodepointSimple((int)code, encoding, isUTF8Profile, isUSAsciiProfile, isAscii8BitProfile);
        }

        protected boolean isSimple(int code, DynamicObject encoding) {
            Encoding enc = EncodingOperations.getEncoding(encoding);
            return enc.isAsciiCompatible() && code >= 0 && code < 128 || enc == ASCIIEncoding.INSTANCE && code >= 0 && code <= 255;
        }
    }

    @RubiniusPrimitive(name="string_find_character")
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringFindCharacterNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringFindCharacterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
            this.makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        }

        @Specialization(guards={"offset < 0"})
        public Object stringFindCharacterNegativeOffset(DynamicObject string, int offset) {
            return this.nil();
        }

        @Specialization(guards={"offset >= 0", "isSingleByte(string)"})
        public Object stringFindCharacterSingleByte(DynamicObject string, int offset, @Cached(value="createBinaryProfile()") ConditionProfile offsetTooLargeProfile) {
            Rope rope = StringOperations.rope(string);
            if (offsetTooLargeProfile.profile(offset >= rope.byteLength())) {
                return this.nil();
            }
            DynamicObject ret = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, offset, 1), null);
            return this.propagate(string, ret);
        }

        @Specialization(guards={"offset >= 0", "!isSingleByte(string)"})
        public Object stringFindCharacter(DynamicObject string, int offset, @Cached(value="createBinaryProfile()") ConditionProfile offsetTooLargeProfile) {
            Rope rope = StringOperations.rope(string);
            if (offsetTooLargeProfile.profile(offset >= rope.byteLength())) {
                return this.nil();
            }
            Encoding enc = rope.getEncoding();
            int clen = StringSupport.preciseLength((Encoding)enc, (byte[])rope.getBytes(), (int)0, (int)rope.byteLength());
            DynamicObject ret = StringSupport.MBCLEN_CHARFOUND_P((int)clen) ? this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, offset, clen), null) : this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), this.makeSubstringNode.executeMake(rope, offset, 1), null);
            return this.propagate(string, ret);
        }

        private Object propagate(DynamicObject string, DynamicObject ret) {
            return this.maybeTaint(string, ret);
        }

        private Object maybeTaint(DynamicObject source, DynamicObject value) {
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            return this.taintResultNode.maybeTaint(source, value);
        }
    }

    @RubiniusPrimitive(name="string_equal", needsSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringEqualPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        public abstract boolean executeStringEqual(DynamicObject var1, DynamicObject var2);

        @Specialization(guards={"ropeReferenceEqual(string, other)"})
        public boolean stringEqualsRopeEquals(DynamicObject string, DynamicObject other) {
            return true;
        }

        @Specialization(guards={"isRubyString(other)", "!ropeReferenceEqual(string, other)", "bytesReferenceEqual(string, other)"})
        public boolean stringEqualsBytesEquals(DynamicObject string, DynamicObject other) {
            return true;
        }

        @Specialization(guards={"isRubyString(other)", "!ropeReferenceEqual(string, other)", "!bytesReferenceEqual(string, other)", "!areComparable(string, other, sameEncodingProfile, firstStringEmptyProfile, secondStringEmptyProfile, firstStringCR7BitProfile, secondStringCR7BitProfile, firstStringAsciiCompatible, secondStringAsciiCompatible)"})
        public boolean stringEqualNotComparable(DynamicObject string, DynamicObject other, @Cached(value="createBinaryProfile()") ConditionProfile sameEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile secondStringEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringCR7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile secondStringCR7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringAsciiCompatible, @Cached(value="createBinaryProfile()") ConditionProfile secondStringAsciiCompatible) {
            return false;
        }

        @Specialization(guards={"isRubyString(other)", "!ropeReferenceEqual(string, other)", "!bytesReferenceEqual(string, other)", "areComparable(string, other, sameEncodingProfile, firstStringEmptyProfile, secondStringEmptyProfile, firstStringCR7BitProfile, secondStringCR7BitProfile, firstStringAsciiCompatible, secondStringAsciiCompatible)"})
        public boolean equal(DynamicObject string, DynamicObject other, @Cached(value="createBinaryProfile()") ConditionProfile sameEncodingProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile secondStringEmptyProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringCR7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile secondStringCR7BitProfile, @Cached(value="createBinaryProfile()") ConditionProfile firstStringAsciiCompatible, @Cached(value="createBinaryProfile()") ConditionProfile secondStringAsciiCompatible, @Cached(value="createBinaryProfile()") ConditionProfile differentSizeProfile) {
            Rope a = Layouts.STRING.getRope(string);
            Rope b = Layouts.STRING.getRope(other);
            if (differentSizeProfile.profile(a.byteLength() != b.byteLength())) {
                return false;
            }
            return a.equals(b);
        }

        protected boolean areComparable(DynamicObject first, DynamicObject second, ConditionProfile sameEncodingProfile, ConditionProfile firstStringEmptyProfile, ConditionProfile secondStringEmptyProfile, ConditionProfile firstStringCR7BitProfile, ConditionProfile secondStringCR7BitProfile, ConditionProfile firstStringAsciiCompatible, ConditionProfile secondStringAsciiCompatible) {
            assert (RubyGuards.isRubyString(first));
            assert (RubyGuards.isRubyString(second));
            Rope firstRope = Layouts.STRING.getRope(first);
            Rope secondRope = Layouts.STRING.getRope(second);
            if (sameEncodingProfile.profile(firstRope.getEncoding() == secondRope.getEncoding())) {
                return true;
            }
            if (firstStringEmptyProfile.profile(firstRope.isEmpty())) {
                return true;
            }
            if (secondStringEmptyProfile.profile(secondRope.isEmpty())) {
                return true;
            }
            CodeRange firstCodeRange = firstRope.getCodeRange();
            CodeRange secondCodeRange = secondRope.getCodeRange();
            if (firstStringCR7BitProfile.profile(firstCodeRange == CodeRange.CR_7BIT)) {
                if (secondStringCR7BitProfile.profile(secondCodeRange == CodeRange.CR_7BIT)) {
                    return true;
                }
                if (secondStringAsciiCompatible.profile(secondRope.getEncoding().isAsciiCompatible())) {
                    return true;
                }
            }
            return secondStringCR7BitProfile.profile(secondCodeRange == CodeRange.CR_7BIT) && firstStringAsciiCompatible.profile(firstRope.getEncoding().isAsciiCompatible());
        }

        protected static boolean ropeReferenceEqual(DynamicObject first, DynamicObject second) {
            assert (RubyGuards.isRubyString(first));
            assert (RubyGuards.isRubyString(second));
            return StringOperations.rope(first) == StringOperations.rope(second);
        }

        protected static boolean bytesReferenceEqual(DynamicObject first, DynamicObject second) {
            assert (RubyGuards.isRubyString(first));
            assert (RubyGuards.isRubyString(second));
            Rope firstRope = StringOperations.rope(first);
            Rope secondRope = StringOperations.rope(second);
            return firstRope.getCodeRange() == CodeRange.CR_7BIT && secondRope.getCodeRange() == CodeRange.CR_7BIT && firstRope.getRawBytes() != null && firstRope.getRawBytes() == secondRope.getRawBytes();
        }
    }

    @RubiniusPrimitive(name="string_compare_substring")
    public static abstract class StringCompareSubstringPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(other)"})
        public int stringCompareSubstring(VirtualFrame frame, DynamicObject string, DynamicObject other, int start, int size) {
            int stringLength = StringOperations.rope(string).characterLength();
            int otherLength = StringOperations.rope(other).characterLength();
            if (start < 0) {
                start += otherLength;
            }
            if (start > otherLength) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.language.control.RaiseException(this.coreExceptions().indexError(String.format("index %d out of string", start), this));
            }
            if (start < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.language.control.RaiseException(this.coreExceptions().indexError(String.format("index %d out of string", start), this));
            }
            if (start + size > otherLength) {
                size = otherLength - start;
            }
            if (size > stringLength) {
                size = stringLength;
            }
            Rope rope = StringOperations.rope(string);
            Rope otherRope = StringOperations.rope(other);
            return ByteList.memcmp((byte[])rope.getBytes(), (int)0, (int)size, (byte[])otherRope.getBytes(), (int)start, (int)size);
        }
    }

    @RubiniusPrimitive(name="string_chr_at", lowerFixnumParameters={0})
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringChrAtPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"indexOutOfBounds(string, byteIndex)"})
        public Object stringChrAtOutOfBounds(DynamicObject string, int byteIndex) {
            return false;
        }

        @Specialization(guards={"!indexOutOfBounds(string, byteIndex)", "isSingleByteOptimizable(string)"})
        public Object stringChrAtSingleByte(DynamicObject string, int byteIndex, @Cached(value="create(getContext(), getSourceSection())") StringByteSubstringPrimitiveNode stringByteSubstringNode) {
            return stringByteSubstringNode.executeStringByteSubstring(string, byteIndex, 1);
        }

        @Specialization(guards={"!indexOutOfBounds(string, byteIndex)", "!isSingleByteOptimizable(string)"})
        public Object stringChrAt(DynamicObject string, int byteIndex, @Cached(value="create(getContext(), getSourceSection())") StringByteSubstringPrimitiveNode stringByteSubstringNode) {
            int end;
            Rope rope = StringOperations.rope(string);
            int c = this.preciseLength(rope, byteIndex, end = rope.byteLength());
            if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                return this.nil();
            }
            int n = StringSupport.MBCLEN_CHARFOUND_LEN((int)c);
            if (n + byteIndex > end) {
                return this.nil();
            }
            return stringByteSubstringNode.executeStringByteSubstring(string, byteIndex, n);
        }

        @CompilerDirectives.TruffleBoundary
        private int preciseLength(Rope rope, int p, int end) {
            return StringSupport.preciseLength((Encoding)rope.getEncoding(), (byte[])rope.getBytes(), (int)p, (int)end);
        }

        protected static boolean indexOutOfBounds(DynamicObject string, int byteIndex) {
            return byteIndex < 0 || byteIndex >= StringOperations.rope(string).byteLength();
        }
    }

    @RubiniusPrimitive(name="string_check_null_safe", needsSelf=false)
    public static abstract class StringCheckNullSafePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject stringCheckNullSafe(DynamicObject string) {
            byte[] bytes = StringOperations.rope(string).getBytes();
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.language.control.RaiseException(this.coreExceptions().argumentError("string contains NULL byte", this));
            }
            return string;
        }
    }

    @RubiniusPrimitive(name="string_byte_substring")
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="length")})
    public static abstract class StringByteSubstringPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public static StringByteSubstringPrimitiveNode create(RubyContext context, SourceSection sourceSection) {
            return StringPrimitiveNodesFactory.StringByteSubstringPrimitiveNodeFactory.create(context, sourceSection, null, null, null);
        }

        public StringByteSubstringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
            this.makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return ArrayAttributeCastNodeGen.create(null, null, "index", index);
        }

        @CreateCast(value={"length"})
        public RubyNode coerceLengthToInt(RubyNode length) {
            return ArrayAttributeCastNodeGen.create(null, null, "length", length);
        }

        public Object executeStringByteSubstring(DynamicObject string, Object index, Object length) {
            return this.nil();
        }

        @Specialization
        public Object stringByteSubstring(DynamicObject string, int index, NotProvided length, @Cached(value="createBinaryProfile()") ConditionProfile negativeLengthProfile, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile, @Cached(value="createBinaryProfile()") ConditionProfile lengthTooLongProfile, @Cached(value="createBinaryProfile()") ConditionProfile nilSubstringProfile, @Cached(value="createBinaryProfile()") ConditionProfile emptySubstringProfile) {
            DynamicObject subString = (DynamicObject)this.stringByteSubstring(string, index, 1, negativeLengthProfile, indexOutOfBoundsProfile, lengthTooLongProfile);
            if (nilSubstringProfile.profile(subString == this.nil())) {
                return subString;
            }
            if (emptySubstringProfile.profile(StringOperations.rope(subString).isEmpty())) {
                return this.nil();
            }
            return subString;
        }

        @Specialization
        public Object stringByteSubstring(DynamicObject string, int index, int length, @Cached(value="createBinaryProfile()") ConditionProfile negativeLengthProfile, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile, @Cached(value="createBinaryProfile()") ConditionProfile lengthTooLongProfile) {
            if (negativeLengthProfile.profile(length < 0)) {
                return this.nil();
            }
            Rope rope = StringOperations.rope(string);
            int stringByteLength = rope.byteLength();
            int normalizedIndex = StringOperations.normalizeIndex(stringByteLength, index);
            if (indexOutOfBoundsProfile.profile(normalizedIndex < 0 || normalizedIndex > stringByteLength)) {
                return this.nil();
            }
            if (lengthTooLongProfile.profile(normalizedIndex + length > stringByteLength)) {
                length = rope.byteLength() - normalizedIndex;
            }
            Rope substringRope = this.makeSubstringNode.executeMake(rope, normalizedIndex, length);
            DynamicObject result = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(string), substringRope, null);
            return this.taintResultNode.maybeTaint(string, result);
        }

        @Specialization(guards={"isRubyRange(range)"})
        public Object stringByteSubstring(DynamicObject string, DynamicObject range, NotProvided length) {
            return null;
        }
    }

    @RubiniusPrimitive(name="string_awk_split")
    public static abstract class StringAwkSplitPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringAwkSplitPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject stringAwkSplit(DynamicObject string, int lim) {
            int p;
            ArrayList<DynamicObject> ret = new ArrayList<DynamicObject>();
            Rope rope = StringOperations.rope(string);
            boolean limit = lim > 0;
            int i = lim > 0 ? 1 : 0;
            byte[] bytes = rope.getBytes();
            int ptr = p = 0;
            int len = rope.byteLength();
            int end = p + len;
            Encoding enc = rope.getEncoding();
            boolean skip = true;
            int e = 0;
            int b = 0;
            boolean singlebyte = rope.isSingleByteOptimizable();
            while (p < end) {
                int c;
                if (singlebyte) {
                    c = bytes[p++] & 0xFF;
                } else {
                    try {
                        c = StringSupport.codePoint((Ruby)this.getContext().getJRubyRuntime(), (Encoding)enc, (byte[])bytes, (int)p, (int)end);
                    }
                    catch (RaiseException ex) {
                        throw new org.jruby.truffle.language.control.RaiseException(this.getContext().getJRubyInterop().toTruffle(ex.getException(), this));
                    }
                    p += StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
                }
                if (skip) {
                    if (enc.isSpace(c)) {
                        b = p - ptr;
                        continue;
                    }
                    e = p - ptr;
                    skip = false;
                    if (!limit || lim > i) continue;
                    break;
                }
                if (enc.isSpace(c)) {
                    ret.add(this.makeString(string, b, e - b));
                    skip = true;
                    b = p - ptr;
                    if (!limit) continue;
                    ++i;
                    continue;
                }
                e = p - ptr;
            }
            if (len > 0 && (limit || len > b || lim < 0)) {
                ret.add(this.makeString(string, b, len - b));
            }
            Object[] objects = ret.toArray();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }

        private DynamicObject makeString(DynamicObject source, int index, int length) {
            assert (RubyGuards.isRubyString(source));
            Rope rope = this.makeSubstringNode.executeMake(StringOperations.rope(source), index, length);
            DynamicObject ret = Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(source)), rope);
            this.taintResultNode.maybeTaint(source, ret);
            return ret;
        }
    }

    @RubiniusPrimitive(name="string_append")
    public static abstract class StringAppendPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeConcatNode makeConcatNode = RopeNodesFactory.MakeConcatNodeGen.create(null, null, null);

        public StringAppendPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract DynamicObject executeStringAppend(DynamicObject var1, DynamicObject var2);

        @Specialization(guards={"isRubyString(other)"})
        public DynamicObject stringAppend(DynamicObject string, DynamicObject other) {
            Rope left = StringOperations.rope(string);
            Rope right = StringOperations.rope(other);
            Encoding compatibleEncoding = EncodingNodes.CompatibleQueryNode.compatibleEncodingForStrings(string, other);
            if (compatibleEncoding == null) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.language.control.RaiseException(this.coreExceptions().encodingCompatibilityError(String.format("incompatible encodings: %s and %s", left.getEncoding(), right.getEncoding()), this));
            }
            StringOperations.setRope(string, this.makeConcatNode.executeMake(left, right, compatibleEncoding));
            return string;
        }
    }

    @RubiniusPrimitive(name="character_printable_p")
    public static abstract class CharacterPrintablePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isCharacterPrintable(DynamicObject character) {
            Rope rope = StringOperations.rope(character);
            Encoding encoding = rope.getEncoding();
            int codepoint = encoding.mbcToCode(rope.getBytes(), 0, rope.byteLength());
            return encoding.isPrint(codepoint);
        }
    }

    @RubiniusPrimitive(name="character_ascii_p")
    @ImportStatic(value={StringGuards.class})
    public static abstract class CharacterAsciiPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"is7Bit(character)"})
        public boolean isCharacterAscii(DynamicObject character) {
            return !StringOperations.rope(character).isEmpty();
        }

        @Specialization(guards={"!is7Bit(character)"})
        public boolean isCharacterAsciiMultiByte(DynamicObject character) {
            Rope rope = StringOperations.rope(character);
            int codepoint = StringSupport.preciseCodePoint((Encoding)rope.getEncoding(), (byte[])rope.getBytes(), (int)0, (int)rope.byteLength());
            boolean found = codepoint != -1;
            return found && Encoding.isAscii((int)codepoint);
        }
    }
}

