/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.parser.jruby;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Syntax;
import org.jruby.ast.AliasNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2ConstNode;
import org.jruby.ast.Colon2ImplicitNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ComplexNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EncodingNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RationalNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.InvalidSourcePosition;
import org.jruby.parser.ParserSupport;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.IsRubiniusUndefinedNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.RaiseIfFrozenNode;
import org.jruby.truffle.core.array.ArrayAppendOneNode;
import org.jruby.truffle.core.array.ArrayAppendOneNodeGen;
import org.jruby.truffle.core.array.ArrayConcatNode;
import org.jruby.truffle.core.array.ArrayDropTailNode;
import org.jruby.truffle.core.array.ArrayDropTailNodeGen;
import org.jruby.truffle.core.array.ArrayGetTailNodeGen;
import org.jruby.truffle.core.array.ArrayLiteralNode;
import org.jruby.truffle.core.array.PrimitiveArrayNodeFactory;
import org.jruby.truffle.core.cast.HashCastNodeGen;
import org.jruby.truffle.core.cast.IntegerCastNodeGen;
import org.jruby.truffle.core.cast.SplatCastNode;
import org.jruby.truffle.core.cast.SplatCastNodeGen;
import org.jruby.truffle.core.cast.StringToSymbolNode;
import org.jruby.truffle.core.cast.StringToSymbolNodeGen;
import org.jruby.truffle.core.cast.ToProcNodeGen;
import org.jruby.truffle.core.cast.ToSNode;
import org.jruby.truffle.core.cast.ToSNodeGen;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.hash.ConcatHashLiteralNode;
import org.jruby.truffle.core.hash.HashLiteralNode;
import org.jruby.truffle.core.hash.HashNodes;
import org.jruby.truffle.core.hash.HashNodesFactory;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.core.module.ModuleNodes;
import org.jruby.truffle.core.module.ModuleNodesFactory;
import org.jruby.truffle.core.numeric.BignumOperations;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.core.range.RangeNodes;
import org.jruby.truffle.core.range.RangeNodesFactory;
import org.jruby.truffle.core.regexp.InterpolatedRegexpNode;
import org.jruby.truffle.core.regexp.MatchDataNodes;
import org.jruby.truffle.core.regexp.MatchDataNodesFactory;
import org.jruby.truffle.core.regexp.RegexpNodes;
import org.jruby.truffle.core.regexp.RegexpNodesFactory;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rubinius.RubiniusLastStringReadNode;
import org.jruby.truffle.core.rubinius.RubiniusLastStringWriteNodeGen;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveConstructor;
import org.jruby.truffle.core.rubinius.RubiniusSingleBlockArgNode;
import org.jruby.truffle.core.string.InterpolatedStringNode;
import org.jruby.truffle.core.string.StringNodes;
import org.jruby.truffle.core.string.StringNodesFactory;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.time.TimeNodes;
import org.jruby.truffle.core.time.TimeNodesFactory;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.ArrayIsAtLeastAsLargeAsNode;
import org.jruby.truffle.language.constants.ReadConstantWithLexicalScopeNode;
import org.jruby.truffle.language.constants.ReadLiteralConstantNode;
import org.jruby.truffle.language.constants.WriteConstantNode;
import org.jruby.truffle.language.control.AndNode;
import org.jruby.truffle.language.control.BreakID;
import org.jruby.truffle.language.control.BreakNode;
import org.jruby.truffle.language.control.ElidableResultNode;
import org.jruby.truffle.language.control.FrameOnStackNode;
import org.jruby.truffle.language.control.IfElseNode;
import org.jruby.truffle.language.control.IfNode;
import org.jruby.truffle.language.control.NotNode;
import org.jruby.truffle.language.control.OnceNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.ReturnID;
import org.jruby.truffle.language.control.UnlessNode;
import org.jruby.truffle.language.control.WhileNode;
import org.jruby.truffle.language.defined.DefinedWrapperNode;
import org.jruby.truffle.language.dispatch.RubyCallNode;
import org.jruby.truffle.language.exceptions.DisablingBacktracesNode;
import org.jruby.truffle.language.exceptions.EnsureNode;
import org.jruby.truffle.language.exceptions.RescueAnyNode;
import org.jruby.truffle.language.exceptions.RescueClassesNode;
import org.jruby.truffle.language.exceptions.RescueSplatNode;
import org.jruby.truffle.language.exceptions.TryNode;
import org.jruby.truffle.language.globals.CheckMatchVariableTypeNode;
import org.jruby.truffle.language.globals.CheckOutputSeparatorVariableTypeNode;
import org.jruby.truffle.language.globals.CheckProgramNameVariableTypeNode;
import org.jruby.truffle.language.globals.CheckRecordSeparatorVariableTypeNode;
import org.jruby.truffle.language.globals.CheckStdoutVariableTypeNode;
import org.jruby.truffle.language.globals.ReadGlobalVariableNodeGen;
import org.jruby.truffle.language.globals.ReadLastBacktraceNode;
import org.jruby.truffle.language.globals.ReadMatchReferenceNode;
import org.jruby.truffle.language.globals.ReadThreadLocalGlobalVariableNode;
import org.jruby.truffle.language.globals.UpdateLastBacktraceNode;
import org.jruby.truffle.language.globals.UpdateVerbosityNode;
import org.jruby.truffle.language.globals.WriteGlobalVariableNode;
import org.jruby.truffle.language.globals.WriteGlobalVariableNodeGen;
import org.jruby.truffle.language.globals.WriteProgramNameNodeGen;
import org.jruby.truffle.language.globals.WriteReadOnlyGlobalNode;
import org.jruby.truffle.language.literal.BooleanLiteralNode;
import org.jruby.truffle.language.literal.FloatLiteralNode;
import org.jruby.truffle.language.literal.IntegerFixnumLiteralNode;
import org.jruby.truffle.language.literal.LongFixnumLiteralNode;
import org.jruby.truffle.language.literal.NilLiteralNode;
import org.jruby.truffle.language.literal.ObjectLiteralNode;
import org.jruby.truffle.language.literal.StringLiteralNode;
import org.jruby.truffle.language.locals.DeclarationFlipFlopStateNode;
import org.jruby.truffle.language.locals.FlipFlopNode;
import org.jruby.truffle.language.locals.FlipFlopStateNode;
import org.jruby.truffle.language.locals.InitFlipFlopSlotNode;
import org.jruby.truffle.language.locals.LocalFlipFlopStateNode;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadLocalVariableNode;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;
import org.jruby.truffle.language.methods.AddMethodNodeGen;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.BlockDefinitionNode;
import org.jruby.truffle.language.methods.CatchBreakNode;
import org.jruby.truffle.language.methods.ExceptionTranslatingNode;
import org.jruby.truffle.language.methods.GetCurrentVisibilityNode;
import org.jruby.truffle.language.methods.GetDefaultDefineeNode;
import org.jruby.truffle.language.methods.MethodDefinitionNode;
import org.jruby.truffle.language.methods.ModuleBodyDefinitionNode;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.language.objects.DefineClassNode;
import org.jruby.truffle.language.objects.DefineModuleNode;
import org.jruby.truffle.language.objects.LexicalScopeNode;
import org.jruby.truffle.language.objects.ReadClassVariableNode;
import org.jruby.truffle.language.objects.ReadInstanceVariableNode;
import org.jruby.truffle.language.objects.RunModuleDefinitionNode;
import org.jruby.truffle.language.objects.SingletonClassNode;
import org.jruby.truffle.language.objects.SingletonClassNodeGen;
import org.jruby.truffle.language.objects.WriteClassVariableNode;
import org.jruby.truffle.language.objects.WriteInstanceVariableNode;
import org.jruby.truffle.language.parser.jruby.ConstantReplacer;
import org.jruby.truffle.language.parser.jruby.DeadNode;
import org.jruby.truffle.language.parser.jruby.MethodTranslator;
import org.jruby.truffle.language.parser.jruby.ParseEnvironment;
import org.jruby.truffle.language.parser.jruby.ReadLocalDummyNode;
import org.jruby.truffle.language.parser.jruby.ReadLocalNode;
import org.jruby.truffle.language.parser.jruby.Translator;
import org.jruby.truffle.language.parser.jruby.TranslatorEnvironment;
import org.jruby.truffle.language.threadlocal.GetFromThreadLocalNodeGen;
import org.jruby.truffle.language.threadlocal.ThreadLocalObjectNode;
import org.jruby.truffle.language.threadlocal.ThreadLocalObjectNodeGen;
import org.jruby.truffle.language.threadlocal.WrapInThreadLocalNodeGen;
import org.jruby.truffle.language.yield.YieldExpressionNode;
import org.jruby.truffle.platform.graal.AssertConstantNode;
import org.jruby.truffle.platform.graal.AssertConstantNodeGen;
import org.jruby.truffle.platform.graal.AssertNotCompiledNode;
import org.jruby.truffle.platform.graal.AssertNotCompiledNodeGen;
import org.jruby.util.ByteList;
import org.jruby.util.KeyValuePair;

public class BodyTranslator
extends Translator {
    protected final BodyTranslator parent;
    protected final TranslatorEnvironment environment;
    public boolean translatingForStatement = false;
    private boolean translatingNextExpression = false;
    private boolean translatingWhile = false;
    protected String currentCallMethodName = null;
    private boolean privately = false;
    protected boolean usesRubiniusPrimitive = false;
    private static final Set<String> THREAD_LOCAL_GLOBAL_VARIABLES = new HashSet<String>(Arrays.asList("$~", "$1", "$2", "$3", "$4", "$5", "$6", "$7", "$8", "$9", "$!", "$?"));
    private static final Set<String> READ_ONLY_GLOBAL_VARIABLES = new HashSet<String>(Arrays.asList("$:", "$LOAD_PATH", "$-I", "$\"", "$LOADED_FEATURES", "$<", "$FILENAME", "$?", "$-a", "$-l", "$-p", "$!"));
    private static final Map<String, String> GLOBAL_VARIABLE_ALIASES;
    public static final Object BAD_FRAME_SLOT;
    public Deque<Object> frameOnStackMarkerSlotStack = new ArrayDeque<Object>();
    private static final ParserSupport PARSER_SUPPORT;

    public BodyTranslator(com.oracle.truffle.api.nodes.Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, Source source, boolean topLevel) {
        super(currentNode, context, source);
        this.parent = parent;
        this.environment = environment;
    }

    private DynamicObject translateNameNodeToSymbol(Node node) {
        return this.context.getSymbolTable().getSymbol(((LiteralNode)node).getName());
    }

    public RubyNode visitAliasNode(AliasNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        DynamicObject oldName = this.translateNameNodeToSymbol(node.getOldName());
        DynamicObject newName = this.translateNameNodeToSymbol(node.getNewName());
        ModuleNodes.AliasMethodNode ret = ModuleNodesFactory.AliasMethodNodeFactory.create(new RaiseIfFrozenNode(new GetDefaultDefineeNode(this.context, sourceSection)), new ObjectLiteralNode(this.context, sourceSection, newName), new ObjectLiteralNode(this.context, sourceSection, oldName));
        this.setSourceSection(ret, sourceSection);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitAndNode(org.jruby.ast.AndNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode x = this.translateNodeOrNil(sourceSection, node.getFirstNode());
        RubyNode y = this.translateNodeOrNil(sourceSection, node.getSecondNode());
        AndNode ret = new AndNode(this.context, sourceSection, x, y);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitArgsCatNode(ArgsCatNode node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.collectArgsCatNodes(nodes, node);
        ArrayList<Object> translatedNodes = new ArrayList<Object>();
        for (Node catNode : nodes) {
            translatedNodes.add(catNode.accept((NodeVisitor)this));
        }
        ArrayConcatNode ret = new ArrayConcatNode(this.context, this.translate(node.getPosition()), translatedNodes.toArray(new RubyNode[translatedNodes.size()]));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    private void collectArgsCatNodes(List<Node> nodes, ArgsCatNode node) {
        if (node.getFirstNode() instanceof ArgsCatNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatNode)node.getFirstNode());
        } else {
            nodes.add(node.getFirstNode());
        }
        if (node.getSecondNode() instanceof ArgsCatNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatNode)node.getSecondNode());
        } else {
            SplatNode secondNode = new SplatNode(node.getSecondNode().getPosition(), node.getSecondNode());
            nodes.add((Node)secondNode);
        }
    }

    public RubyNode visitArgsPushNode(ArgsPushNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode args = (RubyNode)node.getFirstNode().accept((NodeVisitor)this);
        RubyNode value = (RubyNode)node.getSecondNode().accept((NodeVisitor)this);
        ArrayAppendOneNode ret = ArrayAppendOneNodeGen.create(this.context, sourceSection, KernelNodesFactory.DupNodeFactory.create(this.context, sourceSection, new RubyNode[]{args}), value);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitArrayNode(ArrayNode node) {
        Node[] values = node.children();
        RubyNode[] translatedValues = new RubyNode[values.length];
        for (int n = 0; n < values.length; ++n) {
            translatedValues[n] = (RubyNode)values[n].accept((NodeVisitor)this);
        }
        ArrayLiteralNode ret = ArrayLiteralNode.create(this.context, this.translate(node.getPosition()), translatedValues);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitAttrAssignNode(AttrAssignNode node) {
        ArrayNode fixedArgsNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        FrameSlot frameSlot = this.environment.declareVar(this.environment.allocateLocalTemp("attrasgn"));
        ArrayList<ReadLocalDummyNode> argChildNodes = new ArrayList<ReadLocalDummyNode>(node.getArgsNode().childNodes());
        Node valueNode = (Node)argChildNodes.remove(argChildNodes.size() - 1);
        WriteLocalVariableNode writeValue = new WriteLocalVariableNode(this.context, sourceSection, frameSlot, (RubyNode)valueNode.accept((NodeVisitor)this));
        argChildNodes.add(new ReadLocalDummyNode(node.getPosition(), sourceSection, frameSlot));
        ArrayNode newArgsNode = new ArrayNode(node.getPosition(), (Node)argChildNodes.get(0));
        argChildNodes.remove(0);
        for (Node node2 : argChildNodes) {
            newArgsNode.add(node2);
        }
        if (node.getArgsNode() instanceof ArgsPushNode) {
            if (newArgsNode.size() != 2) {
                throw new UnsupportedOperationException();
            }
            fixedArgsNode = new ArgsPushNode(newArgsNode.getPosition(), newArgsNode.children()[0], newArgsNode.children()[1]);
        } else {
            fixedArgsNode = newArgsNode;
        }
        CallNode callNode = new CallNode(node.getPosition(), node.getReceiverNode(), node.getName(), (Node)fixedArgsNode, null);
        this.copyNewline((Node)node, (Node)callNode);
        boolean isAccessorOnSelf = node.getReceiverNode() instanceof SelfNode;
        RubyNode actualCall = this.translateCallNode(callNode, isAccessorOnSelf, false);
        RubyNode ret = BodyTranslator.sequence(this.context, sourceSection, Arrays.asList(writeValue, actualCall, new ReadLocalVariableNode(this.context, sourceSection, LocalVariableType.FRAME_LOCAL, frameSlot)));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitBeginNode(BeginNode node) {
        RubyNode ret = (RubyNode)node.getBodyNode().accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitBignumNode(BignumNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        BigInteger value = node.getValue();
        RubyNode ret = value.bitLength() >= 64 ? new ObjectLiteralNode(this.context, sourceSection, BignumOperations.createBignum(this.context, node.getValue())) : new LongFixnumLiteralNode(this.context, sourceSection, value.longValue());
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode visitBlockNode(BlockNode node) {
        RubyNode ret;
        int firstLine;
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> translatedChildren = new ArrayList<RubyNode>();
        int lastLine = firstLine = node.getPosition().getLine() + 1;
        for (Node child : node.children()) {
            RubyNode translatedChild;
            if (child.getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection.push(sourceSection);
            } else {
                lastLine = Math.max(lastLine, child.getPosition().getLine() + 1);
            }
            try {
                translatedChild = (RubyNode)child.accept((NodeVisitor)this);
            }
            finally {
                if (child.getPosition() == InvalidSourcePosition.INSTANCE) {
                    this.parentSourceSection.pop();
                }
            }
            if (translatedChild instanceof DeadNode) continue;
            translatedChildren.add(translatedChild);
        }
        if (translatedChildren.size() == 1) {
            ret = (RubyNode)translatedChildren.get(0);
        } else {
            int startIndex = sourceSection.getSource().getLineStartOffset(node.getPosition().getLine() + 1);
            int length = 0;
            for (int n = firstLine; n <= lastLine; ++n) {
                length += sourceSection.getSource().getLineLength(n);
            }
            length = Math.min(length + startIndex, sourceSection.getSource().getLength()) - startIndex;
            ret = BodyTranslator.sequence(this.context, sourceSection.getSource().createSection(sourceSection.getIdentifier(), startIndex, length), translatedChildren);
        }
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode visitBreakNode(org.jruby.ast.BreakNode node) {
        RubyNode resultNode;
        assert (this.environment.isBlock() || this.translatingWhile) : "The parser did not see an invalid break";
        SourceSection sourceSection = this.translate(node.getPosition());
        if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
            this.parentSourceSection.push(sourceSection);
            try {
                resultNode = (RubyNode)node.getValueNode().accept((NodeVisitor)this);
            }
            finally {
                this.parentSourceSection.pop();
            }
        } else {
            resultNode = (RubyNode)node.getValueNode().accept((NodeVisitor)this);
        }
        BreakNode ret = new BreakNode(this.context, sourceSection, this.environment.getBreakID(), this.translatingWhile, resultNode);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitCallNode(CallNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        Node receiver = node.getReceiverNode();
        String methodName = node.getName();
        if (receiver instanceof StrNode && methodName.equals("freeze")) {
            StrNode strNode = (StrNode)receiver;
            ByteList byteList = strNode.getValue();
            int codeRange = strNode.getCodeRange();
            Rope rope = this.context.getRopeTable().getRope(byteList.bytes(), byteList.getEncoding(), CodeRange.fromInt(codeRange));
            DynamicObject frozenString = this.context.getFrozenStrings().getFrozenString(rope);
            return this.addNewlineIfNeeded((Node)node, new DefinedWrapperNode(this.context, sourceSection, this.context.getCoreStrings().METHOD, new ObjectLiteralNode(this.context, null, frozenString)));
        }
        if (receiver instanceof ConstNode && ((ConstNode)receiver).getName().equals("Rubinius")) {
            if (methodName.equals("primitive")) {
                RubyNode ret = this.translateRubiniusPrimitive(sourceSection, node);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (methodName.equals("invoke_primitive")) {
                RubyNode ret = this.translateRubiniusInvokePrimitive(sourceSection, node);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (methodName.equals("privately")) {
                RubyNode ret = this.translateRubiniusPrivately(sourceSection, node);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (methodName.equals("single_block_arg")) {
                RubyNode ret = this.translateRubiniusSingleBlockArg(sourceSection, node);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (methodName.equals("check_frozen")) {
                RubyNode ret = this.translateRubiniusCheckFrozen(sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
        } else if (receiver instanceof Colon2ConstNode && ((Colon2ConstNode)receiver).getLeftNode() instanceof ConstNode && ((ConstNode)((Colon2ConstNode)receiver).getLeftNode()).getName().equals("Truffle") && ((Colon2ConstNode)receiver).getName().equals("Graal")) {
            if (methodName.equals("assert_constant")) {
                AssertConstantNode ret = AssertConstantNodeGen.create(this.context, sourceSection, (RubyNode)((Node)node.getArgsNode().childNodes().get(0)).accept((NodeVisitor)this));
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (methodName.equals("assert_not_compiled")) {
                AssertNotCompiledNode ret = AssertNotCompiledNodeGen.create(this.context, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
        } else if (receiver instanceof ConstNode && ((ConstNode)receiver).getName().equals("Truffle")) {
            if (methodName.equals("omit")) {
                RubyNode ret = this.nilNode(sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
        } else if (receiver instanceof VCallNode && ((VCallNode)receiver).getName().equals("undefined") && this.getSourcePath(sourceSection).startsWith(this.context.getCoreLibrary().getCoreLoadPath() + "/core/") && methodName.equals("equal?")) {
            RubyNode argument = this.translateArgumentsAndBlock(sourceSection, null, node.getArgsNode(), methodName).getArguments()[0];
            IsRubiniusUndefinedNode ret = new IsRubiniusUndefinedNode(this.context, sourceSection, argument);
            return this.addNewlineIfNeeded((Node)node, ret);
        }
        return this.translateCallNode(node, false, false);
    }

    private RubyNode translateRubiniusPrimitive(SourceSection sourceSection, CallNode node) {
        this.usesRubiniusPrimitive = true;
        if (node.getArgsNode().childNodes().size() != 1 || !(node.getArgsNode().childNodes().get(0) instanceof SymbolNode)) {
            throw new UnsupportedOperationException("Rubinius.primitive must have a single literal symbol argument");
        }
        String primitiveName = ((SymbolNode)node.getArgsNode().childNodes().get(0)).getName();
        RubiniusPrimitiveConstructor primitive = this.context.getRubiniusPrimitiveManager().getPrimitive(primitiveName);
        ReturnID returnID = this.environment.getReturnID();
        return primitive.createCallPrimitiveNode(this.context, sourceSection, returnID);
    }

    private RubyNode translateRubiniusInvokePrimitive(SourceSection sourceSection, CallNode node) {
        if (node.getArgsNode().childNodes().size() < 1 || !(node.getArgsNode().childNodes().get(0) instanceof SymbolNode)) {
            throw new UnsupportedOperationException("Rubinius.invoke_primitive must have at least an initial literal symbol argument");
        }
        String primitiveName = ((SymbolNode)node.getArgsNode().childNodes().get(0)).getName();
        RubiniusPrimitiveConstructor primitive = this.context.getRubiniusPrimitiveManager().getPrimitive(primitiveName);
        ArrayList<RubyNode> arguments = new ArrayList<RubyNode>();
        for (int n = 1; n < node.getArgsNode().childNodes().size(); ++n) {
            RubyNode readArgumentNode = (RubyNode)((Node)node.getArgsNode().childNodes().get(n)).accept((NodeVisitor)this);
            arguments.add(readArgumentNode);
        }
        return primitive.createInvokePrimitiveNode(this.context, sourceSection, arguments.toArray(new RubyNode[arguments.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateRubiniusPrivately(SourceSection sourceSection, CallNode node) {
        if (!(node.getIterNode() instanceof IterNode)) {
            throw new UnsupportedOperationException("Rubinius.privately needs a literal block");
        }
        if (node.getArgsNode() != null && node.getArgsNode().childNodes().size() > 0) {
            throw new UnsupportedOperationException("Rubinius.privately should not have any arguments");
        }
        this.currentCallMethodName = "privately";
        boolean previousPrivately = this.privately;
        this.privately = true;
        try {
            RubyNode rubyNode = (RubyNode)((IterNode)node.getIterNode()).getBodyNode().accept((NodeVisitor)this);
            return rubyNode;
        }
        finally {
            this.privately = previousPrivately;
        }
    }

    public RubyNode translateRubiniusSingleBlockArg(SourceSection sourceSection, CallNode node) {
        return new RubiniusSingleBlockArgNode(this.context, sourceSection);
    }

    private RubyNode translateRubiniusCheckFrozen(SourceSection sourceSection) {
        return new RaiseIfFrozenNode(new org.jruby.truffle.language.objects.SelfNode(this.context, sourceSection));
    }

    private RubyNode translateCallNode(CallNode node, boolean ignoreVisibility, boolean isVCall) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode receiverTranslated = (RubyNode)node.getReceiverNode().accept((NodeVisitor)this);
        Node args = node.getArgsNode();
        Node block = node.getIterNode();
        if (block == null && args instanceof IterNode) {
            block = args;
            args = null;
        }
        ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, block, args, node.getName());
        ArrayList<RubyNode> children = new ArrayList<RubyNode>();
        if (argumentsAndBlock.getBlock() != null) {
            children.add(argumentsAndBlock.getBlock());
        }
        children.addAll(Arrays.asList(argumentsAndBlock.getArguments()));
        RubyNode translated = new RubyCallNode(this.context, BodyTranslator.enclosing(sourceSection, children.toArray(new RubyNode[children.size()])), node.getName(), receiverTranslated, argumentsAndBlock.getBlock(), argumentsAndBlock.isSplatted(), this.privately || ignoreVisibility, isVCall, argumentsAndBlock.getArguments());
        if (argumentsAndBlock.getBlock() instanceof BlockDefinitionNode) {
            BlockDefinitionNode blockDef = (BlockDefinitionNode)argumentsAndBlock.getBlock();
            translated = new FrameOnStackNode(this.context, translated.getSourceSection(), translated, argumentsAndBlock.getFrameOnStackMarkerSlot());
            translated = new CatchBreakNode(this.context, translated.getSourceSection(), blockDef.getBreakID(), translated);
        }
        return this.addNewlineIfNeeded((Node)node, translated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArgumentsAndBlockTranslation translateArgumentsAndBlock(SourceSection sourceSection, Node iterNode, Node argsNode, String nameToSetWhenTranslatingBlock) {
        FrameSlot frameOnStackMarkerSlot;
        RubyNode blockTranslated;
        assert (!(argsNode instanceof IterNode));
        ArrayList<Node> arguments = new ArrayList<Node>();
        Node blockPassNode = null;
        boolean isSplatted = false;
        if (argsNode instanceof ListNode) {
            arguments.addAll(argsNode.childNodes());
        } else if (argsNode instanceof BlockPassNode) {
            BlockPassNode blockPass = (BlockPassNode)argsNode;
            Node blockPassArgs = blockPass.getArgsNode();
            if (blockPassArgs instanceof ListNode) {
                arguments.addAll(blockPassArgs.childNodes());
            } else if (blockPassArgs instanceof ArgsCatNode) {
                arguments.add(blockPassArgs);
            } else if (blockPassArgs != null) {
                throw new UnsupportedOperationException("Don't know how to block pass " + blockPassArgs);
            }
            blockPassNode = blockPass.getBodyNode();
        } else if (argsNode instanceof SplatNode) {
            isSplatted = true;
            arguments.add(argsNode);
        } else if (argsNode instanceof ArgsCatNode) {
            isSplatted = true;
            arguments.add(argsNode);
        } else if (argsNode != null) {
            isSplatted = true;
            arguments.add(argsNode);
        }
        RubyNode[] argumentsTranslated = new RubyNode[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            argumentsTranslated[i] = (RubyNode)((Node)arguments.get(i)).accept((NodeVisitor)this);
        }
        if (iterNode instanceof BlockPassNode) {
            blockPassNode = ((BlockPassNode)iterNode).getBodyNode();
        }
        this.currentCallMethodName = nameToSetWhenTranslatingBlock;
        if (blockPassNode != null) {
            blockTranslated = ToProcNodeGen.create(this.context, sourceSection, (RubyNode)blockPassNode.accept((NodeVisitor)this));
            frameOnStackMarkerSlot = null;
        } else if (iterNode != null) {
            frameOnStackMarkerSlot = this.environment.declareVar(this.environment.allocateLocalTemp("frame_on_stack_marker"));
            this.frameOnStackMarkerSlotStack.push(frameOnStackMarkerSlot);
            try {
                blockTranslated = (RubyNode)iterNode.accept((NodeVisitor)this);
            }
            finally {
                this.frameOnStackMarkerSlotStack.pop();
            }
            if (blockTranslated instanceof ObjectLiteralNode && ((ObjectLiteralNode)blockTranslated).getObject() == this.context.getCoreLibrary().getNilObject()) {
                blockTranslated = null;
            }
        } else {
            blockTranslated = null;
            frameOnStackMarkerSlot = null;
        }
        return new ArgumentsAndBlockTranslation(blockTranslated, argumentsTranslated, isSplatted, frameOnStackMarkerSlot);
    }

    public RubyNode visitCaseNode(CaseNode node) {
        RubyNode ret;
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode elseNode = this.translateNodeOrNil(sourceSection, node.getElseNode());
        if (node.getCaseNode() != null) {
            String tempName = this.environment.allocateLocalTemp("case");
            ReadLocalNode readTemp = this.environment.findLocalVarNode(tempName, sourceSection);
            RubyNode assignTemp = readTemp.makeWriteNode((RubyNode)node.getCaseNode().accept((NodeVisitor)this));
            for (int n = node.getCases().size() - 1; n >= 0; --n) {
                WhenNode when = (WhenNode)node.getCases().get(n);
                List expressions = when.getExpressionNodes() instanceof ListNode && !(when.getExpressionNodes() instanceof ArrayNode) ? when.getExpressionNodes().childNodes() : Collections.singletonList(when.getExpressionNodes());
                ArrayList<RubyCallNode> comparisons = new ArrayList<RubyCallNode>();
                for (Node expressionNode : expressions) {
                    RubyNode rubyExpression = (RubyNode)expressionNode.accept((NodeVisitor)this);
                    if (expressionNode instanceof SplatNode || expressionNode instanceof ArgsCatNode || expressionNode instanceof ArgsPushNode) {
                        comparisons.add(new RubyCallNode(this.context, sourceSection, "when_splat", (RubyNode)new org.jruby.truffle.language.objects.SelfNode(this.context, sourceSection), null, false, true, rubyExpression, NodeUtil.cloneNode(readTemp)));
                        continue;
                    }
                    comparisons.add(new RubyCallNode(this.context, sourceSection, "===", rubyExpression, null, false, true, NodeUtil.cloneNode(readTemp)));
                }
                RubyNode conditionNode = (RubyNode)comparisons.get(comparisons.size() - 1);
                for (int i = comparisons.size() - 2; i >= 0; --i) {
                    conditionNode = new org.jruby.truffle.language.control.OrNode(this.context, sourceSection, (RubyNode)comparisons.get(i), conditionNode);
                }
                RubyNode thenNode = this.translateNodeOrNil(sourceSection, when.getBodyNode());
                IfElseNode ifNode = new IfElseNode(this.context, sourceSection, conditionNode, thenNode, elseNode);
                elseNode = ifNode;
            }
            RubyNode ifNode = elseNode;
            ret = BodyTranslator.sequence(this.context, sourceSection, Arrays.asList(assignTemp, ifNode));
        } else {
            for (int n = node.getCases().size() - 1; n >= 0; --n) {
                WhenNode when = (WhenNode)node.getCases().get(n);
                List<Node> expressions = when.getExpressionNodes() instanceof ListNode ? when.getExpressionNodes().childNodes() : Collections.singletonList(when.getExpressionNodes());
                ArrayList<RubyNode> tests = new ArrayList<RubyNode>();
                for (Node expressionNode : expressions) {
                    RubyNode rubyExpression = (RubyNode)expressionNode.accept((NodeVisitor)this);
                    tests.add(rubyExpression);
                }
                RubyNode conditionNode = (RubyNode)tests.get(tests.size() - 1);
                for (int i = tests.size() - 2; i >= 0; --i) {
                    conditionNode = new org.jruby.truffle.language.control.OrNode(this.context, sourceSection, (RubyNode)tests.get(i), conditionNode);
                }
                RubyNode thenNode = (RubyNode)when.getBodyNode().accept((NodeVisitor)this);
                IfElseNode ifNode = new IfElseNode(this.context, sourceSection, conditionNode, thenNode, elseNode);
                elseNode = ifNode;
            }
            ret = elseNode;
        }
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode openModule(SourceSection sourceSection, RubyNode defineOrGetNode, String name, Node bodyNode, boolean sclass) {
        LexicalScope newLexicalScope = this.environment.pushLexicalScope();
        try {
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, newLexicalScope, Arity.NO_ARGUMENTS, name, false, null, false, false, false);
            ReturnID returnId = sclass ? this.environment.getReturnID() : this.environment.getParseEnvironment().allocateReturnID();
            TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParseEnvironment(), returnId, true, true, sharedMethodInfo, name, 0, null);
            BodyTranslator moduleTranslator = new BodyTranslator(this.currentNode, this.context, this, newEnvironment, this.source, false);
            ModuleBodyDefinitionNode definition = moduleTranslator.compileClassNode(sourceSection, name, bodyNode, sclass);
            RunModuleDefinitionNode runModuleDefinitionNode = new RunModuleDefinitionNode(this.context, sourceSection, newLexicalScope, definition, defineOrGetNode);
            return runModuleDefinitionNode;
        }
        finally {
            this.environment.popLexicalScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleBodyDefinitionNode compileClassNode(SourceSection sourceSection, String name, Node bodyNode, boolean sclass) {
        RubyNode body;
        this.parentSourceSection.push(sourceSection);
        try {
            body = this.translateNodeOrNil(sourceSection, bodyNode);
        }
        finally {
            this.parentSourceSection.pop();
        }
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = BodyTranslator.sequence(this.context, sourceSection, Arrays.asList(this.initFlipFlopStates(sourceSection), body));
        }
        RubyRootNode rootNode = new RubyRootNode(this.context, sourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body, this.environment.needsDeclarationFrame());
        ModuleBodyDefinitionNode definitionNode = new ModuleBodyDefinitionNode(this.context, sourceSection, this.environment.getSharedMethodInfo().getName(), this.environment.getSharedMethodInfo(), Truffle.getRuntime().createCallTarget(rootNode), sclass);
        return definitionNode;
    }

    public RubyNode visitClassNode(ClassNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        RubyNode superClass = node.getSuperNode() != null ? (RubyNode)node.getSuperNode().accept((NodeVisitor)this) : new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
        DefineClassNode defineOrGetClass = new DefineClassNode(this.context, sourceSection, name, lexicalParent, superClass);
        RubyNode ret = this.openModule(sourceSection, defineOrGetClass, name, node.getBodyNode(), false);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitClassVarAsgnNode(ClassVarAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode rhs = (RubyNode)node.getValueNode().accept((NodeVisitor)this);
        WriteClassVariableNode ret = new WriteClassVariableNode(this.context, sourceSection, this.environment.getLexicalScope(), node.getName(), rhs);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitClassVarNode(ClassVarNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ReadClassVariableNode ret = new ReadClassVariableNode(this.context, sourceSection, this.environment.getLexicalScope(), node.getName());
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitColon2Node(Colon2Node node) {
        if (!(node instanceof Colon2ConstNode)) {
            throw new UnsupportedOperationException(node.toString());
        }
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = ConstantReplacer.replacementName(sourceSection, node.getName());
        RubyNode lhs = (RubyNode)node.getLeftNode().accept((NodeVisitor)this);
        ReadLiteralConstantNode ret = new ReadLiteralConstantNode(this.context, sourceSection, lhs, name);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitColon3Node(Colon3Node node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = ConstantReplacer.replacementName(sourceSection, node.getName());
        ObjectLiteralNode root = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
        ReadLiteralConstantNode ret = new ReadLiteralConstantNode(this.context, sourceSection, root, name);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    private RubyNode translateCPath(SourceSection sourceSection, Colon3Node node) {
        RubyNode ret = node instanceof Colon2ImplicitNode ? new LexicalScopeNode(this.context, sourceSection, this.environment.getLexicalScope()) : (node instanceof Colon2ConstNode ? (RubyNode)((Node)node.childNodes().get(0)).accept((NodeVisitor)this) : new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass()));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitComplexNode(ComplexNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode ret = this.translateRationalComplex(sourceSection, "Complex", new IntegerFixnumLiteralNode(this.context, sourceSection, 0), (RubyNode)node.getNumber().accept((NodeVisitor)this));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitConstDeclNode(ConstDeclNode node) {
        RubyNode moduleNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode rhs = (RubyNode)node.getValueNode().accept((NodeVisitor)this);
        Node constNode = node.getConstNode();
        if (constNode == null || constNode instanceof Colon2ImplicitNode) {
            moduleNode = new LexicalScopeNode(this.context, sourceSection, this.environment.getLexicalScope());
        } else if (constNode instanceof Colon2ConstNode) {
            constNode = ((Colon2Node)constNode).getLeftNode();
            moduleNode = (RubyNode)constNode.accept((NodeVisitor)this);
        } else if (constNode instanceof Colon3Node) {
            moduleNode = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
        } else {
            throw new UnsupportedOperationException();
        }
        WriteConstantNode ret = new WriteConstantNode(this.context, sourceSection, node.getName(), moduleNode, rhs);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    private String getSourcePath(SourceSection sourceSection) {
        Source source = sourceSection.getSource();
        if (source == null) {
            return "(unknown)";
        }
        String path = source.getPath();
        if (path == null) {
            return source.getShortName();
        }
        return path;
    }

    public RubyNode visitConstNode(ConstNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = ConstantReplacer.replacementName(sourceSection, node.getName());
        if (name.equals("Rubinius") && this.getSourcePath(sourceSection).startsWith(this.context.getCoreLibrary().getCoreLoadPath() + "/core/rubinius")) {
            RubyNode ret = (RubyNode)new Colon3Node(node.getPosition(), name).accept((NodeVisitor)this);
            return this.addNewlineIfNeeded((Node)node, ret);
        }
        if (name.equals("RUBY_PLATFORM") && this.getSourcePath(sourceSection).contains("test/xml_mini/jdom_engine_test.rb")) {
            ObjectLiteralNode ret = new ObjectLiteralNode(this.context, sourceSection, StringOperations.createString(this.context, StringOperations.encodeRope("truffle", (Encoding)UTF8Encoding.INSTANCE, CodeRange.CR_7BIT)));
            return this.addNewlineIfNeeded((Node)node, ret);
        }
        LexicalScope lexicalScope = this.environment.getLexicalScope();
        ReadConstantWithLexicalScopeNode ret = new ReadConstantWithLexicalScopeNode(this.context, sourceSection, lexicalScope, name);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitDAsgnNode(DAsgnNode node) {
        RubyNode ret = (RubyNode)new LocalAsgnNode(node.getPosition(), node.getName(), node.getDepth(), node.getValueNode()).accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitDRegxNode(DRegexpNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<Object> children = new ArrayList<Object>();
        for (Node child : node.children()) {
            children.add(child.accept((NodeVisitor)this));
        }
        InterpolatedRegexpNode i = new InterpolatedRegexpNode(this.context, sourceSection, children.toArray(new RubyNode[children.size()]), node.getOptions());
        if (node.getOptions().isOnce()) {
            OnceNode ret = new OnceNode(this.context, i.getEncapsulatingSourceSection(), i);
            return this.addNewlineIfNeeded((Node)node, ret);
        }
        return this.addNewlineIfNeeded((Node)node, i);
    }

    public RubyNode visitDStrNode(DStrNode node) {
        RubyNode ret = this.translateInterpolatedString(this.translate(node.getPosition()), node.children());
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitDSymbolNode(DSymbolNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode stringNode = this.translateInterpolatedString(sourceSection, node.children());
        StringToSymbolNode ret = StringToSymbolNodeGen.create(this.context, sourceSection, stringNode);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    private RubyNode translateInterpolatedString(SourceSection sourceSection, Node[] childNodes) {
        ToSNode[] children = new ToSNode[childNodes.length];
        for (int i = 0; i < childNodes.length; ++i) {
            children[i] = ToSNodeGen.create(this.context, sourceSection, (RubyNode)childNodes[i].accept((NodeVisitor)this));
        }
        return new InterpolatedStringNode(this.context, sourceSection, children);
    }

    public RubyNode visitDVarNode(DVarNode node) {
        ReadLocalNode readNode = this.environment.findLocalVarNode(node.getName(), this.translate(node.getPosition()));
        if (readNode == null) {
            int depth = node.getDepth();
            TranslatorEnvironment e = this.environment;
            for (int n = 0; n < depth; ++n) {
                e = e.getParent();
            }
            e.declareVar(node.getName());
            readNode = this.environment.findLocalVarNode(node.getName(), this.translate(node.getPosition()));
        }
        return this.addNewlineIfNeeded((Node)node, readNode);
    }

    public RubyNode visitDXStrNode(DXStrNode node) {
        DStrNode string = new DStrNode(node.getPosition(), node.getEncoding());
        string.addAll((ListNode)node);
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), (Node)string, new Node[0]);
        FCallNode callNode = new FCallNode(node.getPosition(), "`", (Node)argsNode, null);
        this.copyNewline((Node)node, (Node)callNode);
        RubyNode ret = (RubyNode)callNode.accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitDefinedNode(DefinedNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        org.jruby.truffle.language.defined.DefinedNode ret = new org.jruby.truffle.language.defined.DefinedNode(this.context, sourceSection, (RubyNode)node.getExpressionNode().accept((NodeVisitor)this));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitDefnNode(DefnNode node) {
        String coreRubiniusPath;
        SourceSection sourceSection = this.translate(node.getPosition(), node.getName());
        RaiseIfFrozenNode classNode = new RaiseIfFrozenNode(new GetDefaultDefineeNode(this.context, sourceSection));
        String methodName = node.getName();
        String path = this.getSourcePath(sourceSection);
        if (path.startsWith(coreRubiniusPath = this.context.getCoreLibrary().getCoreLoadPath() + "/core/rubinius/")) {
            boolean rename = false;
            if (path.equals(coreRubiniusPath + "common/array.rb")) {
                rename = methodName.equals("fill") || methodName.equals("zip");
            } else if (path.equals(coreRubiniusPath + "common/float.rb")) {
                rename = methodName.equals("round");
            } else if (path.equals(coreRubiniusPath + "common/range.rb")) {
                rename = methodName.equals("each") || methodName.equals("step") || methodName.equals("to_a");
            } else if (path.equals(coreRubiniusPath + "common/integer.rb")) {
                rename = methodName.equals("downto") || methodName.equals("upto");
            } else if (path.equals(coreRubiniusPath + "common/string.rb")) {
                rename = methodName.equals("<<");
            }
            if (rename) {
                methodName = methodName.equals("<<") ? "concat_internal" : methodName + "_internal";
            }
        }
        RubyNode ret = this.translateMethodDefinition(sourceSection, classNode, methodName, node.getArgsNode(), node.getBodyNode(), false);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitDefsNode(DefsNode node) {
        SourceSection sourceSection = this.translate(node.getPosition(), node.getName());
        RubyNode objectNode = (RubyNode)node.getReceiverNode().accept((NodeVisitor)this);
        SingletonClassNode singletonClassNode = SingletonClassNodeGen.create(this.context, sourceSection, objectNode);
        RubyNode ret = this.translateMethodDefinition(sourceSection, singletonClassNode, node.getName(), node.getArgsNode(), node.getBodyNode(), true);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    protected RubyNode translateMethodDefinition(SourceSection sourceSection, RubyNode classNode, String methodName, ArgsNode argsNode, Node bodyNode, boolean isDefs) {
        Arity arity = MethodTranslator.getArity(argsNode);
        ArgumentDescriptor[] argumentDescriptors = Helpers.argsNodeToArgumentDescriptors((ArgsNode)argsNode);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.environment.getLexicalScope(), arity, methodName, false, argumentDescriptors, false, false, false);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParseEnvironment(), this.environment.getParseEnvironment().allocateReturnID(), true, true, sharedMethodInfo, methodName, 0, null);
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, false, this.source, argsNode);
        MethodDefinitionNode methodDefinitionNode = methodCompiler.compileMethodNode(sourceSection, methodName, bodyNode, sharedMethodInfo);
        RubyNode visibilityNode = isDefs ? new ObjectLiteralNode(this.context, sourceSection, Visibility.PUBLIC) : new GetCurrentVisibilityNode(this.context, sourceSection);
        return AddMethodNodeGen.create(this.context, sourceSection, isDefs, true, classNode, methodDefinitionNode, visibilityNode);
    }

    public RubyNode visitDotNode(DotNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode begin = (RubyNode)node.getBeginNode().accept((NodeVisitor)this);
        RubyNode end = (RubyNode)node.getEndNode().accept((NodeVisitor)this);
        ObjectLiteralNode rangeClass = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getRangeClass());
        ObjectLiteralNode isExclusive = new ObjectLiteralNode(this.context, sourceSection, node.isExclusive());
        RangeNodes.NewNode ret = RangeNodesFactory.NewNodeFactory.create(this.context, sourceSection, rangeClass, begin, end, isExclusive);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitEncodingNode(EncodingNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ObjectLiteralNode ret = new ObjectLiteralNode(this.context, sourceSection, EncodingNodes.getEncoding(node.getEncoding()));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitEnsureNode(org.jruby.ast.EnsureNode node) {
        RubyNode tryPart = (RubyNode)node.getBodyNode().accept((NodeVisitor)this);
        RubyNode ensurePart = (RubyNode)node.getEnsureNode().accept((NodeVisitor)this);
        EnsureNode ret = new EnsureNode(this.context, this.translate(node.getPosition()), tryPart, ensurePart);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitEvStrNode(EvStrNode node) {
        RubyNode ret;
        if (node.getBody() == null) {
            SourceSection sourceSection = this.translate(node.getPosition());
            ret = new ObjectLiteralNode(this.context, sourceSection, StringOperations.createString(this.context, RopeConstants.EMPTY_ASCII_8BIT_ROPE));
        } else {
            ret = (RubyNode)node.getBody().accept((NodeVisitor)this);
        }
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitFCallNode(FCallNode node) {
        SelfNode receiver = new SelfNode(node.getPosition());
        CallNode callNode = new CallNode(node.getPosition(), (Node)receiver, node.getName(), node.getArgsNode(), node.getIterNode());
        this.copyNewline((Node)node, (Node)callNode);
        return this.translateCallNode(callNode, true, false);
    }

    public RubyNode visitFalseNode(FalseNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        BooleanLiteralNode ret = new BooleanLiteralNode(this.context, sourceSection, false);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitFixnumNode(FixnumNode node) {
        long value = node.getValue();
        RubyNode ret = CoreLibrary.fitsIntoInteger(value) ? new IntegerFixnumLiteralNode(this.context, this.translate(node.getPosition()), (int)value) : new LongFixnumLiteralNode(this.context, this.translate(node.getPosition()), value);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitFlipNode(FlipNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode begin = (RubyNode)node.getBeginNode().accept((NodeVisitor)this);
        RubyNode end = (RubyNode)node.getEndNode().accept((NodeVisitor)this);
        FlipFlopStateNode stateNode = this.createFlipFlopState(sourceSection, 0);
        FlipFlopNode ret = new FlipFlopNode(this.context, sourceSection, begin, end, stateNode, node.isExclusive());
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    protected FlipFlopStateNode createFlipFlopState(SourceSection sourceSection, int depth) {
        FrameSlot frameSlot = this.environment.declareVar(this.environment.allocateLocalTemp("flipflop"));
        this.environment.getFlipFlopStates().add(frameSlot);
        if (depth == 0) {
            return new LocalFlipFlopStateNode(frameSlot);
        }
        return new DeclarationFlipFlopStateNode(depth, frameSlot);
    }

    public RubyNode visitFloatNode(FloatNode node) {
        FloatLiteralNode ret = new FloatLiteralNode(this.context, this.translate(node.getPosition()), node.getValue());
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitForNode(ForNode node) {
        String temp = this.environment.allocateLocalTemp("for");
        Node receiver = node.getIterNode();
        LocalVarNode readTemp = new LocalVarNode(node.getPosition(), 0, temp);
        Node forVar = node.getVarNode();
        Node assignTemp = BodyTranslator.setRHS(forVar, (Node)readTemp);
        BlockNode bodyWithTempAssign = new BlockNode(node.getPosition());
        bodyWithTempAssign.add(assignTemp);
        bodyWithTempAssign.add(node.getBodyNode());
        ArgumentNode blockVar = new ArgumentNode(node.getPosition(), temp);
        ListNode blockArgsPre = new ListNode(node.getPosition(), (Node)blockVar);
        ArgsNode blockArgs = new ArgsNode(node.getPosition(), blockArgsPre, null, null, null, null, null, null);
        IterNode block = new IterNode(node.getPosition(), (Node)blockArgs, node.getScope(), (Node)bodyWithTempAssign);
        CallNode callNode = new CallNode(node.getPosition(), receiver, "each", null, (Node)block);
        this.copyNewline((Node)node, (Node)callNode);
        this.translatingForStatement = true;
        RubyNode translated = (RubyNode)callNode.accept((NodeVisitor)this);
        this.translatingForStatement = false;
        return this.addNewlineIfNeeded((Node)node, translated);
    }

    private static Node setRHS(Node node, Node rhs) {
        if (node instanceof AssignableNode || node instanceof IArgumentNode) {
            return PARSER_SUPPORT.node_assign(node, rhs);
        }
        throw new UnsupportedOperationException("Don't know how to set the RHS of a " + node.getClass().getName());
    }

    private RubyNode translateDummyAssignment(Node dummyAssignment, final RubyNode rhs) {
        if (dummyAssignment instanceof StarNode) {
            return rhs;
        }
        if (dummyAssignment instanceof AssignableNode || dummyAssignment instanceof IArgumentNode) {
            Node wrappedRHS = new Node(dummyAssignment.getPosition(), false){

                public <T> T accept(NodeVisitor<T> visitor) {
                    return (T)rhs;
                }

                public List<Node> childNodes() {
                    return Collections.emptyList();
                }

                public NodeType getNodeType() {
                    return NodeType.FIXNUMNODE;
                }
            };
            return (RubyNode)BodyTranslator.setRHS(dummyAssignment, wrappedRHS).accept((NodeVisitor)this);
        }
        throw new UnsupportedOperationException("Don't know how to translate the dummy asgn " + dummyAssignment.getClass().getName());
    }

    public RubyNode visitGlobalAsgnNode(GlobalAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode rhs = (RubyNode)node.getValueNode().accept((NodeVisitor)this);
        String name = node.getName();
        if (GLOBAL_VARIABLE_ALIASES.containsKey(name)) {
            name = GLOBAL_VARIABLE_ALIASES.get(name);
        }
        if (name.equals("$~")) {
            rhs = new CheckMatchVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name.equals("$0")) {
            rhs = new CheckProgramNameVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name.equals("$/")) {
            rhs = new CheckRecordSeparatorVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name.equals("$,")) {
            rhs = new CheckOutputSeparatorVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name.equals("$_")) {
            rhs = this.getSourcePath(sourceSection).endsWith("truffle/rubysl/rubysl-stringio/lib/rubysl/stringio/stringio.rb") ? RubiniusLastStringWriteNodeGen.create(this.context, sourceSection, rhs) : WrapInThreadLocalNodeGen.create(this.context, sourceSection, rhs);
            this.environment.declareVar("$_");
        } else if (name.equals("$stdout")) {
            rhs = new CheckStdoutVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name.equals("$VERBOSE")) {
            rhs = new UpdateVerbosityNode(this.context, sourceSection, rhs);
        } else if (name.equals("$@")) {
            return new UpdateLastBacktraceNode(this.context, sourceSection, rhs);
        }
        boolean inCore = this.getSourcePath(rhs.getSourceSection()).startsWith(this.context.getCoreLibrary().getCoreLoadPath() + "/core/");
        if (!inCore && READ_ONLY_GLOBAL_VARIABLES.contains(name)) {
            return this.addNewlineIfNeeded((Node)node, new WriteReadOnlyGlobalNode(this.context, sourceSection, name, rhs));
        }
        if (THREAD_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            ThreadLocalObjectNode threadLocalVariablesObjectNode = ThreadLocalObjectNodeGen.create(this.context, sourceSection);
            return this.addNewlineIfNeeded((Node)node, new WriteInstanceVariableNode(this.context, sourceSection, name, threadLocalVariablesObjectNode, rhs));
        }
        if (FRAME_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            ReadLocalNode localVarNode;
            if (this.environment.getNeverAssignInParentScope()) {
                this.environment.declareVar(name);
            }
            if ((localVarNode = this.environment.findLocalVarNode(node.getName(), sourceSection)) == null) {
                if (this.environment.hasOwnScopeForAssignments()) {
                    this.environment.declareVar(node.getName());
                }
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(node.getName());
                localVarNode = this.environment.findLocalVarNode(node.getName(), sourceSection);
                if (localVarNode == null) {
                    throw new RuntimeException("shouldn't be here");
                }
            }
            RubyNode assignment = localVarNode.makeWriteNode(rhs);
            if (name.equals("$_")) {
                assignment = GetFromThreadLocalNodeGen.create(this.context, sourceSection, assignment);
            }
            return this.addNewlineIfNeeded((Node)node, assignment);
        }
        WriteGlobalVariableNode writeGlobalVariableNode = WriteGlobalVariableNodeGen.create(this.context, sourceSection, name, rhs);
        RubyNode translated = name.equals("$0") ? WriteProgramNameNodeGen.create(this.context, sourceSection, writeGlobalVariableNode) : writeGlobalVariableNode;
        return this.addNewlineIfNeeded((Node)node, translated);
    }

    public RubyNode visitGlobalVarNode(GlobalVarNode node) {
        RubyNode ret;
        String name = node.getName();
        if (GLOBAL_VARIABLE_ALIASES.containsKey(name)) {
            name = GLOBAL_VARIABLE_ALIASES.get(name);
        }
        SourceSection sourceSection = this.translate(node.getPosition());
        if (FRAME_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            this.environment.declareVarWhereAllowed(name);
            RubyNode readNode = this.environment.findLocalVarNode(name, sourceSection);
            if (name.equals("$_")) {
                readNode = this.getSourcePath(sourceSection).equals(this.context.getCoreLibrary().getCoreLoadPath() + "/core/rubinius/common/regexp.rb") ? new RubiniusLastStringReadNode(this.context, sourceSection) : GetFromThreadLocalNodeGen.create(this.context, sourceSection, readNode);
            }
            ret = readNode;
        } else {
            ret = THREAD_LOCAL_GLOBAL_VARIABLES.contains(name) ? new ReadThreadLocalGlobalVariableNode(this.context, sourceSection, name, ALWAYS_DEFINED_GLOBALS.contains(name)) : (name.equals("$@") ? new ReadLastBacktraceNode(this.context, sourceSection) : ReadGlobalVariableNodeGen.create(this.context, sourceSection, name));
        }
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitHashNode(HashNode node) {
        RubyNode ret;
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> hashConcats = new ArrayList<RubyNode>();
        ArrayList<Object> keyValues = new ArrayList<Object>();
        for (KeyValuePair pair : node.getPairs()) {
            if (pair.getKey() == null) {
                HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(this.context, this.translate(node.getPosition()), keyValues.toArray(new RubyNode[keyValues.size()]));
                hashConcats.add(hashLiteralSoFar);
                hashConcats.add(HashCastNodeGen.create(this.context, sourceSection, (RubyNode)((Node)pair.getValue()).accept((NodeVisitor)this)));
                keyValues.clear();
                continue;
            }
            keyValues.add(((Node)pair.getKey()).accept((NodeVisitor)this));
            if (pair.getValue() == null) {
                keyValues.add(this.nilNode(sourceSection));
                continue;
            }
            keyValues.add(((Node)pair.getValue()).accept((NodeVisitor)this));
        }
        HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(this.context, this.translate(node.getPosition()), keyValues.toArray(new RubyNode[keyValues.size()]));
        hashConcats.add(hashLiteralSoFar);
        if (hashConcats.size() == 1) {
            ret = (RubyNode)hashConcats.get(0);
            return this.addNewlineIfNeeded((Node)node, ret);
        }
        ret = new ConcatHashLiteralNode(this.context, sourceSection, hashConcats.toArray(new RubyNode[hashConcats.size()]));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitIfNode(org.jruby.ast.IfNode node) {
        RubyNode ret;
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode condition = this.translateNodeOrNil(sourceSection, node.getCondition());
        Node thenBody = node.getThenBody();
        Node elseBody = node.getElseBody();
        if (thenBody != null && elseBody != null) {
            RubyNode thenBodyTranslated = (RubyNode)thenBody.accept((NodeVisitor)this);
            RubyNode elseBodyTranslated = (RubyNode)elseBody.accept((NodeVisitor)this);
            ret = new IfElseNode(this.context, sourceSection, condition, thenBodyTranslated, elseBodyTranslated);
        } else if (thenBody != null) {
            RubyNode thenBodyTranslated = (RubyNode)thenBody.accept((NodeVisitor)this);
            ret = new IfNode(this.context, sourceSection, condition, thenBodyTranslated);
        } else if (elseBody != null) {
            RubyNode elseBodyTranslated = (RubyNode)elseBody.accept((NodeVisitor)this);
            ret = new UnlessNode(this.context, sourceSection, condition, elseBodyTranslated);
        } else {
            ret = BodyTranslator.sequence(this.context, sourceSection, Arrays.asList(condition, new NilLiteralNode(this.context, sourceSection, true)));
        }
        return ret;
    }

    public RubyNode visitInstAsgnNode(InstAsgnNode node) {
        String corePath;
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getName();
        RubyNode rhs = node.getValueNode() == null ? new DeadNode(this.context, sourceSection, new Exception("null RHS of instance variable assignment")) : (RubyNode)node.getValueNode().accept((NodeVisitor)this);
        RaiseIfFrozenNode self = new RaiseIfFrozenNode(new org.jruby.truffle.language.objects.SelfNode(this.context, sourceSection));
        String path = this.getSourcePath(sourceSection);
        if (path.equals((corePath = this.context.getCoreLibrary().getCoreLoadPath() + "/core/") + "rubinius/common/hash.rb")) {
            if (name.equals("@default")) {
                HashNodes.SetDefaultValueNode ret = HashNodesFactory.SetDefaultValueNodeFactory.create(self, rhs);
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@default_proc")) {
                HashNodes.SetDefaultProcNode ret = HashNodesFactory.SetDefaultProcNodeFactory.create(self, rhs);
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
        } else if (path.equals(corePath + "rubinius/bootstrap/string.rb") || path.equals(corePath + "rubinius/common/string.rb")) {
            if (name.equals("@hash")) {
                StringNodes.ModifyBangNode ret = StringNodesFactory.ModifyBangNodeFactory.create(new RubyNode[0]);
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
        } else if (path.equals(corePath + "rubinius/common/range.rb")) {
            if (name.equals("@begin")) {
                RangeNodes.InternalSetBeginNode ret = RangeNodesFactory.InternalSetBeginNodeGen.create(self, rhs);
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@end")) {
                RangeNodes.InternalSetEndNode ret = RangeNodesFactory.InternalSetEndNodeGen.create(self, rhs);
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@excl")) {
                RangeNodes.InternalSetExcludeEndNode ret = RangeNodesFactory.InternalSetExcludeEndNodeGen.create(self, rhs);
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
        } else if (path.equals(corePath + "rubinius/common/io.rb") && (name.equals("@used") || name.equals("@total") || name.equals("@lineno"))) {
            WriteInstanceVariableNode ret = new WriteInstanceVariableNode(this.context, sourceSection, name, self, IntegerCastNodeGen.create(this.context, sourceSection, rhs));
            return this.addNewlineIfNeeded((Node)node, ret);
        }
        WriteInstanceVariableNode ret = new WriteInstanceVariableNode(this.context, sourceSection, name, self, rhs);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitInstVarNode(InstVarNode node) {
        String corePath;
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getName();
        org.jruby.truffle.language.objects.SelfNode self = new org.jruby.truffle.language.objects.SelfNode(this.context, sourceSection);
        String path = this.getSourcePath(sourceSection);
        if (path.equals((corePath = this.context.getCoreLibrary().getCoreLoadPath() + "/core/") + "rubinius/common/array.rb") || path.equals(corePath + "rubinius/api/shims/array.rb")) {
            if (name.equals("@total")) {
                RubyCallNode ret = new RubyCallNode(this.context, sourceSection, "size", (RubyNode)self, null, false, new RubyNode[0]);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@tuple")) {
                org.jruby.truffle.language.objects.SelfNode ret = self;
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@start")) {
                IntegerFixnumLiteralNode ret = new IntegerFixnumLiteralNode(this.context, sourceSection, 0);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
        } else if (path.equals(corePath + "rubinius/common/regexp.rb")) {
            if (name.equals("@source")) {
                MatchDataNodes.RubiniusSourceNode ret = MatchDataNodesFactory.RubiniusSourceNodeGen.create(self);
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@full")) {
                RubyCallNode ret = new RubyCallNode(this.context, sourceSection, "full", (RubyNode)self, null, false, new RubyNode[0]);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@regexp")) {
                MatchDataNodes.RegexpNode ret = MatchDataNodesFactory.RegexpNodeFactory.create(new RubyNode[]{self});
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@names")) {
                RegexpNodes.RubiniusNamesNode ret = RegexpNodesFactory.RubiniusNamesNodeGen.create(self);
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
        } else if (path.equals(corePath + "rubinius/common/time.rb")) {
            if (name.equals("@is_gmt")) {
                TimeNodes.InternalGMTNode ret = TimeNodesFactory.InternalGMTNodeFactory.create(self);
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@offset")) {
                TimeNodes.InternalOffsetNode ret = TimeNodesFactory.InternalOffsetNodeFactory.create(self);
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
        } else if (path.equals(corePath + "rubinius/common/hash.rb")) {
            if (name.equals("@default")) {
                HashNodes.DefaultValueNode ret = HashNodesFactory.DefaultValueNodeFactory.create(self);
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@default_proc")) {
                HashNodes.DefaultProcNode ret = HashNodesFactory.DefaultProcNodeFactory.create(new RubyNode[]{self});
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@size")) {
                HashNodes.SizeNode ret = HashNodesFactory.SizeNodeFactory.create(new RubyNode[]{self});
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
        } else if (path.equals(corePath + "rubinius/common/range.rb") || path.equals(corePath + "rubinius/api/shims/range.rb")) {
            if (name.equals("@begin")) {
                RangeNodes.BeginNode ret = RangeNodesFactory.BeginNodeFactory.create(new RubyNode[]{self});
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@end")) {
                RangeNodes.EndNode ret = RangeNodesFactory.EndNodeFactory.create(new RubyNode[]{self});
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
            if (name.equals("@excl")) {
                RangeNodes.ExcludeEndNode ret = RangeNodesFactory.ExcludeEndNodeFactory.create(new RubyNode[]{self});
                this.setSourceSection(ret, sourceSection);
                return this.addNewlineIfNeeded((Node)node, ret);
            }
        }
        ReadInstanceVariableNode ret = new ReadInstanceVariableNode(this.context, sourceSection, name, self);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitIterNode(IterNode node) {
        return this.translateBlockLikeNode(node, false);
    }

    public RubyNode visitLambdaNode(LambdaNode node) {
        return this.translateBlockLikeNode((IterNode)node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateBlockLikeNode(IterNode node, boolean isLambda) {
        BlockDefinitionNode definitionNode;
        ProcType type;
        SourceSection sourceSection = this.translate(node.getPosition());
        ArgsNode argsNode = node.getArgsNode();
        boolean hasOwnScope = isLambda || !this.translatingForStatement;
        String name = isLambda ? "(lambda)" : this.currentCallMethodName;
        boolean isProc = !isLambda;
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.environment.getLexicalScope(), MethodTranslator.getArity(argsNode), name, true, Helpers.argsNodeToArgumentDescriptors((ArgsNode)argsNode), false, false, false);
        String namedMethodName = isLambda ? sharedMethodInfo.getName() : this.environment.getNamedMethodName();
        ParseEnvironment parseEnvironment = this.environment.getParseEnvironment();
        ReturnID returnID = isLambda ? parseEnvironment.allocateReturnID() : this.environment.getReturnID();
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, parseEnvironment, returnID, hasOwnScope, false, sharedMethodInfo, namedMethodName, this.environment.getBlockDepth() + 1, parseEnvironment.allocateBreakID());
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, true, this.source, argsNode);
        if (isProc) {
            methodCompiler.translatingForStatement = this.translatingForStatement;
        }
        methodCompiler.frameOnStackMarkerSlotStack = this.frameOnStackMarkerSlotStack;
        ProcType procType = type = isLambda ? ProcType.LAMBDA : ProcType.PROC;
        if (isLambda) {
            this.frameOnStackMarkerSlotStack.push(BAD_FRAME_SLOT);
        }
        try {
            definitionNode = methodCompiler.compileBlockNode(sourceSection, sharedMethodInfo.getName(), node.getBodyNode(), sharedMethodInfo, type);
        }
        finally {
            if (isLambda) {
                this.frameOnStackMarkerSlotStack.pop();
            }
        }
        return this.addNewlineIfNeeded((Node)node, definitionNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode visitLocalAsgnNode(LocalAsgnNode node) {
        RubyNode rhs;
        ReadLocalNode lhs;
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.environment.getNeverAssignInParentScope()) {
            this.environment.declareVar(node.getName());
        }
        if ((lhs = this.environment.findLocalVarNode(node.getName(), sourceSection)) == null) {
            if (this.environment.hasOwnScopeForAssignments()) {
                this.environment.declareVar(node.getName());
            } else {
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(node.getName());
            }
            lhs = this.environment.findLocalVarNode(node.getName(), sourceSection);
            if (lhs == null) {
                throw new RuntimeException("shouldn't be here");
            }
        }
        if (node.getValueNode() == null) {
            rhs = new DeadNode(this.context, sourceSection, new Exception());
        } else {
            if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection.push(sourceSection);
            }
            try {
                rhs = (RubyNode)node.getValueNode().accept((NodeVisitor)this);
            }
            finally {
                if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                    this.parentSourceSection.pop();
                }
            }
        }
        RubyNode ret = lhs.makeWriteNode(rhs);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitLocalVarNode(LocalVarNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getName();
        ReadLocalNode readNode = this.environment.findLocalVarNode(name, sourceSection);
        if (readNode == null) {
            this.environment.declareVar(node.getName());
            readNode = this.environment.findLocalVarNode(name, sourceSection);
        }
        return this.addNewlineIfNeeded((Node)node, readNode);
    }

    public RubyNode visitMatchNode(MatchNode node) {
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), (Node)new GlobalVarNode(node.getPosition(), "$_"), new Node[0]);
        CallNode callNode = new CallNode(node.getPosition(), node.getRegexpNode(), "=~", (Node)argsNode, null);
        this.copyNewline((Node)node, (Node)callNode);
        RubyNode ret = (RubyNode)callNode.accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitMatch2Node(Match2Node node) {
        RegexpNode regexpNode;
        Regex regex;
        if (node.getReceiverNode() instanceof RegexpNode && (regex = new Regex((regexpNode = (RegexpNode)node.getReceiverNode()).getValue().bytes(), 0, regexpNode.getValue().length(), regexpNode.getOptions().toOptions(), regexpNode.getEncoding(), Syntax.RUBY)).numberOfNames() > 0) {
            Iterator i = regex.namedBackrefIterator();
            while (i.hasNext()) {
                NameEntry e = (NameEntry)i.next();
                String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                if (this.environment.hasOwnScopeForAssignments()) {
                    this.environment.declareVar(name);
                    continue;
                }
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(name);
            }
        }
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]);
        CallNode callNode = new CallNode(node.getPosition(), node.getReceiverNode(), "=~", (Node)argsNode, null);
        this.copyNewline((Node)node, (Node)callNode);
        RubyNode ret = (RubyNode)callNode.accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitMatch3Node(Match3Node node) {
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]);
        CallNode callNode = new CallNode(node.getPosition(), node.getReceiverNode(), "=~", (Node)argsNode, null);
        this.copyNewline((Node)node, (Node)callNode);
        RubyNode ret = (RubyNode)callNode.accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitModuleNode(ModuleNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        DefineModuleNode defineModuleNode = new DefineModuleNode(this.context, sourceSection, name, lexicalParent);
        RubyNode ret = this.openModule(sourceSection, defineModuleNode, name, node.getBodyNode(), false);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitMultipleAsgnNode(MultipleAsgnNode node) {
        ArrayList<RubyNode> sequence;
        RubyNode result;
        RubyNode rhsTranslated;
        SourceSection sourceSection = this.translate(node.getPosition());
        ListNode preArray = node.getPre();
        ListNode postArray = node.getPost();
        Node rhs = node.getValueNode();
        if (rhs == null) {
            this.context.getJRubyRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, this.source.getName(), node.getPosition().getLine(), "no RHS for multiple assignment - using nil");
            rhsTranslated = this.nilNode(sourceSection);
        } else {
            rhsTranslated = (RubyNode)rhs.accept((NodeVisitor)this);
        }
        if (preArray != null && node.getPost() == null && node.getRest() == null && rhsTranslated instanceof ArrayLiteralNode && ((ArrayLiteralNode)rhsTranslated).getSize() == preArray.size()) {
            ArrayLiteralNode rhsArrayLiteral = (ArrayLiteralNode)rhsTranslated;
            int assignedValuesCount = preArray.size();
            RubyNode[] sequence2 = new RubyNode[assignedValuesCount * 2];
            RubyNode[] tempValues = new RubyNode[assignedValuesCount];
            for (int n = 0; n < assignedValuesCount; ++n) {
                String tempName = this.environment.allocateLocalTemp("multi");
                ReadLocalNode readTemp = this.environment.findLocalVarNode(tempName, sourceSection);
                RubyNode assignTemp = readTemp.makeWriteNode(rhsArrayLiteral.stealNode(n));
                RubyNode assignFinalValue = this.translateDummyAssignment(preArray.get(n), NodeUtil.cloneNode(readTemp));
                sequence2[n] = assignTemp;
                sequence2[assignedValuesCount + n] = assignFinalValue;
                tempValues[n] = NodeUtil.cloneNode(readTemp);
            }
            RubyNode blockNode = BodyTranslator.sequence(this.context, sourceSection, Arrays.asList(sequence2));
            ArrayLiteralNode arrayNode = ArrayLiteralNode.create(this.context, sourceSection, tempValues);
            ElidableResultNode elidableResult = new ElidableResultNode(this.context, sourceSection, blockNode, arrayNode);
            result = elidableResult;
        } else if (preArray != null) {
            sequence = new ArrayList<RubyNode>();
            String tempRHSName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempRHS = this.environment.findLocalVarNode(tempRHSName, sourceSection).makeWriteNode(rhsTranslated);
            sequence.add(writeTempRHS);
            String tempName = this.environment.allocateLocalTemp("array");
            SplatCastNode splatCastNode = SplatCastNodeGen.create(this.context, sourceSection, this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, true, this.environment.findLocalVarNode(tempRHSName, sourceSection));
            RubyNode writeTemp = this.environment.findLocalVarNode(tempName, sourceSection).makeWriteNode(splatCastNode);
            sequence.add(writeTemp);
            for (int n = 0; n < preArray.size(); ++n) {
                RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.environment.findLocalVarNode(tempName, sourceSection), n);
                sequence.add(this.translateDummyAssignment(preArray.get(n), assignedValue));
            }
            if (node.getRest() != null) {
                RubyNode assignedValue = ArrayGetTailNodeGen.create(this.context, sourceSection, preArray.size(), this.environment.findLocalVarNode(tempName, sourceSection));
                if (postArray != null) {
                    assignedValue = ArrayDropTailNodeGen.create(this.context, sourceSection, postArray.size(), assignedValue);
                }
                sequence.add(this.translateDummyAssignment(node.getRest(), assignedValue));
            }
            if (postArray != null) {
                ArrayList<RubyNode> smallerSequence = new ArrayList<RubyNode>();
                for (int n = 0; n < postArray.size(); ++n) {
                    RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.environment.findLocalVarNode(tempName, sourceSection), node.getPreCount() + n);
                    smallerSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
                }
                RubyNode smaller = BodyTranslator.sequence(this.context, sourceSection, smallerSequence);
                ArrayList<RubyNode> atLeastAsLargeSequence = new ArrayList<RubyNode>();
                for (int n = 0; n < postArray.size(); ++n) {
                    RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.environment.findLocalVarNode(tempName, sourceSection), -(postArray.size() - n));
                    atLeastAsLargeSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
                }
                RubyNode atLeastAsLarge = BodyTranslator.sequence(this.context, sourceSection, atLeastAsLargeSequence);
                IfElseNode assignPost = new IfElseNode(this.context, sourceSection, new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), this.environment.findLocalVarNode(tempName, sourceSection)), atLeastAsLarge, smaller);
                sequence.add(assignPost);
            }
            result = new ElidableResultNode(this.context, sourceSection, BodyTranslator.sequence(this.context, sourceSection, sequence), this.environment.findLocalVarNode(tempRHSName, sourceSection));
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() instanceof StarNode) {
            result = rhsTranslated;
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() != null && rhs != null && !(rhs instanceof ArrayNode)) {
            SplatCastNode.NilBehavior nilBehavior;
            sequence = new ArrayList();
            if (this.translatingNextExpression) {
                nilBehavior = SplatCastNode.NilBehavior.EMPTY_ARRAY;
            } else if (rhsTranslated instanceof SplatCastNode && ((SplatCastNodeGen)rhsTranslated).getChild() instanceof NilLiteralNode) {
                rhsTranslated = ((SplatCastNodeGen)rhsTranslated).getChild();
                nilBehavior = SplatCastNode.NilBehavior.CONVERT;
            } else {
                nilBehavior = SplatCastNode.NilBehavior.ARRAY_WITH_NIL;
            }
            String tempRHSName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempRHS = this.environment.findLocalVarNode(tempRHSName, sourceSection).makeWriteNode(rhsTranslated);
            sequence.add(writeTempRHS);
            SplatCastNode rhsSplatCast = SplatCastNodeGen.create(this.context, sourceSection, nilBehavior, true, this.environment.findLocalVarNode(tempRHSName, sourceSection));
            String tempRHSSplattedName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempSplattedRHS = this.environment.findLocalVarNode(tempRHSSplattedName, sourceSection).makeWriteNode(rhsSplatCast);
            sequence.add(writeTempSplattedRHS);
            sequence.add(this.translateDummyAssignment(node.getRest(), this.environment.findLocalVarNode(tempRHSSplattedName, sourceSection)));
            ReadLocalNode assignmentResult = nilBehavior == SplatCastNode.NilBehavior.CONVERT ? this.environment.findLocalVarNode(tempRHSSplattedName, sourceSection) : this.environment.findLocalVarNode(tempRHSName, sourceSection);
            result = new ElidableResultNode(this.context, sourceSection, BodyTranslator.sequence(this.context, sourceSection, sequence), assignmentResult);
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() != null && rhs != null && rhs instanceof ArrayNode) {
            result = this.translateDummyAssignment(node.getRest(), rhsTranslated);
        } else if (node.getPre() == null && node.getRest() != null && node.getPost() != null) {
            sequence = new ArrayList();
            String tempRHSName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempRHS = this.environment.findLocalVarNode(tempRHSName, sourceSection).makeWriteNode(rhsTranslated);
            sequence.add(writeTempRHS);
            String tempName = this.environment.allocateLocalTemp("array");
            SplatCastNode splatCastNode = SplatCastNodeGen.create(this.context, sourceSection, this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, false, this.environment.findLocalVarNode(tempRHSName, sourceSection));
            RubyNode writeTemp = this.environment.findLocalVarNode(tempName, sourceSection).makeWriteNode(splatCastNode);
            sequence.add(writeTemp);
            if (node.getRest() != null) {
                ArrayDropTailNode assignedValue = ArrayDropTailNodeGen.create(this.context, sourceSection, postArray.size(), this.environment.findLocalVarNode(tempName, sourceSection));
                sequence.add(this.translateDummyAssignment(node.getRest(), assignedValue));
            }
            ArrayList<RubyNode> smallerSequence = new ArrayList<RubyNode>();
            for (int n = 0; n < postArray.size(); ++n) {
                RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.environment.findLocalVarNode(tempName, sourceSection), node.getPreCount() + n);
                smallerSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
            }
            RubyNode smaller = BodyTranslator.sequence(this.context, sourceSection, smallerSequence);
            ArrayList<RubyNode> atLeastAsLargeSequence = new ArrayList<RubyNode>();
            for (int n = 0; n < postArray.size(); ++n) {
                RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.environment.findLocalVarNode(tempName, sourceSection), -(postArray.size() - n));
                atLeastAsLargeSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
            }
            RubyNode atLeastAsLarge = BodyTranslator.sequence(this.context, sourceSection, atLeastAsLargeSequence);
            IfElseNode assignPost = new IfElseNode(this.context, sourceSection, new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), this.environment.findLocalVarNode(tempName, sourceSection)), atLeastAsLarge, smaller);
            sequence.add(assignPost);
            result = new ElidableResultNode(this.context, sourceSection, BodyTranslator.sequence(this.context, sourceSection, sequence), this.environment.findLocalVarNode(tempRHSName, sourceSection));
        } else {
            this.context.getJRubyRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, this.source.getName(), node.getPosition().getLine(), node + " unknown form of multiple assignment");
            result = this.nilNode(sourceSection);
        }
        DefinedWrapperNode ret = new DefinedWrapperNode(this.context, sourceSection, this.context.getCoreStrings().ASSIGNMENT, result);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode visitNextNode(NextNode node) {
        RubyNode resultNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        if (!this.environment.isBlock() && !this.translatingWhile) {
            throw new RaiseException(this.context.getCoreExceptions().syntaxError("Invalid next", this.currentNode));
        }
        boolean t = this.translatingNextExpression;
        this.translatingNextExpression = true;
        if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
            this.parentSourceSection.push(sourceSection);
        }
        try {
            resultNode = (RubyNode)node.getValueNode().accept((NodeVisitor)this);
        }
        finally {
            if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection.pop();
            }
            this.translatingNextExpression = t;
        }
        org.jruby.truffle.language.control.NextNode ret = new org.jruby.truffle.language.control.NextNode(this.context, sourceSection, resultNode);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitNilNode(NilNode node) {
        if (node.getPosition() == InvalidSourcePosition.INSTANCE && this.parentSourceSection.peek() == null) {
            DeadNode ret = new DeadNode(this.context, null, new Exception());
            return this.addNewlineIfNeeded((Node)node, ret);
        }
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode ret = this.nilNode(sourceSection);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitNthRefNode(NthRefNode node) {
        ReadMatchReferenceNode ret = new ReadMatchReferenceNode(this.context, this.translate(node.getPosition()), node.getMatchNumber());
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitOpAsgnAndNode(OpAsgnAndNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        Node lhs = node.getFirstNode();
        Node rhs = node.getSecondNode();
        DefinedWrapperNode ret = new DefinedWrapperNode(this.context, sourceSection, this.context.getCoreStrings().ASSIGNMENT, new AndNode(this.context, sourceSection, (RubyNode)lhs.accept((NodeVisitor)this), (RubyNode)rhs.accept((NodeVisitor)this)));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitOpAsgnNode(OpAsgnNode node) {
        if (node.getOperatorName().equals("||")) {
            String temp = this.environment.allocateLocalTemp("opassign");
            LocalAsgnNode writeReceiverToTemp = new LocalAsgnNode(node.getPosition(), temp, 0, node.getReceiverNode());
            LocalVarNode readReceiverFromTemp = new LocalVarNode(node.getPosition(), 0, temp);
            CallNode readMethod = new CallNode(node.getPosition(), (Node)readReceiverFromTemp, node.getVariableName(), null, null);
            CallNode writeMethod = new CallNode(node.getPosition(), (Node)readReceiverFromTemp, node.getVariableName() + "=", (Node)BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]), null);
            SourceSection sourceSection = this.translate(node.getPosition());
            RubyNode lhs = (RubyNode)readMethod.accept((NodeVisitor)this);
            RubyNode rhs = (RubyNode)writeMethod.accept((NodeVisitor)this);
            DefinedWrapperNode ret = new DefinedWrapperNode(this.context, sourceSection, this.context.getCoreStrings().ASSIGNMENT, BodyTranslator.sequence(this.context, sourceSection, Arrays.asList((RubyNode)writeReceiverToTemp.accept((NodeVisitor)this), new org.jruby.truffle.language.control.OrNode(this.context, sourceSection, lhs, rhs))));
            return this.addNewlineIfNeeded((Node)node, ret);
        }
        String temp = this.environment.allocateLocalTemp("opassign");
        LocalAsgnNode writeReceiverToTemp = new LocalAsgnNode(node.getPosition(), temp, 0, node.getReceiverNode());
        LocalVarNode readReceiverFromTemp = new LocalVarNode(node.getPosition(), 0, temp);
        CallNode readMethod = new CallNode(node.getPosition(), (Node)readReceiverFromTemp, node.getVariableName(), null, null);
        CallNode operation = new CallNode(node.getPosition(), (Node)readMethod, node.getOperatorName(), (Node)BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]), null);
        CallNode writeMethod = new CallNode(node.getPosition(), (Node)readReceiverFromTemp, node.getVariableName() + "=", (Node)BodyTranslator.buildArrayNode(node.getPosition(), (Node)operation, new Node[0]), null);
        BlockNode block = new BlockNode(node.getPosition());
        block.add((Node)writeReceiverToTemp);
        block.add((Node)writeMethod);
        RubyNode ret = (RubyNode)block.accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitOpAsgnOrNode(OpAsgnOrNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode lhs = (RubyNode)node.getFirstNode().accept((NodeVisitor)this);
        RubyNode rhs = (RubyNode)node.getSecondNode().accept((NodeVisitor)this);
        if (node.getFirstNode().needsDefinitionCheck() && !(node.getFirstNode() instanceof InstVarNode)) {
            org.jruby.truffle.language.defined.DefinedNode defined = new org.jruby.truffle.language.defined.DefinedNode(this.context, lhs.getSourceSection(), lhs);
            lhs = new AndNode(this.context, lhs.getSourceSection(), defined, lhs);
        }
        DefinedWrapperNode ret = new DefinedWrapperNode(this.context, sourceSection, this.context.getCoreStrings().ASSIGNMENT, new org.jruby.truffle.language.control.OrNode(this.context, sourceSection, lhs, rhs));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitOpElementAsgnNode(OpElementAsgnNode node) {
        Node index = node.getArgsNode() == null ? null : (Node)node.getArgsNode().childNodes().get(0);
        Node operand = node.getValueNode();
        String temp = this.environment.allocateLocalTemp("opelementassign");
        LocalAsgnNode writeArrayToTemp = new LocalAsgnNode(node.getPosition(), temp, 0, node.getReceiverNode());
        LocalVarNode readArrayFromTemp = new LocalVarNode(node.getPosition(), 0, temp);
        CallNode arrayRead = new CallNode(node.getPosition(), (Node)readArrayFromTemp, "[]", (Node)BodyTranslator.buildArrayNode(node.getPosition(), index, new Node[0]), null);
        String op = node.getOperatorName();
        Object operation = null;
        operation = op.equals("||") ? new OrNode(node.getPosition(), (Node)arrayRead, operand) : (op.equals("&&") ? new org.jruby.ast.AndNode(node.getPosition(), (Node)arrayRead, operand) : new CallNode(node.getPosition(), (Node)arrayRead, node.getOperatorName(), (Node)BodyTranslator.buildArrayNode(node.getPosition(), operand, new Node[0]), null));
        this.copyNewline((Node)node, (Node)operation);
        CallNode arrayWrite = new CallNode(node.getPosition(), (Node)readArrayFromTemp, "[]=", (Node)BodyTranslator.buildArrayNode(node.getPosition(), index, new Node[]{operation}), null);
        BlockNode block = new BlockNode(node.getPosition());
        block.add((Node)writeArrayToTemp);
        block.add((Node)arrayWrite);
        RubyNode ret = (RubyNode)block.accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    private static ArrayNode buildArrayNode(ISourcePosition sourcePosition, Node first, Node ... rest) {
        if (first == null) {
            return new ArrayNode(sourcePosition);
        }
        ArrayNode array = new ArrayNode(sourcePosition, first);
        for (Node node : rest) {
            array.add(node);
        }
        return array;
    }

    public RubyNode visitOrNode(OrNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode x = this.translateNodeOrNil(sourceSection, node.getFirstNode());
        RubyNode y = this.translateNodeOrNil(sourceSection, node.getSecondNode());
        org.jruby.truffle.language.control.OrNode ret = new org.jruby.truffle.language.control.OrNode(this.context, sourceSection, x, y);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitPreExeNode(PreExeNode node) {
        RubyNode ret = (RubyNode)node.getBodyNode().accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitPostExeNode(PostExeNode node) {
        RubyNode ret = (RubyNode)node.getBodyNode().accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitRationalNode(RationalNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode ret = this.translateRationalComplex(sourceSection, "Rational", new LongFixnumLiteralNode(this.context, sourceSection, node.getNumerator()), new LongFixnumLiteralNode(this.context, sourceSection, node.getDenominator()));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    private RubyNode translateRationalComplex(SourceSection sourceSection, String name, RubyNode a, RubyNode b) {
        ObjectLiteralNode moduleNode = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
        return new RubyCallNode(this.context, sourceSection, "convert", (RubyNode)new ReadLiteralConstantNode(this.context, sourceSection, moduleNode, name), null, false, true, a, b);
    }

    public RubyNode visitRedoNode(RedoNode node) {
        if (!this.environment.isBlock() && !this.translatingWhile) {
            throw new RaiseException(this.context.getCoreExceptions().syntaxError("Invalid redo", this.currentNode));
        }
        org.jruby.truffle.language.control.RedoNode ret = new org.jruby.truffle.language.control.RedoNode(this.context, this.translate(node.getPosition()));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitRegexpNode(RegexpNode node) {
        Rope rope = StringOperations.ropeFromByteList(node.getValue());
        Regex regex = RegexpNodes.compile(this.currentNode, this.context, rope, node.getOptions());
        DynamicObject regexp = RegexpNodes.createRubyRegexp(this.context.getCoreLibrary().getRegexpClass(), regex, (Rope)regex.getUserObject(), node.getOptions());
        Layouts.REGEXP.getOptions(regexp).setLiteral(true);
        ObjectLiteralNode literalNode = new ObjectLiteralNode(this.context, this.translate(node.getPosition()), regexp);
        if (node.getOptions().isOnce()) {
            OnceNode ret = new OnceNode(this.context, literalNode.getEncapsulatingSourceSection(), literalNode);
            return this.addNewlineIfNeeded((Node)node, ret);
        }
        return this.addNewlineIfNeeded((Node)node, literalNode);
    }

    public static boolean all7Bit(byte[] bytes) {
        for (int n = 0; n < bytes.length; ++n) {
            if (bytes[n] < 0) {
                return false;
            }
            if (bytes[n] != 92 || n + 1 >= bytes.length || bytes[n + 1] != 120) continue;
            boolean isSecondHex = n + 3 < bytes.length && Character.digit(bytes[n + 3], 16) != -1;
            String num = isSecondHex ? new String(Arrays.copyOfRange(bytes, n + 2, n + 4), StandardCharsets.UTF_8) : new String(Arrays.copyOfRange(bytes, n + 2, n + 3), StandardCharsets.UTF_8);
            int b = Integer.parseInt(num, 16);
            if (b > 127) {
                return false;
            }
            if (isSecondHex) {
                n += 3;
                continue;
            }
            n += 2;
        }
        return true;
    }

    public RubyNode visitRescueNode(RescueNode node) {
        RescueAnyNode rescueNode;
        RubyNode bodyNode;
        RescueBodyNode rescueBody;
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode tryPart = node.getBodyNode() == null || node.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? this.nilNode(sourceSection) : (RubyNode)node.getBodyNode().accept((NodeVisitor)this);
        ArrayList<org.jruby.truffle.language.exceptions.RescueNode> rescueNodes = new ArrayList<org.jruby.truffle.language.exceptions.RescueNode>();
        if (this.context.getOptions().BACKTRACES_OMIT_UNUSED && rescueBody != null && rescueBody.getExceptionNodes() == null && rescueBody.getBodyNode() instanceof SideEffectFree && rescueBody.getOptRescueNode() == null) {
            tryPart = new DisablingBacktracesNode(this.context, sourceSection, tryPart);
            bodyNode = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? this.nilNode(sourceSection) : (RubyNode)rescueBody.getBodyNode().accept((NodeVisitor)this);
            rescueNode = new RescueAnyNode(this.context, sourceSection, bodyNode);
            rescueNodes.add(rescueNode);
        } else {
            for (rescueBody = node.getRescueNode(); rescueBody != null; rescueBody = rescueBody.getOptRescueNode()) {
                if (rescueBody.getExceptionNodes() != null) {
                    org.jruby.truffle.language.exceptions.RescueNode rescueNode2;
                    if (rescueBody.getExceptionNodes() instanceof ArrayNode) {
                        Node[] exceptionNodes = ((ArrayNode)rescueBody.getExceptionNodes()).children();
                        RubyNode[] handlingClasses = new RubyNode[exceptionNodes.length];
                        for (int n = 0; n < handlingClasses.length; ++n) {
                            handlingClasses[n] = (RubyNode)exceptionNodes[n].accept((NodeVisitor)this);
                        }
                        RubyNode translatedBody = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? this.nilNode(sourceSection) : (RubyNode)rescueBody.getBodyNode().accept((NodeVisitor)this);
                        rescueNode2 = new RescueClassesNode(this.context, sourceSection, handlingClasses, translatedBody);
                        rescueNodes.add(rescueNode2);
                        continue;
                    }
                    if (rescueBody.getExceptionNodes() instanceof SplatNode) {
                        SplatNode splat = (SplatNode)rescueBody.getExceptionNodes();
                        RubyNode splatTranslated = this.translateNodeOrNil(sourceSection, splat.getValue());
                        RubyNode bodyTranslated = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? this.nilNode(sourceSection) : (RubyNode)rescueBody.getBodyNode().accept((NodeVisitor)this);
                        rescueNode2 = new RescueSplatNode(this.context, sourceSection, splatTranslated, bodyTranslated);
                        rescueNodes.add(rescueNode2);
                        continue;
                    }
                    this.unimplemented((Node)node);
                    continue;
                }
                bodyNode = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? this.nilNode(sourceSection) : (RubyNode)rescueBody.getBodyNode().accept((NodeVisitor)this);
                rescueNode = new RescueAnyNode(this.context, sourceSection, bodyNode);
                rescueNodes.add(rescueNode);
            }
        }
        RubyNode elsePart = node.getElseNode() == null || node.getElseNode().getPosition() == InvalidSourcePosition.INSTANCE ? null : (RubyNode)node.getElseNode().accept((NodeVisitor)this);
        TryNode ret = new TryNode(this.context, sourceSection, new ExceptionTranslatingNode(this.context, sourceSection, tryPart, UnsupportedOperationBehavior.TYPE_ERROR), rescueNodes.toArray(new org.jruby.truffle.language.exceptions.RescueNode[rescueNodes.size()]), elsePart);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitRetryNode(RetryNode node) {
        org.jruby.truffle.language.control.RetryNode ret = new org.jruby.truffle.language.control.RetryNode(this.context, this.translate(node.getPosition()));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitReturnNode(ReturnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode translatedChild = (RubyNode)node.getValueNode().accept((NodeVisitor)this);
        org.jruby.truffle.language.control.ReturnNode ret = new org.jruby.truffle.language.control.ReturnNode(this.context, sourceSection, this.environment.getReturnID(), translatedChild);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitSClassNode(SClassNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode receiverNode = (RubyNode)node.getReceiverNode().accept((NodeVisitor)this);
        SingletonClassNode singletonClassNode = SingletonClassNodeGen.create(this.context, sourceSection, receiverNode);
        RubyNode ret = this.openModule(sourceSection, singletonClassNode, "(singleton-def)", node.getBodyNode(), true);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitSValueNode(SValueNode node) {
        RubyNode ret = (RubyNode)node.getValue().accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitSelfNode(SelfNode node) {
        org.jruby.truffle.language.objects.SelfNode ret = new org.jruby.truffle.language.objects.SelfNode(this.context, this.translate(node.getPosition()));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitSplatNode(SplatNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode value = this.translateNodeOrNil(sourceSection, node.getValue());
        SplatCastNode ret = SplatCastNodeGen.create(this.context, sourceSection, SplatCastNode.NilBehavior.CONVERT, false, value);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitStrNode(StrNode node) {
        RubyNode ret;
        SourceSection sourceSection = this.translate(node.getPosition());
        ByteList byteList = node.getValue();
        int codeRange = node.getCodeRange();
        Rope rope = this.context.getRopeTable().getRope(byteList.bytes(), byteList.getEncoding(), CodeRange.fromInt(codeRange));
        if (node.isFrozen()) {
            DynamicObject frozenString = this.context.getFrozenStrings().getFrozenString(rope);
            ret = new DefinedWrapperNode(this.context, sourceSection, this.context.getCoreStrings().METHOD, new ObjectLiteralNode(this.context, null, frozenString));
        } else {
            ret = new StringLiteralNode(this.context, sourceSection, rope);
        }
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitSymbolNode(SymbolNode node) {
        Rope rope = StringOperations.createRope(node.getName(), node.getEncoding());
        ObjectLiteralNode ret = new ObjectLiteralNode(this.context, this.translate(node.getPosition()), this.context.getSymbolTable().getSymbol(rope));
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitTrueNode(TrueNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        BooleanLiteralNode ret = new BooleanLiteralNode(this.context, sourceSection, true);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitUndefNode(UndefNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        DynamicObject nameSymbol = this.translateNameNodeToSymbol(node.getName());
        ModuleNodes.UndefMethodNode ret = ModuleNodesFactory.UndefMethodNodeFactory.create(this.context, sourceSection, new RubyNode[]{new RaiseIfFrozenNode(new GetDefaultDefineeNode(this.context, sourceSection)), new ObjectLiteralNode(this.context, sourceSection, new Object[]{nameSymbol})});
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitUntilNode(UntilNode node) {
        org.jruby.ast.WhileNode whileNode = new org.jruby.ast.WhileNode(node.getPosition(), node.getConditionNode(), node.getBodyNode(), node.evaluateAtStart());
        this.copyNewline((Node)node, (Node)whileNode);
        RubyNode ret = this.translateWhileNode(whileNode, true);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitVCallNode(VCallNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (node.getName().equals("undefined") && this.getSourcePath(sourceSection).startsWith(this.context.getCoreLibrary().getCoreLoadPath() + "/core/")) {
            ObjectLiteralNode ret = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getRubiniusUndefined());
            return this.addNewlineIfNeeded((Node)node, ret);
        }
        SelfNode receiver = new SelfNode(node.getPosition());
        CallNode callNode = new CallNode(node.getPosition(), (Node)receiver, node.getName(), null, null);
        this.copyNewline((Node)node, (Node)callNode);
        RubyNode ret = this.translateCallNode(callNode, true, true);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitWhileNode(org.jruby.ast.WhileNode node) {
        RubyNode ret = this.translateWhileNode(node, false);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateWhileNode(org.jruby.ast.WhileNode node, boolean conditionInversed) {
        RubyNode body;
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode condition = (RubyNode)node.getConditionNode().accept((NodeVisitor)this);
        if (conditionInversed) {
            condition = new NotNode(this.context, sourceSection, condition);
        }
        BreakID whileBreakID = this.environment.getParseEnvironment().allocateBreakID();
        boolean oldTranslatingWhile = this.translatingWhile;
        this.translatingWhile = true;
        BreakID oldBreakID = this.environment.getBreakID();
        this.environment.setBreakIDForWhile(whileBreakID);
        this.frameOnStackMarkerSlotStack.push(BAD_FRAME_SLOT);
        try {
            body = this.translateNodeOrNil(sourceSection, node.getBodyNode());
        }
        finally {
            this.frameOnStackMarkerSlotStack.pop();
            this.environment.setBreakIDForWhile(oldBreakID);
            this.translatingWhile = oldTranslatingWhile;
        }
        WhileNode loop = node.evaluateAtStart() ? WhileNode.createWhile(this.context, sourceSection, condition, body) : WhileNode.createDoWhile(this.context, sourceSection, condition, body);
        CatchBreakNode ret = new CatchBreakNode(this.context, sourceSection, whileBreakID, loop);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitXStrNode(XStrNode node) {
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), (Node)new StrNode(node.getPosition(), node.getValue()), new Node[0]);
        FCallNode callNode = new FCallNode(node.getPosition(), "`", (Node)argsNode, null);
        RubyNode ret = (RubyNode)callNode.accept((NodeVisitor)this);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitYieldNode(YieldNode node) {
        boolean unsplat;
        ArrayList<Node> arguments = new ArrayList<Node>();
        Node argsNode = node.getArgsNode();
        boolean bl = unsplat = argsNode instanceof SplatNode || argsNode instanceof ArgsCatNode;
        if (argsNode instanceof SplatNode) {
            argsNode = ((SplatNode)argsNode).getValue();
        }
        if (argsNode != null) {
            if (argsNode instanceof ListNode) {
                arguments.addAll(node.getArgsNode().childNodes());
            } else {
                arguments.add(node.getArgsNode());
            }
        }
        ArrayList<Object> argumentsTranslated = new ArrayList<Object>();
        for (Node argument : arguments) {
            argumentsTranslated.add(argument.accept((NodeVisitor)this));
        }
        RubyNode[] argumentsTranslatedArray = argumentsTranslated.toArray(new RubyNode[argumentsTranslated.size()]);
        YieldExpressionNode ret = new YieldExpressionNode(this.context, this.translate(node.getPosition()), unsplat, argumentsTranslatedArray);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitZArrayNode(ZArrayNode node) {
        RubyNode[] values = new RubyNode[]{};
        ArrayLiteralNode ret = ArrayLiteralNode.create(this.context, this.translate(node.getPosition()), values);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitBackRefNode(BackRefNode node) {
        int index = 0;
        switch (node.getType()) {
            case '`': {
                index = -1;
                break;
            }
            case '\'': {
                index = -2;
                break;
            }
            case '&': {
                index = -3;
                break;
            }
            case '+': {
                index = -4;
                break;
            }
            default: {
                throw new UnsupportedOperationException(Character.toString(node.getType()));
            }
        }
        ReadMatchReferenceNode ret = new ReadMatchReferenceNode(this.context, this.translate(node.getPosition()), index);
        return this.addNewlineIfNeeded((Node)node, ret);
    }

    public RubyNode visitStarNode(StarNode star) {
        return this.nilNode(this.translate(star.getPosition()));
    }

    protected RubyNode initFlipFlopStates(SourceSection sourceSection) {
        RubyNode[] initNodes = new RubyNode[this.environment.getFlipFlopStates().size()];
        for (int n = 0; n < initNodes.length; ++n) {
            initNodes[n] = new InitFlipFlopSlotNode(this.context, sourceSection, this.environment.getFlipFlopStates().get(n));
        }
        return BodyTranslator.sequence(this.context, sourceSection, Arrays.asList(initNodes));
    }

    protected RubyNode defaultVisit(Node node) {
        RubyNode ret = this.unimplemented(node);
        return this.addNewlineIfNeeded(node, ret);
    }

    protected RubyNode unimplemented(Node node) {
        this.context.getJRubyRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, this.source.getName(), node.getPosition().getLine(), node + " does nothing - translating as nil");
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.nilNode(sourceSection);
    }

    public TranslatorEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    protected String getIdentifier() {
        if (this.environment.isBlock()) {
            TranslatorEnvironment methodParent = this.environment.getParent();
            while (methodParent.isBlock()) {
                methodParent = methodParent.getParent();
            }
            if (this.environment.getBlockDepth() > 1) {
                return String.format("block (%d levels) in %s", this.environment.getBlockDepth(), methodParent.getNamedMethodName());
            }
            return String.format("block in %s", methodParent.getNamedMethodName());
        }
        return this.environment.getNamedMethodName();
    }

    public RubyNode visitOther(Node node) {
        if (node instanceof ReadLocalDummyNode) {
            ReadLocalDummyNode readLocal = (ReadLocalDummyNode)node;
            ReadLocalVariableNode ret = new ReadLocalVariableNode(this.context, readLocal.getSourceSection(), LocalVariableType.FRAME_LOCAL, readLocal.getFrameSlot());
            return this.addNewlineIfNeeded(node, ret);
        }
        throw new UnsupportedOperationException();
    }

    private void copyNewline(Node from, Node to) {
        if (from.isNewline()) {
            to.setNewline();
        }
    }

    private RubyNode addNewlineIfNeeded(Node jrubyNode, RubyNode node) {
        if (jrubyNode.isNewline()) {
            SourceSection current = node.getEncapsulatingSourceSection();
            if (current == null) {
                return node;
            }
            if (this.context.getCoverageManager() != null) {
                this.context.getCoverageManager().setLineHasCode(current.getLineLocation());
            }
            node.unsafeSetIsNewLine();
        }
        return node;
    }

    static {
        Map<String, String> m = GLOBAL_VARIABLE_ALIASES = new HashMap<String, String>();
        m.put("$-I", "$LOAD_PATH");
        m.put("$:", "$LOAD_PATH");
        m.put("$-d", "$DEBUG");
        m.put("$-v", "$VERBOSE");
        m.put("$-w", "$VERBOSE");
        m.put("$-0", "$/");
        m.put("$RS", "$/");
        m.put("$INPUT_RECORD_SEPARATOR", "$/");
        m.put("$>", "$stdout");
        m.put("$PROGRAM_NAME", "$0");
        BAD_FRAME_SLOT = new Object();
        PARSER_SUPPORT = new ParserSupport();
    }

    protected static class ArgumentsAndBlockTranslation {
        private final RubyNode block;
        private final RubyNode[] arguments;
        private final boolean isSplatted;
        private final FrameSlot frameOnStackMarkerSlot;

        public ArgumentsAndBlockTranslation(RubyNode block, RubyNode[] arguments, boolean isSplatted, FrameSlot frameOnStackMarkerSlot) {
            this.block = block;
            this.arguments = arguments;
            this.isSplatted = isSplatted;
            this.frameOnStackMarkerSlot = frameOnStackMarkerSlot;
        }

        public RubyNode getBlock() {
            return this.block;
        }

        public RubyNode[] getArguments() {
            return this.arguments;
        }

        public boolean isSplatted() {
            return this.isSplatted;
        }

        public FrameSlot getFrameOnStackMarkerSlot() {
            return this.frameOnStackMarkerSlot;
        }
    }
}

