/*
 * Decompiled with CFR 0.152.
 */
package com.headius.options.example;

import com.headius.options.Option;

public class Example {
    public static void main(String[] args2) {
        Option<String> databaseName = Option.string("config.databaseName", MyCategory.STANDARD, "name of the database");
        Option<Integer> connCount = Option.integer("config.connCount", MyCategory.EXTENDED, "connection count");
        Option<Boolean> authenticate = Option.bool("config.authenticate", MyCategory.SPECIAL, "do authentication");
        Option<Class<AccountType>> acctType = Option.enumeration("config.acctType", (Enum)MyCategory.OTHER, AccountType.class, "account type");
        Option<String> username = Option.string("config.username", (Enum)MyCategory.STANDARD, new String[]{"root", "guest"}, "account name");
        Option<Boolean> timeout2 = Option.bool("config.timeout", MyCategory.EXTENDED, true, "timeout connections");
        Option<Integer> timeoutSecs = Option.integer("config.timeoutSecs", MyCategory.EXTENDED, new Integer[]{15, 30, 60}, (Integer)30, "timeout in seconds");
        String dbname = databaseName.load();
        AccountType accountType = (AccountType)((Object)acctType.load());
        System.setProperty("config.databaseName", "customers");
        dbname = databaseName.reload();
        if (databaseName.isSpecified()) {
            // empty if block
        }
        Option<String> firstName = Option.string("config", "first.name", MyCategory.STANDARD, "...");
        System.out.println(Option.formatOptions(databaseName, connCount, authenticate, acctType, username, timeout2, timeoutSecs, firstName));
        System.out.println(Option.formatValues(databaseName, connCount, authenticate, acctType, username, timeout2, timeoutSecs, firstName));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AccountType {
        ADMIN,
        GUEST,
        NORMAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MyCategory {
        STANDARD,
        EXTENDED,
        SPECIAL,
        OTHER;

    }
}

