/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import junit.framework.TestCase;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.RuleMatch;

public class MultipleWhitespaceRuleTest
extends TestCase {
    public void testRule() throws IOException {
        MultipleWhitespaceRule rule = new MultipleWhitespaceRule(TestTools.getEnglishMessages(), TestTools.getDemoLanguage());
        JLanguageTool langTool = new JLanguageTool(TestTools.getDemoLanguage());
        RuleMatch[] matches = rule.match(langTool.getAnalyzedSentence("This is a test sentence."));
        MultipleWhitespaceRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This is a test sentence..."));
        MultipleWhitespaceRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\n\tThis is a test sentence..."));
        MultipleWhitespaceRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("Multiple tabs\t\tare okay"));
        MultipleWhitespaceRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This  is a test sentence."));
        MultipleWhitespaceRuleTest.assertEquals((int)1, (int)matches.length);
        MultipleWhitespaceRuleTest.assertEquals((int)4, (int)matches[0].getFromPos());
        MultipleWhitespaceRuleTest.assertEquals((int)6, (int)matches[0].getToPos());
        matches = rule.match(langTool.getAnalyzedSentence("This is a test   sentence."));
        MultipleWhitespaceRuleTest.assertEquals((int)1, (int)matches.length);
        MultipleWhitespaceRuleTest.assertEquals((int)14, (int)matches[0].getFromPos());
        MultipleWhitespaceRuleTest.assertEquals((int)17, (int)matches[0].getToPos());
        matches = rule.match(langTool.getAnalyzedSentence("This is   a  test   sentence."));
        MultipleWhitespaceRuleTest.assertEquals((int)3, (int)matches.length);
        MultipleWhitespaceRuleTest.assertEquals((int)7, (int)matches[0].getFromPos());
        MultipleWhitespaceRuleTest.assertEquals((int)10, (int)matches[0].getToPos());
        MultipleWhitespaceRuleTest.assertEquals((int)11, (int)matches[1].getFromPos());
        MultipleWhitespaceRuleTest.assertEquals((int)13, (int)matches[1].getToPos());
        MultipleWhitespaceRuleTest.assertEquals((int)17, (int)matches[2].getFromPos());
        MultipleWhitespaceRuleTest.assertEquals((int)20, (int)matches[2].getToPos());
        matches = rule.match(langTool.getAnalyzedSentence("\t\t\t    \t\t\t\t  "));
        MultipleWhitespaceRuleTest.assertEquals((int)1, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This \u00a0is a test sentence."));
        MultipleWhitespaceRuleTest.assertEquals((int)1, (int)matches.length);
        MultipleWhitespaceRuleTest.assertEquals((int)4, (int)matches[0].getFromPos());
        MultipleWhitespaceRuleTest.assertEquals((int)6, (int)matches[0].getToPos());
    }
}

