/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.support;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.support.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXValidationSupport<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FXValidationSupport.class);
    private ReadOnlyObjectWrapper<ValidationState> validationState = new ReadOnlyObjectWrapper((Object)ValidationState.NOT_VALIDATED);
    private Validator<T> validator = new Validator<T>(){

        @Override
        public boolean isValid(T input) {
            return true;
        }
    };

    public void validate(T value) {
        LOG.trace("Validating {}", (Object)value);
        if (this.validator.isValid(value)) {
            this.validationState.set((Object)ValidationState.VALID);
        } else {
            this.validationState.set((Object)ValidationState.INVALID);
        }
    }

    public void setValidator(Validator<T> validator) {
        RequireUtils.requireNotNull(validator, "Validator cannot be null");
        this.validator = validator;
        this.makeNotValidated();
    }

    public void makeNotValidated() {
        LOG.trace("Making state {}", (Object)ValidationState.NOT_VALIDATED);
        this.validationState.set((Object)ValidationState.NOT_VALIDATED);
    }

    public final ReadOnlyObjectProperty<ValidationState> validationStateProperty() {
        return this.validationState.getReadOnlyProperty();
    }

    public static enum ValidationState {
        VALID,
        INVALID,
        NOT_VALIDATED;

    }
}

