/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.allinone;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Direction;
import com.baselet.control.util.Utils;
import com.baselet.element.interfaces.GridElementDeprecatedAddons;
import com.baselet.element.old.OldGridElement;
import com.baselet.element.old.activity.AEnd;
import com.baselet.element.old.activity.Activity;
import com.baselet.element.old.activity.Condition;
import com.baselet.element.old.activity.Container;
import com.baselet.element.old.activity.Element;
import com.baselet.element.old.activity.End;
import com.baselet.element.old.activity.EndIf;
import com.baselet.element.old.activity.EventRaise;
import com.baselet.element.old.activity.EventRecieve;
import com.baselet.element.old.activity.Fork;
import com.baselet.element.old.activity.GoTo;
import com.baselet.element.old.activity.If;
import com.baselet.element.old.activity.LineSpacer;
import com.baselet.element.old.activity.PartActivity;
import com.baselet.element.old.activity.Row;
import com.baselet.element.old.activity.Start;
import com.baselet.element.old.activity.StartElement;
import com.baselet.element.old.activity.StopElement;
import com.baselet.element.old.activity.Sync;
import com.baselet.element.sticking.StickingPolygon;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sourceforge.jlibeps.epsgraphics.EpsGraphics2D;

public class ActivityDiagramText
extends OldGridElement {
    private final AtomicBoolean autoInsertIF = new AtomicBoolean();
    private ArrayList<Row> rows;
    private ArrayList<Container> containers;
    private Container root_container;
    private Container current_container;
    private HashMap<String, Element> elements;
    private String title;
    private Graphics2D graphics;
    private ArrayList<GoTo> gotos;
    private int goto_seperation_left;
    private int goto_seperation_right;
    private float zoom;
    private static final String normalchars = "[^\\~\\>]";
    private static final String conditionChars = "[^\\]]";
    private static final String title_pattern = "title\\:([^\\~\\>]+)";
    private static final String line_pattern = "(\\t*)(\\[([ [^\\]]]+)\\])?(((Start)|(End|AEnd)|(\\|)|(If|Fork)|(EndIf|Sync)|(While(\\[([^\\~\\>]*)\\])?)|(\\>([^\\~\\>]+))|(([^\\~\\>]+)\\>)|(([^\\~\\>]+)\\.\\.)|([^\\~\\>]+))(\\~([^\\~\\>]+)?)?)?\\s*(\\-\\>([^\\~\\>]+))?\\s*";

    private void init(Graphics2D graphics) {
        this.zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        this.graphics = graphics;
        this.rows = new ArrayList();
        this.gotos = new ArrayList();
        this.containers = new ArrayList();
        this.elements = new HashMap();
        this.rows.add(new Row());
        this.current_container = this.root_container = new Container(this.autoInsertIF, HandlerElementMap.getHandlerForElement(this), graphics, null, this.rows, 0);
        this.title = null;
        this.goto_seperation_left = (int)(5.0f * this.zoom);
        this.goto_seperation_right = (int)(5.0f * this.zoom);
        this.graphics = graphics;
        this.graphics.setFont(HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont());
        this.graphics.setColor(this.fgColor);
    }

    private String preparse(String line) {
        String parsed_line = "";
        Pattern p_empty = Pattern.compile("\\s*");
        Pattern p_title = Pattern.compile(title_pattern);
        if (!p_empty.matcher(line).matches()) {
            Pattern p = Pattern.compile(line_pattern);
            Matcher m_title = p_title.matcher(line);
            if (m_title.matches()) {
                parsed_line = null;
                this.title = m_title.group(1);
            } else {
                parsed_line = p.matcher(line).matches() ? line : null;
            }
        }
        return parsed_line;
    }

    public int getGotoPosition(Direction dir) {
        if (Direction.LEFT.equals((Object)dir)) {
            if ((float)this.goto_seperation_left + 4.0f * this.zoom < 30.0f * this.zoom) {
                this.goto_seperation_left = (int)((float)this.goto_seperation_left + 4.0f * this.zoom);
            }
            return (int)(30.0f * this.zoom - (float)this.goto_seperation_left);
        }
        if ((float)this.goto_seperation_right + 4.0f * this.zoom < 30.0f * this.zoom) {
            this.goto_seperation_right = (int)((float)this.goto_seperation_right + 4.0f * this.zoom);
        }
        return (int)((float)this.root_container.getWidth() + 30.0f * this.zoom + (float)this.goto_seperation_right);
    }

    private Vector<String> preparse(Vector<String> lines) {
        if (lines.isEmpty()) {
            return lines;
        }
        Vector<String> parsed_lines = new Vector<String>();
        Iterator<String> it = lines.iterator();
        String current_line = this.preparse(it.next());
        if (current_line == null) {
            current_line = "";
        }
        while (current_line.equals("") && it.hasNext()) {
            current_line = this.preparse(it.next());
            if (current_line != null) continue;
            current_line = "";
        }
        String previous_line = current_line;
        int current_depth = 0;
        int last_depth = 0;
        while (it.hasNext()) {
            current_line = this.preparse(it.next());
            if (current_line == null) continue;
            if (!current_line.equals("")) {
                current_depth = 0;
                while (current_line.charAt(current_depth) == '\t') {
                    ++current_depth;
                }
                if (!previous_line.equals("") || current_depth == last_depth) {
                    parsed_lines.add(previous_line);
                }
                previous_line = current_line;
                last_depth = current_depth;
                continue;
            }
            if (previous_line.equals("")) continue;
            parsed_lines.add(previous_line);
            previous_line = current_line;
        }
        if (!previous_line.equals("")) {
            parsed_lines.add(previous_line);
        }
        return parsed_lines;
    }

    private void addElement(Element e) {
        this.current_container.addElement(e);
        this.elements.put(e.getId(), e);
    }

    @Override
    public void paintEntity(Graphics g) {
        this.init((Graphics2D)g);
        Vector<String> lines = Utils.decomposeStringsWithEmptyLines(this.getPanelAttributes());
        lines = this.preparse(lines);
        if (lines.size() == 0) {
            return;
        }
        this.autoInsertIF.set(true);
        while (lines.size() > 0 && lines.elementAt(0).startsWith("var:")) {
            if (lines.elementAt(0).equals("var:noautoif")) {
                this.autoInsertIF.set(false);
            }
            lines.remove(0);
        }
        int current_depth = 0;
        Pattern p = Pattern.compile(line_pattern);
        Element start_element = null;
        Element current_element = null;
        this.containers.add(this.root_container);
        for (String string : lines) {
            Matcher m = p.matcher(string);
            Container closed_container = null;
            if (!m.matches()) continue;
            Pattern p_empty = Pattern.compile("\\s*");
            Matcher m_empty = p_empty.matcher(string);
            if (m_empty.matches()) {
                if (start_element != null) {
                    this.addElement(start_element);
                    start_element = null;
                }
                if (this.current_container.isRoot()) continue;
                this.current_container.addColumn();
                continue;
            }
            if (m.group(1) != null) {
                if (m.group(1).length() > current_depth) {
                    while (current_depth < m.group(1).length()) {
                        this.current_container = this.current_container.addNewContainer();
                        this.containers.add(this.current_container);
                        if (start_element != null) {
                            this.current_container.setStartElement((StartElement)start_element);
                            this.elements.put(start_element.getId(), start_element);
                            start_element = null;
                        }
                        ++current_depth;
                    }
                } else {
                    if (start_element != null) {
                        this.addElement(start_element);
                        start_element = null;
                    }
                    if (m.group(1).length() < current_depth) {
                        while (current_depth > m.group(1).length()) {
                            closed_container = this.current_container;
                            if (!this.current_container.isRoot()) {
                                this.current_container = this.current_container.close();
                            }
                            --current_depth;
                        }
                    }
                }
            }
            Element e = null;
            if (m.group(2) != null) {
                String input = "";
                if (m.group(3) != null) {
                    input = m.group(3);
                }
                current_element = e = new Condition(HandlerElementMap.getHandlerForElement(this), input, this.graphics);
            }
            if (e != null) {
                this.addElement(e);
            }
            e = null;
            if (m.group(4) != null) {
                String id = m.group(22);
                if (m.group(6) != null) {
                    e = new Start(HandlerElementMap.getHandlerForElement(this), this.graphics);
                } else if (m.group(7) != null) {
                    e = m.group(7).equals("AEnd") ? new AEnd(HandlerElementMap.getHandlerForElement(this), this.graphics, id) : new End(HandlerElementMap.getHandlerForElement(this), this.graphics, id);
                } else if (m.group(8) != null) {
                    e = new LineSpacer(HandlerElementMap.getHandlerForElement(this), this.graphics);
                } else if (m.group(9) != null) {
                    start_element = m.group(9).equals("Fork") ? new Fork(HandlerElementMap.getHandlerForElement(this), this.graphics, id) : new If(HandlerElementMap.getHandlerForElement(this), this.graphics, id);
                    current_element = start_element;
                } else if (m.group(10) != null) {
                    StopElement se = m.group(10).equals("Sync") ? new Sync(HandlerElementMap.getHandlerForElement(this), this.graphics, id) : new EndIf(HandlerElementMap.getHandlerForElement(this), this.graphics, id);
                    if (closed_container != null) {
                        closed_container.setStopElement(se);
                        this.elements.put(se.getId(), se);
                    } else {
                        e = se;
                    }
                    current_element = se;
                } else if (m.group(11) != null) {
                    this.current_container = this.current_container.addNewWhile(m.group(13));
                    ++current_depth;
                } else if (m.group(15) != null) {
                    e = new EventRecieve(HandlerElementMap.getHandlerForElement(this), this.graphics, m.group(15), id);
                } else if (m.group(17) != null) {
                    e = new EventRaise(HandlerElementMap.getHandlerForElement(this), this.graphics, m.group(17), id);
                } else if (m.group(19) != null) {
                    e = new PartActivity(HandlerElementMap.getHandlerForElement(this), m.group(19), this.graphics, id);
                } else if (m.group(20) != null) {
                    e = new Activity(HandlerElementMap.getHandlerForElement(this), m.group(20), this.graphics, id);
                }
            }
            if (e != null) {
                current_element = e;
                this.addElement(e);
            }
            if (m.group(23) == null || m.group(24) == null || current_element == null) continue;
            String connect_to = m.group(24);
            this.gotos.add(new GoTo(this.graphics, current_element, connect_to));
            current_element.setTerminated();
        }
        if (start_element != null) {
            this.addElement(start_element);
        }
        while (!this.current_container.isRoot()) {
            this.current_container = this.current_container.close();
        }
        for (Container container : this.containers) {
            container.removeEmptyColumns();
        }
        ArrayList<GoTo> valid_gotos = new ArrayList<GoTo>();
        for (GoTo go : this.gotos) {
            Element from = go.getFromElement();
            go.setToElement(this.elements.get(go.getToElementId()));
            Element to = go.getToElement();
            if (from == null || to == null) continue;
            valid_gotos.add(go);
            boolean fromleft = from.getRow().isLeft(from);
            boolean fromright = from.getRow().isRight(from);
            boolean toleft = to.getRow().isLeft(to);
            boolean toright = to.getRow().isRight(to);
            if (fromleft) {
                go.setDirection(Direction.LEFT);
                if (toleft) continue;
                this.rows = to.getRow().makeExclusiveLeft(to, this.rows);
                continue;
            }
            if (toleft) {
                go.setDirection(Direction.LEFT);
                this.rows = from.getRow().makeExclusiveLeft(from, this.rows);
                continue;
            }
            if (fromright) {
                go.setDirection(Direction.RIGHT);
                if (toright) continue;
                this.rows = to.getRow().makeExclusiveRight(to, this.rows);
                continue;
            }
            if (toright) {
                go.setDirection(Direction.RIGHT);
                this.rows = from.getRow().makeExclusiveRight(from, this.rows);
                continue;
            }
            go.setDirection(Direction.LEFT);
            this.rows = from.getRow().makeExclusiveLeft(from, this.rows);
            this.rows = to.getRow().makeExclusiveLeft(to, this.rows);
        }
        int n = 0;
        int width = (int)((float)this.root_container.getWidth() + 30.0f * this.zoom * 2.0f);
        int height = 0;
        if (this.title != null) {
            int n2 = n + (int)(25.0f * this.zoom);
            height += (int)(25.0f * this.zoom);
            if (this.title.length() > 0) {
                HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(this.graphics, this.title, (double)((int)(10.0f * this.zoom)), (double)((int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() + (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts()), AlignHorizontal.LEFT);
                int titlewidth = (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextWidth(this.title);
                int ty = (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize() + (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts() + (int)(8.0f * this.zoom);
                this.graphics.drawLine(0, ty, titlewidth + (int)(10.0f * this.zoom), ty);
                this.graphics.drawLine(titlewidth + (int)(10.0f * this.zoom), ty, titlewidth + ty + (int)(10.0f * this.zoom), 0);
            }
        }
        for (Row r : this.rows) {
            int n3;
            n3 = r.setElementYPosition(n3);
        }
        this.root_container.setX((int)((float)this.root_container.getLeftWidth() + 30.0f * this.zoom));
        for (Row r : this.rows) {
            height += r.getHeight();
        }
        if ((float)width < 50.0f * this.zoom) {
            width = (int)(50.0f * this.zoom);
        }
        if ((float)height < 50.0f * this.zoom) {
            height = (int)(50.0f * this.zoom);
        }
        this.setSize(width, height);
        this.graphics.drawRect(0, 0, this.getRectangle().width - 1, this.getRectangle().height - 1);
        this.root_container.paint();
        for (GoTo goTo : valid_gotos) {
            goTo.paint(HandlerElementMap.getHandlerForElement(this).getZoomFactor(), this.getGotoPosition(goTo.getDirection()));
        }
    }

    @Override
    public Set<Direction> getResizeArea(int x, int y) {
        return new HashSet<Direction>();
    }

    @Override
    public StickingPolygon generateStickingBorder() {
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public GridElementDeprecatedAddons getDeprecatedAddons() {
        return new GridElementDeprecatedAddons(){

            public void doBeforeExport() {
                ActivityDiagramText.this.paintEntity((Graphics)new EpsGraphics2D());
            }
        };
    }
}

