/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.tomcat.InstrumentableClassLoader;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.res.StringManager;

public class WebappClassLoader
extends URLClassLoader
implements Lifecycle,
InstrumentableClassLoader {
    private static final Log log = LogFactory.getLog(WebappClassLoader.class);
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final List<String> JVM_THREAD_GROUP_NAMES = new ArrayList<String>();
    private static final String JVM_THREAD_GROUP_SYSTEM = "system";
    private static final String SERVICES_PREFIX = "META-INF/services/";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final Manifest MANIFEST_UNKNOWN = new Manifest();
    protected static final String[] triggers;
    protected static final String[] packageTriggers;
    protected static final StringManager sm;
    boolean antiJARLocking = false;
    protected DirContext resources = null;
    protected HashMap<String, ResourceEntry> resourceEntries = new HashMap();
    protected HashMap<String, String> notFoundResources = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 1000;
        }
    };
    protected boolean delegate = false;
    protected long lastJarAccessed = 0L;
    protected String[] repositories = new String[0];
    protected URL[] repositoryURLs = null;
    protected File[] files = new File[0];
    protected JarFile[] jarFiles = new JarFile[0];
    protected File[] jarRealFiles = new File[0];
    protected String jarPath = null;
    protected String[] jarNames = new String[0];
    protected long[] lastModifiedDates = new long[0];
    protected String[] paths = new String[0];
    protected ArrayList<Permission> permissionList = new ArrayList();
    protected File loaderDir = null;
    protected String canonicalLoaderDir = null;
    protected HashMap<String, PermissionCollection> loaderPC = new HashMap();
    protected SecurityManager securityManager = null;
    protected ClassLoader parent = null;
    protected ClassLoader system = null;
    protected ClassLoader j2seClassLoader;
    protected boolean started = false;
    protected boolean hasExternalRepositories = false;
    protected boolean searchExternalFirst = false;
    protected boolean needConvert = false;
    protected Permission allPermission = new AllPermission();
    private boolean clearReferencesStatic = false;
    private boolean clearReferencesStopThreads = false;
    private boolean clearReferencesStopTimerThreads = false;
    private boolean clearReferencesLogFactoryRelease = true;
    private boolean clearReferencesHttpClientKeepAliveThread = true;
    private String contextName = "unknown";
    private final List<ClassFileTransformer> transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private URL webInfClassesCodeBase = null;

    public WebappClassLoader() {
        super(new URL[0]);
        ClassLoader p = this.getParent();
        if (p == null) {
            p = WebappClassLoader.getSystemClassLoader();
        }
        this.parent = p;
        ClassLoader j = String.class.getClassLoader();
        if (j == null) {
            j = WebappClassLoader.getSystemClassLoader();
            while (j.getParent() != null) {
                j = j.getParent();
            }
        }
        this.j2seClassLoader = j;
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public WebappClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        ClassLoader p = this.getParent();
        if (p == null) {
            p = WebappClassLoader.getSystemClassLoader();
        }
        this.parent = p;
        ClassLoader j = String.class.getClassLoader();
        if (j == null) {
            j = WebappClassLoader.getSystemClassLoader();
            while (j.getParent() != null) {
                j = j.getParent();
            }
        }
        this.j2seClassLoader = j;
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public DirContext getResources() {
        return this.resources;
    }

    public void setResources(DirContext resources) {
        this.resources = resources;
        if (resources instanceof ProxyDirContext) {
            this.contextName = ((ProxyDirContext)resources).getContextName();
        }
    }

    public String getContextName() {
        return this.contextName;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public boolean getAntiJARLocking() {
        return this.antiJARLocking;
    }

    public void setAntiJARLocking(boolean antiJARLocking) {
        this.antiJARLocking = antiJARLocking;
    }

    public boolean getSearchExternalFirst() {
        return this.searchExternalFirst;
    }

    public void setSearchExternalFirst(boolean searchExternalFirst) {
        this.searchExternalFirst = searchExternalFirst;
    }

    public void addPermission(String filepath) {
        if (filepath == null) {
            return;
        }
        String path = filepath;
        if (this.securityManager != null) {
            Permission permission = null;
            if (path.startsWith("jndi:") || path.startsWith("jar:jndi:")) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                permission = new JndiPermission(path + "*");
                this.addPermission(permission);
            } else {
                if (!path.endsWith(File.separator)) {
                    permission = new FilePermission(path, "read");
                    this.addPermission(permission);
                    path = path + File.separator;
                }
                permission = new FilePermission(path + "-", "read");
                this.addPermission(permission);
            }
        }
    }

    public void addPermission(URL url) {
        if (url != null) {
            this.addPermission(url.toString());
        }
    }

    public void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.permissionList.add(permission);
        }
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    public void setWorkDir(File workDir) {
        this.loaderDir = new File(workDir, "loader");
        if (this.loaderDir == null) {
            this.canonicalLoaderDir = null;
        } else {
            try {
                this.canonicalLoaderDir = this.loaderDir.getCanonicalPath();
                if (!this.canonicalLoaderDir.endsWith(File.separator)) {
                    this.canonicalLoaderDir = this.canonicalLoaderDir + File.separator;
                }
            }
            catch (IOException ioe) {
                this.canonicalLoaderDir = null;
            }
        }
    }

    @Deprecated
    protected void setParentClassLoader(ClassLoader pcl) {
        this.parent = pcl;
    }

    public boolean getClearReferencesStatic() {
        return this.clearReferencesStatic;
    }

    public void setClearReferencesStatic(boolean clearReferencesStatic) {
        this.clearReferencesStatic = clearReferencesStatic;
    }

    public boolean getClearReferencesStopThreads() {
        return this.clearReferencesStopThreads;
    }

    public void setClearReferencesStopThreads(boolean clearReferencesStopThreads) {
        this.clearReferencesStopThreads = clearReferencesStopThreads;
    }

    public boolean getClearReferencesStopTimerThreads() {
        return this.clearReferencesStopTimerThreads;
    }

    public void setClearReferencesStopTimerThreads(boolean clearReferencesStopTimerThreads) {
        this.clearReferencesStopTimerThreads = clearReferencesStopTimerThreads;
    }

    public boolean getClearReferencesLogFactoryRelease() {
        return this.clearReferencesLogFactoryRelease;
    }

    public void setClearReferencesLogFactoryRelease(boolean clearReferencesLogFactoryRelease) {
        this.clearReferencesLogFactoryRelease = clearReferencesLogFactoryRelease;
    }

    public boolean getClearReferencesHttpClientKeepAliveThread() {
        return this.clearReferencesHttpClientKeepAliveThread;
    }

    public void setClearReferencesHttpClientKeepAliveThread(boolean clearReferencesHttpClientKeepAliveThread) {
        this.clearReferencesHttpClientKeepAliveThread = clearReferencesHttpClientKeepAliveThread;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException(sm.getString("webappClassLoader.addTransformer.illegalArgument", this.getContextName()));
        }
        if (this.transformers.contains(transformer)) {
            log.warn((Object)sm.getString("webappClassLoader.addTransformer.duplicate", transformer, this.getContextName()));
            return;
        }
        this.transformers.add(transformer);
        log.info((Object)sm.getString("webappClassLoader.addTransformer", transformer, this.getContextName()));
    }

    @Override
    public void removeTransformer(ClassFileTransformer transformer) {
        if (transformer == null) {
            return;
        }
        if (this.transformers.remove(transformer)) {
            log.info((Object)sm.getString("webappClassLoader.removeTransformer", transformer, this.getContextName()));
            return;
        }
    }

    @Override
    public WebappClassLoader copyWithoutTransformers() {
        WebappClassLoader result = new WebappClassLoader(this.parent);
        result.antiJARLocking = this.antiJARLocking;
        result.resources = this.resources;
        result.files = this.files;
        result.delegate = this.delegate;
        result.lastJarAccessed = this.lastJarAccessed;
        result.repositories = this.repositories;
        result.jarPath = this.jarPath;
        result.loaderDir = this.loaderDir;
        result.canonicalLoaderDir = this.canonicalLoaderDir;
        result.clearReferencesStatic = this.clearReferencesStatic;
        result.clearReferencesStopThreads = this.clearReferencesStopThreads;
        result.clearReferencesStopTimerThreads = this.clearReferencesStopTimerThreads;
        result.clearReferencesLogFactoryRelease = this.clearReferencesLogFactoryRelease;
        result.clearReferencesHttpClientKeepAliveThread = this.clearReferencesHttpClientKeepAliveThread;
        result.repositoryURLs = (URL[])this.repositoryURLs.clone();
        result.jarFiles = (JarFile[])this.jarFiles.clone();
        result.jarRealFiles = (File[])this.jarRealFiles.clone();
        result.jarNames = (String[])this.jarNames.clone();
        result.lastModifiedDates = (long[])this.lastModifiedDates.clone();
        result.paths = (String[])this.paths.clone();
        result.notFoundResources.putAll(this.notFoundResources);
        result.permissionList.addAll(this.permissionList);
        result.loaderPC.putAll(this.loaderPC);
        result.contextName = this.contextName;
        result.hasExternalRepositories = this.hasExternalRepositories;
        result.searchExternalFirst = this.searchExternalFirst;
        try {
            result.start();
        }
        catch (LifecycleException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public void addRepository(String repository) {
        if (repository.startsWith("/WEB-INF/lib") || repository.startsWith("/WEB-INF/classes")) {
            return;
        }
        try {
            URL url = new URL(repository);
            super.addURL(url);
            this.hasExternalRepositories = true;
            this.repositoryURLs = null;
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid repository: " + repository);
            iae.initCause(e);
            throw iae;
        }
    }

    synchronized void addRepository(String repository, File file) {
        int i;
        if (repository == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addRepository(" + repository + ")"));
        }
        String[] result = new String[this.repositories.length + 1];
        for (i = 0; i < this.repositories.length; ++i) {
            result[i] = this.repositories[i];
        }
        result[this.repositories.length] = repository;
        this.repositories = result;
        File[] result2 = new File[this.files.length + 1];
        for (i = 0; i < this.files.length; ++i) {
            result2[i] = this.files[i];
        }
        result2[this.files.length] = file;
        this.files = result2;
    }

    synchronized void addJar(String jar, JarFile jarFile, File file) throws IOException {
        int i;
        if (jar == null) {
            return;
        }
        if (jarFile == null) {
            return;
        }
        if (file == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addJar(" + jar + ")"));
        }
        if (this.jarPath != null && jar.startsWith(this.jarPath)) {
            String jarName = jar.substring(this.jarPath.length());
            while (jarName.startsWith("/")) {
                jarName = jarName.substring(1);
            }
            String[] result = new String[this.jarNames.length + 1];
            for (i = 0; i < this.jarNames.length; ++i) {
                result[i] = this.jarNames[i];
            }
            result[this.jarNames.length] = jarName;
            this.jarNames = result;
        }
        try {
            long lastModified = ((ResourceAttributes)this.resources.getAttributes(jar)).getLastModified();
            String[] result = new String[this.paths.length + 1];
            for (i = 0; i < this.paths.length; ++i) {
                result[i] = this.paths[i];
            }
            result[this.paths.length] = jar;
            this.paths = result;
            long[] result3 = new long[this.lastModifiedDates.length + 1];
            for (i = 0; i < this.lastModifiedDates.length; ++i) {
                result3[i] = this.lastModifiedDates[i];
            }
            result3[this.lastModifiedDates.length] = lastModified;
            this.lastModifiedDates = result3;
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (!this.validateJarFile(file)) {
            return;
        }
        JarFile[] result2 = new JarFile[this.jarFiles.length + 1];
        for (i = 0; i < this.jarFiles.length; ++i) {
            result2[i] = this.jarFiles[i];
        }
        result2[this.jarFiles.length] = jarFile;
        this.jarFiles = result2;
        File[] result4 = new File[this.jarRealFiles.length + 1];
        for (i = 0; i < this.jarRealFiles.length; ++i) {
            result4[i] = this.jarRealFiles[i];
        }
        result4[this.jarRealFiles.length] = file;
        this.jarRealFiles = result4;
    }

    public String[] findRepositories() {
        return (String[])this.repositories.clone();
    }

    public boolean modified() {
        int length2;
        int length;
        if (log.isDebugEnabled()) {
            log.debug((Object)"modified()");
        }
        if ((length = this.paths.length) > (length2 = this.lastModifiedDates.length)) {
            length = length2;
        }
        for (int i = 0; i < length; ++i) {
            try {
                long lastModified = ((ResourceAttributes)this.resources.getAttributes(this.paths[i])).getLastModified();
                if (lastModified == this.lastModifiedDates[i]) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Resource '" + this.paths[i] + "' was modified; Date is now: " + new Date(lastModified) + " Was: " + new Date(this.lastModifiedDates[i])));
                }
                return true;
            }
            catch (NamingException e) {
                log.error((Object)("    Resource '" + this.paths[i] + "' is missing"));
                return true;
            }
        }
        length = this.jarNames.length;
        if (this.getJarPath() != null) {
            try {
                String name;
                NameClassPair ncPair;
                NamingEnumeration<Binding> enumeration = this.resources.listBindings(this.getJarPath());
                int i = 0;
                while (enumeration.hasMoreElements() && i < length) {
                    ncPair = (NameClassPair)enumeration.nextElement();
                    name = ncPair.getName();
                    if (!name.endsWith(".jar")) continue;
                    if (!name.equals(this.jarNames[i])) {
                        log.info((Object)("    Additional JARs have been added : '" + name + "'"));
                        return true;
                    }
                    ++i;
                }
                if (enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        ncPair = (NameClassPair)enumeration.nextElement();
                        name = ncPair.getName();
                        if (!name.endsWith(".jar")) continue;
                        log.info((Object)"    Additional JARs have been added");
                        return true;
                    }
                } else if (i < this.jarNames.length) {
                    log.info((Object)"    Additional JARs have been added");
                    return true;
                }
            }
            catch (NamingException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("    Failed tracking modifications of '" + this.getJarPath() + "'"));
                }
            }
            catch (ClassCastException e) {
                log.error((Object)("    Failed tracking modifications of '" + this.getJarPath() + "' : " + e.getMessage()));
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebappClassLoader\r\n");
        sb.append("  context: ");
        sb.append(this.contextName);
        sb.append("\r\n");
        sb.append("  delegate: ");
        sb.append(this.delegate);
        sb.append("\r\n");
        sb.append("  repositories:\r\n");
        if (this.repositories != null) {
            for (int i = 0; i < this.repositories.length; ++i) {
                sb.append("    ");
                sb.append(this.repositories[i]);
                sb.append("\r\n");
            }
        }
        if (this.parent != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.parent.toString());
            sb.append("\r\n");
        }
        if (this.transformers.size() > 0) {
            sb.append("----------> Class file transformers:\r\n");
            for (ClassFileTransformer transformer : this.transformers) {
                sb.append(transformer).append("\r\n");
            }
        }
        return sb.toString();
    }

    @Override
    protected void addURL(URL url) {
        super.addURL(url);
        this.hasExternalRepositories = true;
        this.repositoryURLs = null;
    }

    protected final Class<?> doDefineClass(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
        return super.defineClass(name, b, off, len, protectionDomain);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findClass(" + name + ")"));
        }
        if (!this.started) {
            throw new ClassNotFoundException(name);
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i));
            }
            catch (Exception se) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      -->Exception-->ClassNotFoundException", (Throwable)se);
                }
                throw new ClassNotFoundException(name, se);
            }
        }
        Class<?> clazz = null;
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("      findClassInternal(" + name + ")"));
            }
            if (this.hasExternalRepositories && this.searchExternalFirst) {
                try {
                    clazz = super.findClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                }
                catch (AccessControlException ace) {
                    log.warn((Object)("WebappClassLoader.findClassInternal(" + name + ") security exception: " + ace.getMessage()), (Throwable)ace);
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)e);
                    }
                    throw e;
                }
            }
            if (clazz == null) {
                try {
                    clazz = this.findClassInternal(name);
                }
                catch (ClassNotFoundException cnfe) {
                    if (!this.hasExternalRepositories || this.searchExternalFirst) {
                        throw cnfe;
                    }
                }
                catch (AccessControlException ace) {
                    log.warn((Object)("WebappClassLoader.findClassInternal(" + name + ") security exception: " + ace.getMessage()), (Throwable)ace);
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)e);
                    }
                    throw e;
                }
            }
            if (clazz == null && this.hasExternalRepositories && !this.searchExternalFirst) {
                try {
                    clazz = super.findClass(name);
                }
                catch (AccessControlException ace) {
                    log.warn((Object)("WebappClassLoader.findClassInternal(" + name + ") security exception: " + ace.getMessage()), (Throwable)ace);
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)e);
                    }
                    throw e;
                }
            }
            if (clazz == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"    --> Passing on ClassNotFoundException");
            }
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.debug((Object)("      Returning class " + clazz));
        }
        if (log.isTraceEnabled()) {
            ClassLoader cl = Globals.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedGetClassLoader(clazz)) : clazz.getClassLoader();
            log.debug((Object)("      Loaded by " + cl.toString()));
        }
        return clazz;
    }

    @Override
    public URL findResource(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findResource(" + name + ")"));
        }
        URL url = null;
        if (this.hasExternalRepositories && this.searchExternalFirst) {
            url = super.findResource(name);
        }
        if (url == null) {
            ResourceEntry entry = this.resourceEntries.get(name);
            if (entry == null) {
                if (this.securityManager != null) {
                    PrivilegedFindResourceByName dp = new PrivilegedFindResourceByName(name, name, false);
                    entry = AccessController.doPrivileged(dp);
                } else {
                    entry = this.findResourceInternal(name, name, false);
                }
            }
            if (entry != null) {
                url = entry.source;
            }
        }
        if (url == null && this.hasExternalRepositories && !this.searchExternalFirst) {
            url = super.findResource(name);
        }
        if (log.isDebugEnabled()) {
            if (url != null) {
                log.debug((Object)("    --> Returning '" + url.toString() + "'"));
            } else {
                log.debug((Object)"    --> Resource not found, returning null");
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        int i;
        Enumeration<URL> otherResourcePaths;
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findResources(" + name + ")"));
        }
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        int jarFilesLength = this.jarFiles.length;
        int repositoriesLength = this.repositories.length;
        if (this.hasExternalRepositories && this.searchExternalFirst) {
            otherResourcePaths = super.findResources(name);
            while (otherResourcePaths.hasMoreElements()) {
                result.add(otherResourcePaths.nextElement());
            }
        }
        for (i = 0; i < repositoriesLength; ++i) {
            try {
                String fullPath = this.repositories[i] + name;
                this.resources.lookup(fullPath);
                try {
                    result.add(this.getURI(new File(this.files[i], name)));
                }
                catch (MalformedURLException e) {}
                continue;
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        JarFile[] e = this.jarFiles;
        synchronized (this.jarFiles) {
            if (this.openJARs()) {
                for (i = 0; i < jarFilesLength; ++i) {
                    JarEntry jarEntry = this.jarFiles[i].getJarEntry(name);
                    if (jarEntry == null) continue;
                    try {
                        String jarFakeUrl = this.getURI(this.jarRealFiles[i]).toString();
                        jarFakeUrl = "jar:" + jarFakeUrl + "!/" + name;
                        result.add(new URL(jarFakeUrl));
                        continue;
                    }
                    catch (MalformedURLException e2) {
                        // empty catch block
                    }
                }
            }
            // ** MonitorExit[e] (shouldn't be in output)
            if (this.hasExternalRepositories && !this.searchExternalFirst) {
                otherResourcePaths = super.findResources(name);
                while (otherResourcePaths.hasMoreElements()) {
                    result.add(otherResourcePaths.nextElement());
                }
            }
            return Collections.enumeration(result);
        }
    }

    @Override
    public URL getResource(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResource(" + name + ")"));
        }
        URL url = null;
        if (this.delegate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader " + this.parent));
            }
            if ((url = this.parent.getResource(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  --> Returning '" + url.toString() + "'"));
                }
                return url;
            }
        }
        if ((url = this.findResource(name)) != null) {
            if (this.antiJARLocking) {
                ResourceEntry entry = this.resourceEntries.get(name);
                try {
                    String repository = entry.codeBase.toString();
                    if (repository.endsWith(".jar") && !name.endsWith(CLASS_FILE_SUFFIX)) {
                        File resourceFile = new File(this.loaderDir, name);
                        url = this.getURI(resourceFile);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  --> Returning '" + url.toString() + "'"));
            }
            return url;
        }
        if (!this.delegate && (url = this.parent.getResource(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  --> Returning '" + url.toString() + "'"));
            }
            return url;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResourceAsStream(" + name + ")"));
        }
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from cache");
            }
            return stream;
        }
        if (this.delegate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader " + this.parent));
            }
            if ((stream = this.parent.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from local");
            }
            stream = this.findLoadedResource(name);
            try {
                if (this.hasExternalRepositories && stream == null) {
                    stream = url.openStream();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (stream != null) {
                return stream;
            }
        }
        if (!this.delegate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader unconditionally " + this.parent));
            }
            if ((stream = this.parent.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean delegateLoad;
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadClass(" + name + ", " + resolve + ")"));
        }
        Class<?> clazz = null;
        if (!this.started) {
            try {
                throw new IllegalStateException();
            }
            catch (IllegalStateException e) {
                log.info((Object)sm.getString("webappClassLoader.stopped", name), (Throwable)e);
            }
        }
        if ((clazz = this.findLoadedClass0(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        try {
            clazz = this.j2seClassLoader.loadClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                log.info((Object)error, (Throwable)se);
                throw new ClassNotFoundException(error, se);
            }
        }
        boolean bl = delegateLoad = this.delegate || this.filter(name);
        if (delegateLoad) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader1 " + this.parent));
            }
            try {
                clazz = Class.forName(name, false, this.parent);
                if (clazz != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (!delegateLoad) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader at end: " + this.parent));
            }
            try {
                clazz = Class.forName(name, false, this.parent);
                if (clazz != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl = codeSource.getLocation().toString();
        PermissionCollection pc = this.loaderPC.get(codeUrl);
        if (pc == null && (pc = super.getPermissions(codeSource)) != null) {
            for (Permission p : this.permissionList) {
                pc.add(p);
            }
            this.loaderPC.put(codeUrl, pc);
        }
        return pc;
    }

    @Override
    public URL[] getURLs() {
        if (this.repositoryURLs != null) {
            return (URL[])this.repositoryURLs.clone();
        }
        URL[] external = super.getURLs();
        int filesLength = this.files.length;
        int jarFilesLength = this.jarRealFiles.length;
        int externalsLength = external.length;
        int off = 0;
        try {
            int i;
            URL[] urls = new URL[filesLength + jarFilesLength + externalsLength];
            if (this.searchExternalFirst) {
                for (i = 0; i < externalsLength; ++i) {
                    urls[i] = external[i];
                }
                off = externalsLength;
            }
            for (i = 0; i < filesLength; ++i) {
                urls[off + i] = this.getURI(this.files[i]);
            }
            off += filesLength;
            for (i = 0; i < jarFilesLength; ++i) {
                urls[off + i] = this.getURI(this.jarRealFiles[i]);
            }
            off += jarFilesLength;
            if (!this.searchExternalFirst) {
                for (i = 0; i < externalsLength; ++i) {
                    urls[off + i] = external[i];
                }
            }
            this.repositoryURLs = urls;
        }
        catch (MalformedURLException e) {
            this.repositoryURLs = new URL[0];
        }
        return (URL[])this.repositoryURLs.clone();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
    }

    @Override
    public LifecycleState getState() {
        return LifecycleState.NEW;
    }

    @Override
    public String getStateName() {
        return this.getState().toString();
    }

    @Override
    public void init() {
    }

    @Override
    public void start() throws LifecycleException {
        this.started = true;
        String encoding = null;
        try {
            encoding = System.getProperty("file.encoding");
        }
        catch (SecurityException e) {
            return;
        }
        if (encoding.indexOf("EBCDIC") != -1) {
            this.needConvert = true;
        }
        for (int i = 0; i < this.repositories.length; ++i) {
            if (!this.repositories[i].equals("/WEB-INF/classes/")) continue;
            try {
                this.webInfClassesCodeBase = this.files[i].toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {}
            break;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void stop() throws LifecycleException {
        int i;
        this.clearReferences();
        this.started = false;
        int length = this.files.length;
        for (i = 0; i < length; ++i) {
            this.files[i] = null;
        }
        length = this.jarFiles.length;
        for (i = 0; i < length; ++i) {
            try {
                if (this.jarFiles[i] != null) {
                    this.jarFiles[i].close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jarFiles[i] = null;
        }
        this.notFoundResources.clear();
        this.resourceEntries.clear();
        this.resources = null;
        this.repositories = null;
        this.repositoryURLs = null;
        this.files = null;
        this.jarFiles = null;
        this.jarRealFiles = null;
        this.jarPath = null;
        this.jarNames = null;
        this.lastModifiedDates = null;
        this.paths = null;
        this.hasExternalRepositories = false;
        this.parent = null;
        this.webInfClassesCodeBase = null;
        this.permissionList.clear();
        this.loaderPC.clear();
        if (this.loaderDir != null) {
            WebappClassLoader.deleteDir(this.loaderDir);
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeJARs(boolean force) {
        if (this.jarFiles.length <= 0) return;
        JarFile[] jarFileArray = this.jarFiles;
        synchronized (this.jarFiles) {
            if (!force && System.currentTimeMillis() <= this.lastJarAccessed + 90000L) return;
            for (int i = 0; i < this.jarFiles.length; ++i) {
                try {
                    if (this.jarFiles[i] == null) continue;
                    this.jarFiles[i].close();
                    this.jarFiles[i] = null;
                    continue;
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Failed to close JAR", (Throwable)e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected ClassLoader getJavaseClassLoader() {
        return this.j2seClassLoader;
    }

    protected void setJavaseClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException(sm.getString("webappClassLoader.javaseClassLoaderNull"));
        }
        this.j2seClassLoader = classLoader;
    }

    protected void clearReferences() {
        this.clearReferencesJdbc();
        this.clearReferencesThreads();
        this.checkThreadLocalsForLeaks();
        this.clearReferencesRmiTargets();
        if (this.clearReferencesStatic) {
            this.clearReferencesStaticFinal();
        }
        IntrospectionUtils.clear();
        if (this.clearReferencesLogFactoryRelease) {
            LogFactory.release((ClassLoader)this);
        }
        this.clearReferencesResourceBundles();
        Introspector.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void clearReferencesJdbc() {
        InputStream is = this.getResourceAsStream("org/apache/catalina/loader/JdbcLeakPrevention.class");
        byte[] classBytes = new byte[2048];
        int offset = 0;
        int read = is.read(classBytes, offset, classBytes.length - offset);
        while (read > -1) {
            if ((offset += read) == classBytes.length) {
                byte[] tmp = new byte[classBytes.length * 2];
                System.arraycopy(classBytes, 0, tmp, 0, classBytes.length);
                classBytes = tmp;
            }
            read = is.read(classBytes, offset, classBytes.length - offset);
        }
        Class<?> lpClass = this.defineClass("org.apache.catalina.loader.JdbcLeakPrevention", classBytes, 0, offset, this.getClass().getProtectionDomain());
        Object obj = lpClass.newInstance();
        List driverNames = (List)obj.getClass().getMethod("clearJdbcDriverRegistrations", new Class[0]).invoke(obj, new Object[0]);
        for (String name : driverNames) {
            log.error((Object)sm.getString("webappClassLoader.clearJdbc", this.contextName, name));
        }
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException ioe) {
            log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveStreamError", this.contextName), (Throwable)ioe);
        }
        return;
        catch (Exception e) {
            try {
                Throwable t = ExceptionUtils.unwrapInvocationTargetException(e);
                ExceptionUtils.handleThrowable(t);
                log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveFailed", this.contextName), t);
                if (is == null) return;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveStreamError", this.contextName), (Throwable)ioe);
                }
                throw throwable;
            }
            try {
                is.close();
                return;
            }
            catch (IOException ioe) {
                log.warn((Object)sm.getString("webappClassLoader.jdbcRemoveStreamError", this.contextName), (Throwable)ioe);
            }
            return;
        }
    }

    private final void clearReferencesStaticFinal() {
        int i;
        Field[] fields;
        Class<?> clazz;
        Collection values = ((HashMap)this.resourceEntries.clone()).values();
        block6: for (ResourceEntry entry : values) {
            if (entry.loadedClass == null) continue;
            clazz = entry.loadedClass;
            try {
                fields = clazz.getDeclaredFields();
                for (i = 0; i < fields.length; ++i) {
                    if (!Modifier.isStatic(fields[i].getModifiers())) continue;
                    fields[i].get(null);
                    continue block6;
                }
            }
            catch (Throwable t) {
            }
        }
        for (ResourceEntry entry : values) {
            if (entry.loadedClass == null) continue;
            clazz = entry.loadedClass;
            try {
                fields = clazz.getDeclaredFields();
                for (i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    int mods = field.getModifiers();
                    if (field.getType().isPrimitive() || field.getName().indexOf("$") != -1 || !Modifier.isStatic(mods)) continue;
                    try {
                        field.setAccessible(true);
                        if (Modifier.isFinal(mods)) {
                            if (field.getType().getName().startsWith("java.") || field.getType().getName().startsWith("javax.")) continue;
                            this.nullInstance(field.get(null));
                            continue;
                        }
                        field.set(null, null);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Set field " + field.getName() + " to null in class " + clazz.getName()));
                        continue;
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Could not set field " + field.getName() + " to null in class " + clazz.getName()), t);
                    }
                }
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not clean fields for class " + clazz.getName()), t);
            }
        }
    }

    private void nullInstance(Object instance) {
        if (instance == null) {
            return;
        }
        Field[] fields = instance.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int mods = field.getModifiers();
            if (field.getType().isPrimitive() || field.getName().indexOf("$") != -1) continue;
            try {
                Object value;
                field.setAccessible(true);
                if (Modifier.isStatic(mods) && Modifier.isFinal(mods) || null == (value = field.get(instance))) continue;
                Class<?> valueClass = value.getClass();
                if (!this.loadedByThisOrChild(valueClass)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Not setting field " + field.getName() + " to null in object of class " + instance.getClass().getName() + " because the referenced object was of type " + valueClass.getName() + " which was not loaded by this WebappClassLoader."));
                    continue;
                }
                field.set(instance, null);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Set field " + field.getName() + " to null in class " + instance.getClass().getName()));
                continue;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not set field " + field.getName() + " to null in object instance of class " + instance.getClass().getName()), t);
            }
        }
    }

    private void clearReferencesThreads() {
        Thread[] threads = this.getThreads();
        ArrayList<Thread> executorThreadsToStop = new ArrayList<Thread>();
        for (Thread thread : threads) {
            ClassLoader ccl;
            if (thread == null || (ccl = thread.getContextClassLoader()) != this || thread == Thread.currentThread()) continue;
            ThreadGroup tg = thread.getThreadGroup();
            if (tg != null && JVM_THREAD_GROUP_NAMES.contains(tg.getName())) {
                if (!this.clearReferencesHttpClientKeepAliveThread || !thread.getName().equals("Keep-Alive-Timer")) continue;
                thread.setContextClassLoader(this.parent);
                log.debug((Object)sm.getString("webappClassLoader.checkThreadsHttpClient"));
                continue;
            }
            if (!thread.isAlive()) continue;
            if (thread.getClass().getName().startsWith("java.util.Timer") && this.clearReferencesStopTimerThreads) {
                this.clearReferencesStopTimerThread(thread);
                continue;
            }
            if (this.isRequestThread(thread)) {
                log.error((Object)sm.getString("webappClassLoader.warnRequestThread", this.contextName, thread.getName()));
            } else {
                log.error((Object)sm.getString("webappClassLoader.warnThread", this.contextName, thread.getName()));
            }
            if (!this.clearReferencesStopThreads) continue;
            boolean usingExecutor = false;
            try {
                Object target = null;
                for (String fieldName : new String[]{"target", "runnable", "action"}) {
                    try {
                        Field targetField = thread.getClass().getDeclaredField(fieldName);
                        targetField.setAccessible(true);
                        target = targetField.get(thread);
                        break;
                    }
                    catch (NoSuchFieldException nfe) {
                    }
                }
                if (target != null && target.getClass().getCanonicalName() != null && target.getClass().getCanonicalName().equals("java.util.concurrent.ThreadPoolExecutor.Worker")) {
                    Field executorField = target.getClass().getDeclaredField("this$0");
                    executorField.setAccessible(true);
                    Object executor = executorField.get(target);
                    if (executor instanceof ThreadPoolExecutor) {
                        ((ThreadPoolExecutor)executor).shutdownNow();
                        usingExecutor = true;
                    }
                }
            }
            catch (SecurityException e) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", thread.getName(), this.contextName), (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", thread.getName(), this.contextName), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", thread.getName(), this.contextName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)sm.getString("webappClassLoader.stopThreadFail", thread.getName(), this.contextName), (Throwable)e);
            }
            if (usingExecutor) {
                executorThreadsToStop.add(thread);
                continue;
            }
            thread.stop();
        }
        int count = 0;
        for (Thread t : executorThreadsToStop) {
            while (t.isAlive() && count < 100) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    break;
                }
                ++count;
            }
            if (!t.isAlive()) continue;
            t.stop();
        }
    }

    private boolean isRequestThread(Thread thread) {
        StackTraceElement[] elements = thread.getStackTrace();
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[elements.length - (i + 1)];
            if (!"org.apache.catalina.connector.CoyoteAdapter".equals(element.getClassName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesStopTimerThread(Thread thread) {
        try {
            try {
                Field newTasksMayBeScheduledField = thread.getClass().getDeclaredField("newTasksMayBeScheduled");
                newTasksMayBeScheduledField.setAccessible(true);
                Field queueField = thread.getClass().getDeclaredField("queue");
                queueField.setAccessible(true);
                Object queue = queueField.get(thread);
                Method clearMethod = queue.getClass().getDeclaredMethod("clear", new Class[0]);
                clearMethod.setAccessible(true);
                Object object = queue;
                synchronized (object) {
                    newTasksMayBeScheduledField.setBoolean(thread, false);
                    clearMethod.invoke(queue, new Object[0]);
                    queue.notify();
                }
            }
            catch (NoSuchFieldException nfe) {
                Method cancelMethod = thread.getClass().getDeclaredMethod("cancel", new Class[0]);
                Thread thread2 = thread;
                synchronized (thread2) {
                    cancelMethod.setAccessible(true);
                    cancelMethod.invoke((Object)thread, new Object[0]);
                }
            }
            log.error((Object)sm.getString("webappClassLoader.warnTimerThread", this.contextName, thread.getName()));
        }
        catch (Exception e) {
            Throwable t = ExceptionUtils.unwrapInvocationTargetException(e);
            ExceptionUtils.handleThrowable(t);
            log.warn((Object)sm.getString("webappClassLoader.stopTimerThreadFail", thread.getName(), this.contextName), t);
        }
    }

    private void checkThreadLocalsForLeaks() {
        Thread[] threads = this.getThreads();
        try {
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Field inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
            inheritableThreadLocalsField.setAccessible(true);
            Class<?> tlmClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = tlmClass.getDeclaredField("table");
            tableField.setAccessible(true);
            Method expungeStaleEntriesMethod = tlmClass.getDeclaredMethod("expungeStaleEntries", new Class[0]);
            expungeStaleEntriesMethod.setAccessible(true);
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                Object threadLocalMap = threadLocalsField.get(threads[i]);
                if (null != threadLocalMap) {
                    expungeStaleEntriesMethod.invoke(threadLocalMap, new Object[0]);
                    this.checkThreadLocalMapForLeaks(threadLocalMap, tableField);
                }
                if (null == (threadLocalMap = inheritableThreadLocalsField.get(threads[i]))) continue;
                expungeStaleEntriesMethod.invoke(threadLocalMap, new Object[0]);
                this.checkThreadLocalMapForLeaks(threadLocalMap, tableField);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.warn((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaksFail", this.getContextName()), t);
        }
    }

    private void checkThreadLocalMapForLeaks(Object map, Field internalTableField) throws IllegalAccessException, NoSuchFieldException {
        Object[] table;
        if (map != null && (table = (Object[])internalTableField.get(map)) != null) {
            for (int j = 0; j < table.length; ++j) {
                Object obj = table[j];
                if (obj == null) continue;
                boolean potentialLeak = false;
                Object key = ((Reference)obj).get();
                if (this.equals(key) || this.loadedByThisOrChild(key)) {
                    potentialLeak = true;
                }
                Field valueField = obj.getClass().getDeclaredField("value");
                valueField.setAccessible(true);
                Object value = valueField.get(obj);
                if (this.equals(value) || this.loadedByThisOrChild(value)) {
                    potentialLeak = true;
                }
                if (!potentialLeak) continue;
                Object[] args = new Object[5];
                args[0] = this.contextName;
                if (key != null) {
                    args[1] = this.getPrettyClassName(key.getClass());
                    try {
                        args[2] = key.toString();
                    }
                    catch (Exception e) {
                        log.error((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badKey", args[1]), (Throwable)e);
                        args[2] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                    }
                }
                if (value != null) {
                    args[3] = this.getPrettyClassName(value.getClass());
                    try {
                        args[4] = value.toString();
                    }
                    catch (Exception e) {
                        log.error((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badValue", args[3]), (Throwable)e);
                        args[4] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                    }
                }
                if (value == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaksDebug", args));
                    continue;
                }
                log.error((Object)sm.getString("webappClassLoader.checkThreadLocalsForLeaks", args));
            }
        }
    }

    private String getPrettyClassName(Class<?> clazz) {
        String name = clazz.getCanonicalName();
        if (name == null) {
            name = clazz.getName();
        }
        return name;
    }

    private boolean loadedByThisOrChild(Object o) {
        if (o == null) {
            return false;
        }
        Class<?> clazz = o instanceof Class ? (Class<?>)o : o.getClass();
        for (ClassLoader cl = clazz.getClassLoader(); cl != null; cl = cl.getParent()) {
            if (cl != this) continue;
            return true;
        }
        if (o instanceof Collection) {
            Iterator iter = ((Collection)o).iterator();
            try {
                while (iter.hasNext()) {
                    Object entry = iter.next();
                    if (!this.loadedByThisOrChild(entry)) continue;
                    return true;
                }
            }
            catch (ConcurrentModificationException e) {
                log.warn((Object)sm.getString("webappClassLoader", clazz.getName(), this.getContextName()), (Throwable)e);
            }
        }
        return false;
    }

    private Thread[] getThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        try {
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
        }
        catch (SecurityException se) {
            String msg = sm.getString("webappClassLoader.getThreadGroupError", tg.getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)msg, (Throwable)se);
            }
            log.warn((Object)msg);
        }
        int threadCountGuess = tg.activeCount() + 50;
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = tg.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = tg.enumerate(threads);
        }
        return threads;
    }

    private void clearReferencesRmiTargets() {
        try {
            Class<?> objectTargetClass = Class.forName("sun.rmi.transport.Target");
            Field cclField = objectTargetClass.getDeclaredField("ccl");
            cclField.setAccessible(true);
            Class<?> objectTableClass = Class.forName("sun.rmi.transport.ObjectTable");
            Field objTableField = objectTableClass.getDeclaredField("objTable");
            objTableField.setAccessible(true);
            Object objTable = objTableField.get(null);
            if (objTable == null) {
                return;
            }
            if (objTable instanceof Map) {
                Iterator iter = ((Map)objTable).values().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    Object cclObject = cclField.get(obj);
                    if (this != cclObject) continue;
                    iter.remove();
                }
            }
            Field implTableField = objectTableClass.getDeclaredField("implTable");
            implTableField.setAccessible(true);
            Object implTable = implTableField.get(null);
            if (implTable == null) {
                return;
            }
            if (implTable instanceof Map) {
                Iterator iter = ((Map)implTable).values().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    Object cclObject = cclField.get(obj);
                    if (this != cclObject) continue;
                    iter.remove();
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.info((Object)sm.getString("webappClassLoader.clearRmiInfo", this.contextName), (Throwable)e);
        }
        catch (SecurityException e) {
            log.warn((Object)sm.getString("webappClassLoader.clearRmiFail", this.contextName), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            log.warn((Object)sm.getString("webappClassLoader.clearRmiFail", this.contextName), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)sm.getString("webappClassLoader.clearRmiFail", this.contextName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)sm.getString("webappClassLoader.clearRmiFail", this.contextName), (Throwable)e);
        }
    }

    private void clearReferencesResourceBundles() {
        try {
            Field cacheListField = ResourceBundle.class.getDeclaredField("cacheList");
            cacheListField.setAccessible(true);
            Map cacheList = (Map)cacheListField.get(null);
            Set keys = cacheList.keySet();
            Field loaderRefField = null;
            Iterator keysIter = keys.iterator();
            int countRemoved = 0;
            while (keysIter.hasNext()) {
                ClassLoader loader;
                Object key = keysIter.next();
                if (loaderRefField == null) {
                    loaderRefField = key.getClass().getDeclaredField("loaderRef");
                    loaderRefField.setAccessible(true);
                }
                WeakReference loaderRef = (WeakReference)loaderRefField.get(key);
                for (loader = (ClassLoader)loaderRef.get(); loader != null && loader != this; loader = loader.getParent()) {
                }
                if (loader == null) continue;
                keysIter.remove();
                ++countRemoved;
            }
            if (countRemoved > 0 && log.isDebugEnabled()) {
                log.debug((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesCount", countRemoved, this.contextName));
            }
        }
        catch (SecurityException e) {
            log.error((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", this.contextName), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            if (Globals.IS_ORACLE_JVM) {
                log.error((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", this.getContextName()), (Throwable)e);
            } else {
                log.debug((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", this.getContextName()), (Throwable)e);
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", this.contextName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)sm.getString("webappClassLoader.clearReferencesResourceBundlesFail", this.contextName), (Throwable)e);
        }
    }

    protected boolean openJARs() {
        if (this.started && this.jarFiles.length > 0) {
            this.lastJarAccessed = System.currentTimeMillis();
            if (this.jarFiles[0] == null) {
                for (int i = 0; i < this.jarFiles.length; ++i) {
                    try {
                        this.jarFiles[i] = new JarFile(this.jarRealFiles[i]);
                        continue;
                    }
                    catch (IOException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Failed to open JAR", (Throwable)e);
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> findClassInternal(String name) throws ClassNotFoundException {
        if (!this.validate(name)) {
            throw new ClassNotFoundException(name);
        }
        String tempPath = name.replace('.', '/');
        String classPath = tempPath + CLASS_FILE_SUFFIX;
        ResourceEntry entry = null;
        if (this.securityManager != null) {
            PrivilegedFindResourceByName dp = new PrivilegedFindResourceByName(name, classPath, true);
            entry = AccessController.doPrivileged(dp);
        } else {
            entry = this.findResourceInternal(name, classPath, true);
        }
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        Class<?> clazz = entry.loadedClass;
        if (clazz != null) {
            return clazz;
        }
        WebappClassLoader webappClassLoader = this;
        synchronized (webappClassLoader) {
            clazz = entry.loadedClass;
            if (clazz != null) {
                return clazz;
            }
            if (entry.binaryContent == null) {
                throw new ClassNotFoundException(name);
            }
            String packageName = null;
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                packageName = name.substring(0, pos);
            }
            Package pkg = null;
            if (packageName != null && (pkg = this.getPackage(packageName)) == null) {
                try {
                    if (entry.manifest == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(packageName, entry.manifest, entry.codeBase);
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                pkg = this.getPackage(packageName);
            }
            if (this.securityManager != null && pkg != null) {
                boolean sealCheck = true;
                if (pkg.isSealed()) {
                    sealCheck = pkg.isSealed(entry.codeBase);
                } else {
                    boolean bl = sealCheck = entry.manifest == null || !this.isPackageSealed(packageName, entry.manifest);
                }
                if (!sealCheck) {
                    throw new SecurityException("Sealing violation loading " + name + " : Package " + packageName + " is sealed.");
                }
            }
            try {
                clazz = this.defineClass(name, entry.binaryContent, 0, entry.binaryContent.length, new CodeSource(entry.codeBase, entry.certificates));
            }
            catch (UnsupportedClassVersionError ucve) {
                throw new UnsupportedClassVersionError(ucve.getLocalizedMessage() + " " + sm.getString("webappClassLoader.wrongVersion", name));
            }
            entry.loadedClass = clazz;
            entry.binaryContent = null;
            entry.source = null;
            entry.codeBase = null;
            entry.manifest = null;
            entry.certificates = null;
        }
        return clazz;
    }

    protected ResourceEntry findResourceInternal(File file, String path) {
        ResourceEntry entry = new ResourceEntry();
        try {
            entry.source = this.getURI(new File(file, path));
            String sourceString = entry.source.toString();
            entry.codeBase = sourceString.startsWith(this.webInfClassesCodeBase.toString()) && sourceString.endsWith(CLASS_FILE_SUFFIX) ? this.webInfClassesCodeBase : entry.source;
        }
        catch (MalformedURLException e) {
            return null;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResourceEntry findResourceInternal(String name, String path, boolean manifestRequired) {
        Object lookupResult;
        int i;
        if (!this.started) {
            log.info((Object)sm.getString("webappClassLoader.stopped", name));
            return null;
        }
        if (name == null) return null;
        if (path == null) {
            return null;
        }
        JarEntry jarEntry = null;
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null) {
            if (!manifestRequired) return entry;
            if (entry.manifest != MANIFEST_UNKNOWN) return entry;
            JarFile[] jarFileArray = this.jarFiles;
            synchronized (this.jarFiles) {
                if (!this.openJARs()) return entry;
                int i2 = 0;
                while (i2 < this.jarFiles.length) {
                    jarEntry = this.jarFiles[i2].getJarEntry(path);
                    if (jarEntry != null) {
                        try {
                            entry.manifest = this.jarFiles[i2].getManifest();
                        }
                        catch (IOException ioe) {}
                        return entry;
                    }
                    ++i2;
                }
                return entry;
            }
        }
        int contentLength = -1;
        InputStream binaryStream = null;
        boolean isClassResource = path.endsWith(CLASS_FILE_SUFFIX);
        boolean isCacheable = isClassResource;
        if (!isCacheable) {
            isCacheable = path.startsWith(SERVICES_PREFIX);
        }
        int jarFilesLength = this.jarFiles.length;
        int repositoriesLength = this.repositories.length;
        Resource resource = null;
        boolean fileNeedConvert = false;
        for (i = 0; entry == null && i < repositoriesLength; ++i) {
            try {
                String fullPath = this.repositories[i] + path;
                lookupResult = this.resources.lookup(fullPath);
                if (lookupResult instanceof Resource) {
                    resource = (Resource)lookupResult;
                }
                ResourceAttributes attributes = (ResourceAttributes)this.resources.getAttributes(fullPath);
                contentLength = (int)attributes.getContentLength();
                String canonicalPath = attributes.getCanonicalPath();
                entry = canonicalPath != null ? this.findResourceInternal(new File(canonicalPath), "") : this.findResourceInternal(this.files[i], path);
                entry.lastModified = attributes.getLastModified();
                if (resource == null) continue;
                try {
                    binaryStream = resource.streamContent();
                }
                catch (IOException e) {
                    return null;
                }
                if (this.needConvert && path.endsWith(".properties")) {
                    fileNeedConvert = true;
                }
                Permission e = this.allPermission;
                synchronized (e) {
                    int j;
                    long[] result2 = new long[this.lastModifiedDates.length + 1];
                    for (j = 0; j < this.lastModifiedDates.length; ++j) {
                        result2[j] = this.lastModifiedDates[j];
                    }
                    result2[this.lastModifiedDates.length] = entry.lastModified;
                    this.lastModifiedDates = result2;
                    String[] result = new String[this.paths.length + 1];
                    for (j = 0; j < this.paths.length; ++j) {
                        result[j] = this.paths[j];
                    }
                    result[this.paths.length] = fullPath;
                    this.paths = result;
                    continue;
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        if (entry == null && this.notFoundResources.containsKey(name)) {
            return null;
        }
        JarFile[] e = this.jarFiles;
        synchronized (this.jarFiles) {
            block97: {
                try {
                    int pos;
                    byte[] binaryContent;
                    if (!this.openJARs()) {
                        lookupResult = null;
                        // ** MonitorExit[e] (shouldn't be in output)
                        return lookupResult;
                    }
                    i = 0;
                    while (true) {
                        block99: {
                            JarEntry jarEntry2;
                            Enumeration<JarEntry> entries;
                            File resourceFile;
                            Object buf;
                            block100: {
                                block98: {
                                    ResourceEntry e2;
                                    if (entry != null || i >= jarFilesLength) break block98;
                                    jarEntry = this.jarFiles[i].getJarEntry(path);
                                    if (jarEntry == null) break block99;
                                    entry = new ResourceEntry();
                                    try {
                                        entry.codeBase = this.getURI(this.jarRealFiles[i]);
                                        String jarFakeUrl = entry.codeBase.toString();
                                        jarFakeUrl = "jar:" + jarFakeUrl + "!/" + path;
                                        entry.source = new URL(jarFakeUrl);
                                        entry.lastModified = this.jarRealFiles[i].lastModified();
                                    }
                                    catch (MalformedURLException e3) {
                                        e2 = null;
                                        if (binaryStream == null) return e2;
                                        try {
                                            binaryStream.close();
                                        }
                                        catch (IOException e4) {
                                            // empty catch block
                                        }
                                        return e2;
                                    }
                                    contentLength = (int)jarEntry.getSize();
                                    try {
                                        entry.manifest = manifestRequired ? this.jarFiles[i].getManifest() : MANIFEST_UNKNOWN;
                                        binaryStream = this.jarFiles[i].getInputStream(jarEntry);
                                    }
                                    catch (IOException e5) {
                                        e2 = null;
                                        if (binaryStream == null) return e2;
                                        try {
                                            binaryStream.close();
                                        }
                                        catch (IOException e6) {
                                            // empty catch block
                                        }
                                        return e2;
                                    }
                                    if (!this.antiJARLocking || path.endsWith(CLASS_FILE_SUFFIX)) break block99;
                                    buf = new byte[1024];
                                    resourceFile = new File(this.loaderDir, jarEntry.getName());
                                    if (resourceFile.exists()) break block99;
                                    entries = this.jarFiles[i].entries();
                                    break block100;
                                }
                                if (entry == null) {
                                    buf = this.notFoundResources;
                                    synchronized (buf) {
                                        this.notFoundResources.put(name, name);
                                    }
                                    buf = null;
                                    // ** MonitorExit[e] (shouldn't be in output)
                                    return buf;
                                }
                                if (binaryStream == null || !isCacheable && !fileNeedConvert) break block97;
                                binaryContent = new byte[contentLength];
                                pos = 0;
                                try {
                                    int n;
                                    while ((n = binaryStream.read(binaryContent, pos, binaryContent.length - pos)) > 0) {
                                        pos += n;
                                    }
                                    break;
                                }
                                catch (IOException e7) {
                                    log.error((Object)sm.getString("webappClassLoader.readError", name), (Throwable)e7);
                                    jarEntry2 = null;
                                    if (binaryStream == null) return jarEntry2;
                                    try {
                                        binaryStream.close();
                                    }
                                    catch (IOException e8) {
                                        // empty catch block
                                    }
                                    return jarEntry2;
                                }
                            }
                            block76: while (entries.hasMoreElements()) {
                                jarEntry2 = entries.nextElement();
                                if (jarEntry2.isDirectory() || jarEntry2.getName().endsWith(CLASS_FILE_SUFFIX)) continue;
                                resourceFile = new File(this.loaderDir, jarEntry2.getName());
                                try {
                                    if (!resourceFile.getCanonicalPath().startsWith(this.canonicalLoaderDir)) {
                                        throw new IllegalArgumentException(sm.getString("webappClassLoader.illegalJarPath", jarEntry2.getName()));
                                    }
                                }
                                catch (IOException ioe) {
                                    throw new IllegalArgumentException(sm.getString("webappClassLoader.validationErrorJarPath", jarEntry2.getName()), ioe);
                                }
                                File parentFile = resourceFile.getParentFile();
                                if (parentFile.mkdirs() || !parentFile.exists()) {
                                    // empty if block
                                }
                                FileOutputStream os = null;
                                InputStream is = null;
                                try {
                                    is = this.jarFiles[i].getInputStream(jarEntry2);
                                    os = new FileOutputStream(resourceFile);
                                    while (true) {
                                        int n;
                                        if ((n = is.read((byte[])buf)) <= 0) {
                                            resourceFile.setLastModified(jarEntry2.getTime());
                                            continue block76;
                                        }
                                        os.write((byte[])buf, 0, n);
                                    }
                                }
                                catch (IOException e9) {}
                                continue;
                                finally {
                                    try {
                                        if (is != null) {
                                            is.close();
                                        }
                                    }
                                    catch (IOException e10) {}
                                    try {
                                        if (os == null) continue;
                                        os.close();
                                    }
                                    catch (IOException e11) {}
                                }
                            }
                        }
                        ++i;
                    }
                    if (fileNeedConvert) {
                        String str = new String(binaryContent, 0, pos);
                        try {
                            binaryContent = str.getBytes(CHARSET_UTF8);
                        }
                        catch (Exception e12) {
                            ResourceEntry resourceEntry = null;
                            if (binaryStream == null) return resourceEntry;
                            try {
                                binaryStream.close();
                            }
                            catch (IOException e13) {
                                // empty catch block
                            }
                            return resourceEntry;
                        }
                    }
                    entry.binaryContent = binaryContent;
                    if (jarEntry != null) {
                        entry.certificates = jarEntry.getCertificates();
                    }
                }
                finally {
                    if (binaryStream != null) {
                        try {
                            binaryStream.close();
                        }
                        catch (IOException e2) {}
                    }
                }
            }
            // ** MonitorExit[e] (shouldn't be in output)
            if (isClassResource && entry.binaryContent != null && this.transformers.size() > 0) {
                String className = name.endsWith(CLASS_FILE_SUFFIX) ? name.substring(0, name.length() - CLASS_FILE_SUFFIX.length()) : name;
                String internalName = className.replace(".", "/");
                for (ClassFileTransformer transformer : this.transformers) {
                    try {
                        byte[] transformed = transformer.transform(this, internalName, null, null, entry.binaryContent);
                        if (transformed == null) continue;
                        entry.binaryContent = transformed;
                    }
                    catch (IllegalClassFormatException e14) {
                        log.error((Object)sm.getString("webappClassLoader.transformError", name), (Throwable)e14);
                        return null;
                    }
                }
            }
            HashMap<String, ResourceEntry> hashMap = this.resourceEntries;
            synchronized (hashMap) {
                ResourceEntry entry2 = this.resourceEntries.get(name);
                if (entry2 != null) return entry2;
                this.resourceEntries.put(name, entry);
                return entry;
            }
        }
    }

    protected boolean isPackageSealed(String name, Manifest man) {
        String path = name.replace('.', '/') + '/';
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected InputStream findLoadedResource(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null) {
            if (entry.binaryContent != null) {
                return new ByteArrayInputStream(entry.binaryContent);
            }
            try {
                return entry.source.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Class<?> findLoadedClass0(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null) {
            return entry.loadedClass;
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected boolean filter(String name) {
        if (name == null) {
            return false;
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        packageName = name.substring(0, pos);
        for (int i = 0; i < packageTriggers.length; ++i) {
            if (!packageName.startsWith(packageTriggers[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean validate(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith("java.")) {
            return false;
        }
        if (name.startsWith("javax.servlet.jsp.jstl")) {
            return true;
        }
        if (name.startsWith("javax.servlet.")) {
            return false;
        }
        return !name.startsWith("javax.el");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateJarFile(File file) throws IOException {
        if (triggers == null) {
            return true;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            for (int i = 0; i < triggers.length; ++i) {
                JarEntry jarEntry;
                Class<?> clazz = null;
                try {
                    clazz = this.parent != null ? this.parent.loadClass(triggers[i]) : Class.forName(triggers[i]);
                }
                catch (Exception e) {
                    clazz = null;
                }
                if (clazz == null) continue;
                String name = triggers[i].replace('.', '/') + CLASS_FILE_SUFFIX;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Checking for " + name));
                }
                if ((jarEntry = jarFile.getJarEntry(name)) == null) continue;
                log.info((Object)("validateJarFile(" + file + ") - jar not loaded. See Servlet Spec 3.0, " + "section 10.7.2. Offending class: " + name));
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    @Deprecated
    protected URL getURL(File file, boolean encoded) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (encoded) {
            return this.getURI(realFile);
        }
        return realFile.toURI().toURL();
    }

    protected URL getURI(File file) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return realFile.toURI().toURL();
    }

    protected static void deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                WebappClassLoader.deleteDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    static {
        JVM_THREAD_GROUP_NAMES.add(JVM_THREAD_GROUP_SYSTEM);
        JVM_THREAD_GROUP_NAMES.add("RMI Runtime");
        triggers = new String[]{"javax.servlet.Servlet", "javax.el.Expression"};
        packageTriggers = new String[0];
        sm = StringManager.getManager("org.apache.catalina.loader");
    }

    protected static final class PrivilegedGetClassLoader
    implements PrivilegedAction<ClassLoader> {
        public Class<?> clazz;

        public PrivilegedGetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            return this.clazz.getClassLoader();
        }
    }

    protected class PrivilegedFindResourceByName
    implements PrivilegedAction<ResourceEntry> {
        protected String name;
        protected String path;
        protected boolean manifestRequired;

        PrivilegedFindResourceByName(String name, String path, boolean manifestRequired) {
            this.name = name;
            this.path = path;
            this.manifestRequired = manifestRequired;
        }

        @Override
        public ResourceEntry run() {
            return WebappClassLoader.this.findResourceInternal(this.name, this.path, this.manifestRequired);
        }
    }
}

