/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.EOFException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

class PreviewWindow
extends Frame
implements CbButtonCallback {
    CbButton close_b;
    RemoteFile file;
    FileManager filemgr;
    ImagePanel ip;

    public PreviewWindow(FileManager fileManager, RemoteFile remoteFile) {
        this.file = remoteFile;
        this.filemgr = fileManager;
        this.makeUI();
        this.setTitle(this.filemgr.text("preview_title", this.file.path));
        try {
            byte[] byArray;
            URL uRL = new URL(this.filemgr.getDocumentBase(), "preview.cgi" + FileManager.urlize(this.file.path) + "?rand=" + System.currentTimeMillis() + "&trust=" + this.filemgr.trust + this.filemgr.extra);
            URLConnection uRLConnection = uRL.openConnection();
            this.filemgr.set_cookie(uRLConnection);
            int n = uRLConnection.getContentLength();
            InputStream inputStream = uRLConnection.getInputStream();
            if (n >= 0) {
                byArray = new byte[uRLConnection.getContentLength()];
                for (int i = 0; i < byArray.length; i += inputStream.read(byArray, i, byArray.length - i)) {
                }
            } else {
                byArray = new byte[]{};
                while (true) {
                    int n2;
                    byte[] byArray2 = new byte[16384];
                    try {
                        n2 = inputStream.read(byArray2);
                    }
                    catch (EOFException eOFException) {
                        break;
                    }
                    if (n2 <= 0) break;
                    byte[] byArray3 = new byte[byArray.length + n2];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                    System.arraycopy(byArray2, 0, byArray3, byArray.length, n2);
                    byArray = byArray3;
                }
            }
            if (uRLConnection.getContentType().equals("text/plain")) {
                String string = new String(byArray, 0);
                new ErrorWindow(string);
                this.dispose();
                return;
            }
            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 666);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (image.getWidth(this) <= 0) {
                new ErrorWindow(this.filemgr.text("preview_bad"));
                this.dispose();
                return;
            }
            this.ip.setImage(image);
            this.pack();
            this.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void makeUI() {
        this.setLayout(new BorderLayout());
        BorderPanel borderPanel = new BorderPanel(2, Util.body);
        borderPanel.setLayout(new BorderLayout());
        this.ip = new ImagePanel(null);
        borderPanel.add("Center", this.ip);
        this.add("Center", borderPanel);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.close_b = new CbButton(this.filemgr.get_image("cancel.gif"), this.filemgr.text("close"), 0, this);
        panel.add(this.close_b);
        this.add("South", panel);
        Util.recursiveBody(this);
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.close_b) {
            this.dispose();
        }
    }
}

