/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.exists.RestExistsAction;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestStatusToXContentListener;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.term.TermSuggestionBuilder;

public class RestSearchAction
extends BaseRestHandler {
    @Inject
    public RestSearchAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_search", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search", this);
        controller.registerHandler(RestRequest.Method.GET, "/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search/template", this);
        RestExistsAction restExistsAction = new RestExistsAction(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_search/exists", restExistsAction);
        controller.registerHandler(RestRequest.Method.POST, "/_search/exists", restExistsAction);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search/exists", restExistsAction);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search/exists", restExistsAction);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search/exists", restExistsAction);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search/exists", restExistsAction);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        SearchRequest searchRequest = new SearchRequest();
        RestSearchAction.parseSearchRequest(searchRequest, request, this.parseFieldMatcher, null);
        client.search(searchRequest, new RestStatusToXContentListener<SearchResponse>(channel));
    }

    public static void parseSearchRequest(SearchRequest searchRequest, RestRequest request, ParseFieldMatcher parseFieldMatcher, BytesReference bodyContent) {
        String searchType;
        searchRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
        boolean isTemplateRequest = request.path().endsWith("/template");
        if (bodyContent == null && RestActions.hasBodyContent(request)) {
            bodyContent = RestActions.getRestContent(request);
        }
        if (bodyContent != null) {
            if (isTemplateRequest) {
                searchRequest.templateSource(bodyContent);
            } else {
                searchRequest.source(bodyContent);
            }
        }
        if (SearchType.fromString(searchType = request.param("search_type"), parseFieldMatcher).equals((Object)SearchType.QUERY_AND_FETCH) || SearchType.fromString(searchType, parseFieldMatcher).equals((Object)SearchType.DFS_QUERY_AND_FETCH)) {
            throw new IllegalArgumentException("Unsupported search type [" + searchType + "]");
        }
        searchRequest.searchType(searchType);
        searchRequest.extraSource(RestSearchAction.parseSearchSource(request));
        searchRequest.requestCache(request.paramAsBoolean("request_cache", null));
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchRequest.scroll(new Scroll(TimeValue.parseTimeValue(scroll, null, "scroll")));
        }
        searchRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        searchRequest.routing(request.param("routing"));
        searchRequest.preference(request.param("preference"));
        searchRequest.indicesOptions(IndicesOptions.fromRequest(request, searchRequest.indicesOptions()));
    }

    public static SearchSourceBuilder parseSearchSource(RestRequest request) {
        String suggestField;
        String sStats;
        String sSorts;
        FetchSourceContext fetchSourceContext;
        String sFieldDataFields;
        String sField;
        int size;
        int from;
        SearchSourceBuilder searchSourceBuilder = null;
        QuerySourceBuilder querySourceBuilder = RestActions.parseQuerySource(request);
        if (querySourceBuilder != null) {
            searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query(querySourceBuilder);
        }
        if ((from = request.paramAsInt("from", -1)) != -1) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.from(from);
        }
        if ((size = request.paramAsInt("size", -1)) != -1) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.size(size);
        }
        if (request.hasParam("explain")) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.explain(request.paramAsBoolean("explain", null));
        }
        if (request.hasParam("version")) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.version(request.paramAsBoolean("version", null));
        }
        if (request.hasParam("timeout")) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.timeout(request.paramAsTime("timeout", null));
        }
        if (request.hasParam("terminate_after")) {
            int terminateAfter;
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            if ((terminateAfter = request.paramAsInt("terminate_after", 0)) < 0) {
                throw new IllegalArgumentException("terminateAfter must be > 0");
            }
            if (terminateAfter > 0) {
                searchSourceBuilder.terminateAfter(terminateAfter);
            }
        }
        if ((sField = request.param("fields")) != null) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            if (!Strings.hasText(sField)) {
                searchSourceBuilder.noFields();
            } else {
                String[] sFields = Strings.splitStringByCommaToArray(sField);
                if (sFields != null) {
                    for (String field : sFields) {
                        searchSourceBuilder.field(field);
                    }
                }
            }
        }
        if ((sFieldDataFields = request.param("fielddata_fields")) != null) {
            String[] sFields;
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            if (Strings.hasText(sFieldDataFields) && (sFields = Strings.splitStringByCommaToArray(sFieldDataFields)) != null) {
                for (String field : sFields) {
                    searchSourceBuilder.fieldDataField(field);
                }
            }
        }
        if ((fetchSourceContext = FetchSourceContext.parseFromRestRequest(request)) != null) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.fetchSource(fetchSourceContext);
        }
        if (request.hasParam("track_scores")) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.trackScores(request.paramAsBoolean("track_scores", false));
        }
        if ((sSorts = request.param("sort")) != null) {
            String[] sorts;
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            for (String sort : sorts = Strings.splitStringByCommaToArray(sSorts)) {
                int delimiter = sort.lastIndexOf(":");
                if (delimiter != -1) {
                    String sortField = sort.substring(0, delimiter);
                    String reverse = sort.substring(delimiter + 1);
                    if ("asc".equals(reverse)) {
                        searchSourceBuilder.sort(sortField, SortOrder.ASC);
                        continue;
                    }
                    if (!"desc".equals(reverse)) continue;
                    searchSourceBuilder.sort(sortField, SortOrder.DESC);
                    continue;
                }
                searchSourceBuilder.sort(sort);
            }
        }
        if ((sStats = request.param("stats")) != null) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.stats(Strings.splitStringByCommaToArray(sStats));
        }
        if ((suggestField = request.param("suggest_field")) != null) {
            String suggestText = request.param("suggest_text", request.param("q"));
            int suggestSize = request.paramAsInt("suggest_size", 5);
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            String suggestMode = request.param("suggest_mode");
            searchSourceBuilder.suggest().addSuggestion(((TermSuggestionBuilder)((TermSuggestionBuilder)((TermSuggestionBuilder)SuggestBuilders.termSuggestion(suggestField).field(suggestField)).text(suggestText)).size(suggestSize)).suggestMode(suggestMode));
        }
        return searchSourceBuilder;
    }
}

