/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArtifactHandler
implements ArtifactHandler {
    private final ConfigurationContainer configurationContainer;
    private final NotationParser<Object, PublishArtifact> publishArtifactFactory;

    public DefaultArtifactHandler(ConfigurationContainer configurationContainer, NotationParser<Object, PublishArtifact> publishArtifactFactory) {
        this.configurationContainer = configurationContainer;
        this.publishArtifactFactory = publishArtifactFactory;
    }

    private PublishArtifact pushArtifact(Configuration configuration, Object notation, Closure configureClosure) {
        PublishArtifact publishArtifact = (PublishArtifact)this.publishArtifactFactory.parseNotation(notation);
        configuration.getArtifacts().add((Object)publishArtifact);
        ConfigureUtil.configure((Closure)configureClosure, (Object)publishArtifact);
        return publishArtifact;
    }

    public PublishArtifact add(String configurationName, Object artifactNotation) {
        return this.pushArtifact(this.configurationContainer.getByName(configurationName), artifactNotation, null);
    }

    public PublishArtifact add(String configurationName, Object artifactNotation, Closure configureClosure) {
        return this.pushArtifact(this.configurationContainer.getByName(configurationName), artifactNotation, configureClosure);
    }

    public Object methodMissing(String name, Object arg) {
        Object[] args = (Object[])arg;
        Configuration configuration = (Configuration)this.configurationContainer.findByName(name);
        if (configuration == null) {
            throw new MissingMethodException(name, this.getClass(), args);
        }
        List normalizedArgs = GUtil.flatten(Arrays.asList(args), (boolean)false);
        if (normalizedArgs.size() == 2 && normalizedArgs.get(1) instanceof Closure) {
            return this.pushArtifact(configuration, normalizedArgs.get(0), (Closure)normalizedArgs.get(1));
        }
        for (Object notation : args) {
            this.pushArtifact(configuration, notation, null);
        }
        return null;
    }
}

