/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.HashMap;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DirSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotImpl;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashValueSerializer;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultFileSnapshotterSerializer
implements Serializer<FileCollectionSnapshotImpl> {
    private final HashValueSerializer hashValueSerializer = new HashValueSerializer();
    private final StringInterner stringInterner;

    public DefaultFileSnapshotterSerializer(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
    }

    public FileCollectionSnapshotImpl read(Decoder decoder) throws Exception {
        HashMap<String, IncrementalFileSnapshot> snapshots = new HashMap<String, IncrementalFileSnapshot>();
        FileCollectionSnapshotImpl snapshot = new FileCollectionSnapshotImpl(snapshots);
        int snapshotsCount = decoder.readSmallInt();
        for (int i = 0; i < snapshotsCount; ++i) {
            String key = this.stringInterner.intern(decoder.readString());
            byte fileSnapshotKind = decoder.readByte();
            if (fileSnapshotKind == 1) {
                snapshots.put(key, DirSnapshot.getInstance());
                continue;
            }
            if (fileSnapshotKind == 2) {
                snapshots.put(key, MissingFileSnapshot.getInstance());
                continue;
            }
            if (fileSnapshotKind == 3) {
                snapshots.put(key, new FileHashSnapshot(this.hashValueSerializer.read(decoder)));
                continue;
            }
            throw new RuntimeException("Unable to read serialized file collection snapshot. Unrecognized value found in the data stream.");
        }
        return snapshot;
    }

    public void write(Encoder encoder, FileCollectionSnapshotImpl value) throws Exception {
        encoder.writeSmallInt(value.snapshots.size());
        for (String key : value.snapshots.keySet()) {
            encoder.writeString((CharSequence)key);
            IncrementalFileSnapshot incrementalFileSnapshot = value.snapshots.get(key);
            if (incrementalFileSnapshot instanceof DirSnapshot) {
                encoder.writeByte((byte)1);
                continue;
            }
            if (incrementalFileSnapshot instanceof MissingFileSnapshot) {
                encoder.writeByte((byte)2);
                continue;
            }
            if (!(incrementalFileSnapshot instanceof FileHashSnapshot)) continue;
            encoder.writeByte((byte)3);
            this.hashValueSerializer.write(encoder, ((FileHashSnapshot)incrementalFileSnapshot).hash);
        }
    }
}

