/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.util.ObservableList;
import java.beans.PropertyChangeEvent;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecutionContext;

public class TaskMutator {
    private final TaskInternal task;
    private boolean executingleftShiftAction;

    public TaskMutator(TaskInternal task) {
        this.task = task;
    }

    public void mutate(String method, Runnable action) {
        if (!this.task.getState().isConfigurable()) {
            throw new IllegalStateException(this.format(method));
        }
        action.run();
    }

    public void assertMutable(String listname, PropertyChangeEvent evt) {
        String method = null;
        if (evt instanceof ObservableList.ElementEvent) {
            switch (((ObservableList.ElementEvent)evt).getChangeType()) {
                case ADDED: {
                    method = String.format("%s.%s", listname, "add()");
                    break;
                }
                case UPDATED: {
                    method = String.format("%s.%s", listname, "set(int, Object)");
                    break;
                }
                case REMOVED: {
                    method = String.format("%s.%s", listname, "remove()");
                    break;
                }
                case CLEARED: {
                    method = String.format("%s.%s", listname, "clear()");
                    break;
                }
                case MULTI_ADD: {
                    method = String.format("%s.%s", listname, "addAll()");
                    break;
                }
                case MULTI_REMOVE: {
                    method = String.format("%s.%s", listname, "removeAll()");
                }
            }
        }
        if (method == null) {
            return;
        }
        if (!this.task.getState().isConfigurable()) {
            throw new IllegalStateException(this.format(method));
        }
    }

    public ContextAwareTaskAction leftShift(final ContextAwareTaskAction action) {
        return new ContextAwareTaskAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Task task) {
                TaskMutator.this.executingleftShiftAction = true;
                try {
                    action.execute(task);
                }
                finally {
                    TaskMutator.this.executingleftShiftAction = false;
                }
            }

            public void contextualise(TaskExecutionContext context) {
                action.contextualise(context);
            }
        };
    }

    private String format(String method) {
        if (this.executingleftShiftAction) {
            return String.format("Cannot call %s on %s after task has started execution. Check the configuration of %s as you may have misused '<<' at task declaration.", method, this.task, this.task);
        }
        return String.format("Cannot call %s on %s after task has started execution.", method, this.task);
    }
}

