/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionFailureException;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.AbstractPost12ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ActionRunner;
import org.gradle.tooling.internal.consumer.connection.BuildInvocationsAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.InternalBuildActionAdapter;
import org.gradle.tooling.internal.consumer.connection.ModelBuilderBackedModelProducer;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.internal.protocol.InternalBuildActionExecutor;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.ModelBuilder;
import org.gradle.tooling.model.gradle.BuildInvocations;
import org.gradle.tooling.model.gradle.ProjectPublications;
import org.gradle.util.GradleVersion;

public class ActionAwareConsumerConnection
extends AbstractPost12ConsumerConnection {
    private final ActionRunner actionRunner;
    private final ModelProducer modelProducer;

    public ActionAwareConsumerConnection(ConnectionVersion4 delegate, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, ActionAwareConsumerConnection.getVersionDetails(delegate.getMetaData().getVersion()));
        ModelProducer modelProducer = new ModelBuilderBackedModelProducer(adapter, this.getVersionDetails(), modelMapping, (ModelBuilder)((Object)delegate));
        if (!this.getVersionDetails().maySupportModel(BuildInvocations.class)) {
            modelProducer = new BuildInvocationsAdapterProducer(adapter, this.getVersionDetails(), modelProducer);
        }
        this.modelProducer = modelProducer;
        this.actionRunner = new InternalBuildActionExecutorBackedActionRunner((InternalBuildActionExecutor)((Object)delegate), adapter);
    }

    protected ModelProducer getModelProducer() {
        return this.modelProducer;
    }

    protected ActionRunner getActionRunner() {
        return this.actionRunner;
    }

    protected static VersionDetails getVersionDetails(String versionString) {
        GradleVersion version = GradleVersion.version((String)versionString);
        if (version.compareTo(GradleVersion.version((String)"1.11")) > 0) {
            return new R112VersionDetails(version.getVersion());
        }
        return new R18VersionDetails(version.getVersion());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalBuildActionExecutorBackedActionRunner
    implements ActionRunner {
        private final InternalBuildActionExecutor executor;
        private final ProtocolToModelAdapter adapter;

        private InternalBuildActionExecutorBackedActionRunner(InternalBuildActionExecutor executor, ProtocolToModelAdapter adapter) {
            this.executor = executor;
            this.adapter = adapter;
        }

        @Override
        public <T> T run(BuildAction<T> action, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
            BuildResult<T> result;
            try {
                result = this.executor.run(new InternalBuildActionAdapter<T>(action, this.adapter), operationParameters);
            }
            catch (InternalBuildActionFailureException e) {
                throw new BuildActionFailureException("The supplied build action failed with an exception.", e.getCause());
            }
            return result.getModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class R112VersionDetails
    extends VersionDetails {
        private R112VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return true;
        }

        @Override
        public boolean supportsTaskDisplayName() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class R18VersionDetails
    extends VersionDetails {
        private R18VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return modelType != ProjectPublications.class && modelType != BuildInvocations.class;
        }
    }
}

