/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Scanner;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.ui.log.ErrorLoggedEvent;
import org.pdfsam.ui.log.LogLevel;
import org.pdfsam.ui.log.LogMessage;
import org.sejda.eventstudio.StaticStudio;
import org.slf4j.LoggerFactory;

@Named
public class LogMessageBroadcaster
extends AppenderBase<ILoggingEvent> {
    private PatternLayoutEncoder encoder;

    @Inject
    LogMessageBroadcaster(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        encoder.setContext(loggerContext);
        this.setContext(loggerContext);
        encoder.start();
        ((LoggerContext)this.getContext()).getLogger("ROOT").addAppender(this);
    }

    @Override
    public void append(ILoggingEvent event) {
        StringWriter writer = new StringWriter();
        try {
            this.encoder.init(new WriterOutputStream(writer));
            this.encoder.doEncode(event);
            this.doAppendMessage(writer.toString(), event);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void doAppendMessage(String message, ILoggingEvent event) {
        if (StringUtils.isNotBlank(message)) {
            try (Scanner scanner = new Scanner(message);){
                while (scanner.hasNextLine()) {
                    StaticStudio.eventStudio().broadcast(new LogMessage(scanner.nextLine(), LogLevel.toLogLevel(event.getLevel().toInt())), "LogStage");
                }
            }
            if (event.getLevel().isGreaterOrEqual(Level.ERROR)) {
                StaticStudio.eventStudio().broadcast(new ErrorLoggedEvent());
            }
        }
    }

    public PatternLayoutEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
    }
}

