/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.io;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.sejda.core.support.io.OutputWriterHelper;
import org.sejda.core.support.io.model.PopulatedFileOutput;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;

abstract class BaseOutputWriter
implements TaskOutputDispatcher {
    Map<String, File> multipleFiles;
    private ExistingOutputPolicy existingOutputPolicy = ExistingOutputPolicy.FAIL;

    public BaseOutputWriter(ExistingOutputPolicy existingOutputPolicy) {
        this.multipleFiles = new HashMap<String, File>();
        this.existingOutputPolicy = ObjectUtils.defaultIfNull(existingOutputPolicy, ExistingOutputPolicy.FAIL);
    }

    @Override
    public void dispatch(FileTaskOutput output) throws IOException {
        OutputWriterHelper.moveToFile(this.multipleFiles, output.getDestination(), this.existingOutputPolicy);
    }

    @Override
    public void dispatch(DirectoryTaskOutput output) throws IOException {
        OutputWriterHelper.moveToDirectory(this.multipleFiles, output.getDestination(), this.existingOutputPolicy);
    }

    void add(PopulatedFileOutput fileOutput) {
        fileOutput.getFile().deleteOnExit();
        this.multipleFiles.put(fileOutput.getName(), fileOutput.getFile());
    }

    void clear() {
        this.multipleFiles.clear();
    }
}

