/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.parosproxy.paros.model.FileCopier;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.utils.I18N;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public final class Constant {
    public static final String PROGRAM_NAME = "OWASP ZAP";
    public static final String PROGRAM_NAME_SHORT = "ZAP";
    public static final String ZAP_HOMEPAGE = "http://www.owasp.org/index.php/ZAP";
    public static final String ZAP_EXTENSIONS_PAGE = "https://github.com/zaproxy/zap-extensions";
    public static final String ZAP_TEAM = "ZAP Dev Team";
    public static final String PAROS_TEAM = "Chinotec Technologies";
    private static final String DEV_VERSION = "Dev Build";
    public static final String ALPHA_VERSION = "alpha";
    public static final String BETA_VERSION = "beta";
    private static final long VERSION_TAG = 2004002L;
    private static final long V_2_3_1_TAG = 2003001L;
    private static final long V_2_2_0_TAG = 2002000L;
    private static final long V_2_1_0_TAG = 2001000L;
    private static final long V_2_0_0_TAG = 2000000L;
    private static final long V_1_4_1_TAG = 1004001L;
    private static final long V_1_3_1_TAG = 1003001L;
    private static final long V_1_3_0_TAG = 1003000L;
    private static final long V_1_2_1_TAG = 1002001L;
    private static final long V_1_2_0_TAG = 1002000L;
    private static final long V_1_1_0_TAG = 1001000L;
    private static final long V_1_0_0_TAG = 1000000L;
    private static final long V_PAROS_TAG = 30020013L;
    public static String PROGRAM_VERSION = "Dev Build";
    public static String PROGRAM_TITLE = "OWASP ZAP " + PROGRAM_VERSION;
    public static final String SYSTEM_PAROS_USER_LOG = "zap.user.log";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    @Deprecated
    public static final String FILE_CONFIG_DEFAULT = "xml/config.xml";
    public static final String FILE_CONFIG_NAME = "config.xml";
    public static final String FOLDER_PLUGIN = "plugin";
    public static final String FOLDER_FILTER = "filter";
    public static final String FOLDER_SESSION_DEFAULT = "session";
    public static final String DBNAME_TEMPLATE = "db" + System.getProperty("file.separator") + "zapdb";
    public static final String MESSAGES_PREFIX = "Messages";
    public static final String MESSAGES_EXTENSION = ".properties";
    public static final String DBNAME_UNTITLED_DEFAULT = "session" + System.getProperty("file.separator") + "untitled";
    public String FILE_CONFIG = "config.xml";
    public String FOLDER_SESSION = "session";
    public String DBNAME_UNTITLED = this.FOLDER_SESSION + System.getProperty("file.separator") + "untitled";
    public String ACCEPTED_LICENSE_DEFAULT;
    public String ACCEPTED_LICENSE = this.ACCEPTED_LICENSE_DEFAULT = "AcceptedLicense";
    public static final String FILE_PROGRAM_SPLASH = "resource/zap128x128.png";
    public static String ACCELERATOR_UNDO = "control Z";
    public static String ACCELERATOR_REDO = "control Y";
    public static String ACCELERATOR_TRIGGER_KEY = "Control";
    private static Constant instance = null;
    public static final int MAX_HOST_CONNECTION = 15;
    public static final int MAX_THREADS_PER_SCAN = 50;
    public static final String USER_AGENT = "";
    private static String staticEyeCatcher = "0W45pz4p";
    private static boolean staticSP = false;
    private static final String USER_CONTEXTS_DIR = "contexts";
    private static final String USER_POLICIES_DIR = "policies";
    private static String zapHome = null;
    private static String zapStd = null;
    private static String zapInstall = null;
    private static Boolean onKali = null;
    private static Boolean lowMemoryOption = null;
    public static I18N messages = null;
    private static final Locale SYSTEMS_LOCALE = Locale.getDefault();
    public static final String LANG_DIR = "lang";
    public static final String VULNERABILITIES_PREFIX = "vulnerabilities";
    @Deprecated
    public static String VULNS_BASE = "vulnerabilities";
    public static final String VULNERABILITIES_EXTENSION = ".xml";
    public String DIRBUSTER_DIR;
    public String DIRBUSTER_CUSTOM_DIR = this.DIRBUSTER_DIR = "dirbuster";
    public String FUZZER_DIR = "fuzzers";
    public static String FOLDER_LOCAL_PLUGIN = "plugin";
    public static final URL OK_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/072.png");
    public static final URL INFO_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/073.png");
    public static final URL LOW_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/074.png");
    public static final URL MED_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/076.png");
    public static final URL HIGH_FLAG_IMAGE_URL = Constant.class.getResource("/resource/icon/10/071.png");
    public static final URL BLANK_IMAGE_URL = Constant.class.getResource("/resource/icon/10/blank.png");
    public static final URL SPIDER_IMAGE_URL = Constant.class.getResource("/resource/icon/10/spider.png");
    private static final Pattern patternWindows = Pattern.compile("window", 2);
    private static final Pattern patternLinux = Pattern.compile("linux", 2);
    private static final Pattern patternMacOsX = Pattern.compile("mac", 2);

    public static String getEyeCatcher() {
        return staticEyeCatcher;
    }

    public static void setEyeCatcher(String string) {
        staticEyeCatcher = string;
    }

    public static void setSP(boolean bl) {
        staticSP = bl;
    }

    public static boolean isSP() {
        return staticSP;
    }

    public Constant() {
        this.initializeFilesAndDirectories();
        this.setAcceleratorKeys();
    }

    public static String getDefaultHomeDirectory(boolean bl) {
        if (zapStd == null) {
            zapStd = System.getProperty("user.home");
            if (zapStd == null) {
                zapStd = ".";
            }
            zapStd = Constant.isLinux() ? zapStd + FILE_SEPARATOR + "." + PROGRAM_NAME_SHORT : (Constant.isMacOsX() ? zapStd + FILE_SEPARATOR + "Library" + FILE_SEPARATOR + "Application Support" + FILE_SEPARATOR + PROGRAM_NAME_SHORT : zapStd + FILE_SEPARATOR + PROGRAM_NAME);
        }
        if (bl && (Constant.isDevBuild() || Constant.isDailyBuild())) {
            return zapStd + "_D";
        }
        return zapStd;
    }

    private void initializeFilesAndDirectories() {
        Object object;
        block37: {
            FileCopier fileCopier = new FileCopier();
            File file = null;
            Logger logger = null;
            System.setProperty(SYSTEM_PAROS_USER_LOG, "log");
            PROGRAM_VERSION = Constant.getVersionFromManifest();
            PROGRAM_TITLE = "OWASP ZAP " + PROGRAM_VERSION;
            if (zapHome == null) {
                zapHome = Constant.getDefaultHomeDirectory(true);
            }
            zapHome = Constant.getAbsolutePath(zapHome);
            file = new File(zapHome);
            this.FILE_CONFIG = zapHome + this.FILE_CONFIG;
            this.FOLDER_SESSION = zapHome + this.FOLDER_SESSION;
            this.DBNAME_UNTITLED = zapHome + this.DBNAME_UNTITLED;
            this.ACCEPTED_LICENSE = zapHome + this.ACCEPTED_LICENSE;
            this.DIRBUSTER_CUSTOM_DIR = zapHome + this.DIRBUSTER_DIR;
            this.FUZZER_DIR = zapHome + this.FUZZER_DIR;
            FOLDER_LOCAL_PLUGIN = zapHome + FOLDER_LOCAL_PLUGIN;
            try {
                System.setProperty(SYSTEM_PAROS_USER_LOG, zapHome);
                if (!file.isDirectory() && !file.mkdir()) {
                    System.out.println("Failed to create directory " + file.getAbsolutePath());
                }
                if (!((File)(object = new File(zapHome + "/log4j.properties"))).exists()) {
                    fileCopier.copy(new File(zapInstall, "xml/log4j.properties"), (File)object);
                }
                System.setProperty("log4j.configuration", ((File)object).getAbsolutePath());
                PropertyConfigurator.configure((String)((File)object).getAbsolutePath());
                logger = Logger.getLogger(Constant.class);
                file = new File(this.FILE_CONFIG);
                if (!file.isFile()) {
                    File file2 = Constant.isDevBuild() || Constant.isDailyBuild() ? new File(Constant.getDefaultHomeDirectory(false) + FILE_SEPARATOR + FILE_CONFIG_NAME) : new File(zapHome + FILE_SEPARATOR + "zap" + FILE_SEPARATOR + FILE_CONFIG_NAME);
                    if (file2.exists() && Paths.get(zapHome, new String[0]).equals(Paths.get(Constant.getDefaultHomeDirectory(true), new String[0]))) {
                        logger.info((Object)("Copying defaults from " + file2.getAbsolutePath() + " to " + this.FILE_CONFIG));
                        fileCopier.copy(file2, file);
                    } else {
                        logger.info((Object)("Copying defaults from " + Constant.getPathDefaultConfigFile() + " to " + this.FILE_CONFIG));
                        fileCopier.copy(Constant.getPathDefaultConfigFile().toFile(), file);
                    }
                }
                if (!(file = new File(this.FOLDER_SESSION)).isDirectory()) {
                    logger.info((Object)("Creating directory " + this.FOLDER_SESSION));
                    if (!file.mkdir()) {
                        System.out.println("Failed to create directory " + file.getAbsolutePath());
                    }
                }
                if (!(file = new File(this.DIRBUSTER_CUSTOM_DIR)).isDirectory()) {
                    logger.info((Object)("Creating directory " + this.DIRBUSTER_CUSTOM_DIR));
                    if (!file.mkdir()) {
                        System.out.println("Failed to create directory " + file.getAbsolutePath());
                    }
                }
                if (!(file = new File(this.FUZZER_DIR)).isDirectory()) {
                    logger.info((Object)("Creating directory " + this.FUZZER_DIR));
                    if (!file.mkdir()) {
                        System.out.println("Failed to create directory " + file.getAbsolutePath());
                    }
                }
                if (!(file = new File(FOLDER_LOCAL_PLUGIN)).isDirectory()) {
                    logger.info((Object)("Creating directory " + FOLDER_LOCAL_PLUGIN));
                    if (!file.mkdir()) {
                        System.out.println("Failed to create directory " + file.getAbsolutePath());
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Unable to initialize home directory! " + exception.getMessage());
                exception.printStackTrace(System.err);
                System.exit(1);
            }
            try {
                try {
                    object = new ZapXmlConfiguration(this.FILE_CONFIG);
                    object.setAutoSave(false);
                    long l = object.getLong("version");
                    if (l == 2004002L || Constant.isDevBuild() || Constant.isDailyBuild()) break block37;
                    logger.info((Object)("Backing up config file to " + this.FILE_CONFIG + ".bak"));
                    file = new File(this.FILE_CONFIG);
                    try {
                        fileCopier.copy(file, new File(this.FILE_CONFIG + ".bak"));
                    }
                    catch (IOException iOException) {
                        String string = "Failed to backup config file " + this.FILE_CONFIG + " to " + this.FILE_CONFIG + ".bak " + iOException.getMessage();
                        System.err.println(string);
                        logger.error((Object)string, (Throwable)iOException);
                    }
                    if (l == 30020013L) {
                        this.upgradeFrom1_1_0((XMLConfiguration)object);
                        this.upgradeFrom1_2_0((XMLConfiguration)object);
                    }
                    if (l <= 1000000L) {
                        // empty if block
                    }
                    if (l <= 1001000L) {
                        this.upgradeFrom1_1_0((XMLConfiguration)object);
                    }
                    if (l <= 1002000L) {
                        this.upgradeFrom1_2_0((XMLConfiguration)object);
                    }
                    if (l <= 1002001L) {
                        // empty if block
                    }
                    if (l <= 1003000L) {
                        // empty if block
                    }
                    if (l <= 1003001L) {
                        // empty if block
                    }
                    if (l <= 1004001L) {
                        this.upgradeFrom1_4_1((XMLConfiguration)object);
                    }
                    if (l <= 2000000L) {
                        this.upgradeFrom2_0_0((XMLConfiguration)object);
                    }
                    if (l <= 2001000L) {
                        // empty if block
                    }
                    if (l <= 2002000L) {
                        this.upgradeFrom2_2_0((XMLConfiguration)object);
                    }
                    if (l <= 2003001L) {
                        this.upgradeFrom2_3_1((XMLConfiguration)object);
                    }
                    logger.info((Object)("Upgraded from " + l));
                    object.setProperty("version", (Object)2004002L);
                    object.save();
                }
                catch (NoSuchElementException | ConfigurationException | ConversionException throwable) {
                    fileCopier.copy(Constant.getPathDefaultConfigFile().toFile(), new File(this.FILE_CONFIG));
                }
            }
            catch (Exception exception) {
                System.err.println("Unable to upgrade config file " + this.FILE_CONFIG + " " + exception.getMessage());
                exception.printStackTrace(System.err);
                System.exit(1);
            }
        }
        Locale locale = Locale.ENGLISH;
        try {
            ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration(this.FILE_CONFIG);
            zapXmlConfiguration.setAutoSave(false);
            object = zapXmlConfiguration.getString("view.locale", "en_GB");
            if (((String)object).length() == 0) {
                object = "en_GB";
            }
            String[] stringArray = ((String)object).split("_");
            locale = new Locale(stringArray[0], stringArray[1]);
        }
        catch (Exception exception) {
            System.out.println("Failed to initialise locale " + exception);
        }
        Locale.setDefault(locale);
        messages = new I18N(locale);
    }

    private void copyProperty(XMLConfiguration xMLConfiguration, XMLConfiguration xMLConfiguration2, String string) {
        xMLConfiguration2.setProperty(string, xMLConfiguration.getProperty(string));
    }

    private void copyAllProperties(XMLConfiguration xMLConfiguration, XMLConfiguration xMLConfiguration2, String string) {
        Iterator iterator = xMLConfiguration.getKeys(string);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.copyProperty(xMLConfiguration, xMLConfiguration2, string2);
        }
    }

    private void upgradeFrom1_1_0(XMLConfiguration xMLConfiguration) throws ConfigurationException {
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration(Constant.getPathDefaultConfigFile().toFile());
        zapXmlConfiguration.setAutoSave(false);
        this.copyAllProperties(zapXmlConfiguration, xMLConfiguration, "pscans");
    }

    private void upgradeFrom1_2_0(XMLConfiguration xMLConfiguration) throws ConfigurationException {
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration(Constant.getPathDefaultConfigFile().toFile());
        zapXmlConfiguration.setAutoSave(false);
        this.copyProperty(zapXmlConfiguration, xMLConfiguration, "view.editorView");
        this.copyProperty(zapXmlConfiguration, xMLConfiguration, "view.brkPanelView");
        this.copyProperty(zapXmlConfiguration, xMLConfiguration, "view.showMainToolbar");
    }

    private void upgradeFrom1_4_1(XMLConfiguration xMLConfiguration) {
        String string;
        Object[] objectArray;
        String string2;
        String string3;
        String string4;
        int n;
        if (!xMLConfiguration.getProperty("spider.postform").toString().equals("0")) {
            xMLConfiguration.setProperty("spider.postform", (Object)"true");
            xMLConfiguration.setProperty("spider.processform", (Object)"true");
        } else {
            xMLConfiguration.setProperty("spider.postform", (Object)"false");
            xMLConfiguration.setProperty("spider.processform", (Object)"false");
        }
        String[] stringArray = xMLConfiguration.getStringArray("session.tokens");
        for (n = 0; n < stringArray.length; ++n) {
            string4 = "httpsessions.tokens.token(" + n + ").";
            xMLConfiguration.setProperty(string4 + "name", (Object)stringArray[n]);
            xMLConfiguration.setProperty(string4 + "enabled", (Object)Boolean.TRUE);
        }
        xMLConfiguration.clearTree(FOLDER_SESSION_DEFAULT);
        stringArray = xMLConfiguration.getStringArray("anticsrf.tokens");
        xMLConfiguration.clearTree("anticsrf.tokens");
        for (n = 0; n < stringArray.length; ++n) {
            string4 = "anticsrf.tokens.token(" + n + ").";
            xMLConfiguration.setProperty(string4 + "name", (Object)stringArray[n]);
            xMLConfiguration.setProperty(string4 + "enabled", (Object)Boolean.TRUE);
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n2 = 0;
        while ((string3 = xMLConfiguration.getString((string2 = "invoke.A" + n2 + ".") + "name")) != null && !USER_AGENT.equals(string3)) {
            objectArray = new Object[]{string3, xMLConfiguration.getString(string2 + "directory", USER_AGENT), xMLConfiguration.getString(string2 + "command"), xMLConfiguration.getString(string2 + "parameters"), xMLConfiguration.getBoolean(string2 + "output", true), xMLConfiguration.getBoolean(string2 + "note", false)};
            arrayList.add(objectArray);
            ++n2;
        }
        xMLConfiguration.clearTree("invoke.A");
        int n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string3 = "invoke.apps.app(" + n2 + ").";
            objectArray = (Object[])arrayList.get(n2);
            xMLConfiguration.setProperty(string3 + "name", objectArray[0]);
            xMLConfiguration.setProperty(string3 + "directory", objectArray[1]);
            xMLConfiguration.setProperty(string3 + "command", objectArray[2]);
            xMLConfiguration.setProperty(string3 + "parameters", objectArray[3]);
            xMLConfiguration.setProperty(string3 + "output", objectArray[4]);
            xMLConfiguration.setProperty(string3 + "note", objectArray[5]);
            xMLConfiguration.setProperty(string3 + "enabled", (Object)Boolean.TRUE);
        }
        arrayList = new ArrayList();
        n2 = 0;
        while ((string3 = xMLConfiguration.getString((string = "connection.auth.A" + n2 + ".") + "hostName")) != null && !USER_AGENT.equals(string3)) {
            objectArray = new Object[]{string3, Integer.valueOf(xMLConfiguration.getString(string + "port", "80")), xMLConfiguration.getString(string + "userName"), xMLConfiguration.getString(string + "password"), xMLConfiguration.getString(string + "realm")};
            arrayList.add(objectArray);
            ++n2;
        }
        xMLConfiguration.clearTree("connection.auth.A");
        int n4 = arrayList.size();
        for (n2 = 0; n2 < n4; ++n2) {
            string3 = "connection.auths.auth(" + n2 + ").";
            objectArray = (Object[])arrayList.get(n2);
            xMLConfiguration.setProperty(string3 + "name", (Object)("Auth " + n2));
            xMLConfiguration.setProperty(string3 + "hostName", objectArray[0]);
            xMLConfiguration.setProperty(string3 + "port", objectArray[1]);
            xMLConfiguration.setProperty(string3 + "userName", objectArray[2]);
            xMLConfiguration.setProperty(string3 + "password", objectArray[3]);
            xMLConfiguration.setProperty(string3 + "realm", objectArray[4]);
            xMLConfiguration.setProperty(string3 + "enabled", (Object)Boolean.TRUE);
        }
        String[] stringArray2 = xMLConfiguration.getStringArray("pscans.names");
        arrayList = new ArrayList();
        for (String objectArray2 : stringArray2) {
            String string5 = "pscans." + objectArray2 + ".";
            Object[] objectArray3 = new Object[]{objectArray2, xMLConfiguration.getString(string5 + "type"), xMLConfiguration.getString(string5 + "config"), xMLConfiguration.getString(string5 + "reqUrlRegex"), xMLConfiguration.getString(string5 + "reqHeadRegex"), xMLConfiguration.getString(string5 + "resHeadRegex"), xMLConfiguration.getString(string5 + "resBodyRegex"), xMLConfiguration.getBoolean(string5 + "enabled")};
            arrayList.add(objectArray3);
        }
        xMLConfiguration.clearTree("pscans.names");
        for (String string6 : stringArray2) {
            xMLConfiguration.clearTree("pscans." + string6);
        }
        int n5 = arrayList.size();
        for (int i = 0; i < n5; ++i) {
            String string6 = "pscans.autoTagScanners.scanner(" + i + ").";
            Object[] objectArray4 = (Object[])arrayList.get(i);
            xMLConfiguration.setProperty(string6 + "name", objectArray4[0]);
            xMLConfiguration.setProperty(string6 + "type", objectArray4[1]);
            xMLConfiguration.setProperty(string6 + "config", objectArray4[2]);
            xMLConfiguration.setProperty(string6 + "reqUrlRegex", objectArray4[3]);
            xMLConfiguration.setProperty(string6 + "reqHeadRegex", objectArray4[4]);
            xMLConfiguration.setProperty(string6 + "resHeadRegex", objectArray4[5]);
            xMLConfiguration.setProperty(string6 + "resBodyRegex", objectArray4[6]);
            xMLConfiguration.setProperty(string6 + "enabled", objectArray4[7]);
        }
    }

    private void upgradeFrom2_0_0(XMLConfiguration xMLConfiguration) {
        String string = xMLConfiguration.getString("bruteforce.defaultFile", USER_AGENT);
        if (!USER_AGENT.equals(string)) {
            String string2 = USER_AGENT;
            File file = new File(this.DIRBUSTER_CUSTOM_DIR + File.separator + string);
            if (!file.exists()) {
                file = new File(this.DIRBUSTER_DIR + File.separator + string);
            }
            if (file.exists()) {
                string2 = file.getAbsolutePath();
            }
            xMLConfiguration.setProperty("bruteforce.defaultFile", (Object)string2);
        }
        xMLConfiguration.clearTree("nullrequest");
        xMLConfiguration.clearTree("nullresponse");
    }

    private void upgradeFrom2_2_0(XMLConfiguration xMLConfiguration) {
        try {
            if (!xMLConfiguration.getBoolean("start.checkForUpdates", false)) {
                xMLConfiguration.setProperty("start.dayLastChecked", (Object)USER_AGENT);
            }
        }
        catch (Exception exception) {
            xMLConfiguration.setProperty("start.dayLastChecked", (Object)USER_AGENT);
        }
        xMLConfiguration.setProperty("addons.block", (Object)USER_AGENT);
    }

    private void upgradeFrom2_3_1(XMLConfiguration xMLConfiguration) {
        xMLConfiguration.clearProperty("connection.confirmRemoveAuth");
        xMLConfiguration.clearTree("options.auth");
    }

    public static void setLocale(String string) {
        String[] stringArray = string.split("_");
        Locale locale = new Locale(stringArray[0], stringArray[1]);
        Locale.setDefault(locale);
        if (messages == null) {
            messages = new I18N(locale);
        } else {
            messages.setLocale(locale);
        }
    }

    public static Locale getLocale() {
        return messages.getLocal();
    }

    public static Locale getSystemsLocale() {
        return SYSTEMS_LOCALE;
    }

    public static Constant getInstance() {
        if (instance == null) {
            Constant.createInstance();
        }
        return instance;
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new Constant();
        }
    }

    private void setAcceleratorKeys() {
        if (Constant.isMacOsX()) {
            ACCELERATOR_UNDO = "meta Z";
            ACCELERATOR_REDO = "meta shift Z";
            ACCELERATOR_TRIGGER_KEY = "Meta";
        } else {
            ACCELERATOR_UNDO = "control Z";
            ACCELERATOR_REDO = "control Y";
            ACCELERATOR_TRIGGER_KEY = "Control";
        }
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        Matcher matcher = patternWindows.matcher(string);
        return matcher.find();
    }

    public static boolean isLinux() {
        String string = System.getProperty("os.name");
        Matcher matcher = patternLinux.matcher(string);
        return matcher.find();
    }

    public static boolean isMacOsX() {
        String string = System.getProperty("os.name");
        Matcher matcher = patternMacOsX.matcher(string);
        return matcher.find();
    }

    public static void setZapHome(String string) {
        zapHome = Constant.getAbsolutePath(string);
    }

    private static String getAbsolutePath(String string) {
        String string2;
        String string3 = Paths.get(string, new String[0]).toAbsolutePath().toString();
        if (!string3.endsWith(string2 = FileSystems.getDefault().getSeparator())) {
            string3 = string3 + string2;
        }
        return string3;
    }

    public static String getZapHome() {
        return zapHome;
    }

    public static Path getPathDefaultConfigFile() {
        return Paths.get(Constant.getZapInstall(), "xml", FILE_CONFIG_NAME);
    }

    public static File getContextsDir() {
        File file = new File(Constant.getZapHome(), USER_CONTEXTS_DIR);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.isDirectory() && file.canWrite()) {
            return file;
        }
        return Model.getSingleton().getOptionsParam().getUserDirectory();
    }

    public static File getPoliciesDir() {
        File file = new File(Constant.getZapHome(), USER_POLICIES_DIR);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.isDirectory() && file.canWrite()) {
            return file;
        }
        return Model.getSingleton().getOptionsParam().getUserDirectory();
    }

    public static void setZapInstall(String string) {
        zapInstall = Constant.getAbsolutePath(string);
    }

    public static String getZapInstall() {
        if (zapInstall == null) {
            String string = ".";
            Path path = Paths.get(string, new String[0]);
            if (!Files.isDirectory(path.resolve("db"), new LinkOption[0]) || !Files.isDirectory(path.resolve(LANG_DIR), new LinkOption[0])) {
                string = ZAP.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                System.out.println("Defaulting ZAP install dir to " + string);
            }
            if (string.startsWith("/") && string.indexOf(":") > 0) {
                string = string.substring(1);
            }
            zapInstall = Constant.getAbsolutePath(string);
        }
        return zapInstall;
    }

    private static Manifest getManifest() {
        String string = Constant.class.getSimpleName() + ".class";
        String string2 = Constant.class.getResource(string).toString();
        if (!string2.startsWith("jar")) {
            return null;
        }
        String string3 = string2.substring(0, string2.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            return new Manifest(new URL(string3).openStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getVersionFromManifest() {
        Manifest manifest = Constant.getManifest();
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue("Implementation-Version");
        }
        return DEV_VERSION;
    }

    public static Date getReleaseCreateDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Manifest manifest = Constant.getManifest();
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            try {
                return simpleDateFormat.parse(attributes.getValue("Create-Date"));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date getInstallDate() {
        File file;
        String string = Constant.class.getSimpleName() + ".class";
        String string2 = Constant.class.getResource(string).toString();
        if (!string2.startsWith("jar:file:")) {
            return null;
        }
        int n = (string2 = string2.substring(9)).indexOf("!");
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if ((file = new File(string2)).exists()) {
            return new Date(file.getParentFile().lastModified());
        }
        return null;
    }

    public static boolean isDevBuild() {
        return Constant.isDevBuild(PROGRAM_VERSION);
    }

    public static boolean isDevBuild(String string) {
        return DEV_VERSION.equals(string);
    }

    public static boolean isDailyBuild(String string) {
        return string.startsWith("D-");
    }

    public static boolean isDailyBuild() {
        return Constant.isDailyBuild(PROGRAM_VERSION);
    }

    public static void setLowMemoryOption(boolean bl) {
        if (lowMemoryOption != null) {
            throw new InvalidParameterException("Low memory option already set to " + lowMemoryOption);
        }
        lowMemoryOption = bl;
    }

    public static boolean isLowMemoryOptionSet() {
        return lowMemoryOption != null && lowMemoryOption != false;
    }

    public static boolean isKali() {
        if (onKali == null) {
            onKali = false;
            File file = new File("/etc/os-release");
            if (Constant.isLinux() && !Constant.isDailyBuild() && file.exists()) {
                try {
                    FileInputStream fileInputStream = null;
                    Properties properties = new Properties();
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                    String string = properties.getProperty("ID");
                    if (string != null) {
                        String[] stringArray;
                        for (String string2 : stringArray = string.split(" ")) {
                            if (!string2.toLowerCase().equals("kali")) continue;
                            onKali = true;
                            break;
                        }
                    }
                    ((InputStream)fileInputStream).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return onKali;
    }
}

