/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import net.htmlparser.jericho.Source;
import org.apache.commons.configuration.Configuration;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

@RunWith(value=MockitoJUnitRunner.class)
public class PluginPassiveScannerUnitTest {
    @Mock
    Configuration configuration;
    PluginPassiveScanner scanner;

    @Before
    public void setUp() throws Exception {
        this.scanner = new TestPluginPassiveScanner();
    }

    @Test
    public void shouldHaveMediumAsDefaultLevel() {
        Assert.assertThat((Object)((Object)this.scanner.getLevel()), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)((Object)Plugin.AlertThreshold.MEDIUM))));
    }

    @Test
    public void shouldHaveNoConfigurationByDefault() {
        Assert.assertThat((Object)this.scanner.getConfig(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.nullValue()));
    }

    @Test
    public void shouldEnableByDefaultIsNotSpecifiedInConfiguration() {
        BDDMockito.given((Object)this.configuration.getBoolean(Matchers.anyString(), Matchers.eq((boolean)true))).willReturn((Object)true);
        BDDMockito.given((Object)this.configuration.getString(Matchers.anyString(), Matchers.anyString())).willReturn((Object)Plugin.AlertThreshold.DEFAULT.name());
        this.scanner.setConfig(this.configuration);
        Assert.assertThat((Object)this.scanner.isEnabled(), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void shouldDisableIfSpecifiedInConfiguration() {
        BDDMockito.given((Object)this.configuration.getBoolean(Matchers.anyString(), Matchers.anyBoolean())).willReturn((Object)false);
        BDDMockito.given((Object)this.configuration.getString(Matchers.anyString(), Matchers.anyString())).willReturn((Object)Plugin.AlertThreshold.DEFAULT.name());
        this.scanner.setConfig(this.configuration);
        Assert.assertThat((Object)this.scanner.isEnabled(), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void shouldPersistEnabledStatusInConfigurationOnSave() {
        BDDMockito.given((Object)this.configuration.getBoolean(Matchers.anyString(), Matchers.eq((boolean)true))).willReturn((Object)true);
        BDDMockito.given((Object)this.configuration.getString(Matchers.anyString(), Matchers.anyString())).willReturn((Object)Plugin.AlertThreshold.DEFAULT.name());
        this.scanner.setConfig(this.configuration);
        this.scanner.save();
        ((Configuration)Mockito.verify((Object)this.configuration)).setProperty("pscans." + this.scanner.getClass().getCanonicalName() + ".enabled", (Object)true);
    }

    private final class TestPluginPassiveScanner
    extends PluginPassiveScanner {
        private TestPluginPassiveScanner() {
        }

        @Override
        public void setParent(PassiveScanThread passiveScanThread) {
        }

        @Override
        public void scanHttpResponseReceive(HttpMessage httpMessage, int n, Source source) {
        }

        @Override
        public void scanHttpRequestSend(HttpMessage httpMessage, int n) {
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

