/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderResource;
import org.zaproxy.zap.extension.spider.SpiderScan;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.spider.filters.MaxChildrenFetchFilter;
import org.zaproxy.zap.spider.filters.MaxChildrenParseFilter;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;

public class SpiderAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(SpiderAPI.class);
    private static final String PREFIX = "spider";
    private static final String ACTION_START_SCAN = "scan";
    private static final String ACTION_START_SCAN_AS_USER = "scanAsUser";
    private static final String ACTION_PAUSE_SCAN = "pause";
    private static final String ACTION_RESUME_SCAN = "resume";
    private static final String ACTION_STOP_SCAN = "stop";
    private static final String ACTION_PAUSE_ALL_SCANS = "pauseAllScans";
    private static final String ACTION_RESUME_ALL_SCANS = "resumeAllScans";
    private static final String ACTION_STOP_ALL_SCANS = "stopAllScans";
    private static final String ACTION_REMOVE_SCAN = "removeScan";
    private static final String ACTION_REMOVE_ALL_SCANS = "removeAllScans";
    private static final String VIEW_STATUS = "status";
    private static final String VIEW_RESULTS = "results";
    private static final String VIEW_FULL_RESULTS = "fullResults";
    private static final String VIEW_SCANS = "scans";
    private static final String PARAM_URL = "url";
    private static final String PARAM_USER_ID = "userId";
    private static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_CONTEXT_NAME = "contextName";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_RECURSE = "recurse";
    private static final String PARAM_SCAN_ID = "scanId";
    private static final String PARAM_MAX_CHILDREN = "maxChildren";
    private static final String ACTION_EXCLUDE_FROM_SCAN = "excludeFromScan";
    private static final String ACTION_CLEAR_EXCLUDED_FROM_SCAN = "clearExcludedFromScan";
    private static final String VIEW_EXCLUDED_FROM_SCAN = "excludedFromScan";
    private ExtensionSpider extension;

    public SpiderAPI(ExtensionSpider extensionSpider) {
        this.extension = extensionSpider;
        this.addApiAction(new ApiAction(ACTION_START_SCAN, new String[]{PARAM_URL}, new String[]{PARAM_MAX_CHILDREN, PARAM_RECURSE, PARAM_CONTEXT_NAME}));
        this.addApiAction(new ApiAction(ACTION_START_SCAN_AS_USER, new String[]{PARAM_URL, PARAM_CONTEXT_ID, PARAM_USER_ID}, new String[]{PARAM_MAX_CHILDREN, PARAM_RECURSE}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_RESUME_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_STOP_SCAN, null, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_RESUME_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_STOP_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_REMOVE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_CLEAR_EXCLUDED_FROM_SCAN));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_FROM_SCAN, new String[]{PARAM_REGEX}));
        this.addApiView(new ApiView(VIEW_STATUS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_RESULTS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_FULL_RESULTS, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_SCANS));
        this.addApiView(new ApiView(VIEW_EXCLUDED_FROM_SCAN));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("Request for handleApiAction: " + string + " (params: " + jSONObject.toString() + ")"));
        int n = -1;
        Context context = null;
        switch (string) {
            case "scan": {
                String string2;
                String string3 = ApiUtils.getNonEmptyStringParam(jSONObject, PARAM_URL);
                if (jSONObject.containsKey((Object)PARAM_MAX_CHILDREN) && (string2 = jSONObject.getString(PARAM_MAX_CHILDREN)) != null && string2.length() > 0) {
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_MAX_CHILDREN);
                    }
                }
                if (jSONObject.containsKey((Object)PARAM_CONTEXT_NAME)) {
                    context = ApiUtils.getContextByName(jSONObject, PARAM_CONTEXT_NAME);
                }
                int n2 = this.scanURL(string3, null, n, this.getParam(jSONObject, PARAM_RECURSE, true), context);
                return new ApiResponseElement(string, Integer.toString(n2));
            }
            case "scanAsUser": {
                String string4;
                String string5 = ApiUtils.getNonEmptyStringParam(jSONObject, PARAM_URL);
                int n3 = ApiUtils.getIntParam(jSONObject, PARAM_USER_ID);
                ExtensionUserManagement extensionUserManagement = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
                if (extensionUserManagement == null) {
                    throw new ApiException(ApiException.Type.NO_IMPLEMENTOR, "ExtensionUserManagement");
                }
                context = ApiUtils.getContextByParamId(jSONObject, PARAM_CONTEXT_ID);
                if (!context.isIncluded(string5)) {
                    throw new ApiException(ApiException.Type.URL_NOT_IN_CONTEXT, PARAM_CONTEXT_ID);
                }
                User user = extensionUserManagement.getContextUserAuthManager(context.getIndex()).getUserById(n3);
                if (user == null) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND, PARAM_USER_ID);
                }
                if (jSONObject.containsKey((Object)PARAM_MAX_CHILDREN) && (string4 = jSONObject.getString(PARAM_MAX_CHILDREN)) != null && string4.length() > 0) {
                    try {
                        n = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_MAX_CHILDREN);
                    }
                }
                int n4 = this.scanURL(string5, user, n, this.getParam(jSONObject, PARAM_RECURSE, true), context);
                return new ApiResponseElement(string, Integer.toString(n4));
            }
            case "pause": {
                GenericScanner2 genericScanner2 = this.getSpiderScan(jSONObject);
                if (genericScanner2 == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.pauseScan(genericScanner2.getScanId());
                break;
            }
            case "resume": {
                GenericScanner2 genericScanner2 = this.getSpiderScan(jSONObject);
                if (genericScanner2 == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.resumeScan(genericScanner2.getScanId());
                break;
            }
            case "stop": {
                GenericScanner2 genericScanner2 = this.getSpiderScan(jSONObject);
                if (genericScanner2 == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.stopScan(genericScanner2.getScanId());
                break;
            }
            case "removeScan": {
                GenericScanner2 genericScanner2 = this.getSpiderScan(jSONObject);
                if (genericScanner2 == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.removeScan(genericScanner2.getScanId());
                break;
            }
            case "pauseAllScans": {
                this.extension.pauseAllScans();
                break;
            }
            case "resumeAllScans": {
                this.extension.resumeAllScans();
                break;
            }
            case "stopAllScans": {
                this.extension.stopAllScans();
                break;
            }
            case "removeAllScans": {
                this.extension.removeAllScans();
                break;
            }
            case "clearExcludedFromScan": {
                try {
                    Session session = Model.getSingleton().getSession();
                    session.setExcludeFromSpiderRegexs(new ArrayList<String>());
                    break;
                }
                catch (DatabaseException databaseException) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, databaseException.getMessage());
                }
            }
            case "excludeFromScan": {
                String string6 = jSONObject.getString(PARAM_REGEX);
                try {
                    Session session = Model.getSingleton().getSession();
                    session.addExcludeFromSpiderRegex(string6);
                    break;
                }
                catch (DatabaseException databaseException) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, databaseException.getMessage());
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX);
                }
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
        }
        return ApiResponseElement.OK;
    }

    private GenericScanner2 getSpiderScan(JSONObject jSONObject) throws ApiException {
        int n = this.getParam(jSONObject, PARAM_SCAN_ID, -1);
        SpiderScan spiderScan = n == -1 ? this.extension.getLastScan() : this.extension.getScan(n);
        if (spiderScan == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
        }
        return spiderScan;
    }

    private int scanURL(String string, User user, int n, boolean bl, Context context) throws ApiException {
        URI uRI;
        log.debug((Object)("API Spider scanning url: " + string));
        try {
            uRI = new URI(string, true);
        }
        catch (URIException uRIException) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
        }
        String string2 = uRI.getScheme();
        if (string2 == null || !string2.equalsIgnoreCase("http") && !string2.equalsIgnoreCase("https")) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
        }
        StructuralNode structuralNode = null;
        try {
            structuralNode = SessionStructure.find(Model.getSingleton().getSession().getSessionId(), new URI(string, false), "GET", "");
        }
        catch (Exception exception) {
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
        Target target = new Target(structuralNode);
        target.setRecurse(bl);
        if (context != null) {
            target.setContext(context);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n > 0 ? 3 : 1);
        arrayList.add(uRI);
        if (n > 0) {
            MaxChildrenFetchFilter maxChildrenFetchFilter = new MaxChildrenFetchFilter();
            maxChildrenFetchFilter.setMaxChildren(n);
            maxChildrenFetchFilter.setModel(this.extension.getModel());
            MaxChildrenParseFilter maxChildrenParseFilter = new MaxChildrenParseFilter();
            maxChildrenParseFilter.setMaxChildren(n);
            maxChildrenParseFilter.setModel(this.extension.getModel());
            arrayList.add(maxChildrenFetchFilter);
            arrayList.add(maxChildrenParseFilter);
        }
        return this.extension.startScan(target.getDisplayName(), target, user, arrayList.toArray(new Object[arrayList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        ApiResponse apiResponse;
        if (VIEW_STATUS.equals(string)) {
            SpiderScan spiderScan = (SpiderScan)this.getSpiderScan(jSONObject);
            int n = 0;
            if (spiderScan != null) {
                n = spiderScan.getProgress();
            }
            apiResponse = new ApiResponseElement(string, Integer.toString(n));
        } else if (VIEW_RESULTS.equals(string)) {
            apiResponse = new ApiResponseList(string);
            SpiderScan spiderScan = (SpiderScan)this.getSpiderScan(jSONObject);
            if (spiderScan != null) {
                Set<String> set = spiderScan.getResults();
                synchronized (set) {
                    for (String set2 : spiderScan.getResults()) {
                        ((ApiResponseList)apiResponse).addItem(new ApiResponseElement(PARAM_URL, set2));
                    }
                }
            }
        } else if (VIEW_FULL_RESULTS.equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList(string);
            SpiderScan spiderScan = (SpiderScan)this.getSpiderScan(jSONObject);
            ApiResponseList apiResponseList2 = new ApiResponseList("urlsInScope");
            Set<String> string3 = spiderScan.getResults();
            synchronized (string3) {
                for (SpiderResource spiderResource : spiderScan.getResourcesFound()) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("messageId", Integer.toString(spiderResource.getHistoryId()));
                    hashMap.put("method", spiderResource.getMethod());
                    hashMap.put(PARAM_URL, spiderResource.getUri());
                    hashMap.put("statusCode", Integer.toString(spiderResource.getStatusCode()));
                    hashMap.put("statusReason", spiderResource.getStatusReason());
                    apiResponseList2.addItem(new ApiResponseSet("resource", hashMap));
                }
            }
            apiResponseList.addItem(apiResponseList2);
            ApiResponseList apiResponseList3 = new ApiResponseList("urlsOutOfScope");
            string3 = spiderScan.getResultsOutOfScope();
            synchronized (string3) {
                for (String string2 : spiderScan.getResultsOutOfScope()) {
                    apiResponseList3.addItem(new ApiResponseElement(PARAM_URL, string2));
                }
            }
            apiResponseList.addItem(apiResponseList3);
            apiResponse = apiResponseList;
        } else if (VIEW_EXCLUDED_FROM_SCAN.equals(string)) {
            apiResponse = new ApiResponseList(string);
            Session session = Model.getSingleton().getSession();
            List<String> list = session.getExcludeFromSpiderRegexs();
            for (String spiderScan : list) {
                ((ApiResponseList)apiResponse).addItem(new ApiResponseElement(PARAM_REGEX, spiderScan));
            }
        } else if (VIEW_SCANS.equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList(string);
            for (GenericScanner2 genericScanner2 : this.extension.getAllScans()) {
                SpiderScan spiderScan = (SpiderScan)genericScanner2;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("id", Integer.toString(spiderScan.getScanId()));
                hashMap.put("progress", Integer.toString(spiderScan.getProgress()));
                hashMap.put("state", spiderScan.getState());
                apiResponseList.addItem(new ApiResponseSet(ACTION_START_SCAN, hashMap));
            }
            apiResponse = apiResponseList;
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return apiResponse;
    }
}

