/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    long buttonHandle;
    long entryHandle;
    long textRenderer;
    long cellHandle;
    long popupHandle;
    long menuHandle;
    int lastEventTime;
    int visibleCount = 10;
    long imContext;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    String[] items = new String[0];
    boolean selectionAdded;
    int indexSelected;
    public static final int LIMIT = 65535;

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.add(string, this.items.length);
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n > this.items.length) {
            this.error(6);
        }
        String[] stringArray = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, stringArray, 0, n);
        stringArray[n] = string;
        System.arraycopy(this.items, n, stringArray, n + 1, this.items.length - n);
        this.items = stringArray;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK3) {
            OS.gtk_combo_box_text_insert(this.handle, n, null, byArray);
        } else {
            OS.gtk_combo_box_insert_text(this.handle, n, byArray);
        }
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            int n = OS.gtk_editable_get_position(this.entryHandle);
            OS.gtk_editable_select_region(this.entryHandle, n, n);
        }
    }

    void clearText() {
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0) {
            int n = OS.gtk_combo_box_get_active(this.handle);
            if (n != -1) {
                long l = OS.gtk_combo_box_get_model(this.handle);
                long[] lArray = new long[1];
                long l2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                OS.gtk_tree_model_iter_nth_child(l, l2, 0L, n);
                OS.gtk_tree_model_get(l, l2, 0, lArray, -1);
                OS.g_free(l2);
                if (lArray[0] != 0L && OS.strlen(lArray[0]) > 0) {
                    this.postEvent(24);
                }
                OS.g_free(lArray[0]);
            }
        } else {
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
        OS.gtk_combo_box_set_active(this.handle, -1);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if ((this.style & 8) != 0 || OS.GTK3) {
            return this.computeNativeSize(this.handle, n, n2, bl);
        }
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.entryHandle);
        long l = OS.gtk_entry_get_layout(this.entryHandle);
        OS.pango_layout_get_pixel_size(l, nArray, nArray2);
        int n3 = 2;
        int n4 = 2;
        Point point = this.getThickness(this.entryHandle);
        n3 += point.x;
        n4 += point.y;
        int[] nArray3 = new int[1];
        OS.gtk_widget_style_get(this.entryHandle, OS.interior_focus, nArray3, 0L);
        if (nArray3[0] == 0) {
            OS.gtk_widget_style_get(this.entryHandle, OS.focus_line_width, nArray3, 0L);
            n3 += nArray3[0];
            n4 += nArray3[0];
        }
        int n5 = nArray[0] + n3 * 2;
        int n6 = nArray2[0] + n4 * 2;
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(this.buttonHandle, gtkRequisition);
        GtkRequisition gtkRequisition2 = new GtkRequisition();
        long l2 = OS.gtk_bin_get_child(this.popupHandle);
        this.gtk_widget_get_preferred_size(l2, gtkRequisition2);
        n5 = Math.max(gtkRequisition2.width, n5) + gtkRequisition.width;
        n5 = n == -1 ? n5 : n;
        n6 = n2 == -1 ? n6 : n2;
        return new Point(n5, n6);
    }

    public void copy() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            OS.gtk_editable_copy_clipboard(this.entryHandle);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        long l = OS.gtk_window_list_toplevels();
        if ((this.style & 8) != 0) {
            this.handle = OS.GTK3 ? OS.gtk_combo_box_text_new() : OS.gtk_combo_box_new_text();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.cellHandle = OS.gtk_bin_get_child(this.handle);
            if (this.cellHandle == 0L) {
                this.error(2);
            }
            OS.gtk_combo_box_set_wrap_width(this.handle, 1);
        } else {
            this.handle = OS.GTK3 ? OS.gtk_combo_box_text_new_with_entry() : OS.gtk_combo_box_entry_new_text();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.entryHandle = OS.gtk_bin_get_child(this.handle);
            if (this.entryHandle == 0L) {
                this.error(2);
            }
            if (OS.GTK3) {
                this.imContext = OS.imContextLast();
            }
        }
        this.popupHandle = this.findPopupHandle(l);
        OS.gtk_container_add(this.fixedHandle, this.handle);
        this.textRenderer = OS.gtk_cell_renderer_text_new();
        if (this.textRenderer == 0L) {
            this.error(2);
        }
        int n2 = 0;
        OS.g_object_set(this.textRenderer, OS.ypad, n2, 0L);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.gtk_cell_layout_clear(this.handle);
        this.display.setWarnings(bl);
        OS.gtk_cell_layout_pack_start(this.handle, this.textRenderer, true);
        OS.gtk_cell_layout_set_attributes(this.handle, this.textRenderer, OS.text, 0, 0L);
        this.menuHandle = this.findMenuHandle();
        if (this.menuHandle != 0L) {
            OS.g_object_ref(this.menuHandle);
        }
        this.buttonHandle = this.findButtonHandle();
        if (this.buttonHandle != 0L) {
            OS.g_object_ref(this.buttonHandle);
        }
        if ((this.style & 8) != 0 && this.buttonHandle != 0L) {
            OS.gtk_widget_set_receives_default(this.buttonHandle, false);
        }
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    public void cut() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            OS.gtk_editable_cut_clipboard(this.entryHandle);
        }
    }

    @Override
    void deregister() {
        long l;
        super.deregister();
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.entryHandle != 0L) {
            this.display.removeWidget(this.entryHandle);
        }
        if (this.popupHandle != 0L) {
            this.display.removeWidget(this.popupHandle);
        }
        if (this.menuHandle != 0L) {
            this.display.removeWidget(this.menuHandle);
        }
        if ((l = this.imContext()) != 0L) {
            this.display.removeWidget(l);
        }
    }

    @Override
    boolean filterKey(int n, long l) {
        int n2 = OS.gdk_event_get_time(l);
        if (n2 != this.lastEventTime) {
            this.lastEventTime = n2;
            long l2 = this.imContext();
            if (l2 != 0L) {
                return OS.gtk_im_context_filter_keypress(l2, l);
            }
        }
        this.gdkEventKey = l;
        return false;
    }

    long findPopupHandle(long l) {
        long l2 = 0L;
        long l3 = OS.gtk_window_list_toplevels();
        long l4 = l;
        long l5 = OS.g_list_last(l3);
        while (l5 != 0L) {
            long l6 = OS.g_list_data(l5);
            boolean bl = false;
            l4 = l;
            while (l4 != 0L) {
                long l7 = OS.g_list_data(l4);
                if (l6 == l7) {
                    bl = true;
                    break;
                }
                l4 = OS.g_list_next(l4);
            }
            if (!bl) {
                l2 = l6;
                break;
            }
            l5 = OS.g_list_previous(l5);
        }
        OS.g_list_free(l);
        OS.g_list_free(l3);
        return l2;
    }

    long findButtonHandle() {
        long l = 0L;
        OS.gtk_container_forall(this.handle, this.display.allChildrenProc, 0L);
        if (this.display.allChildren != 0L) {
            long l2 = this.display.allChildren;
            while (l2 != 0L) {
                long l3 = OS.g_list_data(l2);
                if (OS.GTK_IS_BUTTON(l3)) {
                    l = l3;
                    break;
                }
                l2 = OS.g_list_next(l2);
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0L;
        }
        return l;
    }

    long findMenuHandle() {
        if (this.popupHandle == 0L) {
            return 0L;
        }
        long l = 0L;
        OS.gtk_container_forall(this.popupHandle, this.display.allChildrenProc, 0L);
        if (this.display.allChildren != 0L) {
            long l2 = this.display.allChildren;
            while (l2 != 0L) {
                long l3 = OS.g_list_data(l2);
                if (OS.G_OBJECT_TYPE(l3) == OS.GTK_TYPE_MENU()) {
                    l = l3;
                    break;
                }
                l2 = OS.g_list_next(l2);
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0L;
        }
        return l;
    }

    @Override
    void fixModal(long l, long l2) {
        if (this.popupHandle != 0L) {
            if (l != 0L) {
                OS.gtk_window_group_add_window(l, this.popupHandle);
            } else if (l2 != 0L) {
                OS.gtk_window_group_remove_window(l2, this.popupHandle);
            }
        }
    }

    void fixIM() {
        long l;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (l = this.imContext()) != 0L) {
            OS.gtk_im_context_filter_keypress(l, this.gdkEventKey);
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    @Override
    long fontHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    @Override
    long focusHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    @Override
    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        return this.entryHandle != 0L && OS.gtk_widget_has_focus(this.entryHandle);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
        if (this.entryHandle != 0L) {
            OS.g_signal_connect_closure(this.entryHandle, OS.changed, this.display.getClosure(6), true);
            OS.g_signal_connect_closure(this.entryHandle, OS.insert_text, this.display.getClosure(26), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.delete_text, this.display.getClosure(13), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.activate, this.display.getClosure(1), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.populate_popup, this.display.getClosure(37), false);
        }
        this.hookEvents(new long[]{this.buttonHandle, this.entryHandle, this.menuHandle});
        long l = this.imContext();
        if (l != 0L) {
            OS.g_signal_connect_closure(l, OS.commit, this.display.getClosure(9), false);
            int n = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int n2 = 17;
            OS.g_signal_handlers_block_matched(l, n2, n, 0, 0L, 0L, this.entryHandle);
        }
    }

    void hookEvents(long[] lArray) {
        int n = 772;
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            if (l == 0L) continue;
            OS.gtk_widget_add_events(l, n);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[4], 0, this.display.getClosure(4), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[33], 0, this.display.getClosure(33), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[2], 0, this.display.getClosure(3), true);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[4], 0, this.display.getClosure(5), true);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[33], 0, this.display.getClosure(34), true);
            if (l != this.focusHandle()) {
                OS.g_signal_connect_closure_by_id(l, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            }
            if (OS.G_OBJECT_TYPE(l) != OS.GTK_TYPE_MENU()) continue;
            OS.g_signal_connect_closure(l, OS.selection_done, this.display.getClosure(68), true);
        }
    }

    long imContext() {
        if (this.imContext != 0L) {
            return this.imContext;
        }
        return this.entryHandle != 0L ? OS.GTK_ENTRY_IM_CONTEXT(this.entryHandle) : 0L;
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        if (OS.gtk_combo_box_get_active(this.handle) == n) {
            this.clearText();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.clearText();
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        if (bl && this.entryHandle != 0L) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            long l = OS.gtk_entry_get_layout(this.entryHandle);
            OS.pango_layout_xy_to_index(l, n * 1024, n2 * 1024, nArray, nArray2);
            long l2 = OS.pango_layout_get_text(l);
            int n3 = (int)OS.g_utf8_pointer_to_offset(l2, l2 + (long)nArray[0]) + nArray2[0];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.entryHandle, nArray3, nArray4);
            if (nArray3[0] <= n3 && n3 < nArray4[0] && super.dragDetect(n, n2, bl, bl2, blArray)) {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, bl2, blArray);
    }

    @Override
    long enterExitHandle() {
        return this.fixedHandle;
    }

    @Override
    long eventWindow() {
        return this.paintWindow();
    }

    @Override
    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, 0);
        }
        int n = OS.gtk_editable_get_position(this.entryHandle);
        n = OS.gtk_entry_text_index_to_layout_index(this.entryHandle, n);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_entry_get_layout_offsets(this.entryHandle, nArray, nArray2);
        long l = OS.gtk_entry_get_layout(this.entryHandle);
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_index_to_pos(l, n, pangoRectangle);
        int n2 = nArray[0] + OS.PANGO_PIXELS(pangoRectangle.x) - this.getBorderWidth();
        int n3 = nArray2[0] + OS.PANGO_PIXELS(pangoRectangle.y);
        return new Point(n2, n3);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return 0;
        }
        long l = OS.gtk_entry_get_text(this.entryHandle);
        return (int)OS.g_utf8_offset_to_utf16_offset(l, OS.gtk_editable_get_position(this.entryHandle));
    }

    @Override
    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.items.length) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public String[] getItems() {
        this.checkWidget();
        String[] stringArray = new String[this.items.length];
        System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.popupHandle != 0L && OS.gtk_widget_get_visible(this.popupHandle);
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            int n = 0;
            int n2 = OS.gtk_combo_box_get_active(this.handle);
            if (n2 != -1) {
                n = this.getItem(n2).length();
            }
            return new Point(0, n);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (this.entryHandle != 0L) {
            OS.gtk_editable_get_selection_bounds(this.entryHandle, nArray, nArray2);
            long l = OS.gtk_entry_get_text(this.entryHandle);
            nArray[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray[0]);
            nArray2[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray2[0]);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.gtk_combo_box_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            long l = OS.gtk_entry_get_text(this.entryHandle);
            if (l == 0L) {
                return "";
            }
            int n = OS.strlen(l);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l, (long)n);
            return new String(Converter.mbcsToWcs(null, byArray));
        }
        int n = OS.gtk_combo_box_get_active(this.handle);
        return n != -1 ? this.getItem(n) : "";
    }

    String getText(int n, int n2) {
        return this.getText().substring(n, n2 - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_size_request(this.handle, gtkRequisition);
        if (OS.GTK3) {
            return gtkRequisition.height;
        }
        return OS.GTK_WIDGET_REQUISITION_HEIGHT(this.handle);
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = this.entryHandle != 0L ? OS.gtk_entry_get_max_length(this.entryHandle) : 0;
        return n == 0 ? LIMIT : n;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    @Override
    long gtk_activate(long l) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        if (gdkEventButton.type == 4 && gdkEventButton.button == 1) {
            return this.gtk_button_press_event(l, l2, false);
        }
        return super.gtk_button_press_event(l, l2);
    }

    @Override
    long gtk_changed(long l) {
        if (l == this.handle) {
            int n;
            if (this.entryHandle == 0L) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return 0L;
                }
            }
            if ((n = OS.gtk_combo_box_get_active(this.handle)) != -1) {
                this.sendSelectionEvent(13);
            }
            this.indexSelected = -1;
            return 0L;
        }
        boolean bl = false;
        long l2 = OS.gtk_get_current_event();
        if (l2 != 0L) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    bl = true;
                }
            }
            OS.gdk_event_free(l2);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0L;
    }

    @Override
    long gtk_commit(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        if (!OS.gtk_editable_get_editable(this.entryHandle)) {
            return 0L;
        }
        int n = OS.strlen(l2);
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        char[] cArray2 = this.sendIMKeyEvent(1, null, cArray);
        if (cArray2 == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 9L);
        int n2 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int n3 = 17;
        OS.g_signal_handlers_unblock_matched(l, n3, n2, 0, 0L, 0L, this.entryHandle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(l, OS.commit, l2);
        } else {
            byArray = Converter.wcsToMbcs(null, cArray2, true);
            OS.g_signal_emit_by_name(l, OS.commit, byArray);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(l, n3, n2, 0, 0L, 0L, this.entryHandle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.entryHandle, this.fixStart);
            OS.gtk_editable_select_region(this.entryHandle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    @Override
    long gtk_delete_text(long l, long l2, long l3) {
        int n;
        int n2;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        long l4 = OS.gtk_entry_get_text(this.entryHandle);
        if (l3 == -1L) {
            l3 = OS.g_utf8_strlen(l4, -1L);
        }
        if ((string = this.verifyText("", n2 = (int)OS.g_utf8_offset_to_utf16_offset(l4, l2), n = (int)OS.g_utf8_offset_to_utf16_offset(l4, l3))) == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{(int)l3};
            byte[] byArray = Converter.wcsToMbcs(null, string, false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            OS.gtk_editable_insert_text(this.entryHandle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_editable_set_position(this.entryHandle, nArray[0]);
        }
        return 0L;
    }

    @Override
    long gtk_event_after(long l, long l2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button != 1) break;
                if (!this.sendMouseEvent(3, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state)) {
                    return 1L;
                }
                if ((this.style & 8) != 0 || l != this.buttonHandle) break;
                OS.gtk_widget_grab_focus(this.entryHandle);
                break;
            }
            case 12: {
                if ((this.style & 8) != 0) break;
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                OS.memmove(gdkEventFocus, l2, (long)GdkEventFocus.sizeof);
                if (gdkEventFocus.in != 0) {
                    OS.gtk_combo_box_set_focus_on_click(this.handle, false);
                    break;
                }
                OS.gtk_combo_box_set_focus_on_click(this.handle, true);
            }
        }
        return super.gtk_event_after(l, l2);
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        this.fixIM();
        return super.gtk_focus_out_event(l, l2);
    }

    @Override
    long gtk_insert_text(long l, long l2, long l3, long l4) {
        int n;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l3];
        OS.memmove(byArray, l2, (long)byArray.length);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        int[] nArray = new int[1];
        OS.memmove(nArray, l4, 4L);
        long l5 = OS.gtk_entry_get_text(this.entryHandle);
        if (nArray[0] == -1) {
            nArray[0] = (int)OS.g_utf8_strlen(l5, -1L);
        }
        if ((string = this.verifyText(string2, n = (int)OS.g_utf8_offset_to_utf16_offset(l5, nArray[0]), n)) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.entryHandle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                    OS.gtk_editable_delete_selection(this.entryHandle);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] byArray2 = Converter.wcsToMbcs(null, string, false);
                OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                OS.gtk_editable_insert_text(this.entryHandle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            OS.memmove(l4, nArray, 4L);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            this.gdkEventKey = 0L;
            this.fixIM();
            return l3;
        }
        if (this.gdkEventKey == -1L) {
            l3 = 1L;
        }
        this.gdkEventKey = 0L;
        if ((this.style & 8) == 0) {
            int n;
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
            int n2 = n = OS.gtk_combo_box_get_active(this.handle);
            int n3 = gdkEventKey.keyval;
            switch (n3) {
                case 65364: 
                case 65433: {
                    if (n == this.items.length - 1) break;
                    n2 = n + 1;
                    break;
                }
                case 65362: 
                case 65431: {
                    if (n == -1 || n == 0) break;
                    n2 = n - 1;
                    break;
                }
                case 65365: 
                case 65434: {
                    n2 = 0;
                    break;
                }
                case 65366: 
                case 65435: {
                    n2 = this.items.length - 1;
                }
            }
            if (n2 != n) {
                OS.gtk_combo_box_set_active(this.handle, n2);
                return 1L;
            }
        }
        return l3;
    }

    @Override
    long gtk_populate_popup(long l, long l2) {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(l2, 2);
            OS.gtk_container_forall(l2, this.display.setDirectionProc, 2L);
        }
        return 0L;
    }

    @Override
    long gtk_selection_done(long l) {
        int n = OS.gtk_combo_box_get_active(this.handle);
        if (this.indexSelected == -1) {
            this.indexSelected = n;
        } else if (n != -1 && this.indexSelected == n) {
            this.sendSelectionEvent(13);
        }
        return 0L;
    }

    @Override
    long gtk_style_set(long l, long l2) {
        this.setButtonHandle(this.findButtonHandle());
        this.setMenuHandle(this.findMenuHandle());
        return super.gtk_style_set(l, l2);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= this.items.length) {
            return -1;
        }
        for (int i = n; i < this.items.length; ++i) {
            if (!string.equals(this.items[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean isFocusHandle(long l) {
        if (this.buttonHandle != 0L && l == this.buttonHandle) {
            return true;
        }
        if (this.entryHandle != 0L && l == this.entryHandle) {
            return true;
        }
        return super.isFocusHandle(l);
    }

    @Override
    long paintWindow() {
        long l = this.entryHandle != 0L ? this.entryHandle : this.handle;
        OS.gtk_widget_realize(l);
        long l2 = this.gtk_widget_get_window(l);
        if ((this.style & 8) != 0) {
            return l2;
        }
        long l3 = OS.gdk_window_get_children(l2);
        if (l3 != 0L) {
            l2 = OS.g_list_data(l3);
        }
        OS.g_list_free(l3);
        return l2;
    }

    public void paste() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            OS.gtk_editable_paste_clipboard(this.entryHandle);
        }
    }

    @Override
    long parentingHandle() {
        return this.fixedHandle;
    }

    @Override
    void register() {
        long l;
        super.register();
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.entryHandle != 0L) {
            this.display.addWidget(this.entryHandle, this);
        }
        if (this.popupHandle != 0L) {
            this.display.addWidget(this.popupHandle, this);
        }
        if (this.menuHandle != 0L) {
            this.display.addWidget(this.menuHandle, this);
        }
        if ((l = this.imContext()) != 0L) {
            this.display.addWidget(l, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.menuHandle != 0L) {
            OS.g_object_unref(this.menuHandle);
        }
        if (this.buttonHandle != 0L) {
            OS.g_object_unref(this.buttonHandle);
        }
        this.entryHandle = 0L;
        this.buttonHandle = 0L;
        this.menuHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.textRenderer = 0L;
        this.fixIM();
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - n - 1);
        this.items = stringArray2;
        if (OS.gtk_combo_box_get_active(this.handle) == n) {
            this.clearText();
        }
        if (OS.GTK3) {
            OS.gtk_combo_box_text_remove(this.handle, n);
        } else {
            OS.gtk_combo_box_remove_text(this.handle, n);
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - (n2 - n + 1)];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n2 + 1, stringArray2, n, stringArray.length - n2 - 1);
        this.items = stringArray2;
        int n3 = OS.gtk_combo_box_get_active(this.handle);
        if (n <= n3 && n3 <= n2) {
            this.clearText();
        }
        for (int i = n2; i >= n; --i) {
            if (OS.GTK3) {
                OS.gtk_combo_box_text_remove(this.handle, i);
                continue;
            }
            OS.gtk_combo_box_remove_text(this.handle, i);
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        int n = this.items.length;
        this.items = new String[0];
        this.clearText();
        if (OS.GTK3) {
            OS.gtk_combo_box_text_remove_all(this.handle);
        } else {
            for (int i = n - 1; i >= 0; --i) {
                OS.gtk_combo_box_remove_text(this.handle, i);
            }
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        int n2 = OS.gtk_combo_box_get_active(this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.gtk_combo_box_set_active(this.handle, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0 && n2 != n) {
            this.sendEvent(24);
        }
    }

    @Override
    void setBackgroundColor(long l, long l2, GdkRGBA gdkRGBA) {
        if (this.entryHandle == 0L || (this.style & 8) != 0) {
            long l3 = this.findButtonHandle();
            String string = "* {\n";
            if (gdkRGBA != null) {
                String string2 = this.gtk_rgba_to_css_string(gdkRGBA);
                string = string + "background: " + string2 + ";\n";
            }
            string = string + "}\n";
            this.gtk_css_provider_load_from_css(OS.gtk_widget_get_style_context(l3), string);
        } else {
            this.setBackgroundColorGradient(OS.gtk_widget_get_style_context(this.entryHandle), l2, gdkRGBA);
            super.setBackgroundColor(OS.gtk_widget_get_style_context(this.entryHandle), this.entryHandle, gdkRGBA);
        }
        OS.g_object_set(this.textRenderer, OS.background_rgba, gdkRGBA, 0L);
    }

    @Override
    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        if (!OS.GTK3) {
            if (this.entryHandle != 0L) {
                OS.gtk_widget_modify_base(this.entryHandle, 0, gdkColor);
            }
            if (this.cellHandle != 0L) {
                OS.g_object_set(this.cellHandle, OS.background_gdk, gdkColor, 0L);
            }
            OS.g_object_set(this.textRenderer, OS.background_gdk, gdkColor, 0L);
        }
        if (this.entryHandle != 0L) {
            this.setBackgroundColor(this.entryHandle, gdkColor);
        }
        this.setBackgroundColor(this.fixedHandle, gdkColor);
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = n4;
        if (bl2) {
            n5 = Math.max(this.getTextHeight(), n4);
        }
        return super.setBounds(n, n2, n3, n5, bl, bl2);
    }

    void setButtonHandle(long l) {
        if (this.buttonHandle == l) {
            return;
        }
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
            OS.g_object_unref(this.buttonHandle);
        }
        this.buttonHandle = l;
        if (this.buttonHandle != 0L) {
            OS.g_object_ref(this.buttonHandle);
            this.display.addWidget(this.buttonHandle, this);
            this.hookEvents(new long[]{this.buttonHandle});
        }
    }

    void setMenuHandle(long l) {
        if (this.menuHandle == l) {
            return;
        }
        if (this.menuHandle != 0L) {
            this.display.removeWidget(this.menuHandle);
            OS.g_object_unref(this.menuHandle);
        }
        this.menuHandle = l;
        if (this.menuHandle != 0L) {
            OS.g_object_ref(this.menuHandle);
            this.display.addWidget(this.menuHandle, this);
            this.hookEvents(new long[]{this.menuHandle});
        }
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        if (this.entryHandle != 0L) {
            this.setFontDescription(this.entryHandle, l);
        }
        OS.g_object_set(this.textRenderer, OS.font_desc, l, 0L);
        if ((this.style & 8) != 0) {
            int n = OS.gtk_combo_box_get_active(this.handle);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_combo_box_set_active(this.handle, -1);
            OS.gtk_combo_box_set_active(this.handle, n);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        }
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(this.handle, gdkColor, false);
        if (this.entryHandle != 0L) {
            this.setForegroundColor(this.entryHandle, gdkColor, false);
        }
        if (OS.GTK3) {
            GdkRGBA gdkRGBA = this.gdk_color_to_rgba(gdkColor);
            OS.g_object_set(this.textRenderer, OS.foreground_rgba, gdkRGBA, 0L);
        } else {
            OS.g_object_set(this.textRenderer, OS.foreground_gdk, gdkColor, 0L);
        }
    }

    GdkRGBA gdk_color_to_rgba(GdkColor gdkColor) {
        GdkRGBA gdkRGBA = null;
        if (gdkColor != null) {
            gdkRGBA = new GdkRGBA();
            gdkRGBA.alpha = 1.0;
            gdkRGBA.red = (float)(gdkColor.red & 0xFFFF) / 65535.0f;
            gdkRGBA.green = (float)(gdkColor.green & 0xFFFF) / 65535.0f;
            gdkRGBA.blue = (float)(gdkColor.blue & 0xFFFF) / 65535.0f;
        }
        return gdkRGBA;
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= this.items.length) {
            this.error(5);
        }
        this.items[n] = string;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK3) {
            OS.gtk_combo_box_text_remove(this.handle, n);
            OS.gtk_combo_box_text_insert(this.handle, n, null, byArray);
        } else {
            OS.gtk_combo_box_remove_text(this.handle, n);
            OS.gtk_combo_box_insert_text(this.handle, n, byArray);
        }
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    public void setItems(String[] stringArray) {
        int n;
        int n2;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] != null) continue;
            this.error(5);
        }
        n2 = this.items.length;
        this.items = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.items, 0, stringArray.length);
        this.clearText();
        if (OS.GTK3) {
            OS.gtk_combo_box_text_remove_all(this.handle);
        } else {
            for (n = n2 - 1; n >= 0; --n) {
                OS.gtk_combo_box_remove_text(this.handle, n);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            if (OS.GTK3) {
                OS.gtk_combo_box_text_insert(this.handle, n, null, byArray);
            } else {
                OS.gtk_combo_box_insert_text(this.handle, n, byArray);
            }
            if ((this.style & 0x4000000) == 0 || this.popupHandle == 0L) continue;
            OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        if (bl) {
            OS.gtk_combo_box_popup(this.handle);
        } else {
            OS.gtk_combo_box_popdown(this.handle);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.entryHandle != 0L) {
                OS.gtk_widget_set_direction(this.entryHandle, n);
            }
            if (this.cellHandle != 0L) {
                OS.gtk_widget_set_direction(this.cellHandle, n);
            }
            if (!bl && this.popupHandle != 0L) {
                OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, n);
            }
        }
    }

    @Override
    public void setOrientation(int n) {
        super.setOrientation(n);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            return;
        }
        if (this.entryHandle != 0L) {
            long l = OS.gtk_entry_get_text(this.entryHandle);
            int n = (int)OS.g_utf16_offset_to_utf8_offset(l, point.x);
            int n2 = (int)OS.g_utf16_offset_to_utf8_offset(l, point.y);
            OS.gtk_editable_set_position(this.entryHandle, n);
            OS.gtk_editable_select_region(this.entryHandle, n, n2);
        }
    }

    public void setText(String string) {
        long l;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n == -1) {
                return;
            }
            this.select(n);
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, (int)OS.g_utf16_strlen(l = OS.gtk_entry_get_text(this.entryHandle), -1L))) == null) {
            return;
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        OS.gtk_entry_set_text(this.entryHandle, byArray);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        this.sendEvent(24);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if (this.entryHandle != 0L) {
            OS.gtk_entry_set_max_length(this.entryHandle, n);
        }
    }

    @Override
    void setToolTipText(Shell shell, String string) {
        if (this.entryHandle != 0L) {
            shell.setToolTipText(this.entryHandle, string);
        }
        if (this.buttonHandle != 0L) {
            shell.setToolTipText(this.buttonHandle, string);
        }
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
    }

    @Override
    boolean checkSubwindow() {
        return false;
    }

    @Override
    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = gdkEventKey.keyval;
        switch (n) {
            case 65293: 
            case 65421: {
                long l = this.imContext();
                if (l == 0L) break;
                long[] lArray = new long[1];
                OS.gtk_im_context_get_preedit_string(l, lArray, null, null);
                if (lArray[0] == 0L) break;
                int n2 = OS.strlen(lArray[0]);
                OS.g_free(lArray[0]);
                if (n2 == 0) break;
                return false;
            }
        }
        return super.translateTraversal(gdkEventKey);
    }

    String verifyText(String string, int n, int n2) {
        if (string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        long l = OS.gtk_get_current_event();
        if (l != 0L) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    this.setKeyState(event, gdkEventKey);
                }
            }
            OS.gdk_event_free(l);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

