/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class CallStreamInterface
 * \headerfile TelepathyQt/call-stream.h <TelepathyQt/CallStream>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Stream".
 */
class TP_QT_EXPORT CallStreamInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Stream", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Stream");
    }

    /**
     * Creates a CallStreamInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallStreamInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallStreamInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallStreamInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallStreamInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallStreamInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c Interfaces of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>Extra interfaces provided by this stream, such as  \endhtmlonly CallStreamInterfaceMediaInterface \htmlonly .
     *   This SHOULD NOT include the Stream interface itself, and cannot
     *   change once the stream has been created.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInterfaces() const
    {
        return internalRequestProperty(QLatin1String("Interfaces"));
    }

    /**
     * Asynchronous getter for the remote object property \c RemoteMembers of type \c Tp::ContactSendingStateMap.
     *
     * 
     * \htmlonly
     * <p>A map from remote contacts to their sending state.</p>
     * 
     * <p>Media sent to this stream will be sent to all members listed here.
     *   All members listed here will also appear in  \endhtmlonly \link ChannelTypeCallInterface::requestPropertyCallMembers() ChannelTypeCallInterface::CallMembers \endlink \htmlonly ,
     *   and each CallMembers member will be listed in at most one Stream per
     *   Content. Therefore, to hide things from a member of the
     *   call, UIs only need to mute one Stream per Content.</p>
     * 
     * <p>Contacts' handles in this map indicate whether they are
     *   sending media to this stream. Sending_State_Pending_Send indicates
     *   contacts who are not sending but have been asked to do so. The
     *   local user's sending state is shown in  \endhtmlonly \link requestPropertyLocalSendingState() LocalSendingState \endlink \htmlonly .</p>
     * 
     * <p>This mapping is also used by the streaming implementation to map
     *   from  \endhtmlonly CallContentMediaDescriptionInterface \htmlonly s to Streams. In this use-case,
     *   all of the senders in this stream will be represented in
     *    \endhtmlonly \link CallContentInterfaceMediaInterface::requestPropertyRemoteMediaDescriptions() CallContentInterfaceMediaInterface::RemoteMediaDescriptions \endlink \htmlonly . This use-case should not
     *   affect anything that does not handle media streaming.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRemoteMembers() const
    {
        return internalRequestProperty(QLatin1String("RemoteMembers"));
    }

    /**
     * Asynchronous getter for the remote object property \c RemoteMemberIdentifiers of type \c Tp::HandleIdentifierMap.
     *
     * 
     * The string identifiers for handles mentioned in RemoteMembers, to give 
     * clients the minimal information necessary to create contacts without 
     * waiting for round-trips.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRemoteMemberIdentifiers() const
    {
        return internalRequestProperty(QLatin1String("RemoteMemberIdentifiers"));
    }

    /**
     * Asynchronous getter for the remote object property \c LocalSendingState of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The local user's sending state. Media sent on this stream
     *   should be assumed to be received, directly or indirectly, by
     *   every other contact in the
     *    \endhtmlonly \link requestPropertyRemoteMembers() RemoteMembers \endlink \htmlonly  mapping. Change
     *   notification is given via the
     *    \endhtmlonly LocalSendingStateChanged() \htmlonly 
     *   signal.</p>
     * 
     * <div class="rationale">
     *   Implementations of the first Call draft had the self handle
     *   in the  \endhtmlonly \link requestPropertyRemoteMembers() RemoteMembers \endlink \htmlonly  (then
     *   called Members) map and this showed that it's annoying
     *   having to keep track of the self handle so that it can be
     *   special-cased.
     * </div>
     * 
     * <p>A value of <tp:value-ref type="Sending_State">Pending_Send</tp:value-ref> for
     *   this property indicates that the other side requested the
     *   local user start sending media (which can be done by calling either
     *    \endhtmlonly SetSending() \htmlonly  or  \endhtmlonly ChannelTypeCallInterface::Accept() \htmlonly ).</p>
     * 
     * <p>When  \endhtmlonly ChannelTypeCallInterface::Accept() \htmlonly  is
     *   called, all streams with a local sending state of
     *   <tp:value-ref type="Sending_State">Pending_Send</tp:value-ref> and the associated
     *    \endhtmlonly \link CallContentInterface::requestPropertyDisposition() CallContentInterface::Disposition \endlink \htmlonly  set to
     *   <tp:value-ref type="Call_Content_Disposition">Initial</tp:value-ref> are
     *   automatically set to sending.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyLocalSendingState() const
    {
        return internalRequestProperty(QLatin1String("LocalSendingState"));
    }

    /**
     * Asynchronous getter for the remote object property \c CanRequestReceiving of type \c bool.
     *
     * 
     * \htmlonly
     * <p>If true, the user can request that a remote contact starts
     *   sending on this stream.</p>
     * 
     * <div class="rationale">Not all protocols allow the user to ask the
     *   other side to start sending media.</div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCanRequestReceiving() const
    {
        return internalRequestProperty(QLatin1String("CanRequestReceiving"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c SetSending on the remote object.
     * 
     * Set the stream to start or stop sending media from the local user to 
     * other contacts.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param send
     *     
     *     \htmlonly
     *     <p>If True, the
     *        \endhtmlonly \link requestPropertyLocalSendingState() LocalSendingState \endlink \htmlonly  should
     *       change to <tp:value-ref type="Sending_State">Sending</tp:value-ref>, if it isn't
     *       already.</p>
     *     
     *     <p>If False, the
     *        \endhtmlonly \link requestPropertyLocalSendingState() LocalSendingState \endlink \htmlonly  should
     *       change to <tp:value-ref type="Sending_State">None</tp:value-ref>, if it isn't
     *       already.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetSending(bool send, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetSending"));
        callMessage << QVariant::fromValue(send);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c RequestReceiving on the remote object.
     * 
     * Request that a remote contact stops or starts sending on this stream. 
     * The CanRequestReceiving property defines whether the protocol allows 
     * the local user to request the other side start sending on this stream.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param contact
     *     
     *     \htmlonly
     *     <p>Contact from which sending is requested</p>
     *     \endhtmlonly
     *
     * \param receive
     *     
     *     \htmlonly
     *     <p>If true, request that the given contact starts to send media.
     *       If false, request that the given contact stops sending media.</p>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> RequestReceiving(uint contact, bool receive, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("RequestReceiving"));
        callMessage << QVariant::fromValue(contact) << QVariant::fromValue(receive);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c RemoteMembersChanged on the remote object.
     * 
     * \htmlonly
     * Emitted when  \endhtmlonly \link requestPropertyRemoteMembers() RemoteMembers \endlink \htmlonly  changes.
     * \endhtmlonly
     *
     * \param updates
     *     
     *     A mapping from channel-specific handles to their updated sending 
     *     state, whose keys include at least the members who were added, and 
     *     the members whose states changed.
     *
     * \param identifiers
     *     
     *     \htmlonly
     *     The identifiers of the contacts in the <var>Updates</var> map.
     *     \endhtmlonly
     *
     * \param removed
     *     
     *     The channel-specific handles that were removed from the keys of the 
     *     RemoteMembers property, as a result of the contact leaving this 
     *     stream
     *
     * \param reason
     *     
     *     A structured reason for the change.
     */
    void RemoteMembersChanged(const Tp::ContactSendingStateMap& updates, const Tp::HandleIdentifierMap& identifiers, const Tp::UIntList& removed, const Tp::CallStateReason& reason);

    /**
     * Represents the signal \c LocalSendingStateChanged on the remote object.
     * 
     * \htmlonly
     * Emitted when  \endhtmlonly \link requestPropertyLocalSendingState() LocalSendingState \endlink \htmlonly  changes.
     * \endhtmlonly
     *
     * \param state
     *     
     *     The new value of LocalSendingState.
     *
     * \param reason
     *     
     *     A structured reason for the change.
     */
    void LocalSendingStateChanged(uint state, const Tp::CallStateReason& reason);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class CallStreamInterfaceMediaInterface
 * \headerfile TelepathyQt/call-stream.h <TelepathyQt/CallStream>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Stream.Interface.Media".
 */
class TP_QT_EXPORT CallStreamInterfaceMediaInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Stream.Interface.Media", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Stream.Interface.Media");
    }

    /**
     * Creates a CallStreamInterfaceMediaInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallStreamInterfaceMediaInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallStreamInterfaceMediaInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallStreamInterfaceMediaInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallStreamInterfaceMediaInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallStreamInterfaceMediaInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a CallStreamInterfaceMediaInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit CallStreamInterfaceMediaInterface(const Tp::Client::CallStreamInterface& mainInterface);

    /**
     * Creates a CallStreamInterfaceMediaInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    CallStreamInterfaceMediaInterface(const Tp::Client::CallStreamInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c SendingState of type \c uint.
     *
     * 
     * Indicates whether the streaming implementation is/should be sending 
     * media for this stream. The streaming implementation should be able to 
     * rely on reading this value and listening to SendingStateChanged to 
     * determine whether it should be sending media or not. It should not need 
     * to listen to the Hold interfaces on the Call/Content. Feedback on 
     * success should be given via CompleteSendingStateChange. Failures should 
     * be reported via ReportSendingFailure.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySendingState() const
    {
        return internalRequestProperty(QLatin1String("SendingState"));
    }

    /**
     * Asynchronous getter for the remote object property \c ReceivingState of type \c uint.
     *
     * 
     * The counterpart of SendingState. Indicates whether the streaming 
     * implementation is/should be expecting to receive media for this stream. 
     * The CM should only tell the streaming implementation to stop receiving 
     * if it has been told to put the stream on hold, or the stream has been 
     * removed from the call.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyReceivingState() const
    {
        return internalRequestProperty(QLatin1String("ReceivingState"));
    }

    /**
     * Asynchronous getter for the remote object property \c Transport of type \c uint.
     *
     * 
     * The transport for this stream.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyTransport() const
    {
        return internalRequestProperty(QLatin1String("Transport"));
    }

    /**
     * Asynchronous getter for the remote object property \c LocalCandidates of type \c Tp::CandidateList.
     *
     * 
     * [FIXME]. Change notification is via the LocalCandidatesAdded signal.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyLocalCandidates() const
    {
        return internalRequestProperty(QLatin1String("LocalCandidates"));
    }

    /**
     * Asynchronous getter for the remote object property \c LocalCredentials of type \c Tp::StreamCredentials.
     *
     * 
     * The local credentials are sent to the remote site over the signalling 
     * protocol. They are used in ICE to make sure that the connectivity 
     * checks come from the right peer. Change notification is via the 
     * LocalCredentialsChanged signal. This property will be a pair of empty 
     * strings if ICE has not yet been started.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyLocalCredentials() const
    {
        return internalRequestProperty(QLatin1String("LocalCredentials"));
    }

    /**
     * Asynchronous getter for the remote object property \c STUNServers of type \c Tp::SocketAddressIPList.
     *
     * 
     * \htmlonly
     * <p>The IP addresses of possible STUN servers to use for NAT
     *   traversal, as dotted-quad IPv4 address literals or RFC2373
     *   IPv6 address literals.  Change notification is via the
     *    \endhtmlonly STUNServersChanged() \htmlonly 
     *   signal. The IP addresses MUST NOT be given as DNS hostnames.</p>
     * 
     * <div class="rationale">
     *   High-quality connection managers already need an asynchronous
     *   DNS resolver, so they might as well resolve this name to an IP
     *   to make life easier for streaming implementations.
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertySTUNServers() const
    {
        return internalRequestProperty(QLatin1String("STUNServers"));
    }

    /**
     * Asynchronous getter for the remote object property \c RelayInfo of type \c Tp::StringVariantMapList.
     *
     * 
     * \htmlonly
     * <p>A list of mappings describing TURN or Google relay servers
     *   available for the client to use in its candidate gathering, as
     *   determined from the protocol. Well-known map keys are:</p>
     * 
     * <dl>
     *   <dt><code>ip</code> - s</dt>
     *   <dd>The IP address of the relay server as a dotted-quad IPv4
     *     address literal or an RFC2373 IPv6 address literal. This MUST NOT
     *     be a DNS hostname.
     * 
     *     <div class="rationale">
     *       High-quality connection managers already need an asynchronous
     *       DNS resolver, so they might as well resolve this name to an IP
     *       and make life easier for streaming implementations.
     *     </div>
     *   </dd>
     * 
     *   <dt><code>type</code> - s</dt>
     *   <dd>
     *     <p>Either <code>udp</code> for UDP (UDP MUST be assumed if this
     *       key is omitted), <code>tcp</code> for TCP, or
     *       <code>tls</code>.</p>
     * 
     *     <p>The precise meaning of this key depends on the
     *        \endhtmlonly \link requestPropertyTransport() Transport \endlink \htmlonly  property: if
     *       Transport is ICE, <code>tls</code> means
     *       TLS over TCP as referenced by ICE draft 19, and if
     *       Transport is GTalk_P2P, <code>tls</code> means
     *       a fake SSL session over TCP as implemented by libjingle.</p>
     *   </dd>
     * 
     *   <dt><code>port</code> - q</dt>
     *   <dd>The UDP or TCP port of the relay server as an ASCII unsigned
     *     integer</dd>
     * 
     *   <dt><code>unique-id</code> - s</dt>
     *   <dd>A string identifying the relay server. If two RelayInfo entries
     *     have the same unique-id, but different <code>type</code>s, there
     *     is usually little point in connecting to both. Use
     *     <code>priority</code> to determine which version to prefer in this
     *     case. Can also be used by the streaming implementation to avoid
     *     connecting to the same relay multiple times if relaying is
     *     required for both audio and video.</dd>
     * 
     *   <dt><code>priority</code> - u</dt>
     *   <dd>A number determining which version of a server to prefer (if
     *     multiple are present with the same <code>unique-id</code>,
     *     the one with the highest priority should be used, or the streaming
     *     implementation should use the one whose <code>type</code> has the
     *     most desirable properties)</dd>
     * 
     *   <dt><code>username</code> - s</dt>
     *   <dd>The username to use</dd>
     * 
     *   <dt><code>password</code> - s</dt>
     *   <dd>The password to use</dd>
     * 
     *   <dt><code>component</code> - u</dt>
     *   <dd>The component number to use this relay server for, as an
     *     ASCII unsigned integer; if not included, this relay server
     *     may be used for any or all components.
     * 
     *     <div class="rationale">
     *       In ICE draft 6, as used by Google Talk, credentials are only
     *       valid once, so each component needs relaying separately.
     *     </div>
     *   </dd>
     * </dl>
     * 
     * <div class="rationale">
     *   <p>An equivalent of the gtalk-p2p-relay-token property on
     *     MediaSignalling channels is not included here. The connection
     *     manager should be responsible for making the necessary HTTP
     *     requests to turn the token into a username and password.</p>
     * </div>
     * 
     * <p>The type of relay server that this represents depends on
     *   the value of the  \endhtmlonly \link requestPropertyTransport() Transport \endlink \htmlonly 
     *   property. If Transport is ICE, this is a TURN server;
     *   if Transport is GTalk_P2P, this is a Google relay server;
     *   otherwise, the meaning of RelayInfo is undefined.</p>
     * 
     * <p>If relaying is not possible for this stream, the list is
     *   empty.</p>
     * 
     * <p>Change notification is given via the
     *    \endhtmlonly RelayInfoChanged() \htmlonly  signal.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRelayInfo() const
    {
        return internalRequestProperty(QLatin1String("RelayInfo"));
    }

    /**
     * Asynchronous getter for the remote object property \c HasServerInfo of type \c bool.
     *
     * 
     * \htmlonly
     * <p>True if all the initial information about STUN servers and Relay
     *   servers has been retrieved. Change notification is via the
     *    \endhtmlonly ServerInfoRetrieved() \htmlonly  signal.</p>
     * 
     * <div class="rationale">
     *   Streaming implementations that can't cope with STUN and
     *   relay servers being added later SHOULD wait for this
     *   property to become true before proceeding.
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyHasServerInfo() const
    {
        return internalRequestProperty(QLatin1String("HasServerInfo"));
    }

    /**
     * Asynchronous getter for the remote object property \c Endpoints of type \c Tp::ObjectPathList.
     *
     * 
     * The list of Endpoint objects that exist for this stream. Change 
     * notification is via the EndpointsChanged signal.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyEndpoints() const
    {
        return internalRequestProperty(QLatin1String("Endpoints"));
    }

    /**
     * Asynchronous getter for the remote object property \c ICERestartPending of type \c bool.
     *
     * 
     * State recovery for ICERestartRequested. Set when the signal is emitted, 
     * and unset when SetCredentials is called. Useful for debugging.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyICERestartPending() const
    {
        return internalRequestProperty(QLatin1String("ICERestartPending"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c CompleteSendingStateChange on the remote object.
     * 
     * \htmlonly
     * <p>Called in response to
     *    \endhtmlonly SendingStateChanged() \htmlonly (Pending_*, *) to
     *   indicate that the media state has successfully progressed from
     *   Pending_{Start, Stop, Pause} to the corresponding non-pending
     *   state.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param state
     *     
     *     The new (non-pending) value of SendingState.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> CompleteSendingStateChange(uint state, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("CompleteSendingStateChange"));
        callMessage << QVariant::fromValue(state);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ReportSendingFailure on the remote object.
     * 
     * \htmlonly
     * Can be called at any point to indicate a failure in the outgoing
     * portion of the stream.
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> ReportSendingFailure(uint reason, const QString& error, const QString& message, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ReportSendingFailure"));
        callMessage << QVariant::fromValue(reason) << QVariant::fromValue(error) << QVariant::fromValue(message);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c CompleteReceivingStateChange on the remote object.
     * 
     * \htmlonly
     * <p>Called in response to
     *    \endhtmlonly ReceivingStateChanged() \htmlonly (Pending_*, *) to
     *   indicate that the media state has successfully progressed from
     *   Pending_{Start, Stop, Pause} to the corresponding non-pending
     *   state.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param state
     *     
     *     The new (non-pending) value of ReceivingState.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> CompleteReceivingStateChange(uint state, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("CompleteReceivingStateChange"));
        callMessage << QVariant::fromValue(state);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ReportReceivingFailure on the remote object.
     * 
     * \htmlonly
     * Can be called at any point to indicate a failure in the incoming
     * portion of the stream.
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> ReportReceivingFailure(uint reason, const QString& error, const QString& message, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ReportReceivingFailure"));
        callMessage << QVariant::fromValue(reason) << QVariant::fromValue(error) << QVariant::fromValue(message);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c SetCredentials on the remote object.
     * 
     * \htmlonly
     * <p>Used to set the username fragment and password for streams that have
     *   global credentials.</p>
     * \endhtmlonly
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param username
     *     
     *     The username to use when authenticating on the stream.
     *
     * \param password
     *     
     *     The password to use when authenticating on the stream.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> SetCredentials(const QString& username, const QString& password, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("SetCredentials"));
        callMessage << QVariant::fromValue(username) << QVariant::fromValue(password);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AddCandidates on the remote object.
     * 
     * Add candidates to the LocalCandidates property and signal them to the 
     * remote contact(s). Note that connection managers MAY delay the sending 
     * of candidates until FinishInitialCandidates is called.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param candidates
     *     
     *     The candidates to be added.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AddCandidates(const Tp::CandidateList& candidates, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AddCandidates"));
        callMessage << QVariant::fromValue(candidates);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c FinishInitialCandidates on the remote object.
     * 
     * This indicates to the CM that the initial batch of candidates has been 
     * added, and should now be processed/sent to the remote side. Protocols 
     * supporting Raw UDP SHOULD wait for FinishInitialCandidates, and then 
     * set the lowest priority candidate as the Raw UDP candidate.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> FinishInitialCandidates(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("FinishInitialCandidates"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Fail on the remote object.
     * 
     * Signal an unrecoverable error for this stream, and remove it. If all 
     * streams are removed from a content, then it will also be removed.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param reason
     *     
     *     A structured reason for stream removal.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Fail(const Tp::CallStateReason& reason, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Fail"));
        callMessage << QVariant::fromValue(reason);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c SendingStateChanged on the remote object.
     * 
     * Change notification for SendingState. Note that this information is 
     * duplicated onto the Stream interface, so that UIs can ignore the Media 
     * interface, and streaming implementations can ignore everything but the 
     * media interface.
     *
     * \param state
     *     
     *     The new value of SendingState.
     */
    void SendingStateChanged(uint state);

    /**
     * Represents the signal \c ReceivingStateChanged on the remote object.
     * 
     * Change notification for ReceivingState.
     *
     * \param state
     *     
     *     The new value of ReceivingState.
     */
    void ReceivingStateChanged(uint state);

    /**
     * Represents the signal \c LocalCandidatesAdded on the remote object.
     * 
     * Emitted when local candidates are added to the LocalCandidates property.
     *
     * \param candidates
     *     
     *     Candidates that have been added.
     */
    void LocalCandidatesAdded(const Tp::CandidateList& candidates);

    /**
     * Represents the signal \c LocalCredentialsChanged on the remote object.
     * 
     * Emitted when the value of LocalCredentials changes to a non-empty 
     * value. This should only happen when the streaming implementation calls 
     * SetCredentials, so this signal is mostly useful for debugging.
     */
    void LocalCredentialsChanged(const QString& username, const QString& password);

    /**
     * Represents the signal \c RelayInfoChanged on the remote object.
     * 
     * Emitted when the value of RelayInfo changes.
     */
    void RelayInfoChanged(const Tp::StringVariantMapList& relayInfo);

    /**
     * Represents the signal \c STUNServersChanged on the remote object.
     * 
     * Emitted when the value of STUNServers changes.
     */
    void STUNServersChanged(const Tp::SocketAddressIPList& servers);

    /**
     * Represents the signal \c ServerInfoRetrieved on the remote object.
     * 
     * \htmlonly
     * <p>Signals that the initial information about STUN and Relay servers
     *   has been retrieved, i.e. the
     *    \endhtmlonly \link requestPropertyHasServerInfo() HasServerInfo \endlink \htmlonly  property is
     *   now true.</p>
     * \endhtmlonly
     */
    void ServerInfoRetrieved();

    /**
     * Represents the signal \c EndpointsChanged on the remote object.
     * 
     * Emitted when the Endpoints property changes.
     *
     * \param endpointsAdded
     *     
     *     Endpoints that were added.
     *
     * \param endpointsRemoved
     *     
     *     Endpoints that no longer exist.
     */
    void EndpointsChanged(const Tp::ObjectPathList& endpointsAdded, const Tp::ObjectPathList& endpointsRemoved);

    /**
     * Represents the signal \c ICERestartRequested on the remote object.
     * 
     * Emitted when the remote side requests an ICE restart (e.g. third party 
     * call control, when the remote endpoint changes). The streaming 
     * implementation should call SetCredentials again.
     */
    void ICERestartRequested();

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::CallStreamInterface*)
Q_DECLARE_METATYPE(Tp::Client::CallStreamInterfaceMediaInterface*)
