/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.event.ValuedEventSupport;
import esmska.data.event.ValuedListener;
import esmska.gui.Actions;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;
import org.apache.commons.lang.StringUtils;

public class JHtmlLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    private boolean autoHyperlinkHandling = true;
    private JLabel.AccessibleJLabel acc = null;
    private ValuedEventSupport<Events, String> valuedSupport = new ValuedEventSupport(this);

    public void addValuedListener(ValuedListener<Events, String> valuedListener) {
        this.valuedSupport.addValuedListener(valuedListener);
    }

    public void removeValuedListener(ValuedListener<Events, String> valuedListener) {
        this.valuedSupport.removeValuedListener(valuedListener);
    }

    public JHtmlLabel() {
        this((String)null);
    }

    public JHtmlLabel(String text) {
        super(text);
        this.acc = (JLabel.AccessibleJLabel)this.getAccessibleContext();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setAutoHyperlinkHandling(boolean autoHyperlinkHandling) {
        this.autoHyperlinkHandling = autoHyperlinkHandling;
    }

    public boolean isAutoHyperlinkHandling() {
        return this.autoHyperlinkHandling;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        AttributeSet charAttr = this.acc.getCharacterAttribute(this.acc.getIndexAtPoint(e.getPoint()));
        if (charAttr == null) {
            return;
        }
        AttributeSet attr = (AttributeSet)charAttr.getAttribute(HTML.Tag.A);
        if (attr == null) {
            return;
        }
        String url = (String)attr.getAttribute(HTML.Attribute.HREF);
        if (url != null) {
            this.valuedSupport.fireEventOccured(Events.LINK_CLICKED, url);
            if (this.autoHyperlinkHandling) {
                Actions.getBrowseAction(url).actionPerformed(null);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        AttributeSet charAttr = this.acc.getCharacterAttribute(this.acc.getIndexAtPoint(e.getPoint()));
        AttributeSet attr = null;
        if (charAttr != null) {
            attr = (AttributeSet)charAttr.getAttribute(HTML.Tag.A);
        }
        if (attr == null) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setToolTipText(null);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(12));
            String tooltip = (String)attr.getAttribute(HTML.Attribute.HREF);
            this.setToolTipText(StringUtils.startsWith(tooltip, "esmska://") ? null : tooltip);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public static enum Events {
        LINK_CLICKED;

    }
}

