/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.groovy.scripts;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.gradle.testkit.jarjar.org.gradle.groovy.scripts.AbstractUriScriptSource;
import org.gradle.testkit.jarjar.org.gradle.internal.resource.TextResource;
import org.gradle.testkit.jarjar.org.gradle.internal.resource.UriTextResource;

public class NonExistentFileScriptSource
extends AbstractUriScriptSource {
    private final TextResource resource;
    private final File file;

    public NonExistentFileScriptSource(String description, File file) {
        this.resource = new EmptyFileTextResource(description, file);
        this.file = file;
    }

    public TextResource getResource() {
        return this.resource;
    }

    public String getFileName() {
        return this.file.getAbsolutePath();
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    private static class EmptyFileTextResource
    extends UriTextResource {
        public EmptyFileTextResource(String description, File sourceFile) {
            super(description, sourceFile);
        }

        public boolean isContentCached() {
            return true;
        }

        public boolean getHasEmptyContent() {
            return true;
        }

        public File getFile() {
            return null;
        }

        public Charset getCharset() {
            return null;
        }

        public Reader getAsReader() {
            return new StringReader("");
        }

        public String getText() {
            return "";
        }

        public boolean getExists() {
            return true;
        }
    }
}

