/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Iterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.Rendering;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class AbstractMapRenderer
implements Rendering {
    protected Graphics2D g;
    protected NavigatableComponent nc;
    protected boolean isInactiveMode;
    protected Color backgroundColor;
    protected Color inactiveColor;
    protected Color selectedColor;
    protected Color relationSelectedColor;
    protected Color nodeColor;
    protected Color highlightColor;
    protected int virtualNodeSize;
    protected int virtualNodeSpace;
    protected int segmentNumberSpace;

    public AbstractMapRenderer(Graphics2D graphics2D, NavigatableComponent navigatableComponent, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(graphics2D);
        CheckParameterUtil.ensureParameterNotNull(navigatableComponent);
        this.g = graphics2D;
        this.nc = navigatableComponent;
        this.isInactiveMode = bl;
    }

    public abstract void drawNode(Node var1, Color var2, int var3, boolean var4);

    protected void drawOrderNumber(Point point, Point point2, int n, Color color) {
        if (this.isSegmentVisible(point, point2) && AbstractMapRenderer.isLargeSegment(point, point2, this.segmentNumberSpace)) {
            String string = Integer.toString(n);
            int n2 = string.length();
            int n3 = (point.x + point2.x) / 2 - 4 * n2;
            int n4 = (point.y + point2.y) / 2 + 4;
            if (this.virtualNodeSize != 0 && AbstractMapRenderer.isLargeSegment(point, point2, this.virtualNodeSpace)) {
                n4 = (point.y + point2.y) / 2 - this.virtualNodeSize - 3;
            }
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(n3 - 1, n4 - 12, 8 * n2 + 1, 14);
            this.g.setColor(color);
            this.g.drawString(string, n3, n4);
        }
    }

    public void drawVirtualNodes(DataSet dataSet, BBox bBox) {
        block5: {
            if (this.virtualNodeSize == 0 || dataSet == null || bBox == null) {
                return;
            }
            GeneralPath generalPath = new GeneralPath();
            for (Way comparable : dataSet.searchWays(bBox)) {
                if (!comparable.isUsable() || comparable.isDisabledAndHidden() || comparable.isDisabled()) continue;
                this.visitVirtual(generalPath, comparable);
            }
            this.g.setColor(this.nodeColor);
            this.g.draw(generalPath);
            try {
                generalPath = new GeneralPath();
                for (WaySegment waySegment : dataSet.getHighlightedVirtualNodes()) {
                    if (!waySegment.way.isUsable() || waySegment.way.isDisabled()) continue;
                    this.visitVirtual(generalPath, waySegment.toWay());
                }
                this.g.setColor(this.highlightColor);
                this.g.draw(generalPath);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!Main.isTraceEnabled()) break block5;
                Main.trace(arrayIndexOutOfBoundsException.getMessage());
            }
        }
    }

    public void getColors() {
        this.backgroundColor = PaintColors.BACKGROUND.get();
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.selectedColor = PaintColors.SELECTED.get();
        this.relationSelectedColor = PaintColors.RELATIONSELECTED.get();
        this.nodeColor = PaintColors.NODE.get();
        this.highlightColor = PaintColors.HIGHLIGHT.get();
    }

    protected void getSettings(boolean bl) {
        this.virtualNodeSize = bl ? Main.pref.getInteger("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Main.pref.getInteger("mappaint.segmentnumber.space", 40);
        this.getColors();
    }

    public static boolean isLargeSegment(Point2D point2D, Point2D point2D2, int n) {
        double d;
        double d2 = Math.abs(point2D.getX() - point2D2.getX());
        return d2 + (d = Math.abs(point2D.getY() - point2D2.getY())) > (double)n;
    }

    protected boolean isSegmentVisible(Point point, Point point2) {
        if (point.x < 0 && point2.x < 0) {
            return false;
        }
        if (point.y < 0 && point2.y < 0) {
            return false;
        }
        if (point.x > this.nc.getWidth() && point2.x > this.nc.getWidth()) {
            return false;
        }
        return point.y <= this.nc.getHeight() || point2.y <= this.nc.getHeight();
    }

    public void visitVirtual(GeneralPath generalPath, Way way) {
        Iterator<Node> iterator = way.getNodes().iterator();
        if (iterator.hasNext()) {
            Point point = this.nc.getPoint(iterator.next());
            while (iterator.hasNext()) {
                Point point2 = this.nc.getPoint(iterator.next());
                if (this.isSegmentVisible(point, point2) && AbstractMapRenderer.isLargeSegment(point, point2, this.virtualNodeSpace)) {
                    int n = (point2.x + point.x) / 2;
                    int n2 = (point2.y + point.y) / 2;
                    generalPath.moveTo((float)n - (float)this.virtualNodeSize, n2);
                    generalPath.lineTo((float)n + (float)this.virtualNodeSize, n2);
                    generalPath.moveTo(n, (float)n2 - (float)this.virtualNodeSize);
                    generalPath.lineTo(n, (float)n2 + (float)this.virtualNodeSize);
                }
                point = point2;
            }
        }
    }
}

