/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.CollectionProperty;
import org.openstreetmap.josm.data.preferences.EnumProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.dialogs.properties.RecentTagCollection;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class TagEditHelper {
    private final JTable tagTable;
    private final DefaultTableModel tagData;
    private final Map<String, Map<String, Integer>> valueCount;
    protected Collection<OsmPrimitive> sel;
    private String changedKey;
    private String objKey;
    private final Comparator<AutoCompletionListItem> defaultACItemComparator = new Comparator<AutoCompletionListItem>(){

        @Override
        public int compare(AutoCompletionListItem autoCompletionListItem, AutoCompletionListItem autoCompletionListItem2) {
            return String.CASE_INSENSITIVE_ORDER.compare(autoCompletionListItem.getValue(), autoCompletionListItem2.getValue());
        }
    };
    private String lastAddKey;
    private String lastAddValue;
    public static final int DEFAULT_LRU_TAGS_NUMBER = 5;
    public static final int MAX_LRU_TAGS_NUMBER = 30;
    public static final BooleanProperty PROPERTY_FIX_TAG_LOCALE = new BooleanProperty("properties.fix-tag-combobox-locale", false);
    public static final BooleanProperty PROPERTY_REMEMBER_TAGS = new BooleanProperty("properties.remember-recently-added-tags", true);
    public static final IntegerProperty PROPERTY_RECENT_TAGS_NUMBER = new IntegerProperty("properties.recently-added-tags", 5);
    public static final CollectionProperty PROPERTY_RECENT_TAGS = new CollectionProperty("properties.recent-tags", (Collection<String>)Collections.emptyList());
    public static final StringProperty PROPERTY_TAGS_TO_IGNORE = new StringProperty("properties.recent-tags.ignore", new SearchAction.SearchSetting().writeToString());
    public static final EnumProperty<RecentExisting> PROPERTY_RECENT_EXISTING = new EnumProperty<RecentExisting>("properties.recently-added-tags-existing-key", RecentExisting.class, RecentExisting.DISABLE);
    public static final EnumProperty<RefreshRecent> PROPERTY_REFRESH_RECENT = new EnumProperty<RefreshRecent>("properties.refresh-recently-added-tags", RefreshRecent.class, RefreshRecent.STATUS);
    final RecentTagCollection recentTags = new RecentTagCollection(30);
    SearchAction.SearchSetting tagsToIgnore;
    private List<Tag> tags;

    public TagEditHelper(JTable jTable, DefaultTableModel defaultTableModel, Map<String, Map<String, Integer>> map) {
        this.tagTable = jTable;
        this.tagData = defaultTableModel;
        this.valueCount = map;
    }

    public final String getDataKey(int n) {
        return this.tagData.getValueAt(this.tagTable.convertRowIndexToModel(n), 0).toString();
    }

    public final Map<String, Integer> getDataValues(int n) {
        return (Map)this.tagData.getValueAt(this.tagTable.convertRowIndexToModel(n), 1);
    }

    public void addTag() {
        this.changedKey = null;
        this.sel = Main.main.getInProgressSelection();
        if (this.sel == null || this.sel.isEmpty()) {
            return;
        }
        AddTagsDialog addTagsDialog = this.getAddTagsDialog();
        addTagsDialog.showDialog();
        addTagsDialog.destroyActions();
        if (addTagsDialog.getValue() == 1) {
            addTagsDialog.performTagAdding();
        } else {
            addTagsDialog.undoAllTagsAdding();
        }
    }

    protected AddTagsDialog getAddTagsDialog() {
        return new AddTagsDialog();
    }

    public void editTag(int n, boolean bl) {
        String string;
        this.changedKey = null;
        this.sel = Main.main.getInProgressSelection();
        if (this.sel == null || this.sel.isEmpty()) {
            return;
        }
        this.objKey = string = this.getDataKey(n);
        IEditTagDialog iEditTagDialog = this.getEditTagDialog(n, bl, string);
        iEditTagDialog.showDialog();
        if (iEditTagDialog.getValue() != 1) {
            return;
        }
        iEditTagDialog.performTagEdit();
    }

    protected IEditTagDialog getEditTagDialog(int n, boolean bl, String string) {
        return new EditTagDialog(string, this.getDataValues(n), bl);
    }

    public String getChangedKey() {
        return this.changedKey;
    }

    public void resetChangedKey() {
        this.changedKey = null;
    }

    private static List<String> getAutocompletionKeys(String string) {
        if ("name".equals(string) || "addr:street".equals(string)) {
            return Arrays.asList("addr:street", "name");
        }
        return Arrays.asList(string);
    }

    public void loadTagsIfNeeded() {
        this.loadTagsToIgnore();
        if (PROPERTY_REMEMBER_TAGS.get().booleanValue() && this.recentTags.isEmpty()) {
            this.recentTags.loadFromPreference(PROPERTY_RECENT_TAGS);
        }
    }

    void loadTagsToIgnore() {
        SearchAction.SearchSetting searchSetting = Utils.firstNonNull(SearchAction.SearchSetting.readFromString(PROPERTY_TAGS_TO_IGNORE.get()), new SearchAction.SearchSetting());
        if (!Objects.equals(this.tagsToIgnore, searchSetting)) {
            try {
                this.tagsToIgnore = searchSetting;
                this.recentTags.setTagsToIgnore(this.tagsToIgnore);
            }
            catch (SearchCompiler.ParseError parseError) {
                TagEditHelper.warnAboutParseError(parseError);
                this.tagsToIgnore = new SearchAction.SearchSetting();
                this.recentTags.setTagsToIgnore(SearchCompiler.Never.INSTANCE);
            }
        }
    }

    private static void warnAboutParseError(SearchCompiler.ParseError parseError) {
        Main.warn(parseError);
        JOptionPane.showMessageDialog(Main.parent, parseError.getMessage(), I18n.tr("Error", new Object[0]), 0);
    }

    public void saveTagsIfNeeded() {
        if (PROPERTY_REMEMBER_TAGS.get().booleanValue() && !this.recentTags.isEmpty()) {
            this.recentTags.saveToPreference(PROPERTY_RECENT_TAGS);
        }
    }

    private void cacheRecentTags() {
        this.tags = this.recentTags.toList();
    }

    private static boolean warnOverwriteKey(String string, String string2) {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite key", new Object[0]), new String[]{I18n.tr("Replace", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"purge", "cancel"});
        extendedDialog.setContent(string + '\n' + I18n.tr("The new key is already used, overwrite values?", new Object[0]));
        extendedDialog.setCancelButton(2);
        extendedDialog.toggleEnable(string2);
        extendedDialog.showDialog();
        return extendedDialog.getValue() == 1;
    }

    protected class AddTagsDialog
    extends AbstractTagsDialog {
        private final List<JosmAction> recentTagsActions;
        protected final transient FocusAdapter focus;
        private JPanel mainPanel;
        private JPanel recentTagsPanel;
        private int commandCount;

        protected AddTagsDialog() {
            Object object;
            super(Main.parent, I18n.tr("Add value?", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
            this.recentTagsActions = new ArrayList<JosmAction>();
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setCancelButton(2);
            this.configureContextsensitiveHelp("/Dialog/AddValue", true);
            this.mainPanel = new JPanel(new GridBagLayout());
            this.keys = new AutoCompletingComboBox();
            this.values = new AutoCompletingComboBox();
            this.mainPanel.add((Component)new JLabel("<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()) + "<br><br>" + I18n.tr("Please select a key", new Object[0])), GBC.eol().fill(2));
            AutoCompletionManager autoCompletionManager = Main.main.getEditLayer().data.getAutoCompletionManager();
            List<AutoCompletionListItem> list = autoCompletionManager.getKeys();
            AutoCompletionListItem autoCompletionListItem = null;
            Iterator<AutoCompletionListItem> iterator = list.iterator();
            block0: while (iterator.hasNext()) {
                object = iterator.next();
                if (((AutoCompletionListItem)object).getValue().equals(TagEditHelper.this.lastAddKey)) {
                    autoCompletionListItem = object;
                }
                for (int i = 0; i < TagEditHelper.this.tagData.getRowCount(); ++i) {
                    if (!((AutoCompletionListItem)object).getValue().equals(TagEditHelper.this.tagData.getValueAt(i, 0))) continue;
                    if (autoCompletionListItem == object) {
                        autoCompletionListItem = null;
                    }
                    iterator.remove();
                    continue block0;
                }
            }
            Collections.sort(list, TagEditHelper.this.defaultACItemComparator);
            this.keys.setPossibleACItems(list);
            this.keys.setEditable(true);
            this.mainPanel.add((Component)this.keys, GBC.eop().fill(2));
            this.mainPanel.add((Component)new JLabel(I18n.tr("Please select a value", new Object[0])), GBC.eol());
            this.values.setEditable(true);
            this.mainPanel.add((Component)this.values, GBC.eop().fill(2));
            if (autoCompletionListItem != null) {
                this.keys.setSelectedItem(autoCompletionListItem);
                if (TagEditHelper.this.lastAddValue != null) {
                    this.values.setSelectedItem(TagEditHelper.this.lastAddValue);
                }
            }
            this.focus = this.addFocusAdapter(autoCompletionManager, TagEditHelper.this.defaultACItemComparator);
            this.focus.focusGained(null);
            this.mainPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 1), "addAndContinue");
            this.mainPanel.getActionMap().put("addAndContinue", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddTagsDialog.this.performTagAdding();
                    AddTagsDialog.this.refreshRecentTags();
                    AddTagsDialog.this.selectKeysComboBox();
                }
            });
            TagEditHelper.this.cacheRecentTags();
            this.suggestRecentlyAddedTags();
            this.mainPanel.add(Box.createVerticalGlue(), GBC.eop().fill());
            this.setContent(this.mainPanel, false);
            this.selectKeysComboBox();
            this.popupMenu.add(new AbstractAction(I18n.tr("Set number of recently added tags", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddTagsDialog.this.selectNumberOfTags();
                    AddTagsDialog.this.suggestRecentlyAddedTags();
                }
            });
            this.popupMenu.add(this.buildMenuRecentExisting());
            this.popupMenu.add(this.buildMenuRefreshRecent());
            object = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Remember last used tags after a restart", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
                    PROPERTY_REMEMBER_TAGS.put(bl);
                    if (bl) {
                        TagEditHelper.this.saveTagsIfNeeded();
                    }
                }
            });
            ((JCheckBoxMenuItem)object).setState(PROPERTY_REMEMBER_TAGS.get());
            this.popupMenu.add((JMenuItem)object);
        }

        private JMenu buildMenuRecentExisting() {
            JMenu jMenu = new JMenu(I18n.tr("Recent tags with existing key", new Object[0]));
            TreeMap<RecentExisting, String> treeMap = new TreeMap<RecentExisting, String>();
            treeMap.put(RecentExisting.ENABLE, I18n.tr("Enable", new Object[0]));
            treeMap.put(RecentExisting.DISABLE, I18n.tr("Disable", new Object[0]));
            treeMap.put(RecentExisting.HIDE, I18n.tr("Hide", new Object[0]));
            ButtonGroup buttonGroup = new ButtonGroup();
            for (final Map.Entry entry : treeMap.entrySet()) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction((String)entry.getValue()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PROPERTY_RECENT_EXISTING.put((RecentExisting)((Enum)entry.getKey()), new String[0]);
                        AddTagsDialog.this.suggestRecentlyAddedTags();
                    }
                });
                buttonGroup.add(jRadioButtonMenuItem);
                jRadioButtonMenuItem.setSelected(PROPERTY_RECENT_EXISTING.get(new String[0]) == entry.getKey());
                jMenu.add(jRadioButtonMenuItem);
            }
            return jMenu;
        }

        private JMenu buildMenuRefreshRecent() {
            JMenu jMenu = new JMenu(I18n.tr("Refresh recent tags list after applying tag", new Object[0]));
            TreeMap<RefreshRecent, String> treeMap = new TreeMap<RefreshRecent, String>();
            treeMap.put(RefreshRecent.NO, I18n.tr("No refresh", new Object[0]));
            treeMap.put(RefreshRecent.STATUS, I18n.tr("Refresh tag status only (enabled / disabled)", new Object[0]));
            treeMap.put(RefreshRecent.REFRESH, I18n.tr("Refresh tag status and list of recently added tags", new Object[0]));
            ButtonGroup buttonGroup = new ButtonGroup();
            for (final Map.Entry entry : treeMap.entrySet()) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction((String)entry.getValue()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PROPERTY_REFRESH_RECENT.put((RefreshRecent)((Enum)entry.getKey()), new String[0]);
                    }
                });
                buttonGroup.add(jRadioButtonMenuItem);
                jRadioButtonMenuItem.setSelected(PROPERTY_REFRESH_RECENT.get(new String[0]) == entry.getKey());
                jMenu.add(jRadioButtonMenuItem);
            }
            return jMenu;
        }

        @Override
        public void setContentPane(Container container) {
            int n = GuiHelper.getMenuShortcutKeyMaskEx();
            ArrayList<String> arrayList = new ArrayList<String>();
            Shortcut shortcut = Shortcut.findShortcut(49, n);
            if (shortcut != null) {
                arrayList.add(shortcut.getKeyText() + ' ' + I18n.tr("to apply first suggestion", new Object[0]));
            }
            arrayList.add(KeyEvent.getKeyModifiersText(1) + '+' + KeyEvent.getKeyText(10) + ' ' + I18n.tr("to add without closing the dialog", new Object[0]));
            shortcut = Shortcut.findShortcut(49, n | 0x40);
            if (shortcut != null) {
                arrayList.add(shortcut.getKeyText() + ' ' + I18n.tr("to add first suggestion without closing the dialog", new Object[0]));
            }
            JLabel jLabel = new JLabel("<html>" + Utils.join("<br>", arrayList) + "</html>");
            jLabel.setFont(jLabel.getFont().deriveFont(0));
            container.add((Component)jLabel, GBC.eol().fill(2).insets(5, 5, 5, 5));
            super.setContentPane(container);
        }

        protected void selectNumberOfTags() {
            String string = String.format("%d", PROPERTY_RECENT_TAGS_NUMBER.get());
            while ((string = JOptionPane.showInputDialog(this, I18n.tr("Please enter the number of recently added tags to display", new Object[0]), string)) != null) {
                try {
                    int n = Integer.parseInt(string);
                    if (n >= 0 && n <= 30) {
                        PROPERTY_RECENT_TAGS_NUMBER.put(n);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Main.warn(numberFormatException);
                }
                JOptionPane.showMessageDialog(this, I18n.tr("Please enter integer number between 0 and {0}", 30));
            }
            return;
        }

        protected void suggestRecentlyAddedTags() {
            if (this.recentTagsPanel == null) {
                this.recentTagsPanel = new JPanel(new GridBagLayout());
                this.buildRecentTagsPanel();
                this.mainPanel.add((Component)this.recentTagsPanel, GBC.eol().fill(2));
            } else {
                Dimension dimension = this.recentTagsPanel.getPreferredSize();
                this.recentTagsPanel.removeAll();
                this.buildRecentTagsPanel();
                Dimension dimension2 = this.recentTagsPanel.getPreferredSize();
                Dimension dimension3 = this.getMinimumSize();
                Dimension dimension4 = new Dimension(dimension3.width, dimension3.height - dimension.height + dimension2.height);
                this.setMinimumSize(dimension4);
                this.setPreferredSize(dimension4);
                this.setSize(dimension4);
                this.revalidate();
                this.repaint();
            }
        }

        protected void buildRecentTagsPanel() {
            int n = Math.min(PROPERTY_RECENT_TAGS_NUMBER.get(), 30);
            if (n <= 0 || TagEditHelper.this.recentTags.isEmpty()) {
                return;
            }
            this.recentTagsPanel.add((Component)new JLabel(I18n.tr("Recently added tags", new Object[0])), GBC.eol());
            int n2 = 0;
            this.destroyActions();
            for (int i = TagEditHelper.this.tags.size() - 1; i >= 0 && n2 < n; --i) {
                Serializable serializable;
                Object object;
                Cloneable cloneable;
                ImageIcon imageIcon;
                final Tag tag = (Tag)TagEditHelper.this.tags.get(i);
                boolean bl = this.keyExists(tag);
                if (bl && PROPERTY_RECENT_EXISTING.get(new String[0]) == RecentExisting.HIDE) continue;
                Shortcut shortcut = ++n2 > 10 ? null : Shortcut.registerShortcut("properties:recent:" + n2, I18n.tr("Choose recent tag {0}", n2), 48 + n2 % 10, 5006);
                final JosmAction josmAction = new JosmAction(I18n.tr("Choose recent tag {0}", n2), null, I18n.tr("Use this tag again", new Object[0]), shortcut, false){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AddTagsDialog.this.keys.setSelectedItem(tag.getKey());
                        AddTagsDialog.this.focus.focusGained(null);
                        AddTagsDialog.this.values.setSelectedItem(tag.getValue());
                        AddTagsDialog.this.selectValuesCombobox();
                    }
                };
                Shortcut shortcut2 = n2 > 10 ? null : Shortcut.registerShortcut("properties:recent:apply:" + n2, I18n.tr("Apply recent tag {0}", n2), 48 + n2 % 10, 5009);
                JosmAction josmAction2 = new JosmAction(I18n.tr("Apply recent tag {0}", n2), null, I18n.tr("Use this tag again", new Object[0]), shortcut2, false){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        josmAction.actionPerformed(null);
                        AddTagsDialog.this.performTagAdding();
                        AddTagsDialog.this.refreshRecentTags();
                        AddTagsDialog.this.selectKeysComboBox();
                    }
                };
                this.recentTagsActions.add(josmAction);
                this.recentTagsActions.add(josmAction2);
                if (bl && PROPERTY_RECENT_EXISTING.get(new String[0]) == RecentExisting.DISABLE) {
                    josmAction.setEnabled(false);
                }
                if ((imageIcon = MapPaintStyles.getNodeIcon(tag, false)) == null) {
                    cloneable = new HashMap();
                    cloneable.put(tag.getKey(), tag.getValue());
                    object = TaggingPresets.getMatchingPresets(null, (Map<String, String>)((Object)cloneable), false).iterator();
                    while (object.hasNext() && (imageIcon = ((TaggingPreset)(serializable = object.next())).getIcon()) == null) {
                    }
                    if (imageIcon == null) {
                        imageIcon = new ImageIcon(new BufferedImage(16, 16, 2));
                    }
                }
                cloneable = new GridBagConstraints();
                ((GridBagConstraints)cloneable).ipadx = 5;
                this.recentTagsPanel.add((Component)new JLabel(josmAction.isEnabled() ? imageIcon : GuiHelper.getDisabledIcon(imageIcon)), cloneable);
                object = josmAction.isEnabled() ? "" : "; color:gray";
                serializable = new JLabel("<html><style>td{" + (String)object + "}</style>" + "<table><tr>" + "<td>" + n2 + ".</td>" + "<td style='border:1px solid gray'>" + XmlWriter.encode(tag.toString(), true) + '<' + "/td></tr></table></html>");
                ((JComponent)serializable).setFont(((Component)serializable).getFont().deriveFont(0));
                if (josmAction.isEnabled() && shortcut != null && shortcut2 != null) {
                    this.recentTagsPanel.getInputMap(2).put(shortcut.getKeyStroke(), "choose" + n2);
                    this.recentTagsPanel.getActionMap().put("choose" + n2, josmAction);
                    this.recentTagsPanel.getInputMap(2).put(shortcut2.getKeyStroke(), "apply" + n2);
                    this.recentTagsPanel.getActionMap().put("apply" + n2, josmAction2);
                }
                if (josmAction.isEnabled()) {
                    ((JComponent)serializable).setToolTipText((String)josmAction.getValue("ShortDescription"));
                    ((Component)serializable).setCursor(Cursor.getPredefinedCursor(12));
                    ((Component)serializable).addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            josmAction.actionPerformed(null);
                            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                                new TagPopupMenu(tag).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            } else if (mouseEvent.isShiftDown()) {
                                AddTagsDialog.this.performTagAdding();
                                AddTagsDialog.this.refreshRecentTags();
                                AddTagsDialog.this.selectKeysComboBox();
                            } else if (mouseEvent.getClickCount() > 1) {
                                AddTagsDialog.this.buttonAction(0, null);
                            }
                        }
                    });
                } else {
                    ((JComponent)serializable).setEnabled(false);
                    ((JComponent)serializable).setToolTipText(I18n.tr("The key ''{0}'' is already used", tag.getKey()));
                }
                JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
                jPanel.add((Component)serializable);
                this.recentTagsPanel.add((Component)jPanel, GBC.eol().fill(2));
            }
            if (n2 == 0) {
                this.recentTagsPanel.removeAll();
            }
        }

        public void destroyActions() {
            for (JosmAction josmAction : this.recentTagsActions) {
                josmAction.destroy();
            }
        }

        public final void performTagAdding() {
            String string = Tag.removeWhiteSpaces(this.keys.getEditor().getItem().toString());
            String string2 = Tag.removeWhiteSpaces(this.values.getEditor().getItem().toString());
            if (string.isEmpty() || string2.isEmpty()) {
                return;
            }
            for (OsmPrimitive osmPrimitive : TagEditHelper.this.sel) {
                String string3 = osmPrimitive.get(string);
                if (string3 == null || string3.equals(string2)) continue;
                if (TagEditHelper.warnOverwriteKey(I18n.tr("You changed the value of ''{0}'' from ''{1}'' to ''{2}''.", string, string3, string2), "overwriteAddKey")) break;
                return;
            }
            TagEditHelper.this.lastAddKey = string;
            TagEditHelper.this.lastAddValue = string2;
            TagEditHelper.this.recentTags.add(new Tag(string, string2));
            TagEditHelper.this.valueCount.put(string, new TreeMap());
            AutoCompletionManager.rememberUserInput(string, string2, false);
            ++this.commandCount;
            Main.main.undoRedo.add(new ChangePropertyCommand(TagEditHelper.this.sel, string, string2));
            TagEditHelper.this.changedKey = string;
            this.clearEntries();
        }

        protected void clearEntries() {
            this.keys.getEditor().setItem("");
            this.values.getEditor().setItem("");
        }

        public void undoAllTagsAdding() {
            Main.main.undoRedo.undo(this.commandCount);
        }

        private boolean keyExists(Tag tag) {
            return TagEditHelper.this.valueCount.containsKey(tag.getKey());
        }

        private void refreshRecentTags() {
            switch ((RefreshRecent)((Object)PROPERTY_REFRESH_RECENT.get(new String[0]))) {
                case REFRESH: {
                    TagEditHelper.this.cacheRecentTags();
                }
                case STATUS: {
                    this.suggestRecentlyAddedTags();
                    break;
                }
            }
        }

        class EditIgnoreTagsAction
        extends AbstractAction {
            EditIgnoreTagsAction() {
                super(I18n.tr("Edit ignore list", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchAction.SearchSetting searchSetting = SearchAction.showSearchDialog(TagEditHelper.this.tagsToIgnore);
                if (searchSetting == null) {
                    return;
                }
                try {
                    TagEditHelper.this.tagsToIgnore = searchSetting;
                    TagEditHelper.this.recentTags.setTagsToIgnore(TagEditHelper.this.tagsToIgnore);
                    PROPERTY_TAGS_TO_IGNORE.put(TagEditHelper.this.tagsToIgnore.writeToString());
                }
                catch (SearchCompiler.ParseError parseError) {
                    TagEditHelper.warnAboutParseError(parseError);
                }
            }
        }

        class IgnoreTagAction
        extends AbstractAction {
            final transient Tag tag;

            IgnoreTagAction(String string, Tag tag) {
                super(string);
                this.tag = tag;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (TagEditHelper.this.tagsToIgnore != null) {
                        TagEditHelper.this.recentTags.ignoreTag(this.tag, TagEditHelper.this.tagsToIgnore);
                        PROPERTY_TAGS_TO_IGNORE.put(TagEditHelper.this.tagsToIgnore.writeToString());
                    }
                }
                catch (SearchCompiler.ParseError parseError) {
                    throw new IllegalStateException(parseError);
                }
            }
        }

        class TagPopupMenu
        extends JPopupMenu {
            TagPopupMenu(Tag tag) {
                this.add(new IgnoreTagAction(I18n.tr("Ignore key ''{0}''", tag.getKey()), new Tag(tag.getKey(), "")));
                this.add(new IgnoreTagAction(I18n.tr("Ignore tag ''{0}''", tag), tag));
                this.add(new EditIgnoreTagsAction());
            }
        }
    }

    protected abstract class AbstractTagsDialog
    extends ExtendedDialog {
        protected AutoCompletingComboBox keys;
        protected AutoCompletingComboBox values;
        protected JPopupMenu popupMenu;

        AbstractTagsDialog(Component component, String string, String[] stringArray) {
            super(component, string, stringArray);
            this.popupMenu = new JPopupMenu(){
                private final JCheckBoxMenuItem fixTagLanguageCb = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Use English language for tag by default", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
                        PROPERTY_FIX_TAG_LOCALE.put(bl);
                        AbstractTagsDialog.this.keys.setFixedLocale(bl);
                    }
                });
                {
                    this.add(this.fixTagLanguageCb);
                    this.fixTagLanguageCb.setState(PROPERTY_FIX_TAG_LOCALE.get());
                }
            };
            this.addMouseListener(new PopupMenuLauncher(this.popupMenu));
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            Dimension dimension = this.getSize();
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, dimension));
        }

        @Override
        public void setVisible(boolean bl) {
            if (bl) {
                Dimension dimension;
                WindowGeometry windowGeometry = this.initWindowGeometry();
                Dimension dimension2 = windowGeometry.getSize();
                if (!dimension2.equals(dimension = this.getSize())) {
                    if (dimension2.width < dimension.width) {
                        dimension2.width = dimension.width;
                    }
                    if (dimension2.height != dimension.height) {
                        dimension2.height = dimension.height;
                    }
                    this.rememberWindowGeometry(windowGeometry);
                }
                this.keys.setFixedLocale(PROPERTY_FIX_TAG_LOCALE.get());
            }
            super.setVisible(bl);
        }

        private void selectACComboBoxSavingUnixBuffer(AutoCompletingComboBox autoCompletingComboBox) {
            Clipboard clipboard = GuiHelper.getSystemSelection();
            if (clipboard != null) {
                Transferable transferable = Utils.getTransferableContent(clipboard);
                autoCompletingComboBox.requestFocusInWindow();
                autoCompletingComboBox.getEditor().selectAll();
                if (transferable != null) {
                    clipboard.setContents(transferable, null);
                }
            } else {
                autoCompletingComboBox.requestFocusInWindow();
                autoCompletingComboBox.getEditor().selectAll();
            }
        }

        public void selectKeysComboBox() {
            this.selectACComboBoxSavingUnixBuffer(this.keys);
        }

        public void selectValuesCombobox() {
            this.selectACComboBoxSavingUnixBuffer(this.values);
        }

        protected FocusAdapter addFocusAdapter(final AutoCompletionManager autoCompletionManager, final Comparator<AutoCompletionListItem> comparator) {
            JTextField jTextField = this.values.getEditorComponent();
            FocusAdapter focusAdapter = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    String string = AbstractTagsDialog.this.keys.getEditor().getItem().toString();
                    List<AutoCompletionListItem> list = autoCompletionManager.getValues(TagEditHelper.getAutocompletionKeys(string));
                    Collections.sort(list, comparator);
                    if (Main.isTraceEnabled()) {
                        Main.trace("Focus gained by {0}, e={1}", AbstractTagsDialog.this.values, focusEvent);
                    }
                    AbstractTagsDialog.this.values.setPossibleACItems(list);
                    AbstractTagsDialog.this.values.getEditor().selectAll();
                    TagEditHelper.this.objKey = string;
                }
            };
            jTextField.addFocusListener(focusAdapter);
            return focusAdapter;
        }
    }

    protected class EditTagDialog
    extends AbstractTagsDialog
    implements IEditTagDialog {
        private final String key;
        private final transient Map<String, Integer> m;
        private final transient Comparator<AutoCompletionListItem> usedValuesAwareComparator;
        private final transient ListCellRenderer<AutoCompletionListItem> cellRenderer;

        protected EditTagDialog(String string, Map<String, Integer> map, final boolean bl) {
            super(Main.parent, I18n.trn("Change value?", "Change values?", map.size(), new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
            this.usedValuesAwareComparator = new Comparator<AutoCompletionListItem>(){

                @Override
                public int compare(AutoCompletionListItem autoCompletionListItem, AutoCompletionListItem autoCompletionListItem2) {
                    boolean bl;
                    boolean bl2 = EditTagDialog.this.m.containsKey(autoCompletionListItem.getValue());
                    if (bl2 == (bl = EditTagDialog.this.m.containsKey(autoCompletionListItem2.getValue()))) {
                        return String.CASE_INSENSITIVE_ORDER.compare(autoCompletionListItem.getValue(), autoCompletionListItem2.getValue());
                    }
                    if (bl2) {
                        return -1;
                    }
                    return 1;
                }
            };
            this.cellRenderer = new ListCellRenderer<AutoCompletionListItem>(){
                private final DefaultListCellRenderer def = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends AutoCompletionListItem> jList, AutoCompletionListItem autoCompletionListItem, int n, boolean bl, boolean bl2) {
                    Component component = this.def.getListCellRendererComponent(jList, autoCompletionListItem, n, bl, bl2);
                    if (component instanceof JLabel) {
                        Map map;
                        String string = autoCompletionListItem.getValue();
                        if (TagEditHelper.this.valueCount.containsKey(TagEditHelper.this.objKey) && (map = (Map)TagEditHelper.this.valueCount.get(TagEditHelper.this.objKey)).containsKey(string)) {
                            string = I18n.tr("{0} ({1})", string, map.get(string));
                            component.setFont(component.getFont().deriveFont(3));
                        }
                        ((JLabel)component).setText(string);
                    }
                    return component;
                }
            };
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setCancelButton(2);
            this.configureContextsensitiveHelp("/Dialog/EditValue", true);
            this.key = string;
            this.m = map;
            JPanel jPanel = new JPanel(new BorderLayout());
            String string2 = "<html>" + I18n.trn("This will change {0} object.", "This will change up to {0} objects.", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()) + "<br><br>(" + I18n.tr("An empty value deletes the tag.", string) + ")</html>";
            jPanel.add((Component)new JLabel(string2), "North");
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel.add((Component)jPanel2, "Center");
            AutoCompletionManager autoCompletionManager = Main.main.getEditLayer().data.getAutoCompletionManager();
            List<AutoCompletionListItem> list = autoCompletionManager.getKeys();
            Collections.sort(list, TagEditHelper.this.defaultACItemComparator);
            this.keys = new AutoCompletingComboBox(string);
            this.keys.setPossibleACItems(list);
            this.keys.setEditable(true);
            this.keys.setSelectedItem(string);
            jPanel2.add(Box.createVerticalStrut(5), GBC.eol());
            jPanel2.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std());
            jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
            jPanel2.add((Component)this.keys, GBC.eol().fill(2));
            List<AutoCompletionListItem> list2 = autoCompletionManager.getValues(TagEditHelper.getAutocompletionKeys(string));
            Collections.sort(list2, this.usedValuesAwareComparator);
            String string3 = this.m.size() != 1 ? I18n.tr("<different>", new Object[0]) : this.m.entrySet().iterator().next().getKey();
            this.values = new AutoCompletingComboBox(string3);
            this.values.setRenderer(this.cellRenderer);
            this.values.setEditable(true);
            this.values.setPossibleACItems(list2);
            this.values.setSelectedItem(string3);
            this.values.getEditor().setItem(string3);
            jPanel2.add(Box.createVerticalStrut(5), GBC.eol());
            jPanel2.add((Component)new JLabel(I18n.tr("Value", new Object[0])), GBC.std());
            jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
            jPanel2.add((Component)this.values, GBC.eol().fill(2));
            this.values.getEditor().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditTagDialog.this.buttonAction(0, null);
                }
            });
            this.addFocusAdapter(autoCompletionManager, this.usedValuesAwareComparator);
            this.setContent(jPanel, false);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    if (bl) {
                        EditTagDialog.this.selectKeysComboBox();
                    } else {
                        EditTagDialog.this.selectValuesCombobox();
                    }
                }
            });
        }

        @Override
        public void performTagEdit() {
            String string = Tag.removeWhiteSpaces(this.values.getEditor().getItem().toString());
            if ((string = Normalizer.normalize(string, Normalizer.Form.NFC)).isEmpty()) {
                string = null;
            }
            String string2 = Tag.removeWhiteSpaces(this.keys.getEditor().getItem().toString());
            if ((string2 = Normalizer.normalize(string2, Normalizer.Form.NFC)).isEmpty()) {
                string2 = this.key;
                string = null;
            }
            if (this.key.equals(string2) && I18n.tr("<different>", new Object[0]).equals(string)) {
                return;
            }
            if (this.key.equals(string2) || string == null) {
                Main.main.undoRedo.add(new ChangePropertyCommand(TagEditHelper.this.sel, string2, string));
                AutoCompletionManager.rememberUserInput(string2, string, true);
            } else {
                for (OsmPrimitive object : TagEditHelper.this.sel) {
                    if (object.get(string2) == null) continue;
                    if (TagEditHelper.warnOverwriteKey(I18n.tr("You changed the key from ''{0}'' to ''{1}''.", this.key, string2), "overwriteEditKey")) break;
                    return;
                }
                ArrayList arrayList = new ArrayList();
                arrayList.add(new ChangePropertyCommand(TagEditHelper.this.sel, this.key, null));
                if (string.equals(I18n.tr("<different>", new Object[0]))) {
                    HashMap hashMap = new HashMap();
                    for (OsmPrimitive osmPrimitive : TagEditHelper.this.sel) {
                        String string3 = osmPrimitive.get(this.key);
                        if (string3 == null) continue;
                        if (hashMap.containsKey(string3)) {
                            ((List)hashMap.get(string3)).add(osmPrimitive);
                            continue;
                        }
                        ArrayList<OsmPrimitive> arrayList2 = new ArrayList<OsmPrimitive>();
                        arrayList2.add(osmPrimitive);
                        hashMap.put(string3, arrayList2);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        arrayList.add(new ChangePropertyCommand((Collection)entry.getValue(), string2, (String)entry.getKey()));
                    }
                } else {
                    arrayList.add(new ChangePropertyCommand(TagEditHelper.this.sel, string2, string));
                    AutoCompletionManager.rememberUserInput(string2, string, false);
                }
                Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Change properties of up to {0} object", "Change properties of up to {0} objects", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()), arrayList));
            }
            TagEditHelper.this.changedKey = string2;
        }
    }

    protected static interface IEditTagDialog {
        public ExtendedDialog showDialog();

        public int getValue();

        public void performTagEdit();
    }

    private static enum RefreshRecent {
        NO,
        STATUS,
        REFRESH;

    }

    private static enum RecentExisting {
        ENABLE,
        DISABLE,
        HIDE;

    }
}

