/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.text.Bidi;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Utils {
    public static final Pattern WHITE_SPACES_PATTERN = Pattern.compile("\\s+");
    private static final int MILLIS_OF_SECOND = 1000;
    private static final int MILLIS_OF_MINUTE = 60000;
    private static final int MILLIS_OF_HOUR = 3600000;
    private static final int MILLIS_OF_DAY = 86400000;
    public static final String URL_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*+,;=%";
    private static final char[] DEFAULT_STRIP = new char[]{'\u200b', '\ufeff'};
    private static final String[] SIZE_UNITS = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
    private static final double EPSILON = 1.0E-11;
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Utils() {
    }

    public static <T> boolean exists(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
        for (T t : iterable) {
            if (!predicate.evaluate(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean forAll(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
        return !Utils.exists(iterable, Predicates.not(predicate));
    }

    public static <T> boolean exists(Iterable<T> iterable, Class<? extends T> clazz) {
        return Utils.exists(iterable, Predicates.isInstanceOf(clazz));
    }

    public static <T> T find(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
        for (T t : iterable) {
            if (!predicate.evaluate(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> T find(Iterable<? extends Object> iterable, Class<? extends T> clazz) {
        return Utils.find(iterable, Predicates.isInstanceOf(clazz));
    }

    public static <T> Collection<T> filter(Collection<? extends T> collection, Predicate<? super T> predicate) {
        return new FilteredCollection<T>(collection, predicate);
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... TArray) {
        for (T t : TArray) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <S, T extends S> SubclassFilteredCollection<S, T> filteredCollection(Collection<S> collection, Class<T> clazz) {
        return new SubclassFilteredCollection(collection, Predicates.isInstanceOf(clazz));
    }

    public static <T> int indexOf(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
        int n = 0;
        for (T t : iterable) {
            if (predicate.evaluate(t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int min(int n, int n2, int n3) {
        if (n2 < n3) {
            if (n < n2) {
                return n;
            }
            return n2;
        }
        if (n < n3) {
            return n;
        }
        return n3;
    }

    public static int max(int n, int n2, int n3, int n4) {
        return Math.max(Math.max(n, n2), Math.max(n3, n4));
    }

    public static void ensure(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new AssertionError((Object)MessageFormat.format(string, objectArray));
        }
    }

    public static int mod(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("n must be <= 0 but is " + n2);
        }
        int n3 = n % n2;
        if (n3 < 0) {
            n3 += n2;
        }
        return n3;
    }

    public static String join(String string, Collection<?> collection) {
        CheckParameterUtil.ensureParameterNotNull(string, "sep");
        if (collection == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (Object object : collection) {
            if (object == null) {
                object = "";
            }
            if (stringBuilder != null) {
                stringBuilder.append(string).append(object);
                continue;
            }
            stringBuilder = new StringBuilder(object.toString());
        }
        return stringBuilder != null ? stringBuilder.toString() : "";
    }

    public static String joinAsHtmlUnorderedList(Iterable<?> iterable) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("<ul>");
        for (Object obj : iterable) {
            stringBuilder.append("<li>").append(obj).append("</li>");
        }
        stringBuilder.append("</ul>");
        return stringBuilder.toString();
    }

    public static String toString(Color color) {
        if (color == null) {
            return "null";
        }
        if (color.getAlpha() == 255) {
            return String.format("#%06x", color.getRGB() & 0xFFFFFF);
        }
        return String.format("#%06x(alpha=%d)", color.getRGB() & 0xFFFFFF, color.getAlpha());
    }

    public static Integer color_float2int(Float f) {
        if (f == null) {
            return null;
        }
        if (f.floatValue() < 0.0f || f.floatValue() > 1.0f) {
            return 255;
        }
        return (int)(255.0f * f.floatValue() + 0.5f);
    }

    public static Float color_int2float(Integer n) {
        if (n == null) {
            return null;
        }
        if (n < 0 || n > 255) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf((float)n.intValue() / 255.0f);
    }

    public static Color complement(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static <T> T[] copyArray(T[] TArray) {
        if (TArray != null) {
            return Arrays.copyOf(TArray, TArray.length);
        }
        return null;
    }

    public static char[] copyArray(char[] cArray) {
        if (cArray != null) {
            return Arrays.copyOf(cArray, cArray.length);
        }
        return null;
    }

    public static int[] copyArray(int[] nArray) {
        if (nArray != null) {
            return Arrays.copyOf(nArray, nArray.length);
        }
        return null;
    }

    public static Path copyFile(File file, File file2) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(file, "in");
        CheckParameterUtil.ensureParameterNotNull(file2, "out");
        return Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        File[] fileArray;
        CheckParameterUtil.ensureParameterNotNull(file, "in");
        CheckParameterUtil.ensureParameterNotNull(file2, "out");
        if (!file2.exists() && !file2.mkdirs()) {
            Main.warn("Unable to create directory " + file2.getPath());
        }
        if ((fileArray = file.listFiles()) != null) {
            for (File file3 : fileArray) {
                File file4 = new File(file2, file3.getName());
                if (file3.isDirectory()) {
                    Utils.copyDirectory(file3, file4);
                    continue;
                }
                Utils.copyFile(file3, file4);
            }
        }
    }

    public static boolean deleteDirectory(File file) {
        File[] fileArray;
        if (file.exists() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    Utils.deleteDirectory(file2);
                    continue;
                }
                Utils.deleteFile(file2);
            }
        }
        return file.delete();
    }

    public static boolean deleteFile(File file) {
        return Utils.deleteFile(file, I18n.marktr("Unable to delete file {0}"));
    }

    public static boolean deleteFile(File file, String string) {
        boolean bl = file.delete();
        if (!bl) {
            Main.warn(I18n.tr(string, file.getPath()));
        }
        return bl;
    }

    public static boolean mkDirs(File file) {
        return Utils.mkDirs(file, I18n.marktr("Unable to create directory {0}"));
    }

    public static boolean mkDirs(File file, String string) {
        boolean bl = file.mkdirs();
        if (!bl) {
            Main.warn(I18n.tr(string, file.getPath()));
        }
        return bl;
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            Main.warn(iOException);
        }
    }

    public static void close(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            Main.warn(iOException);
        }
    }

    public static URL fileToURL(File file) {
        if (file != null) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                Main.error("Unable to convert filename " + file.getAbsolutePath() + " to URL");
            }
        }
        return null;
    }

    public static boolean equalsEpsilon(double d, double d2) {
        return Math.abs(d - d2) <= 1.0E-11;
    }

    public static boolean equalCollection(Collection<?> collection, Collection<?> collection2) {
        if (collection == null) {
            return collection2 == null;
        }
        if (collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        Iterator<?> iterator = collection.iterator();
        Iterator<?> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            if (Objects.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean copyToClipboard(String string) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            });
            return true;
        }
        catch (HeadlessException | IllegalStateException runtimeException) {
            Main.error(runtimeException);
            return false;
        }
    }

    public static Transferable getTransferableContent(Clipboard clipboard) {
        Transferable transferable = null;
        for (int i = 0; transferable == null && i < 10; ++i) {
            try {
                transferable = clipboard.getContents(null);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    Main.warn("InterruptedException in " + Utils.class.getSimpleName() + " while getting clipboard content");
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                Main.error(nullPointerException);
            }
        }
        return transferable;
    }

    public static String getClipboardContent() {
        try {
            Transferable transferable = Utils.getTransferableContent(Toolkit.getDefaultToolkit().getSystemClipboard());
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (HeadlessException | UnsupportedFlavorException | IOException exception) {
            Main.error(exception);
            return null;
        }
        return null;
    }

    public static String md5Hex(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = messageDigest.digest(byArray);
        return Utils.toHexString(byArray2);
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        int n = byArray.length;
        if (n == 0) {
            return "";
        }
        char[] cArray = new char[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            cArray[n2++] = HEX_ARRAY[(by & 0xF0) >> 4];
            cArray[n2++] = HEX_ARRAY[by & 0xF];
        }
        return new String(cArray);
    }

    public static <T> List<T> topologicalSort(MultiMap<T, T> multiMap) {
        Object object2;
        MultiMap multiMap2 = new MultiMap();
        for (Object object2 : multiMap.keySet()) {
            multiMap2.putVoid(object2);
            for (Object b : multiMap.get(object2)) {
                multiMap2.putVoid(b);
                multiMap2.put(object2, b);
            }
        }
        int n = multiMap2.size();
        object2 = new ArrayList();
        for (int i = 0; i < n; ++i) {
            Object b;
            b = null;
            for (Object a : multiMap2.keySet()) {
                if (!multiMap2.get(a).isEmpty()) continue;
                b = a;
                break;
            }
            if (b == null) {
                throw new RuntimeException();
            }
            object2.add(b);
            multiMap2.remove(b);
            for (Object a : multiMap2.keySet()) {
                multiMap2.remove(a, b);
            }
        }
        if (object2.size() != n) {
            throw new RuntimeException();
        }
        return object2;
    }

    public static String escapeReservedCharactersHTML(String string) {
        return string == null ? "" : string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static <A, B> Collection<B> transform(final Collection<? extends A> collection, final Function<A, B> function) {
        return new AbstractCollection<B>(){

            @Override
            public int size() {
                return collection.size();
            }

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(){
                    private Iterator<? extends A> it;
                    {
                        this.it = collection.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public B next() {
                        return function.apply(this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <A, B> List<B> transform(final List<? extends A> list, final Function<A, B> function) {
        return new AbstractList<B>(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public B get(int n) {
                return function.apply(list.get(n));
            }
        };
    }

    public static BZip2CompressorInputStream getBZip2InputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return new BZip2CompressorInputStream(inputStream, true);
    }

    public static GZIPInputStream getGZipInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return new GZIPInputStream(inputStream);
    }

    public static ZipInputStream getZipInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream, StandardCharsets.UTF_8);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry != null && Main.isDebugEnabled()) {
            Main.debug("Zip entry: " + zipEntry.getName());
        }
        return zipInputStream;
    }

    public static String strip(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return Utils.strip(string, DEFAULT_STRIP);
    }

    public static String strip(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return Utils.strip(string, Utils.stripChars(string2));
    }

    private static String strip(String string, char[] cArray) {
        char c;
        int n = 0;
        int n2 = string.length();
        boolean bl = true;
        while (bl && n < n2) {
            c = string.charAt(n);
            bl = Character.isWhitespace(c) || Character.isSpaceChar(c) || Utils.stripChar(cArray, c);
            if (!bl) continue;
            ++n;
        }
        c = '\u0001';
        while (c != '\u0000' && n2 > n + 1) {
            char c2 = string.charAt(n2 - 1);
            c = Character.isWhitespace(c2) || Character.isSpaceChar(c2) || Utils.stripChar(cArray, c2) ? (char)'\u0001' : '\u0000';
            if (c == '\u0000') continue;
            --n2;
        }
        return string.substring(n, n2);
    }

    private static char[] stripChars(String string) {
        if (string == null || string.isEmpty()) {
            return DEFAULT_STRIP;
        }
        char[] cArray = new char[DEFAULT_STRIP.length + string.length()];
        System.arraycopy(DEFAULT_STRIP, 0, cArray, 0, DEFAULT_STRIP.length);
        string.getChars(0, string.length(), cArray, DEFAULT_STRIP.length);
        return cArray;
    }

    private static boolean stripChar(char[] cArray, char c) {
        for (char c2 : cArray) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    public static String execOutput(List<String> list) throws IOException {
        if (Main.isDebugEnabled()) {
            Main.debug(Utils.join(" ", list));
        }
        Process process = new ProcessBuilder(list).start();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String string;
            StringBuilder stringBuilder = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string);
                    continue;
                }
                stringBuilder.append('\n');
                stringBuilder.append(string);
            }
            String string2 = stringBuilder != null ? stringBuilder.toString() : null;
            return string2;
        }
    }

    public static File getJosmTempDir() {
        String string = System.getProperty("java.io.tmpdir");
        if (string == null) {
            return null;
        }
        File file = new File(string, "JOSM");
        if (!file.exists() && !file.mkdirs()) {
            Main.warn("Unable to create temp directory " + file);
        }
        return file;
    }

    public static String getDurationString(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("elapsedTime must be >= 0");
        }
        if (l < 1000L) {
            return String.format("%d %s", l, I18n.tr("ms", new Object[0]));
        }
        if (l < 60000L) {
            return String.format("%.1f %s", (double)l / 1000.0, I18n.tr("s", new Object[0]));
        }
        if (l < 3600000L) {
            long l2 = l / 60000L;
            return String.format("%d %s %d %s", l2, I18n.tr("min", new Object[0]), (l - l2 * 60000L) / 1000L, I18n.tr("s", new Object[0]));
        }
        if (l < 86400000L) {
            long l3 = l / 3600000L;
            return String.format("%d %s %d %s", l3, I18n.tr("h", new Object[0]), (l - l3 * 3600000L) / 60000L, I18n.tr("min", new Object[0]));
        }
        long l4 = l / 86400000L;
        return String.format("%d %s %d %s", l4, I18n.trn("day", "days", l4, new Object[0]), (l - l4 * 86400000L) / 3600000L, I18n.tr("h", new Object[0]));
    }

    public static String getSizeString(long l, Locale locale) {
        double d;
        if (l < 0L) {
            throw new IllegalArgumentException("bytes must be >= 0");
        }
        int n = 0;
        for (d = (double)l; d >= 1024.0 && n < SIZE_UNITS.length; d /= 1024.0, ++n) {
        }
        if (d > 100.0 || n == 0) {
            return String.format(locale, "%.0f %s", d, SIZE_UNITS[n]);
        }
        if (d > 10.0) {
            return String.format(locale, "%.1f %s", d, SIZE_UNITS[n]);
        }
        return String.format(locale, "%.2f %s", d, SIZE_UNITS[n]);
    }

    public static String getPositionListString(List<Integer> list) {
        Collections.sort(list);
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(list.get(0));
        int n = 0;
        int n2 = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            int n3 = list.get(i);
            if (n3 == n2 + 1) {
                ++n;
            } else if (n == 0) {
                stringBuilder.append(',').append(n3);
            } else {
                stringBuilder.append('-').append(n2);
                stringBuilder.append(',').append(n3);
                n = 0;
            }
            n2 = n3;
        }
        if (n >= 1) {
            stringBuilder.append('-').append(n2);
        }
        return stringBuilder.toString();
    }

    public static List<String> getMatches(Matcher matcher) {
        if (matcher.matches()) {
            ArrayList<String> arrayList = new ArrayList<String>(matcher.groupCount() + 1);
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                arrayList.add(matcher.group(i));
            }
            return arrayList;
        }
        return null;
    }

    public static <T> T cast(Object object, Class<T> clazz) {
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        return null;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            Throwable throwable3 = throwable2.getCause();
            while (throwable3 != null && !throwable3.equals(throwable2)) {
                throwable2 = throwable3;
                throwable3 = throwable2.getCause();
            }
        }
        return throwable2;
    }

    public static <T> T[] addInArrayCopy(T[] TArray, T t) {
        T[] TArray2 = Arrays.copyOf(TArray, TArray.length + 1);
        TArray2[TArray.length] = t;
        return TArray2;
    }

    public static String shortenString(String string, int n) {
        if (string != null && string.length() > n) {
            return string.substring(0, n - 3) + "...";
        }
        return string;
    }

    public static String restrictStringLines(String string, int n) {
        if (string == null) {
            return null;
        }
        return Utils.join("\n", Utils.limit(Arrays.asList(string.split("\\n")), n, "..."));
    }

    public static <T> Collection<T> limit(Collection<T> collection, int n, T t) {
        if (collection == null) {
            return null;
        }
        if (collection.size() > n) {
            ArrayList<T> arrayList = new ArrayList<T>(n);
            Iterator<T> iterator = collection.iterator();
            while (arrayList.size() < n - 1) {
                arrayList.add(iterator.next());
            }
            arrayList.add(t);
            return arrayList;
        }
        return collection;
    }

    public static String fixURLQuery(String string) {
        if (string == null || string.indexOf(63) == -1) {
            return string;
        }
        String string2 = string.substring(string.indexOf(63) + 1);
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, string.indexOf(63) + 1));
        for (int i = 0; i < string2.length(); ++i) {
            String string3 = string2.substring(i, i + 1);
            if (URL_CHARS.contains(string3)) {
                stringBuilder.append(string3);
                continue;
            }
            stringBuilder.append(Utils.encodeUrl(string3));
        }
        return stringBuilder.toString();
    }

    public static String encodeUrl(String string) {
        String string2 = StandardCharsets.UTF_8.name();
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public static String decodeUrl(String string) {
        String string2 = StandardCharsets.UTF_8.name();
        try {
            return URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public static boolean isLocalUrl(String string) {
        return !string.startsWith("http://") && !string.startsWith("https://") && !string.startsWith("resource://");
    }

    public static boolean isValidUrl(String string) {
        try {
            new URL(string);
            return true;
        }
        catch (NullPointerException | MalformedURLException exception) {
            return false;
        }
    }

    public static ThreadFactory newThreadFactory(final String string, final int n) {
        return new ThreadFactory(){
            final AtomicLong count = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, String.format(Locale.ENGLISH, string, this.count.getAndIncrement()));
                thread.setPriority(n);
                return thread;
            }
        };
    }

    public static ForkJoinPool newForkJoinPool(String string, final String string2, final int n) {
        int n2 = Main.pref.getInteger(string, Runtime.getRuntime().availableProcessors());
        return new ForkJoinPool(n2, new ForkJoinPool.ForkJoinWorkerThreadFactory(){
            final AtomicLong count = new AtomicLong(0L);

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
                ForkJoinWorkerThread forkJoinWorkerThread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(forkJoinPool);
                forkJoinWorkerThread.setName(String.format(Locale.ENGLISH, string2, this.count.getAndIncrement()));
                forkJoinWorkerThread.setPriority(n);
                return forkJoinWorkerThread;
            }
        }, null, true);
    }

    public static Executor newDirectExecutor() {
        return new Executor(){

            @Override
            public void execute(Runnable runnable) {
                runnable.run();
            }
        };
    }

    public static String updateSystemProperty(String string, String string2) {
        if (string2 != null) {
            String string3 = System.setProperty(string, string2);
            if (!string.toLowerCase(Locale.ENGLISH).contains("password")) {
                Main.debug("System property '" + string + "' set to '" + string2 + "'. Old value was '" + string3 + '\'');
            } else {
                Main.debug("System property '" + string + "' changed.");
            }
            return string3;
        }
        return null;
    }

    public static SAXParser newSafeSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        sAXParserFactory.setNamespaceAware(true);
        return sAXParserFactory.newSAXParser();
    }

    public static void parseSafeSAX(InputSource inputSource, DefaultHandler defaultHandler) throws ParserConfigurationException, SAXException, IOException {
        long l = System.currentTimeMillis();
        if (Main.isDebugEnabled()) {
            Main.debug("Starting SAX parsing of " + inputSource + " using " + defaultHandler);
        }
        Utils.newSafeSAXParser().parse(inputSource, defaultHandler);
        if (Main.isDebugEnabled()) {
            Main.debug("SAX parsing done in " + Utils.getDurationString(System.currentTimeMillis() - l));
        }
    }

    public static boolean hasExtension(String string, String ... stringArray) {
        String string2 = string.toLowerCase(Locale.ENGLISH).replace("?format=raw", "");
        for (String string3 : stringArray) {
            if (!string2.endsWith('.' + string3.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtension(File file, String ... stringArray) {
        return Utils.hasExtension(file.getName(), stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesFromStream(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
            byte[] byArray = new byte[2048];
            boolean bl = false;
            do {
                int n;
                if ((n = inputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                    continue;
                }
                bl = true;
            } while (!bl);
            if (byteArrayOutputStream.size() == 0) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            return byArray3;
        }
        finally {
            inputStream.close();
        }
    }

    public static int hashMapInitialCapacity(int n, double d) {
        return (int)Math.ceil((double)n / d);
    }

    public static int hashMapInitialCapacity(int n) {
        return Utils.hashMapInitialCapacity(n, 0.75);
    }

    public static List<GlyphVector> getGlyphVectorsBidi(String string, Font font, FontRenderContext fontRenderContext) {
        Object object;
        int n;
        ArrayList<GlyphVector> arrayList = new ArrayList<GlyphVector>();
        Bidi bidi = new Bidi(string, -2);
        byte[] byArray = new byte[bidi.getRunCount()];
        Object[] objectArray = new DirectionString[byArray.length];
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = (byte)bidi.getRunLevel(n);
            object = string.substring(bidi.getRunStart(n), bidi.getRunLimit(n));
            int n2 = byArray[n] % 2 == 0 ? 0 : 1;
            objectArray[n] = new DirectionString(n2, (String)object);
        }
        Bidi.reorderVisually(byArray, 0, objectArray, 0, byArray.length);
        for (n = 0; n < objectArray.length; ++n) {
            object = ((DirectionString)objectArray[n]).str.toCharArray();
            arrayList.add(font.layoutGlyphVector(fontRenderContext, (char[])object, 0, ((Object)object).length, ((DirectionString)objectArray[n]).direction));
        }
        return arrayList;
    }

    public static void setObjectsAccessible(final AccessibleObject ... accessibleObjectArray) {
        if (accessibleObjectArray != null && accessibleObjectArray.length > 0) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    for (AccessibleObject accessibleObject : accessibleObjectArray) {
                        accessibleObject.setAccessible(true);
                    }
                    return null;
                }
            });
        }
    }

    private static class DirectionString {
        public final int direction;
        public final String str;

        DirectionString(int n, String string) {
            this.direction = n;
            this.str = string;
        }
    }

    public static interface Function<A, B> {
        public B apply(A var1);
    }
}

