/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.SecureRandom;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Random {
    public static void createRandom(Ruby runtime, RubyModule OpenSSL2) {
        RubyModule Random2 = OpenSSL2.defineModuleUnder("Random");
        RubyClass OpenSSLError = (RubyClass)OpenSSL2.getConstant("OpenSSLError");
        Random2.defineClassUnder("RandomError", OpenSSLError, OpenSSLError.getAllocator());
        Random2.defineAnnotatedMethods(Random.class);
        Random2.dataWrapStruct((Object)new Holder());
    }

    @JRubyMethod(meta=true)
    public static RubyString random_bytes(ThreadContext context2, IRubyObject self, IRubyObject arg) {
        Ruby runtime = context2.runtime;
        return Random.random_bytes(runtime, self, Random.toInt(runtime, arg));
    }

    static RubyString random_bytes(Ruby runtime, int len) {
        RubyModule Random2 = (RubyModule)runtime.getModule("OpenSSL").getConstantAt("Random");
        return Random.generate(runtime, (IRubyObject)Random2, len, true);
    }

    private static RubyString random_bytes(Ruby runtime, IRubyObject self, int len) {
        return Random.generate(runtime, self, len, true);
    }

    @JRubyMethod(meta=true)
    public static RubyString pseudo_bytes(ThreadContext context2, IRubyObject self, IRubyObject len) {
        Ruby runtime = context2.runtime;
        return Random.generate(runtime, self, Random.toInt(runtime, len), false);
    }

    private static int toInt(Ruby runtime, IRubyObject arg) {
        long len = RubyNumeric.fix2long((IRubyObject)arg);
        if (len < 0L || len > Integer.MAX_VALUE) {
            throw runtime.newArgumentError("negative string size (or size too big) " + len);
        }
        return (int)len;
    }

    private static RubyString generate(Ruby runtime, IRubyObject self, int len, boolean secure) {
        Holder holder = Random.unwrapStruct(self);
        byte[] bytes = new byte[len];
        (secure ? holder.getSecureRandom() : holder.getPlainRandom()).nextBytes(bytes);
        return RubyString.newString((Ruby)runtime, (ByteList)new ByteList(bytes, false));
    }

    private static Holder unwrapStruct(IRubyObject Random2) {
        return (Holder)((RubyModule)Random2).dataGetStruct();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject seed(ThreadContext context2, IRubyObject self, IRubyObject str) {
        byte[] seed2 = str.asString().getBytes();
        Holder holder = Random.unwrapStruct(self);
        holder.getSecureRandom().setSeed(seed2);
        int l = seed2.length;
        if (l >= 4) {
            long s2 = seed2[0] << 24 | seed2[1] << 16 | seed2[2] << 8 | seed2[3];
            holder.getPlainRandom().setSeed(s2);
        }
        return str;
    }

    @JRubyMethod(meta=true, name={"status?"})
    public static IRubyObject status_p(ThreadContext context2, IRubyObject self) {
        return context2.runtime.newBoolean(true);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject random_add(ThreadContext context2, IRubyObject self, IRubyObject str, IRubyObject entropy) {
        return self;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject load_random_file(ThreadContext context2, IRubyObject self, IRubyObject fname) {
        return context2.runtime.getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject write_random_file(ThreadContext context2, IRubyObject self, IRubyObject fname) {
        return context2.runtime.getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject egd(ThreadContext context2, IRubyObject self, IRubyObject fname) {
        return context2.runtime.getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject egd_bytes(ThreadContext context2, IRubyObject self, IRubyObject fname, IRubyObject len) {
        return context2.runtime.getNil();
    }

    private static class Holder {
        private volatile java.util.Random plainRandom;
        private volatile SecureRandom secureRandom;

        private Holder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final java.util.Random getPlainRandom() {
            if (this.plainRandom == null) {
                Holder holder = this;
                synchronized (holder) {
                    if (this.plainRandom == null) {
                        this.plainRandom = new java.util.Random();
                    }
                }
            }
            return this.plainRandom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final SecureRandom getSecureRandom() {
            if (this.secureRandom == null) {
                Holder holder = this;
                synchronized (holder) {
                    if (this.secureRandom == null) {
                        this.secureRandom = SecurityHelper.getSecureRandom();
                    }
                }
            }
            return this.secureRandom;
        }
    }
}

