/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.commandline;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.bitext.BitextReader;
import org.languagetool.bitext.StringPair;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tools.ContextTools;
import org.languagetool.tools.RuleMatchAsXmlSerializer;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public final class CommandLineTools {
    private static final int DEFAULT_CONTEXT_SIZE = 45;

    private CommandLineTools() {
    }

    public static void tagText(String contents, JLanguageTool lt) throws IOException {
        List<String> sentences = lt.sentenceTokenize(contents);
        for (String sentence : sentences) {
            AnalyzedSentence analyzedText = lt.getAnalyzedSentence(sentence);
            System.out.println(analyzedText);
        }
    }

    public static int checkText(String contents, JLanguageTool lt) throws IOException {
        return CommandLineTools.checkText(contents, lt, false, -1, 0, 0, StringTools.XmlPrintMode.NORMAL_XML, false, Collections.emptyList());
    }

    public static int checkText(String contents, JLanguageTool lt, boolean apiFormat, int lineOffset) throws IOException {
        return CommandLineTools.checkText(contents, lt, apiFormat, -1, lineOffset, 0, StringTools.XmlPrintMode.NORMAL_XML, false, Collections.emptyList());
    }

    public static int checkText(String contents, JLanguageTool lt, boolean apiFormat, int lineOffset, boolean listUnknownWords) throws IOException {
        return CommandLineTools.checkText(contents, lt, apiFormat, -1, lineOffset, 0, StringTools.XmlPrintMode.NORMAL_XML, listUnknownWords, Collections.emptyList());
    }

    public static int checkText(String contents, JLanguageTool lt, boolean apiFormat, int contextSize, int lineOffset, int prevMatches, StringTools.XmlPrintMode xmlMode, boolean listUnknownWords, List<String> unknownWords) throws IOException {
        if (contextSize == -1) {
            contextSize = 45;
        }
        long startTime = System.currentTimeMillis();
        List<RuleMatch> ruleMatches = lt.check(contents);
        for (RuleMatch r : ruleMatches) {
            r.setLine(r.getLine() + lineOffset);
            r.setEndLine(r.getEndLine() + lineOffset);
        }
        if (apiFormat) {
            if (listUnknownWords && xmlMode == StringTools.XmlPrintMode.NORMAL_XML) {
                unknownWords = lt.getUnknownWords();
            }
            RuleMatchAsXmlSerializer serializer = new RuleMatchAsXmlSerializer();
            String xml = serializer.ruleMatchesToXml(ruleMatches, contents, contextSize, xmlMode, lt.getLanguage(), unknownWords);
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            out.print(xml);
        } else {
            CommandLineTools.printMatches(ruleMatches, prevMatches, contents, contextSize);
        }
        if (xmlMode == StringTools.XmlPrintMode.NORMAL_XML) {
            SentenceTokenizer sentenceTokenizer = lt.getLanguage().getSentenceTokenizer();
            int sentenceCount = sentenceTokenizer.tokenize(contents).size();
            CommandLineTools.displayTimeStats(startTime, sentenceCount, apiFormat);
        }
        return ruleMatches.size();
    }

    private static void displayTimeStats(long startTime, long sentCount, boolean apiFormat) {
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        float timeInSeconds = (float)time / 1000.0f;
        float sentencesPerSecond = (float)sentCount / timeInSeconds;
        if (apiFormat) {
            System.out.println("<!--");
        }
        System.out.printf(Locale.ENGLISH, "Time: %dms for %d sentences (%.1f sentences/sec)", time, sentCount, Float.valueOf(sentencesPerSecond));
        System.out.println();
        if (apiFormat) {
            System.out.println("-->");
        }
    }

    private static void printMatches(List<RuleMatch> ruleMatches, int prevMatches, String contents, int contextSize) {
        int i = 1;
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(contextSize);
        for (RuleMatch match : ruleMatches) {
            AbstractPatternRule pRule;
            Rule rule = match.getRule();
            String output = i + prevMatches + ".) Line " + (match.getLine() + 1) + ", column " + match.getColumn() + ", Rule ID: " + rule.getId();
            if (rule instanceof AbstractPatternRule && (pRule = (AbstractPatternRule)rule).getSubId() != null) {
                output = output + "[" + pRule.getSubId() + "]";
            }
            System.out.println(output);
            String msg = match.getMessage();
            msg = msg.replaceAll("<suggestion>", "'");
            msg = msg.replaceAll("</suggestion>", "'");
            System.out.println("Message: " + msg);
            List<String> replacements = match.getSuggestedReplacements();
            if (!replacements.isEmpty()) {
                System.out.println("Suggestion: " + String.join((CharSequence)"; ", replacements));
            }
            System.out.println(contextTools.getPlainTextContext(match.getFromPos(), match.getToPos(), contents));
            if (rule.getUrl() != null) {
                System.out.println("More info: " + rule.getUrl());
            }
            if (i < ruleMatches.size()) {
                System.out.println();
            }
            ++i;
        }
    }

    public static int checkBitext(BitextReader reader, JLanguageTool srcLt, JLanguageTool trgLt, List<BitextRule> bRules, boolean apiFormat) throws IOException {
        long startTime = System.currentTimeMillis();
        int contextSize = 45;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int matchCount = 0;
        int sentCount = 0;
        RuleMatchAsXmlSerializer serializer = new RuleMatchAsXmlSerializer();
        PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        if (apiFormat) {
            out.print(serializer.getXmlStart(null, null));
        }
        for (StringPair srcAndTrg : reader) {
            List<RuleMatch> curMatches = Tools.checkBitext(srcAndTrg.getSource(), srcAndTrg.getTarget(), srcLt, trgLt, bRules);
            ArrayList<RuleMatch> fixedMatches = new ArrayList<RuleMatch>();
            for (RuleMatch thisMatch : curMatches) {
                fixedMatches.add(trgLt.adjustRuleMatchPos(thisMatch, reader.getSentencePosition(), reader.getColumnCount(), reader.getLineCount(), reader.getCurrentLine(), null));
            }
            ruleMatches.addAll(fixedMatches);
            if (fixedMatches.size() > 0) {
                if (apiFormat) {
                    String xml = serializer.ruleMatchesToXmlSnippet(fixedMatches, reader.getCurrentLine(), 45);
                    out.print(xml);
                } else {
                    CommandLineTools.printMatches(fixedMatches, matchCount, reader.getCurrentLine(), 45);
                    matchCount += fixedMatches.size();
                }
            }
            ++sentCount;
        }
        CommandLineTools.displayTimeStats(startTime, sentCount, apiFormat);
        if (apiFormat) {
            out.print(serializer.getXmlEnd());
        }
        return ruleMatches.size();
    }

    public static void profileRulesOnText(String contents, JLanguageTool lt) throws IOException {
        long[] workTime = new long[10];
        List<Rule> rules = lt.getAllActiveRules();
        int ruleCount = rules.size();
        System.out.printf("Testing %d rules%n", ruleCount);
        System.out.println("Rule ID\tTime\tSentences\tMatches\tSentences per sec.");
        List<String> sentences = lt.sentenceTokenize(contents);
        for (Rule rule : rules) {
            if (rule instanceof TextLevelRule) continue;
            int matchCount = 0;
            for (int k = 0; k < 10; ++k) {
                long startTime = System.currentTimeMillis();
                for (String sentence : sentences) {
                    matchCount += rule.match(lt.getAnalyzedSentence(sentence)).length;
                }
                long endTime = System.currentTimeMillis();
                workTime[k] = endTime - startTime;
            }
            long time = CommandLineTools.median(workTime);
            float timeInSeconds = (float)time / 1000.0f;
            float sentencesPerSecond = (float)sentences.size() / timeInSeconds;
            System.out.printf(Locale.ENGLISH, "%s\t%d\t%d\t%d\t%.1f", rule.getId(), time, sentences.size(), matchCount, Float.valueOf(sentencesPerSecond));
            System.out.println();
        }
    }

    private static long median(long[] m) {
        Arrays.sort(m);
        int middle = m.length / 2;
        if (m.length % 2 == 1) {
            return m[middle];
        }
        return (m[middle - 1] + m[middle]) / 2L;
    }

    public static void correctBitext(BitextReader reader, JLanguageTool sourceLt, JLanguageTool targetLt, List<BitextRule> bRules) throws IOException {
        for (StringPair srcAndTrg : reader) {
            List<RuleMatch> curMatches = Tools.checkBitext(srcAndTrg.getSource(), srcAndTrg.getTarget(), sourceLt, targetLt, bRules);
            ArrayList<RuleMatch> fixedMatches = new ArrayList<RuleMatch>();
            for (RuleMatch thisMatch : curMatches) {
                fixedMatches.add(targetLt.adjustRuleMatchPos(thisMatch, 0, reader.getTargetColumnCount(), reader.getLineCount(), reader.getCurrentLine(), null));
            }
            if (fixedMatches.size() > 0) {
                System.out.println(CommandLineTools.correctTextFromMatches(srcAndTrg.getTarget(), fixedMatches));
                continue;
            }
            System.out.println(srcAndTrg.getTarget());
        }
    }

    private static String correctTextFromMatches(String contents, List<RuleMatch> matches) {
        StringBuilder sb = new StringBuilder(contents);
        ArrayList<String> errors = new ArrayList<String>();
        for (RuleMatch rm : matches) {
            List<String> replacements = rm.getSuggestedReplacements();
            if (replacements.isEmpty()) continue;
            errors.add(sb.substring(rm.getFromPos(), rm.getToPos()));
        }
        int offset = 0;
        int counter = 0;
        for (RuleMatch rm : matches) {
            List<String> replacements = rm.getSuggestedReplacements();
            if (replacements.isEmpty()) continue;
            if (((String)errors.get(counter)).equals(sb.substring(rm.getFromPos() - offset, rm.getToPos() - offset))) {
                sb.replace(rm.getFromPos() - offset, rm.getToPos() - offset, replacements.get(0));
                offset += rm.getToPos() - rm.getFromPos() - replacements.get(0).length();
            }
            ++counter;
        }
        return sb.toString();
    }
}

