/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.MultiLanguageModel;
import org.languagetool.rules.ngrams.Probability;

public class MultiLanguageModelTest {
    @Test
    public void test() {
        FakeLanguageModel lm1 = new FakeLanguageModel(0.5f);
        FakeLanguageModel lm2 = new FakeLanguageModel(0.2f);
        MultiLanguageModel lm = new MultiLanguageModel(Arrays.asList(lm1, lm2));
        List<String> ngram = Arrays.asList("foo", "bar", "blah");
        Assert.assertEquals((double)0.7f, (double)lm.getPseudoProbability(ngram).getProb(), (double)0.01f);
        Assert.assertEquals((float)0.5f, (float)lm.getPseudoProbability(ngram).getCoverage(), (float)0.01f);
    }

    private static class FakeLanguageModel
    implements LanguageModel {
        private final float fakeValue;

        FakeLanguageModel(float fakeValue) {
            this.fakeValue = fakeValue;
        }

        public Probability getPseudoProbability(List<String> context) {
            return new Probability((double)this.fakeValue, 0.5f);
        }

        public void close() {
        }
    }
}

