/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.core;

import java.io.File;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.List;
import org.zaproxy.clientapi.core.Alert;
import org.zaproxy.clientapi.core.AlertsFile;
import org.zaproxy.clientapi.core.ClientApi;

public class ClientApiMain {
    private HashMap<String, Object> params = new HashMap();
    private String zapaddr = "localhost";
    private int zapport = 8090;
    private Task task;
    private ClientApi api;
    private boolean debug = false;

    public static void main(String[] stringArray) {
        new ClientApiMain(stringArray);
    }

    public ClientApiMain(String[] stringArray) {
        this.initialize(stringArray);
        try {
            this.executeTask();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showHelp();
        }
    }

    private void executeTask() throws Exception {
        try {
            switch (this.task) {
                case stop: {
                    this.api.core.shutdown((String)this.params.get("apikey"));
                    break;
                }
                case checkAlerts: {
                    File file;
                    if (this.params.get("alertsFile") == null) {
                        System.out.println("No Alerts File Path Supplied\n");
                        this.showHelp();
                        System.exit(1);
                    }
                    if (!(file = (File)this.params.get("alertsFile")).exists()) {
                        System.out.println("File not Found: " + file.getAbsolutePath());
                        this.showHelp();
                        System.exit(1);
                    }
                    if (this.params.get("outputFile") == null) {
                        this.api.checkAlerts(AlertsFile.getAlertsFromFile(file, "ignoreAlert"), AlertsFile.getAlertsFromFile(file, "requireAlert"));
                        break;
                    }
                    File file2 = (File)this.params.get("outputFile");
                    try {
                        this.api.checkAlerts(AlertsFile.getAlertsFromFile(file, "ignoreAlert"), AlertsFile.getAlertsFromFile(file, "requireAlert"), file2);
                    }
                    catch (AssertionError assertionError) {
                        System.out.println(((Throwable)((Object)assertionError)).getMessage());
                        System.exit(1);
                    }
                    break;
                }
                case showAlerts: {
                    List<Alert> list = this.api.getAlerts(null, -1, -1);
                    for (Alert alert : list) {
                        System.out.println(alert.toString());
                    }
                    break;
                }
                case saveSession: {
                    if (this.params.get("sessionName") == null) {
                        System.out.println("No session name supplied\n");
                        this.showHelp();
                        System.exit(1);
                    }
                    this.api.core.saveSession((String)this.params.get("apikey"), (String)this.params.get("sessionName"), "true");
                    break;
                }
                case newSession: {
                    if (this.params.get("sessionName") == null) {
                        this.api.core.newSession((String)this.params.get("apikey"), "", "true");
                        break;
                    }
                    this.api.core.newSession((String)this.params.get("apikey"), (String)this.params.get("sessionName"), "true");
                    break;
                }
                case activeScanUrl: {
                    if (this.params.get("url") == null) {
                        System.out.println("No url supplied\n");
                        this.showHelp();
                        System.exit(1);
                        break;
                    }
                    this.api.ascan.scan((String)this.params.get("apikey"), (String)this.params.get("url"), "true", "false", "", "", "");
                    break;
                }
                case activeScanSiteInScope: {
                    this.checkForUrlParam();
                    this.api.activeScanSiteInScope((String)this.params.get("apikey"), (String)this.params.get("url"));
                    break;
                }
                case addExcludeRegexToContext: {
                    this.checkForContextNameParam();
                    this.checkForRegexParam();
                    this.api.addExcludeFromContext((String)this.params.get("apikey"), (String)this.params.get("contextName"), (String)this.params.get("regex"));
                    break;
                }
                case addIncludeRegexToContext: {
                    this.checkForContextNameParam();
                    this.checkForRegexParam();
                    this.api.addIncludeInContext((String)this.params.get("apikey"), (String)this.params.get("contextName"), (String)this.params.get("regex"));
                    break;
                }
                case addIncludeOneMatchingNodeToContext: {
                    this.checkForContextNameParam();
                    this.checkForRegexParam();
                    this.api.includeOneMatchingNodeInContext((String)this.params.get("apikey"), (String)this.params.get("contextName"), (String)this.params.get("regex"));
                }
            }
        }
        catch (ConnectException connectException) {
            System.out.println(connectException.getMessage() + String.format(": zapaddr=%s, zapport=%d\n", this.zapaddr, this.zapport));
            this.showHelp();
            System.exit(1);
        }
    }

    private void checkForRegexParam() {
        if (this.params.get("regex") == null) {
            System.out.println("No regex supplied\n");
            this.showHelp();
            System.exit(1);
        }
    }

    private void checkForContextNameParam() {
        if (this.params.get("contextName") == null) {
            System.out.println("No context name supplied\n");
            this.showHelp();
            System.exit(1);
        }
    }

    private void checkForUrlParam() {
        if (this.params.get("url") == null) {
            System.out.println("No url supplied\n");
            this.showHelp();
            System.exit(1);
        }
    }

    private void initialize(String[] stringArray) {
        if (stringArray.length > 0) {
            if (stringArray[0].equalsIgnoreCase("help")) {
                try {
                    this.setTask(stringArray[1]);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.showHelp();
                    System.exit(1);
                }
                this.showHelp();
                System.exit(0);
            }
            this.setTask(stringArray[0]);
            for (String string : stringArray) {
                String[] stringArray2 = string.split("=");
                if (stringArray2.length != 2) continue;
                if (stringArray2[0].equalsIgnoreCase("zapaddr")) {
                    this.zapaddr = stringArray2[1];
                    continue;
                }
                if (stringArray2[0].equalsIgnoreCase("zapport")) {
                    try {
                        this.zapport = Integer.parseInt(stringArray2[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Invalid value to zapport, must be in integer: " + stringArray2[1]);
                        this.showHelp();
                        System.exit(1);
                    }
                    continue;
                }
                if (stringArray2[0].equalsIgnoreCase("debug") && stringArray2[1].equalsIgnoreCase("true")) {
                    this.debug = true;
                    continue;
                }
                if (stringArray2[0].contains("File")) {
                    this.params.put(stringArray2[0], new File(stringArray2[1]));
                    continue;
                }
                this.params.put(stringArray2[0], stringArray2[1]);
            }
        } else {
            this.showHelp();
            System.exit(1);
        }
        this.api = new ClientApi(this.zapaddr, this.zapport, this.debug);
    }

    private void setTask(String string) {
        try {
            this.task = Task.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Unknown Task: " + string);
            this.showHelp();
            System.exit(1);
        }
    }

    private void showHelp() {
        String string = "";
        if (this.task == null) {
            string = "usage: java -jar zap-api.jar <subcommand> [args]\n\nType 'java -jar zap-api.jar help <subcommand>' for help on a specific subcommand.\n\nAvailable subcommands:\n\tstop\n\tcheckAlerts\n\tshowAlerts\n\tsaveSession\n\tnewSession\n";
        } else {
            switch (this.task) {
                case stop: {
                    string = "usage: stop [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar stop' \n\t\tStop zap listening on default settings (localhost:8090)\n\t2. Type 'java -jar zap-api.jar stop zapaddr=192.168.1.1 apikey=1234' \n\t\tStop zap listening on 192.168.1.1:8090\n\t3. Type 'java -jar zap-api.jar stop zapport=7080 apikey=1234' \n\t\tStop zap listening on localhost:7080\n\t4. Type 'java -jar zap-api.jar stop zapaddr=192.168.1.1 zapport=7080 apikey=1234' \n\t\tStop zap listening on 192.168.1.1:7080\n\n";
                    break;
                }
                case checkAlerts: {
                    string = "usage: checkAlerts alertsFile={PATH} [outputFile={PATH}] [zapaddr={ip}] [zapport={port}]\n\nExamples\n\t1. Type 'java -jar zap-api.jar checkAlerts alertsFile=\"C:\\Users\\me\\My Documents\\alerts.xml\"' \n\t\tCheck alerts ignoring alerts from alertsFile, looking for required alerts from alertsFile, using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar checkAlerts alertsFile=\"C:\\Users\\me\\My Documents\\alerts.xml\" outputFile=\"C:\\Users\\me\\My Documents\\report.xml\"' \n\t\tCheck alerts ignoring alerts from alertsFile, looking for required alerts from alertsFile. Outputting results to report.xml, using zap listening on localhost:8090\n\t3. Type 'java -jar zap-api.jar checkAlerts alertsFile=\"C:\\Users\\me\\My Documents\\alerts.xml\" outputFile=\"C:\\Users\\me\\My Documents\\report.xml\"' zapaddr=192.168.1.1 zapport=7080' \n\t\tCheck alerts ignoring alerts from alertsFile, looking for required alerts from alertsFile. Outputting results to report.xml, using zap listening on 192.168.1.1:7080\nNote: for paths containing spaces ensure path is enclosed in quotes\n\n";
                    break;
                }
                case showAlerts: {
                    string = "usage: showAlerts [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar showAlerts' \n\t\tShow alerts, using zap listening on default settings (localhost:8090)\n\t2. Type 'java -jar zap-api.jar showAlerts zapaddr=192.168.1.1' \n\t\tShow alerts, using zap listening on 192.168.1.1:8090\n\t3. Type 'java -jar zap-api.jar showAlerts zapport=7080' \n\t\tShow alerts, using zap listening on localhost:7080\n\t4. Type 'java -jar zap-api.jar showAlerts zapaddr=192.168.1.1 zapport=7080' \n\t\tShow alerts, using zap listening on 192.168.1.1:7080\n\n";
                    break;
                }
                case saveSession: {
                    string = "usage: saveSession sessionName={PATH} [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar saveSession sessionName=\"Users/me/My Documents/mysession/mysessionfile\"' \n\t\tSave zap session using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar saveSession sessionName=\"Users/me/My Documents/mysession/mysessionfile\" zapaddr=192.168.1.1 zapport=7080' \n\t\tSave zap session using zap listening on 192.168.1.1:7080\nNote: for paths containing spaces ensure path is enclosed in quotes\n\n";
                    break;
                }
                case newSession: {
                    string = "usage: newSession [sessionName={PATH}] [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar newSession' \n\t\tStart new session using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar newSession zapaddr=192.168.1.1 zapport=7080' \n\t\tStart new session using zap listening on 192.168.1.1:7080\n\t3. Type 'java -jar zap-api.jar newSession sessionName=\"Users/me/My Documents/mysession/newsession\"' \n\t\tStart new session using zap listening on localhost:8090, creating session files at /Users/me/My Documents/mysession/newsession\n\t4. Type 'java -jar zap-api.jar newSession sessionName=\"Users/me/My Documents/mysession/mysessionfile\" zapaddr=192.168.1.1 zapport=7080' \n\t\tStart new session using zap listening on 192.168.1.1:7080, creating session files at /Users/me/My Documents/mysession/newsession\nNote: for paths containing spaces ensure path is enclosed in quotes";
                    break;
                }
                case activeScanUrl: {
                    string = "usage: activeScanUrl url={url} [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar activeScanUrl url=http://myurl.com/' \n\t\tExecute and active scan on http://myurl.com/ using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar activeScanUrl url=http://myurl.com/' zapaddr=192.168.1.1 zapport=7080' \n\t\tExecute and active scan on http://myurl.com/ using zap listening on 192.168.1.1:7080\n\t";
                    break;
                }
                case addExcludeRegexToContext: {
                    string = "usage: addExcludeRegexToContext contextName={contextName} regex={regex} [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar addExcludeRegexToContext contextName=1 regex=\\Qhttp://example.com/area\\E.* \n\t\tUrls that match the regex will be excluded from scope using context '1' using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar addExcludeRegexToContext url=http://myurl.com/' zapaddr=192.168.1.1 zapport=7080' \n\t\tUrls that match the regex will be excluded from scope using context '1' using zap listening on 192.168.1.1:7080\n\t";
                    break;
                }
                case addIncludeRegexToContext: {
                    string = "usage: addIncludeRegexToContext contextName={contextName} regex={regex} [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar addIncludeRegexToContext contextName=1 regex=\\Qhttp://example.com/area\\E.* \n\t\tUrls that match the regex will be included in scope using context '1' using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar addIncludeRegexToContext url=http://myurl.com/' zapaddr=192.168.1.1 zapport=7080' \n\t\tUrls that match the regex will be included in scope using context '1' using zap listening on 192.168.1.1:7080\n\t";
                    break;
                }
                case addIncludeOneMatchingNodeToContext: {
                    string = "usage: addIncludeOneMatchingNodeToContext contextName={contextName} regex={regex} [zapaddr={ip}] [zapport={port}]\n\nExamples:\n\t1. Type 'java -jar zap-api.jar addIncludeOneMatchingNodeToContext contextName=1 regex=\\Qhttp://example.com/area\\E.* \n\t\tThe first url from the current session that matches the regex will be included in scope using context '1'. Any other matching url will be excluded from scope using zap listening on localhost:8090\n\t2. Type 'java -jar zap-api.jar addIncludeOneMatchingNodeToContext url=http://myurl.com/' zapaddr=192.168.1.1 zapport=7080' \n\t\tThe first url from the current session that matches the regex will be included in scope using context '1'. Any other matching url will be excluded from scope using context '1' using zap listening on 192.168.1.1:7080\n\t";
                }
            }
        }
        System.out.println(string);
    }

    private static enum Task {
        stop,
        showAlerts,
        checkAlerts,
        saveSession,
        newSession,
        activeScanUrl,
        activeScanSiteInScope,
        addExcludeRegexToContext,
        addIncludeRegexToContext,
        addIncludeOneMatchingNodeToContext;

    }
}

