/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.messagecontainer.http.SelectableHttpMessagesContainer;
import org.zaproxy.zap.view.messagecontainer.http.SingleHttpMessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuUtils;

public class PopupMenuHttpMessageContainer
extends ExtensionPopupMenuMessageContainer {
    private static final long serialVersionUID = -5266647403287261225L;
    private Invoker invoker = null;
    private boolean buttonEnabledForEnableChildren = true;
    private boolean processExtensionPopupChildren = true;
    private final boolean multiSelect;

    public PopupMenuHttpMessageContainer(String string) {
        this(string, false);
    }

    public PopupMenuHttpMessageContainer(String string, boolean bl) {
        super(string);
        this.multiSelect = bl;
    }

    public final void setButtonStateOverriddenByChildren(boolean bl) {
        this.buttonEnabledForEnableChildren = bl;
    }

    public final boolean isButtonStateOverriddenByChildren() {
        return this.buttonEnabledForEnableChildren;
    }

    public final void setProcessExtensionPopupChildren(boolean bl) {
        this.processExtensionPopupChildren = bl;
    }

    public final boolean isProcessExtensionPopupChildren() {
        return this.processExtensionPopupChildren;
    }

    public final boolean isMultiSelect() {
        return this.multiSelect;
    }

    protected final Invoker getInvoker() {
        return this.invoker;
    }

    @Override
    public boolean isEnableForMessageContainer(MessageContainer<?> messageContainer) {
        this.invoker = null;
        if (!(messageContainer instanceof HttpMessageContainer)) {
            return false;
        }
        HttpMessageContainer httpMessageContainer = (HttpMessageContainer)messageContainer;
        if (!this.isEnable(httpMessageContainer)) {
            return false;
        }
        this.invoker = PopupMenuHttpMessageContainer.getInvoker(httpMessageContainer);
        if (!this.isEnableForInvoker(this.invoker, httpMessageContainer)) {
            this.invoker = null;
            return false;
        }
        boolean bl = false;
        if (this.isProcessExtensionPopupChildren()) {
            boolean bl2 = this.processExtensionPopupChildren(PopupMenuUtils.getPopupMenuInvokerWrapper(httpMessageContainer));
            if (this.isButtonStateOverriddenByChildren()) {
                bl = bl2;
            }
        }
        if (!this.isProcessExtensionPopupChildren() || this.isProcessExtensionPopupChildren() && !this.isButtonStateOverriddenByChildren()) {
            bl = this.isButtonEnabledForHttpMessageContainerState(httpMessageContainer);
        }
        if (bl && !this.isSafe()) {
            Control.Mode mode = Control.getSingleton().getMode();
            if (mode.equals((Object)Control.Mode.protect)) {
                bl = this.isSelectedMessagesInSessionScope(httpMessageContainer);
            } else if (mode.equals((Object)Control.Mode.safe)) {
                bl = false;
            }
        }
        this.setEnabled(bl);
        return true;
    }

    protected boolean isEnable(HttpMessageContainer httpMessageContainer) {
        return httpMessageContainer instanceof SelectableHttpMessagesContainer || httpMessageContainer instanceof SingleHttpMessageContainer;
    }

    protected static final Invoker getInvoker(HttpMessageContainer httpMessageContainer) {
        Invoker invoker;
        switch (httpMessageContainer.getName()) {
            case "History Table": {
                invoker = Invoker.HISTORY_PANEL;
                break;
            }
            case "treeSite": {
                invoker = Invoker.SITES_PANEL;
                break;
            }
            case "treeAlert": {
                invoker = Invoker.ALERTS_PANEL;
                break;
            }
            case "SearchHttpMessageContainer": {
                invoker = Invoker.SEARCH_PANEL;
                break;
            }
            case "ActiveScanMessageContainer": {
                invoker = Invoker.ACTIVE_SCANNER_PANEL;
                break;
            }
            case "HttpFuzzerResultsContentPanel": {
                invoker = Invoker.FUZZER_PANEL;
                break;
            }
            case "ForcedBrowseMessageContainer": {
                invoker = Invoker.FORCED_BROWSE_PANEL;
                break;
            }
            default: {
                invoker = Invoker.UNKNOWN;
            }
        }
        return invoker;
    }

    protected boolean isEnableForInvoker(Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return true;
    }

    protected boolean isButtonEnabledForHttpMessageContainerState(HttpMessageContainer httpMessageContainer) {
        boolean bl = this.isButtonEnabledForNumberOfSelectedMessages(httpMessageContainer);
        if (bl) {
            bl = this.isButtonEnabledForSelectedMessages(httpMessageContainer);
        }
        return bl;
    }

    protected boolean isButtonEnabledForNumberOfSelectedMessages(HttpMessageContainer httpMessageContainer) {
        return this.isButtonEnabledForNumberOfSelectedMessages(this.getNumberOfSelectedMessages(httpMessageContainer));
    }

    protected boolean isButtonEnabledForSelectedMessages(HttpMessageContainer httpMessageContainer) {
        return this.isButtonEnabledForSelectedMessages(this.getSelectedMessages(httpMessageContainer));
    }

    protected int getNumberOfSelectedMessages(HttpMessageContainer httpMessageContainer) {
        if (httpMessageContainer instanceof SelectableHttpMessagesContainer) {
            return ((SelectableHttpMessagesContainer)httpMessageContainer).getNumberOfSelectedMessages();
        }
        if (httpMessageContainer instanceof SingleHttpMessageContainer) {
            return ((SingleHttpMessageContainer)httpMessageContainer).isEmpty() ? 0 : 1;
        }
        return 0;
    }

    protected boolean isButtonEnabledForNumberOfSelectedMessages(int n) {
        if (n == 0) {
            return false;
        }
        return n <= 1 || this.isMultiSelect();
    }

    protected List<HttpMessage> getSelectedMessages(HttpMessageContainer httpMessageContainer) {
        SingleHttpMessageContainer singleHttpMessageContainer;
        if (httpMessageContainer instanceof SelectableHttpMessagesContainer) {
            return ((SelectableHttpMessagesContainer)httpMessageContainer).getSelectedMessages();
        }
        if (httpMessageContainer instanceof SingleHttpMessageContainer && !(singleHttpMessageContainer = (SingleHttpMessageContainer)httpMessageContainer).isEmpty()) {
            ArrayList<HttpMessage> arrayList = new ArrayList<HttpMessage>(1);
            arrayList.add((HttpMessage)singleHttpMessageContainer.getMessage());
            return arrayList;
        }
        return Collections.emptyList();
    }

    protected boolean isButtonEnabledForSelectedMessages(List<HttpMessage> list) {
        for (HttpMessage httpMessage : list) {
            if (httpMessage == null || this.isButtonEnabledForSelectedHttpMessage(httpMessage)) continue;
            return false;
        }
        return true;
    }

    protected boolean isButtonEnabledForSelectedHttpMessage(HttpMessage httpMessage) {
        return true;
    }

    protected boolean isSelectedMessagesInSessionScope(HttpMessageContainer httpMessageContainer) {
        for (HttpMessage httpMessage : this.getSelectedMessages(httpMessageContainer)) {
            if (httpMessage == null || httpMessage.isInScope()) continue;
            return false;
        }
        return true;
    }

    protected static enum Invoker {
        SITES_PANEL,
        HISTORY_PANEL,
        ALERTS_PANEL,
        ACTIVE_SCANNER_PANEL,
        SEARCH_PANEL,
        FUZZER_PANEL,
        FORCED_BROWSE_PANEL,
        UNKNOWN;

    }
}

