/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.MapObjectImpl;
import org.openstreetmap.gui.jmapviewer.Style;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;

public class MapPolygonImpl
extends MapObjectImpl
implements MapPolygon {
    private List<? extends ICoordinate> points;

    public MapPolygonImpl(ICoordinate ... iCoordinateArray) {
        this((Layer)null, (String)null, iCoordinateArray);
    }

    public MapPolygonImpl(List<? extends ICoordinate> list) {
        this(null, null, list);
    }

    public MapPolygonImpl(String string, List<? extends ICoordinate> list) {
        this(null, string, list);
    }

    public MapPolygonImpl(String string, ICoordinate ... iCoordinateArray) {
        this(null, string, iCoordinateArray);
    }

    public MapPolygonImpl(Layer layer, List<? extends ICoordinate> list) {
        this(layer, null, list);
    }

    public MapPolygonImpl(Layer layer, String string, List<? extends ICoordinate> list) {
        this(layer, string, list, MapPolygonImpl.getDefaultStyle());
    }

    public MapPolygonImpl(Layer layer, String string, ICoordinate ... iCoordinateArray) {
        this(layer, string, Arrays.asList(iCoordinateArray), MapPolygonImpl.getDefaultStyle());
    }

    public MapPolygonImpl(Layer layer, String string, List<? extends ICoordinate> list, Style style) {
        super(layer, string, style);
        this.points = list;
    }

    @Override
    public List<? extends ICoordinate> getPoints() {
        return this.points;
    }

    @Override
    public void paint(Graphics graphics, List<Point> list) {
        Polygon polygon = new Polygon();
        for (Point point : list) {
            polygon.addPoint(point.x, point.y);
        }
        this.paint(graphics, polygon);
    }

    @Override
    public void paint(Graphics graphics, Polygon polygon) {
        Object object;
        Object object2;
        Color color = graphics.getColor();
        graphics.setColor(this.getColor());
        Stroke stroke = null;
        if (graphics instanceof Graphics2D) {
            object2 = (Graphics2D)graphics;
            stroke = ((Graphics2D)object2).getStroke();
            ((Graphics2D)object2).setStroke(this.getStroke());
        }
        graphics.drawPolygon(polygon);
        if (graphics instanceof Graphics2D && this.getBackColor() != null) {
            object2 = (Graphics2D)graphics;
            object = ((Graphics2D)object2).getComposite();
            ((Graphics2D)object2).setComposite(AlphaComposite.getInstance(3));
            ((Graphics2D)object2).setPaint(this.getBackColor());
            ((Graphics)object2).fillPolygon(polygon);
            ((Graphics2D)object2).setComposite((Composite)object);
        }
        graphics.setColor(color);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setStroke(stroke);
        }
        object2 = polygon.getBounds();
        object = ((Rectangle)object2).getLocation();
        Point point = new Point(((Point)object).x + ((Rectangle)object2).width / 2, ((Point)object).y + ((Rectangle)object2).height / 2);
        if (this.getLayer() == null || this.getLayer().isVisibleTexts().booleanValue()) {
            this.paintText(graphics, point);
        }
    }

    public static Style getDefaultStyle() {
        return new Style(Color.BLUE, new Color(100, 100, 100, 50), new BasicStroke(2.0f), MapPolygonImpl.getDefaultFont());
    }

    public String toString() {
        return "MapPolygon [points=" + this.points + ']';
    }
}

