/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.imagery.TileLoaderFactory;
import org.openstreetmap.josm.data.preferences.StringProperty;

public class CachedTileLoaderFactory
implements TileLoaderFactory {
    public static final StringProperty PROP_TILECACHE_DIR = CachedTileLoaderFactory.getTileCacheDir();
    private final ICacheAccess<String, BufferedImageCacheEntry> cache;
    private Constructor<? extends TileLoader> tileLoaderConstructor;

    public CachedTileLoaderFactory(ICacheAccess<String, BufferedImageCacheEntry> iCacheAccess, Class<? extends TileLoader> clazz) {
        this.cache = iCacheAccess;
        try {
            this.tileLoaderConstructor = clazz.getConstructor(TileLoaderListener.class, ICacheAccess.class, Integer.TYPE, Integer.TYPE, Map.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            Main.warn(exception);
            throw new IllegalArgumentException(exception);
        }
    }

    private static StringProperty getTileCacheDir() {
        String string = null;
        try {
            string = new File(Main.pref.getCacheDirectory(), "tiles").getAbsolutePath();
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
        return new StringProperty("imagery.generic.loader.cachedir", string);
    }

    @Override
    public TileLoader makeTileLoader(TileLoaderListener tileLoaderListener) {
        return this.makeTileLoader(tileLoaderListener, null);
    }

    @Override
    public TileLoader makeTileLoader(TileLoaderListener tileLoaderListener, Map<String, String> map) {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        concurrentHashMap.put("User-Agent", Version.getInstance().getFullAgentString());
        concurrentHashMap.put("Accept", "text/html, image/png, image/jpeg, image/gif, */*");
        if (map != null) {
            concurrentHashMap.putAll(map);
        }
        return this.getLoader(tileLoaderListener, this.cache, Main.pref.getInteger("socket.timeout.connect", 15) * 1000, Main.pref.getInteger("socket.timeout.read", 30) * 1000, concurrentHashMap);
    }

    protected TileLoader getLoader(TileLoaderListener tileLoaderListener, ICacheAccess<String, BufferedImageCacheEntry> iCacheAccess, int n, int n2, Map<String, String> map) {
        try {
            return this.tileLoaderConstructor.newInstance(tileLoaderListener, iCacheAccess, n, n2, map);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Main.warn(illegalArgumentException);
            throw illegalArgumentException;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Main.warn(reflectiveOperationException);
            throw new IllegalArgumentException(reflectiveOperationException);
        }
    }
}

