/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.util;

import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.util.NameVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MultipleNameVisitor
extends NameVisitor {
    public static final int MULTIPLE_NAME_MAX_LENGTH = 80;
    private String multipleClassname;
    private String displayName;
    private int size;

    public void visit(Collection<? extends OsmPrimitive> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        this.size = collection.size();
        this.multipleClassname = null;
        for (OsmPrimitive osmPrimitive : collection) {
            String string2 = osmPrimitive.get("name");
            if (string2 == null) {
                string2 = osmPrimitive.get("ref");
            }
            if (string2 != null && !string2.isEmpty() && stringBuilder.length() <= 80) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string2);
            }
            osmPrimitive.accept(this);
            if (this.multipleClassname == null) {
                this.multipleClassname = this.className;
                string = this.classNamePlural;
                continue;
            }
            if (this.multipleClassname.equals(this.className)) continue;
            this.multipleClassname = "object";
            string = I18n.trn("object", "objects", 2L, new Object[0]);
        }
        if (this.size <= 1) {
            this.displayName = this.name;
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append(this.size).append(' ').append(I18n.trn(this.multipleClassname, string, this.size, new Object[0]));
            if (stringBuilder.length() > 0) {
                stringBuilder2.append(": ");
                if (stringBuilder.length() <= 80) {
                    stringBuilder2.append((CharSequence)stringBuilder);
                } else {
                    stringBuilder2.append(stringBuilder.substring(0, 80)).append("...");
                }
            }
            this.displayName = stringBuilder2.toString();
        }
    }

    @Override
    public JLabel toLabel() {
        return new JLabel(this.getText(), this.getIcon(), 0);
    }

    public String getText() {
        return this.displayName;
    }

    public Icon getIcon() {
        if (this.size <= 1) {
            return this.icon;
        }
        return ImageProvider.get("data", this.multipleClassname);
    }

    public String toString() {
        return this.getText();
    }
}

