/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.color;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceColorSpace;

public class PDDeviceCMYK
extends PDDeviceColorSpace {
    public static PDDeviceCMYK INSTANCE;
    private final PDColor initialColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f, 1.0f}, (PDColorSpace)this);
    private final ICC_ColorSpace awtColorSpace;

    protected PDDeviceCMYK() throws IOException {
        ICC_Profile iccProfile = this.getICCProfile();
        if (iccProfile == null) {
            throw new IOException("Default CMYK color profile could not be loaded");
        }
        this.awtColorSpace = new ICC_ColorSpace(iccProfile);
        this.awtColorSpace.toRGB(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
    }

    protected ICC_Profile getICCProfile() throws IOException {
        String name = "org/sejda/sambox/resources/icc/ISOcoated_v2_300_bas.icc";
        URL url = PDDeviceCMYK.class.getClassLoader().getResource(name);
        if (url == null) {
            throw new IOException("Error loading resource: " + name);
        }
        InputStream input = url.openStream();
        ICC_Profile iccProfile = ICC_Profile.getInstance(input);
        input.close();
        return iccProfile;
    }

    @Override
    public String getName() {
        return COSName.DEVICECMYK.getName();
    }

    @Override
    public int getNumberOfComponents() {
        return 4;
    }

    @Override
    public float[] getDefaultDecode(int bitsPerComponent) {
        return new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    @Override
    public PDColor getInitialColor() {
        return this.initialColor;
    }

    @Override
    public float[] toRGB(float[] value) {
        return this.awtColorSpace.toRGB(value);
    }

    @Override
    public BufferedImage toRGBImage(WritableRaster raster) {
        return this.toRGBImageAWT(raster, this.awtColorSpace);
    }

    static {
        try {
            INSTANCE = new PDDeviceCMYK();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

