/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.log4j;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.log4j.ZapOutputWriter;
import org.zaproxy.zap.view.ScanStatus;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionLog4j
extends ExtensionAdaptor {
    private ZapMenuItem menuGarbageCollect = null;
    private ScanStatus scanStatus;

    public ExtensionLog4j() {
        this.initialize();
    }

    public ExtensionLog4j(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionLog4j");
        this.setOrder(56);
        if (Constant.isDevBuild()) {
            this.scanStatus = new ScanStatus(new ImageIcon(ExtensionLog4j.class.getResource("/resource/icon/fugue/bug.png")), Constant.messages.getString("log4j.icon.title"));
            Logger.getRootLogger().addAppender((Appender)new ZapOutputWriter(this.scanStatus));
            if (View.isInitialised()) {
                View.getSingleton().getMainFrame().getMainFooterPanel().addFooterToolbarRightLabel(this.scanStatus.getCountLabel());
            }
        }
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuGarbageCollect());
        }
    }

    private ZapMenuItem getMenuGarbageCollect() {
        if (this.menuGarbageCollect == null) {
            this.menuGarbageCollect = new ZapMenuItem("log4j.tools.menu.gc");
            this.menuGarbageCollect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Runtime.getRuntime().gc();
                }
            });
        }
        return this.menuGarbageCollect;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("log4j.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }
}

