/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.lib.profiler.ui.charts.AbstractBarChartModel;
import org.netbeans.lib.profiler.ui.charts.BarChartModel;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.DecimalAxisUtils;

public class BarChart
extends JComponent
implements ComponentListener,
AncestorListener,
ChartModelListener,
Accessible {
    List horizAxisXes = new ArrayList();
    int horizAxisHeight = 0;
    int horizLegendWidth = 0;
    int vertAxisWidth = 0;
    int vertLegendHeight = 0;
    private AccessibleContext accessibleContext;
    private BarChartModel model;
    private Graphics2D offScreenGraphics;
    private Image offScreenImage;
    private Insets insets;
    private Paint axisMeshPaint = new Color(80, 80, 80, 50);
    private Paint axisPaint = Color.BLACK;
    private Paint fillPaint = Color.CYAN;
    private Paint outlinePaint = Color.BLACK;
    private Stroke axisStroke = new BasicStroke(1.0f);
    private Stroke outlineStroke = new BasicStroke(1.0f, 2, 1);
    private boolean draw3D = false;
    private boolean modelIncorrect = true;
    private boolean offScreenImageInvalid;
    private boolean offScreenImageSizeInvalid = true;
    private int drawHeight;
    private int drawWidth;
    private int leftOffset = 0;
    private int maxHeight;
    private int rightOffset = 0;
    private int topOffset = 0;
    private int xSpacing = 0;

    public BarChart() {
        this.addAncestorListener(this);
        this.addComponentListener(this);
    }

    public void setAccessibleContext(AccessibleContext accessibleContext) {
        this.accessibleContext = accessibleContext;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public void setDraw3D(boolean bl) {
        if (this.draw3D != bl) {
            this.draw3D = bl;
            this.chartDataChanged();
        }
    }

    public boolean getDraw3D() {
        return this.draw3D;
    }

    public void setFillPaint(Paint paint) {
        if (!this.fillPaint.equals(paint)) {
            this.fillPaint = paint;
            this.chartDataChanged();
        }
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    @Override
    public void setFont(Font font) {
        if (!this.getFont().equals(font)) {
            super.setFont(font);
            this.chartDataChanged();
        }
    }

    public void setLeftOffset(int n) {
        if (this.leftOffset != n) {
            this.leftOffset = n;
            this.chartDataChanged();
        }
    }

    public int getLeftOffset() {
        return this.leftOffset;
    }

    public void setModel(BarChartModel barChartModel) {
        if (this.model != null) {
            this.model.removeChartModelListener(this);
        }
        if (barChartModel != null) {
            barChartModel.addChartModelListener(this);
        }
        this.model = barChartModel;
        this.chartDataChanged();
    }

    public BarChartModel getModel() {
        return this.model;
    }

    public void setOutlinePaint(Paint paint) {
        if (!this.outlinePaint.equals(paint)) {
            this.outlinePaint = paint;
            this.chartDataChanged();
        }
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (!this.outlineStroke.equals(stroke)) {
            this.outlineStroke = stroke;
            this.chartDataChanged();
        }
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setRightOffset(int n) {
        if (this.rightOffset != n) {
            this.rightOffset = n;
            this.chartDataChanged();
        }
    }

    public int getRightOffset() {
        return this.rightOffset;
    }

    public void setTopOffset(int n) {
        if (this.topOffset != n) {
            this.topOffset = n;
            this.chartDataChanged();
        }
    }

    public int getTopOffset() {
        return this.topOffset;
    }

    public void setXSpacing(int n) {
        if (this.xSpacing != n) {
            this.xSpacing = n;
            this.chartDataChanged();
        }
    }

    public int getXSpacing() {
        return this.xSpacing;
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.chartDataChanged();
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void chartDataChanged() {
        if (this.model != null) {
            this.modelIncorrect = true;
            String[] stringArray = this.model.getXLabels();
            int[] nArray = this.model.getYValues();
            if (stringArray == null) {
                throw new RuntimeException("X labels cannot be null!");
            }
            if (nArray == null) {
                throw new RuntimeException("Y values cannot be null!");
            }
            if (stringArray.length - 1 != nArray.length) {
                throw new RuntimeException("Incorrect x-y values count!");
            }
            this.modelIncorrect = false;
            this.maxHeight = this.getMaxY(nArray);
            if (this.getFont() != null && this.getGraphics() != null && this.getGraphics().getFontMetrics() != null) {
                this.horizAxisHeight = this.getFont().getSize() + 10;
                this.horizLegendWidth = (int)this.getGraphics().getFontMetrics().getStringBounds(this.model.getXAxisDesc(), this.getGraphics()).getWidth();
                int n = (int)this.getGraphics().getFontMetrics().getStringBounds(Integer.toString(this.maxHeight) + "0", this.getGraphics()).getWidth() + 10;
                int n2 = (int)this.getGraphics().getFontMetrics().getStringBounds(this.model.getYAxisDesc(), this.getGraphics()).getWidth();
                this.vertLegendHeight = this.getFont().getSize();
                this.vertAxisWidth = Math.max(n, n2 + 4);
            } else {
                this.horizAxisHeight = 0;
                this.horizLegendWidth = 0;
                this.vertAxisWidth = 0;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BarChart.this.offScreenImageInvalid = true;
                BarChart.this.repaint();
            }
        });
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.offScreenImageSizeInvalid = true;
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public static void main(String[] stringArray) {
        BarChart barChart = new BarChart();
        AbstractBarChartModel abstractBarChartModel = new AbstractBarChartModel(){

            @Override
            public String[] getXLabels() {
                return new String[]{"37", "41", "45", "49", "53", "57"};
            }

            @Override
            public String getXAxisDesc() {
                return "[ms]";
            }

            @Override
            public String getYAxisDesc() {
                return "[freq]";
            }

            @Override
            public int[] getYValues() {
                return new int[]{55, 60, 90, 80, 10};
            }
        };
        barChart.setModel(abstractBarChartModel);
        barChart.setBackground(Color.WHITE);
        barChart.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        barChart.setPreferredSize(new Dimension(300, 200));
        barChart.setDraw3D(true);
        barChart.setLeftOffset(20);
        barChart.setRightOffset(5);
        barChart.setTopOffset(30);
        barChart.setXSpacing(10);
        JFrame jFrame = new JFrame("BarChart Tester");
        jFrame.getContentPane().add(barChart);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.model == null || this.modelIncorrect) {
            return;
        }
        if (this.offScreenImageSizeInvalid) {
            this.updateOffScreenImageSize();
        }
        if (this.offScreenImageInvalid) {
            this.drawChart(this.offScreenGraphics);
        }
        graphics.drawImage(this.offScreenImage, this.insets.left, this.insets.top, this);
    }

    protected void drawBar(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Polygon polygon = null;
        Polygon polygon2 = null;
        graphics2D.setPaint(this.fillPaint);
        graphics2D.fillRect(n, n2, n3, n4);
        if (this.draw3D) {
            polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3 / 3, n2 - n3 / 3);
            polygon.addPoint(n + n3 + n3 / 3, n2 - n3 / 3);
            polygon.addPoint(n + n3, n2);
            polygon2 = new Polygon();
            polygon2.addPoint(n + n3, n2);
            polygon2.addPoint(n + n3 + n3 / 3, n2 - n3 / 3);
            polygon2.addPoint(n + n3 + n3 / 3, n2 + n4 - n3 / 3);
            polygon2.addPoint(n + n3, n2 + n4);
            if (this.fillPaint instanceof Color) {
                graphics2D.setPaint(((Color)this.fillPaint).brighter());
            }
            graphics2D.fillPolygon(polygon);
            if (this.fillPaint instanceof Color) {
                graphics2D.setPaint(((Color)this.fillPaint).darker());
            }
            graphics2D.fillPolygon(polygon2);
        }
        graphics2D.setStroke(this.outlineStroke);
        graphics2D.setPaint(this.outlinePaint);
        graphics2D.drawRect(n, n2, n3, n4);
        if (this.draw3D) {
            graphics2D.drawPolygon(polygon);
            graphics2D.drawPolygon(polygon2);
        }
    }

    protected void drawChart(Graphics2D graphics2D) {
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.drawWidth + 1, this.drawHeight + 1);
        String[] stringArray = this.model.getXLabels();
        int[] nArray = this.model.getYValues();
        if (nArray.length > 0 && this.drawWidth > 0 && this.drawHeight > 0) {
            int n = 0;
            if (this.outlineStroke instanceof BasicStroke) {
                n = (int)Math.ceil((((BasicStroke)this.outlineStroke).getLineWidth() - 1.0f) / 2.0f);
            }
            int n2 = nArray.length;
            int n3 = this.drawWidth - this.vertAxisWidth - this.horizLegendWidth - this.leftOffset - this.rightOffset - n2 * this.xSpacing - (this.horizLegendWidth == 0 ? 0 : 5) - n * 2;
            int n4 = this.drawHeight - this.topOffset - this.horizAxisHeight - n * 2;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = this.vertAxisWidth + this.leftOffset + n;
            this.horizAxisXes.clear();
            if (this.draw3D) {
                n6 = n3 / n2 / 3;
                n7 = (n3 -= n6) / n2 / 3;
                n4 -= n7;
            }
            this.drawVerticalAxis(graphics2D, n7, nArray);
            for (int i = 0; i < n2; ++i) {
                int n9 = (n3 - n5) / (n2 - i);
                int n10 = (int)((float)(n4 * nArray[i]) / (float)this.maxHeight);
                int n11 = i == 0 ? Math.max(n8 - this.xSpacing / 2, this.vertAxisWidth) : n8 - this.xSpacing / 2;
                this.drawBar(graphics2D, n8, this.drawHeight - this.horizAxisHeight - n10 - n, n9, n10);
                this.horizAxisXes.add(n11);
                n8 += n9 + this.xSpacing;
                n5 += n9;
            }
            this.horizAxisXes.add(Math.min(n8 - this.xSpacing / 2, this.drawWidth));
            this.drawHorizontalAxis(graphics2D, this.horizAxisXes, stringArray);
        }
        this.offScreenImageInvalid = false;
    }

    protected void drawHorizontalAxis(Graphics2D graphics2D, List list, String[] stringArray) {
        graphics2D.setPaint(this.axisPaint);
        graphics2D.setStroke(this.axisStroke);
        graphics2D.drawLine(this.vertAxisWidth - 3, this.drawHeight - this.horizAxisHeight, this.drawWidth, this.drawHeight - this.horizAxisHeight);
        for (int i = 0; i < list.size(); ++i) {
            int n = (Integer)list.get(i);
            graphics2D.drawLine(n, this.drawHeight - this.horizAxisHeight + 1, n, this.drawHeight - this.horizAxisHeight + 3);
            this.drawHorizontalAxisLegendItem(graphics2D, n, stringArray[i]);
        }
        graphics2D.drawString(this.model.getXAxisDesc(), this.drawWidth - this.horizLegendWidth - 2, this.drawHeight - 5);
    }

    protected void drawHorizontalAxisLegendItem(Graphics2D graphics2D, int n, String string) {
        int n2 = (int)graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth();
        int n3 = Math.min(n - n2 / 2, this.drawWidth - n2 - this.horizLegendWidth - 3);
        graphics2D.drawString(string, n3, this.drawHeight - 5);
    }

    protected void drawVerticalAxis(Graphics2D graphics2D, int n, int[] nArray) {
        long l;
        graphics2D.setPaint(this.axisPaint);
        graphics2D.setStroke(this.axisStroke);
        graphics2D.drawLine(this.vertAxisWidth, 0, this.vertAxisWidth, this.drawHeight - this.horizAxisHeight);
        double d = (double)(this.drawHeight - this.horizAxisHeight - this.topOffset - n) / (double)this.maxHeight;
        long l2 = DecimalAxisUtils.getOptimalUnits(d, 30);
        long l3 = l = 0L;
        int n2 = this.drawHeight - this.horizAxisHeight - (int)((double)l3 * d);
        while (n2 >= this.vertLegendHeight + 5) {
            graphics2D.setPaint(this.axisPaint);
            graphics2D.setStroke(this.axisStroke);
            graphics2D.drawLine(this.vertAxisWidth - 3, n2, this.vertAxisWidth - 1, n2);
            this.drawVerticalAxisLegendItem(graphics2D, n2, Long.toString(l3));
            graphics2D.setPaint(this.axisMeshPaint);
            graphics2D.drawLine(this.vertAxisWidth, n2, this.vertAxisWidth + this.drawWidth, n2);
            n2 = this.drawHeight - this.horizAxisHeight - (int)((double)(l3 += l2) * d);
        }
        graphics2D.setPaint(this.axisPaint);
        graphics2D.drawString(this.model.getYAxisDesc(), 2, this.vertLegendHeight);
    }

    protected void drawVerticalAxisLegendItem(Graphics2D graphics2D, int n, String string) {
        int n2 = (int)graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth();
        int n3 = this.vertLegendHeight;
        int n4 = this.vertAxisWidth - n2 - 5;
        int n5 = Math.max(n + n3 / 2 - 2, 2 * n3 + 3);
        graphics2D.drawString(string, n4, n5);
    }

    protected void updateOffScreenImageSize() {
        this.insets = this.getInsets();
        this.drawWidth = this.getWidth() - this.insets.left - this.insets.right;
        this.drawHeight = this.getHeight() - this.insets.top - this.insets.bottom - 1;
        this.offScreenImage = this.createImage(this.drawWidth + 1, this.drawHeight + 1);
        this.offScreenGraphics = (Graphics2D)this.offScreenImage.getGraphics();
        this.offScreenGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.offScreenImageSizeInvalid = false;
        this.offScreenImageInvalid = true;
    }

    private int getMaxY(int[] nArray) {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (n >= nArray[i]) continue;
            n = nArray[i];
        }
        return n;
    }
}

