/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.basicobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.basicobject.BasicObjectNodes;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=BasicObjectNodes.class)
public final class BasicObjectNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(NotNodeFactory.getInstance(), NotEqualNodeFactory.getInstance(), ReferenceEqualNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InstanceEvalNodeFactory.getInstance(), InstanceExecNodeFactory.getInstance(), InstanceVariablesNodeFactory.getInstance(), MethodMissingNodeFactory.getInstance(), SendNodeFactory.getInstance(), AllocateNodeFactory.getInstance());
    }

    @GeneratedBy(value=BasicObjectNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(BasicObjectNodes.AllocateNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static BasicObjectNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends BasicObjectNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.SendNode.class)
    public static final class SendNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.SendNode> {
        private static SendNodeFactory sendNodeFactoryInstance;

        private SendNodeFactory() {
            super(BasicObjectNodes.SendNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.SendNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SendNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.SendNode> getInstance() {
            if (sendNodeFactoryInstance == null) {
                sendNodeFactoryInstance = new SendNodeFactory();
            }
            return sendNodeFactoryInstance;
        }

        public static BasicObjectNodes.SendNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SendNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.SendNode.class)
        public static final class SendNodeGen
        extends BasicObjectNodes.SendNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @Node.Child
            private BaseNode_ specialization_;

            private SendNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="send(VirtualFrame, Object, Object, Object[], DynamicObject)", value=BasicObjectNodes.SendNode.class)
            private static final class Send1Node_
            extends BaseNode_ {
                Send1Node_(SendNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments2Value instanceof Object[] && arguments3Value instanceof DynamicObject) {
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        return this.root.send(frameValue, arguments0Value, arguments1Value, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(SendNodeGen root) {
                    return new Send1Node_(root);
                }
            }

            @GeneratedBy(methodName="send(VirtualFrame, Object, Object, Object[], NotProvided)", value=BasicObjectNodes.SendNode.class)
            private static final class Send0Node_
            extends BaseNode_ {
                Send0Node_(SendNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        return this.root.send(frameValue, arguments0Value, arguments1Value, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(SendNodeGen root) {
                    return new Send0Node_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.SendNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SendNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(SendNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.SendNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SendNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(SendNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.SendNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SendNodeGen root;

                BaseNode_(SendNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SendNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments2Value instanceof Object[]) {
                        if (arguments3Value instanceof NotProvided) {
                            return Send0Node_.create(this.root);
                        }
                        if (arguments3Value instanceof DynamicObject) {
                            return Send1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
    public static final class MethodMissingNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.MethodMissingNode> {
        private static MethodMissingNodeFactory methodMissingNodeFactoryInstance;

        private MethodMissingNodeFactory() {
            super(BasicObjectNodes.MethodMissingNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.MethodMissingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return MethodMissingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.MethodMissingNode> getInstance() {
            if (methodMissingNodeFactoryInstance == null) {
                methodMissingNodeFactoryInstance = new MethodMissingNodeFactory();
            }
            return methodMissingNodeFactoryInstance;
        }

        public static BasicObjectNodes.MethodMissingNode create(RubyNode[] arguments) {
            return new MethodMissingNodeGen(arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
        public static final class MethodMissingNodeGen
        extends BasicObjectNodes.MethodMissingNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @Node.Child
            private BaseNode_ specialization_;

            private MethodMissingNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="methodMissingBlock(Object, DynamicObject, Object[], DynamicObject)", value=BasicObjectNodes.MethodMissingNode.class)
            private static final class MethodMissingBlockNode_
            extends BaseNode_ {
                MethodMissingBlockNode_(MethodMissingNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        return this.root.methodMissingBlock(arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(MethodMissingNodeGen root) {
                    return new MethodMissingBlockNode_(root);
                }
            }

            @GeneratedBy(methodName="methodMissingNoBlock(Object, DynamicObject, Object[], NotProvided)", value=BasicObjectNodes.MethodMissingNode.class)
            private static final class MethodMissingNoBlockNode_
            extends BaseNode_ {
                MethodMissingNoBlockNode_(MethodMissingNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        return this.root.methodMissingNoBlock(arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(MethodMissingNodeGen root) {
                    return new MethodMissingNoBlockNode_(root);
                }
            }

            @GeneratedBy(methodName="methodMissingNoName(Object, NotProvided, Object[], NotProvided)", value=BasicObjectNodes.MethodMissingNode.class)
            private static final class MethodMissingNoNameNode_
            extends BaseNode_ {
                MethodMissingNoNameNode_(MethodMissingNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments1Value instanceof NotProvided && arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        return this.root.methodMissingNoName(arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(MethodMissingNodeGen root) {
                    return new MethodMissingNoNameNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MethodMissingNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(MethodMissingNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MethodMissingNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(MethodMissingNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MethodMissingNodeGen root;

                BaseNode_(MethodMissingNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (MethodMissingNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments2Value instanceof Object[]) {
                        if (arguments3Value instanceof NotProvided) {
                            if (arguments1Value instanceof NotProvided) {
                                return MethodMissingNoNameNode_.create(this.root);
                            }
                            if (arguments1Value instanceof DynamicObject) {
                                return MethodMissingNoBlockNode_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof DynamicObject && arguments3Value instanceof DynamicObject) {
                            return MethodMissingBlockNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.InstanceVariablesNode.class)
    public static final class InstanceVariablesNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.InstanceVariablesNode> {
        private static InstanceVariablesNodeFactory instanceVariablesNodeFactoryInstance;

        private InstanceVariablesNodeFactory() {
            super(BasicObjectNodes.InstanceVariablesNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.InstanceVariablesNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InstanceVariablesNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.InstanceVariablesNode> getInstance() {
            if (instanceVariablesNodeFactoryInstance == null) {
                instanceVariablesNodeFactoryInstance = new InstanceVariablesNodeFactory();
            }
            return instanceVariablesNodeFactoryInstance;
        }

        public static BasicObjectNodes.InstanceVariablesNode create(RubyNode[] arguments) {
            return new InstanceVariablesNodeGen(arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceVariablesNode.class)
        public static final class InstanceVariablesNodeGen
        extends BasicObjectNodes.InstanceVariablesNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InstanceVariablesNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public DynamicObject executeObject(DynamicObject arguments0Value) {
                return this.instanceVariables(arguments0Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.instanceVariables(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
    public static final class InstanceExecNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.InstanceExecNode> {
        private static InstanceExecNodeFactory instanceExecNodeFactoryInstance;

        private InstanceExecNodeFactory() {
            super(BasicObjectNodes.InstanceExecNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.InstanceExecNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceExecNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.InstanceExecNode> getInstance() {
            if (instanceExecNodeFactoryInstance == null) {
                instanceExecNodeFactoryInstance = new InstanceExecNodeFactory();
            }
            return instanceExecNodeFactoryInstance;
        }

        public static BasicObjectNodes.InstanceExecNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstanceExecNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
        public static final class InstanceExecNodeGen
        extends BasicObjectNodes.InstanceExecNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private InstanceExecNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="instanceExec(Object, Object[], NotProvided)", value=BasicObjectNodes.InstanceExecNode.class)
            private static final class InstanceExec1Node_
            extends BaseNode_ {
                InstanceExec1Node_(InstanceExecNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[] && arguments2Value instanceof NotProvided) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.instanceExec(arguments0Value, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceExecNodeGen root) {
                    return new InstanceExec1Node_(root);
                }
            }

            @GeneratedBy(methodName="instanceExec(VirtualFrame, Object, Object[], DynamicObject)", value=BasicObjectNodes.InstanceExecNode.class)
            private static final class InstanceExec0Node_
            extends BaseNode_ {
                InstanceExec0Node_(InstanceExecNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[] && arguments2Value instanceof DynamicObject) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        return this.root.instanceExec(frameValue, arguments0Value, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceExecNodeGen root) {
                    return new InstanceExec0Node_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InstanceExecNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceExecNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InstanceExecNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceExecNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InstanceExecNodeGen root;

                BaseNode_(InstanceExecNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (InstanceExecNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof Object[]) {
                        if (arguments2Value instanceof DynamicObject) {
                            return InstanceExec0Node_.create(this.root);
                        }
                        if (arguments2Value instanceof NotProvided) {
                            return InstanceExec1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
    public static final class InstanceEvalNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.InstanceEvalNode> {
        private static InstanceEvalNodeFactory instanceEvalNodeFactoryInstance;

        private InstanceEvalNodeFactory() {
            super(BasicObjectNodes.InstanceEvalNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.InstanceEvalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceEvalNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.InstanceEvalNode> getInstance() {
            if (instanceEvalNodeFactoryInstance == null) {
                instanceEvalNodeFactoryInstance = new InstanceEvalNodeFactory();
            }
            return instanceEvalNodeFactoryInstance;
        }

        public static BasicObjectNodes.InstanceEvalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstanceEvalNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
        public static final class InstanceEvalNodeGen
        extends BasicObjectNodes.InstanceEvalNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @Node.Child
            private RubyNode arguments4_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private InstanceEvalNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.arguments4_ = arguments != null && 4 < arguments.length ? arguments[4] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="instanceEval(VirtualFrame, Object, NotProvided, NotProvided, NotProvided, DynamicObject)", value=BasicObjectNodes.InstanceEvalNode.class)
            private static final class InstanceEval3Node_
            extends BaseNode_ {
                InstanceEval3Node_(InstanceEvalNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided && arguments4Value instanceof DynamicObject) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        DynamicObject arguments4Value_ = (DynamicObject)arguments4Value;
                        return this.root.instanceEval(frameValue, arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(InstanceEvalNodeGen root) {
                    return new InstanceEval3Node_(root);
                }
            }

            @GeneratedBy(methodName="instanceEval(VirtualFrame, Object, DynamicObject, NotProvided, NotProvided, NotProvided, IndirectCallNode)", value=BasicObjectNodes.InstanceEvalNode.class)
            private static final class InstanceEval2Node_
            extends BaseNode_ {
                @Node.Child
                private IndirectCallNode callNode;

                InstanceEval2Node_(InstanceEvalNodeGen root, IndirectCallNode callNode) {
                    super(root, 3);
                    this.callNode = callNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided && arguments4Value instanceof NotProvided) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        NotProvided arguments4Value_ = (NotProvided)arguments4Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.instanceEval(frameValue, arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_, this.callNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(InstanceEvalNodeGen root, IndirectCallNode callNode) {
                    return new InstanceEval2Node_(root, callNode);
                }
            }

            @GeneratedBy(methodName="instanceEval(VirtualFrame, Object, DynamicObject, DynamicObject, NotProvided, NotProvided, IndirectCallNode)", value=BasicObjectNodes.InstanceEvalNode.class)
            private static final class InstanceEval1Node_
            extends BaseNode_ {
                @Node.Child
                private IndirectCallNode callNode;

                InstanceEval1Node_(InstanceEvalNodeGen root, IndirectCallNode callNode) {
                    super(root, 2);
                    this.callNode = callNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments1Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && arguments3Value instanceof NotProvided && arguments4Value instanceof NotProvided) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        NotProvided arguments4Value_ = (NotProvided)arguments4Value;
                        if (RubyGuards.isRubyString(arguments1Value_) && RubyGuards.isRubyString(arguments2Value_)) {
                            return this.root.instanceEval(frameValue, arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_, this.callNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(InstanceEvalNodeGen root, IndirectCallNode callNode) {
                    return new InstanceEval1Node_(root, callNode);
                }
            }

            @GeneratedBy(methodName="instanceEval(VirtualFrame, Object, DynamicObject, DynamicObject, int, NotProvided, IndirectCallNode)", value=BasicObjectNodes.InstanceEvalNode.class)
            private static final class InstanceEval0Node_
            extends BaseNode_ {
                @Node.Child
                private IndirectCallNode callNode;
                private final Class<?> arguments3ImplicitType;

                InstanceEval0Node_(InstanceEvalNodeGen root, Object arguments3Value, IndirectCallNode callNode) {
                    super(root, 1);
                    this.arguments3ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments3Value);
                    this.callNode = callNode;
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments3ImplicitType == ((InstanceEval0Node_)other).arguments3ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    NotProvided arguments4Value_;
                    int arguments3Value_;
                    DynamicObject arguments2Value_;
                    DynamicObject arguments1Value_;
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        Object arguments4Value = this.root.arguments4_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value, arguments3Value, arguments4Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments3Value = this.executeArguments3_(frameValue);
                        Object arguments4Value = this.root.arguments4_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value, arguments4Value);
                    }
                    try {
                        if (this.arguments3ImplicitType == Integer.TYPE) {
                            arguments3Value_ = this.root.arguments3_.executeInteger(frameValue);
                        } else {
                            Object arguments3Value__ = this.executeArguments3_(frameValue);
                            arguments3Value_ = RubyTypesGen.expectImplicitInteger(arguments3Value__, this.arguments3ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments4Value = this.root.arguments4_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult(), arguments4Value);
                    }
                    try {
                        arguments4Value_ = this.root.arguments4_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments1Value_) && RubyGuards.isRubyString(arguments2Value_)) {
                        return this.root.instanceEval(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_, this.callNode);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments1Value instanceof DynamicObject && arguments2Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments3Value, this.arguments3ImplicitType) && arguments4Value instanceof NotProvided) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        int arguments3Value_ = RubyTypesGen.asImplicitInteger(arguments3Value, this.arguments3ImplicitType);
                        NotProvided arguments4Value_ = (NotProvided)arguments4Value;
                        if (RubyGuards.isRubyString(arguments1Value_) && RubyGuards.isRubyString(arguments2Value_)) {
                            return this.root.instanceEval(frameValue, arguments0Value, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_, this.callNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(InstanceEvalNodeGen root, Object arguments3Value, IndirectCallNode callNode) {
                    return new InstanceEval0Node_(root, arguments3Value, callNode);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InstanceEvalNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(InstanceEvalNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InstanceEvalNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                static BaseNode_ create(InstanceEvalNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InstanceEvalNodeGen root;

                BaseNode_(InstanceEvalNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (InstanceEvalNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_, this.root.arguments4_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, arguments4Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5, Object var6);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.executeArguments3_(frameValue);
                    Object arguments4Value_ = this.root.arguments4_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, arguments4Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, Object arguments4Value) {
                    if (arguments1Value instanceof DynamicObject && arguments4Value instanceof NotProvided) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (arguments2Value instanceof DynamicObject) {
                            DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                            if (RubyTypesGen.isImplicitInteger(arguments3Value) && RubyGuards.isRubyString(arguments1Value_) && RubyGuards.isRubyString(arguments2Value_)) {
                                IndirectCallNode callNode1 = IndirectCallNode.create();
                                return InstanceEval0Node_.create(this.root, arguments3Value, callNode1);
                            }
                            if (arguments3Value instanceof NotProvided && RubyGuards.isRubyString(arguments1Value_) && RubyGuards.isRubyString(arguments2Value_)) {
                                IndirectCallNode callNode2 = IndirectCallNode.create();
                                return InstanceEval1Node_.create(this.root, callNode2);
                            }
                        }
                        if (arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided && RubyGuards.isRubyString(arguments1Value_)) {
                            IndirectCallNode callNode3 = IndirectCallNode.create();
                            return InstanceEval2Node_.create(this.root, callNode3);
                        }
                    }
                    if (arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided && arguments3Value instanceof NotProvided && arguments4Value instanceof DynamicObject) {
                        return InstanceEval3Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments3_(Frame frameValue) {
                    Object object;
                    Class arguments3Type_ = this.root.arguments3Type_;
                    if (arguments3Type_ == Integer.TYPE) {
                        return this.root.arguments3_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments3Type_ != null) return this.root.arguments3_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments3_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments3Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments3Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments3Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(BasicObjectNodes.InitializeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static BasicObjectNodes.InitializeNode create(RubyNode[] arguments) {
            return new InitializeNodeGen(arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends BasicObjectNodes.InitializeNode {
            private InitializeNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.initialize();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
    public static final class ReferenceEqualNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.ReferenceEqualNode> {
        private static ReferenceEqualNodeFactory referenceEqualNodeFactoryInstance;

        private ReferenceEqualNodeFactory() {
            super(BasicObjectNodes.ReferenceEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.ReferenceEqualNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ReferenceEqualNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.ReferenceEqualNode> getInstance() {
            if (referenceEqualNodeFactoryInstance == null) {
                referenceEqualNodeFactoryInstance = new ReferenceEqualNodeFactory();
            }
            return referenceEqualNodeFactoryInstance;
        }

        public static BasicObjectNodes.ReferenceEqualNode create(RubyNode[] arguments) {
            return new ReferenceEqualNodeGen(arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        public static final class ReferenceEqualNodeGen
        extends BasicObjectNodes.ReferenceEqualNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ReferenceEqualNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.specialization_.executeBoolean1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean0(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="equal(DynamicObject, Object)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal7Node_
            extends BaseNode_ {
                Equal7Node_(ReferenceEqualNodeGen root) {
                    super(root, 8);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean1(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    if (this.root.isNotDynamicObject(arguments1Value_)) {
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (this.root.isNotDynamicObject(arguments1Value)) {
                            return this.root.equal(arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal7Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(Object, DynamicObject)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal6Node_
            extends BaseNode_ {
                Equal6Node_(ReferenceEqualNodeGen root) {
                    super(root, 7);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean1(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (this.root.isNotDynamicObject(arguments0Value_)) {
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (this.root.isNotDynamicObject(arguments0Value)) {
                            return this.root.equal(arguments0Value, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal6Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(Object, Object)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal5Node_
            extends BaseNode_ {
                Equal5Node_(ReferenceEqualNodeGen root) {
                    super(root, 6);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    if (this.root.isNotDynamicObject(arguments0Value_) && this.root.isNotDynamicObject(arguments1Value_) && this.root.notSameClass(arguments0Value_, arguments1Value_)) {
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (this.root.isNotDynamicObject(arguments0Value) && this.root.isNotDynamicObject(arguments1Value) && this.root.notSameClass(arguments0Value, arguments1Value)) {
                        return this.root.equal(arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal5Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(DynamicObject, DynamicObject)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal4Node_
            extends BaseNode_ {
                Equal4Node_(ReferenceEqualNodeGen root) {
                    super(root, 5);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean1(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean1(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal4Node_(root);
                }
            }

            @GeneratedBy(methodName="equal(double, double)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Equal3Node_(ReferenceEqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Equal3Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Equal3Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    double arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean1(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean1(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Equal3Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="equal(long, long)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Equal2Node_(ReferenceEqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Equal2Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Equal2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean1(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Long.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeLong(frameValue);
                        } else if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = RubyTypes.promoteToLong(this.root.arguments1_.executeInteger(frameValue));
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitLong(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean1(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Equal2Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="equal(int, int)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Equal1Node_(ReferenceEqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Equal1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Equal1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean1(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean1(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Equal1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="equal(boolean, boolean)", value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class Equal0Node_
            extends BaseNode_ {
                Equal0Node_(ReferenceEqualNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    boolean arguments1Value_;
                    boolean arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean1(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean1(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.equal(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Boolean && arguments1Value instanceof Boolean) {
                        boolean arguments0Value_ = (Boolean)arguments0Value;
                        boolean arguments1Value_ = (Boolean)arguments1Value;
                        return this.root.equal(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new Equal0Node_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ReferenceEqualNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.getNext().executeBoolean1(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ReferenceEqualNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReferenceEqualNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ReferenceEqualNodeGen root;

                BaseNode_(ReferenceEqualNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ReferenceEqualNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean1((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean1(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeBoolean1(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean0(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Boolean && arguments1Value instanceof Boolean) {
                        return Equal0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitInteger(arguments0Value) && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        return Equal1Node_.create(this.root, arguments0Value, arguments1Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value) && RubyTypesGen.isImplicitLong(arguments1Value)) {
                        return Equal2Node_.create(this.root, arguments0Value, arguments1Value);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value) && RubyTypesGen.isImplicitDouble(arguments1Value)) {
                        return Equal3Node_.create(this.root, arguments0Value, arguments1Value);
                    }
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        return Equal4Node_.create(this.root);
                    }
                    if (this.root.isNotDynamicObject(arguments0Value) && this.root.isNotDynamicObject(arguments1Value) && this.root.notSameClass(arguments0Value, arguments1Value)) {
                        return Equal5Node_.create(this.root);
                    }
                    if (arguments1Value instanceof DynamicObject && this.root.isNotDynamicObject(arguments0Value)) {
                        return Equal6Node_.create(this.root);
                    }
                    if (arguments0Value instanceof DynamicObject && this.root.isNotDynamicObject(arguments1Value)) {
                        return Equal7Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Boolean.TYPE) {
                        return this.root.arguments0_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Boolean.TYPE) {
                        return this.root.arguments1_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.NotEqualNode.class)
    public static final class NotEqualNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.NotEqualNode> {
        private static NotEqualNodeFactory notEqualNodeFactoryInstance;

        private NotEqualNodeFactory() {
            super(BasicObjectNodes.NotEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public BasicObjectNodes.NotEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NotEqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.NotEqualNode> getInstance() {
            if (notEqualNodeFactoryInstance == null) {
                notEqualNodeFactoryInstance = new NotEqualNodeFactory();
            }
            return notEqualNodeFactoryInstance;
        }

        public static BasicObjectNodes.NotEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NotEqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=BasicObjectNodes.NotEqualNode.class)
        public static final class NotEqualNodeGen
        extends BasicObjectNodes.NotEqualNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private NotEqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.equal(frameValue, arguments0Value_, arguments1Value_);
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.NotNode.class)
    public static final class NotNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.NotNode> {
        private static NotNodeFactory notNodeFactoryInstance;

        private NotNodeFactory() {
            super(BasicObjectNodes.NotNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode.class}});
        }

        @Override
        public BasicObjectNodes.NotNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return NotNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BasicObjectNodes.NotNode> getInstance() {
            if (notNodeFactoryInstance == null) {
                notNodeFactoryInstance = new NotNodeFactory();
            }
            return notNodeFactoryInstance;
        }

        public static BasicObjectNodes.NotNode create(RubyNode operand) {
            return new NotNodeGen(operand);
        }

        @GeneratedBy(value=BasicObjectNodes.NotNode.class)
        public static final class NotNodeGen
        extends BasicObjectNodes.NotNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private NotNodeGen(RubyNode operand) {
                this.operand_ = this.createCast(operand);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean operandValue_;
                try {
                    operandValue_ = this.operand_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.not(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }
}

