/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.language.RubyNode;

public class OrNode
extends RubyNode {
    @Node.Child
    private RubyNode left;
    @Node.Child
    private RubyNode right;
    @Node.Child
    private BooleanCastNode leftCast;
    private final ConditionProfile conditionProfile = ConditionProfile.createCountingProfile();

    public OrNode(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
        super(context, sourceSection);
        this.left = left;
        this.right = right;
        this.leftCast = BooleanCastNodeGen.create(context, sourceSection, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object leftValue = this.left.execute(frame);
        boolean leftBoolean = this.leftCast.executeBoolean(frame, leftValue);
        if (this.conditionProfile.profile(leftBoolean)) {
            return leftValue;
        }
        return this.right.execute(frame);
    }
}

