/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Record {
    private byte[] data;
    private byte attributes = 0;

    public Record() {
        this.data = new byte[0];
    }

    public Record(byte[] d) {
        this(d, 0);
    }

    public Record(byte[] d, byte attrs) {
        this.data = new byte[d.length];
        this.attributes = attrs;
        System.arraycopy(d, 0, this.data, 0, d.length);
    }

    public int getSize() {
        return this.data.length;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public byte getAttributes() {
        return this.attributes;
    }

    public void write(OutputStream outs) throws IOException {
        DataOutputStream out = new DataOutputStream(outs);
        out.writeByte(this.attributes);
        out.writeShort(this.data.length);
        out.write(this.data);
    }

    public void read(InputStream ins) throws IOException {
        DataInputStream in = new DataInputStream(ins);
        this.attributes = in.readByte();
        int len = in.readUnsignedShort();
        this.data = new byte[len];
        in.readFully(this.data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Record)) {
            return false;
        }
        Record rec = (Record)obj;
        if (rec.getAttributes() != this.attributes) {
            return false;
        }
        if (rec.getSize() == this.data.length) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == rec.data[i]) continue;
                return false;
            }
        }
        return false;
    }
}

