/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotReverseMemCallGraphPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotSampledResultsPanel;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.SaveSnapshotAction;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotInfoPanel;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.CompareSnapshotsAction;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.openide.actions.FindAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class MemorySnapshotPanel
extends SnapshotPanel
implements ChangeListener,
SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final Icon MEMORY_RESULTS_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabMemoryResults");
    private static final Icon INFO_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabInfo");
    private static final Icon STACK_TRACES_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabStackTraces");
    private Component findActionPresenter;
    private Component findNextPresenter;
    private Component findPreviousPresenter;
    private MemoryResultsPanel memoryPanel;
    private MemoryResultsSnapshot snapshot;
    private Lookup.Provider project;
    private SaveSnapshotAction saveAction;
    private SnapshotInfoPanel infoPanel;
    private SnapshotReverseMemCallGraphPanel reversePanel;

    public MemorySnapshotPanel(Lookup lookup, LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        SnapshotSampledResultsPanel snapshotSampledResultsPanel;
        this.snapshot = (MemoryResultsSnapshot)loadedSnapshot.getSnapshot();
        this.project = loadedSnapshot.getProject();
        this.setLayout(new BorderLayout());
        SnapshotActionsHandler snapshotActionsHandler = new SnapshotActionsHandler();
        this.infoPanel = new SnapshotInfoPanel(loadedSnapshot);
        if (this.snapshot instanceof SampledMemoryResultsSnapshot) {
            this.memoryPanel = new SnapshotSampledResultsPanel((SampledMemoryResultsSnapshot)this.snapshot, (MemoryResUserActionsHandler)snapshotActionsHandler);
            snapshotSampledResultsPanel = (SnapshotSampledResultsPanel)this.memoryPanel;
            snapshotSampledResultsPanel.setSorting(n, bl);
            snapshotSampledResultsPanel.prepareResults();
        } else if (this.snapshot instanceof LivenessMemoryResultsSnapshot) {
            this.memoryPanel = new SnapshotLivenessResultsPanel((LivenessMemoryResultsSnapshot)this.snapshot, (MemoryResUserActionsHandler)snapshotActionsHandler, loadedSnapshot.getSettings().getAllocTrackEvery());
            snapshotSampledResultsPanel = (SnapshotLivenessResultsPanel)this.memoryPanel;
            snapshotSampledResultsPanel.setSorting(n, bl);
            snapshotSampledResultsPanel.prepareResults();
        } else {
            this.memoryPanel = new SnapshotAllocResultsPanel((AllocMemoryResultsSnapshot)this.snapshot, (MemoryResUserActionsHandler)snapshotActionsHandler);
            snapshotSampledResultsPanel = (SnapshotAllocResultsPanel)this.memoryPanel;
            snapshotSampledResultsPanel.setSorting(n, bl);
            snapshotSampledResultsPanel.prepareResults();
        }
        this.infoPanel.updateInfo();
        this.addView(Bundle.MemorySnapshotPanel_MemoryResultsTabName(), MEMORY_RESULTS_TAB_ICON, Bundle.MemorySnapshotPanel_MemoryResultsTabDescr(), (Component)this.memoryPanel, null);
        if (this.snapshot.containsStacks()) {
            this.reversePanel = new SnapshotReverseMemCallGraphPanel(this.snapshot, (MemoryResUserActionsHandler)snapshotActionsHandler);
            this.reversePanel.prepareResults();
            this.addView(Bundle.MemorySnapshotPanel_StackTracesTabName(), STACK_TRACES_TAB_ICON, Bundle.MemorySnapshotPanel_StackTracesTabDescr(), (Component)this.reversePanel, null);
            this.setViewEnabled((Component)this.reversePanel, false);
        }
        this.addView(Bundle.MemorySnapshotPanel_InfoTabName(), INFO_TAB_ICON, Bundle.MemorySnapshotPanel_InfoTabDescr(), this.infoPanel, null);
        this.addChangeListener(this);
        snapshotSampledResultsPanel = ProfilerToolbar.create((boolean)true);
        this.saveAction = new SaveSnapshotAction(loadedSnapshot);
        snapshotSampledResultsPanel.add((Action)new ExportAction(this, loadedSnapshot));
        snapshotSampledResultsPanel.add((Action)new SaveViewAction(this));
        snapshotSampledResultsPanel.addSeparator();
        ContextAwareAction contextAwareAction = (ContextAwareAction)SystemAction.get(FindAction.class);
        this.findActionPresenter = snapshotSampledResultsPanel.add(contextAwareAction.createContextAwareInstance(lookup));
        this.findPreviousPresenter = snapshotSampledResultsPanel.add((Action)new FindPreviousAction(this));
        this.findNextPresenter = snapshotSampledResultsPanel.add((Action)new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)this.findActionPresenter;
            abstractButton.setIcon(Icons.getIcon((String)"GeneralIcons.Find"));
            abstractButton.setText("");
            abstractButton.setToolTipText(Bundle.MemorySnapshotPanel_FindActionTooltip());
        }
        snapshotSampledResultsPanel.addSeparator();
        snapshotSampledResultsPanel.add((Action)new CompareSnapshotsAction(loadedSnapshot));
        this.findActionPresenter.setEnabled(false);
        this.findPreviousPresenter.setEnabled(false);
        this.findNextPresenter.setEnabled(false);
        this.updateToolbar();
        this.add(snapshotSampledResultsPanel.getComponent(), "North");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemorySnapshotPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemorySnapshotPanel.this.performFindNext();
            }
        });
    }

    @Override
    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public BufferedImage getViewImage(boolean bl) {
        Component component = this.getSelectedView();
        if (component == this.memoryPanel) {
            return this.memoryPanel.getCurrentViewScreenshot(bl);
        }
        if (component == this.reversePanel) {
            return this.reversePanel.getCurrentViewScreenshot(bl);
        }
        if (component == this.infoPanel) {
            return this.infoPanel.getCurrentViewScreenshot(bl);
        }
        return null;
    }

    @Override
    public String getViewName() {
        Component component = this.getSelectedView();
        if (component == this.memoryPanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-memory_results";
        }
        if (component == this.reversePanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-allocation_stack_traces";
        }
        if (component == this.infoPanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-info";
        }
        return null;
    }

    public void displayStacksForClass(int n, int n2, boolean bl) {
        this.setReverseCallGraphClass(n, n2, bl);
        this.selectView((Component)this.reversePanel);
    }

    @Override
    public boolean fitsVisibleArea() {
        Component component = this.getSelectedView();
        if (component == this.memoryPanel) {
            return this.memoryPanel.fitsVisibleArea();
        }
        if (component == this.reversePanel) {
            return this.reversePanel.fitsVisibleArea();
        }
        if (component == this.infoPanel) {
            return this.infoPanel.fitsVisibleArea();
        }
        return true;
    }

    @Override
    public boolean hasView() {
        Component component = this.getSelectedView();
        if (component == this.memoryPanel) {
            return true;
        }
        if (component == this.reversePanel) {
            return this.reversePanel.hasView();
        }
        return false;
    }

    @Override
    public void performFind() {
        Component component = this.getSelectedView();
        if (component == this.memoryPanel) {
            String string = FindDialog.getFindString();
            if (string == null) {
                return;
            }
            this.memoryPanel.setFindString(string);
            if (this.reversePanel != null) {
                this.reversePanel.setFindString(string);
            }
            if (!this.memoryPanel.findFirst()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        } else if (component == this.reversePanel) {
            String string = FindDialog.getFindString();
            if (string == null) {
                return;
            }
            this.memoryPanel.setFindString(string);
            this.reversePanel.setFindString(string);
            if (!this.reversePanel.findFirst()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        }
    }

    @Override
    public void performFindNext() {
        Component component = this.getSelectedView();
        if (component == this.memoryPanel) {
            if (!this.memoryPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.memoryPanel.setFindString(string);
                if (this.reversePanel != null) {
                    this.reversePanel.setFindString(string);
                }
            }
            if (!this.memoryPanel.findNext()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        } else if (component == this.reversePanel) {
            if (!this.reversePanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.memoryPanel.setFindString(string);
                this.reversePanel.setFindString(string);
            }
            if (!this.reversePanel.findNext()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        }
    }

    @Override
    public void performFindPrevious() {
        String string;
        Component component = this.getSelectedView();
        if (component == this.memoryPanel) {
            if (!this.memoryPanel.isFindStringDefined()) {
                string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.memoryPanel.setFindString(string);
                if (this.reversePanel != null) {
                    this.reversePanel.setFindString(string);
                }
            }
            if (!this.memoryPanel.findPrevious()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        }
        if (component == this.reversePanel) {
            if (!this.reversePanel.isFindStringDefined()) {
                string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.memoryPanel.setFindString(string);
                this.reversePanel.setFindString(string);
            }
            if (!this.reversePanel.findPrevious()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        }
    }

    public void requestFocus() {
        if (this.memoryPanel != null) {
            this.memoryPanel.requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateToolbar();
        final Component component = this.getSelectedView();
        if (component != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    component.requestFocus();
                }
            });
        }
    }

    @Override
    public void updateSavedState() {
        this.infoPanel.updateInfo();
        this.saveAction.updateState();
    }

    private String getDefaultSnapshotFileName(ResultsSnapshot resultsSnapshot) {
        return "snapshot-" + resultsSnapshot.getTimeTaken();
    }

    private void setReverseCallGraphClass(int n, int n2, boolean bl) {
        this.reversePanel.setClassId(n);
        this.reversePanel.setSorting(n2, bl);
        this.reversePanel.prepareResults();
        this.setViewEnabled((Component)this.reversePanel, true);
    }

    private void updateToolbar() {
        Component component = this.getSelectedView();
        boolean bl = component != this.infoPanel && (component != this.reversePanel || !this.reversePanel.isEmpty());
        this.findActionPresenter.setEnabled(bl);
        this.findPreviousPresenter.setEnabled(bl);
        this.findNextPresenter.setEnabled(bl);
    }

    @Override
    public void exportData(int n, ExportDataDumper exportDataDumper) {
        Component component = this.getSelectedView();
        if (component == this.memoryPanel) {
            if (this.memoryPanel instanceof SnapshotSampledResultsPanel) {
                ((SnapshotSampledResultsPanel)this.memoryPanel).exportData(n, exportDataDumper, Bundle.MemorySnapshotPanel_MemoryResultsTabName());
            } else if (this.memoryPanel instanceof SnapshotAllocResultsPanel) {
                ((SnapshotAllocResultsPanel)this.memoryPanel).exportData(n, exportDataDumper, Bundle.MemorySnapshotPanel_MemoryResultsTabName());
            } else if (this.memoryPanel instanceof SnapshotLivenessResultsPanel) {
                ((SnapshotLivenessResultsPanel)this.memoryPanel).exportData(n, exportDataDumper, Bundle.MemorySnapshotPanel_MemoryResultsTabName());
            }
        } else if (component == this.reversePanel) {
            this.reversePanel.exportData(n, exportDataDumper, Bundle.MemorySnapshotPanel_StackTracesTabName());
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return this.snapshot != null;
    }

    @Override
    public boolean hasExportableView() {
        Component component = this.getSelectedView();
        if (component == this.memoryPanel) {
            return true;
        }
        if (component == this.reversePanel) {
            return this.reversePanel.hasView();
        }
        return false;
    }

    private class SnapshotActionsHandler
    implements MemoryResUserActionsHandler {
        private SnapshotActionsHandler() {
        }

        public void showSourceForMethod(String string, String string2, String string3) {
            if (string2 == null && string3 == null && (VMUtils.isVMPrimitiveType((String)string) || VMUtils.isPrimitiveType((String)string))) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_PRIMITIVE_SRC_MSG);
            } else if ("org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(string) && "traceVMObjectAlloc".equals(string2)) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_REFLECTION_SRC_MSG);
            } else {
                GoToSource.openSource((Lookup.Provider)MemorySnapshotPanel.this.project, (String)string, (String)string2, (String)string3);
            }
        }

        public void showStacksForClass(int n, int n2, boolean bl) {
            MemorySnapshotPanel.this.displayStacksForClass(n, n2, bl);
        }
    }
}

