/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.connection;

import java.io.File;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.testkit.jarjar.com.google.common.collect.Sets;
import org.gradle.testkit.jarjar.org.gradle.api.Transformer;
import org.gradle.testkit.jarjar.org.gradle.internal.composite.DefaultGradleParticipantBuild;
import org.gradle.testkit.jarjar.org.gradle.internal.composite.GradleParticipantBuild;
import org.gradle.testkit.jarjar.org.gradle.util.CollectionUtils;
import org.gradle.testkit.jarjar.org.gradle.util.GradleVersion;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.connection.GradleConnection;
import org.gradle.tooling.connection.GradleConnectionBuilder;
import org.gradle.tooling.internal.connection.GradleConnectionBuilderInternal;
import org.gradle.tooling.internal.connection.GradleConnectionFactory;
import org.gradle.tooling.internal.consumer.DefaultCompositeConnectionParameters;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.DistributionFactory;

public class DefaultGradleConnectionBuilder
implements GradleConnectionBuilderInternal {
    private final Set<DefaultGradleConnectionParticipantBuilder> participantBuilders = Sets.newLinkedHashSet();
    private final GradleConnectionFactory gradleConnectionFactory;
    private final DistributionFactory distributionFactory;
    private File gradleUserHomeDir;
    private Integer daemonMaxIdleTimeValue;
    private TimeUnit daemonMaxIdleTimeUnits;
    private File daemonBaseDir;

    public DefaultGradleConnectionBuilder(GradleConnectionFactory gradleConnectionFactory, DistributionFactory distributionFactory) {
        this.gradleConnectionFactory = gradleConnectionFactory;
        this.distributionFactory = distributionFactory;
    }

    public GradleConnectionBuilder useGradleUserHomeDir(File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        return this;
    }

    public GradleConnectionBuilder.ParticipantBuilder addParticipant(File projectDirectory) {
        DefaultGradleConnectionParticipantBuilder participantBuilder = new DefaultGradleConnectionParticipantBuilder(projectDirectory);
        this.participantBuilders.add(participantBuilder);
        return participantBuilder;
    }

    public GradleConnection build() throws GradleConnectionException {
        if (this.participantBuilders.isEmpty()) {
            throw new IllegalStateException("At least one participant must be specified before creating a connection.");
        }
        return this.createGradleConnection();
    }

    private GradleConnection createGradleConnection() {
        Set<GradleParticipantBuild> participants = CollectionUtils.collect(this.participantBuilders, new Transformer<GradleParticipantBuild, DefaultGradleConnectionParticipantBuilder>(){

            @Override
            public GradleParticipantBuild transform(DefaultGradleConnectionParticipantBuilder participantBuilder) {
                return participantBuilder.build();
            }
        });
        DefaultCompositeConnectionParameters.Builder compositeConnectionParametersBuilder = DefaultCompositeConnectionParameters.builder();
        compositeConnectionParametersBuilder.setBuilds(participants);
        compositeConnectionParametersBuilder.setGradleUserHomeDir(this.gradleUserHomeDir);
        compositeConnectionParametersBuilder.setDaemonMaxIdleTimeValue(this.daemonMaxIdleTimeValue);
        compositeConnectionParametersBuilder.setDaemonMaxIdleTimeUnits(this.daemonMaxIdleTimeUnits);
        compositeConnectionParametersBuilder.setDaemonBaseDir(this.daemonBaseDir);
        DefaultCompositeConnectionParameters connectionParameters = compositeConnectionParametersBuilder.build();
        Distribution distribution = this.distributionFactory.getDistribution(GradleVersion.current().getVersion());
        return this.gradleConnectionFactory.create(distribution, connectionParameters, false);
    }

    public GradleConnectionBuilderInternal daemonMaxIdleTime(int timeoutValue, TimeUnit timeoutUnits) {
        this.daemonMaxIdleTimeValue = timeoutValue;
        this.daemonMaxIdleTimeUnits = timeoutUnits;
        return this;
    }

    public GradleConnectionBuilderInternal daemonBaseDir(File daemonBaseDir) {
        this.daemonBaseDir = daemonBaseDir;
        return this;
    }

    private class DefaultGradleConnectionParticipantBuilder
    implements GradleConnectionBuilder.ParticipantBuilder {
        private final File projectDir;
        private File gradleHome;
        private URI gradleDistribution;
        private String gradleVersion;

        public DefaultGradleConnectionParticipantBuilder(File projectDir) {
            if (projectDir == null) {
                throw new IllegalArgumentException("Project directory cannot be null.");
            }
            this.projectDir = projectDir;
        }

        public GradleConnectionBuilder.ParticipantBuilder useBuildDistribution() {
            this.resetDistribution();
            return this;
        }

        public GradleConnectionBuilder.ParticipantBuilder useInstallation(File gradleHome) {
            this.resetDistribution();
            this.gradleHome = gradleHome;
            return this;
        }

        public GradleConnectionBuilder.ParticipantBuilder useGradleVersion(String gradleVersion) {
            this.resetDistribution();
            this.gradleVersion = gradleVersion;
            return this;
        }

        public GradleConnectionBuilder.ParticipantBuilder useDistribution(URI gradleDistribution) {
            this.resetDistribution();
            this.gradleDistribution = gradleDistribution;
            return this;
        }

        public GradleParticipantBuild build() {
            return new DefaultGradleParticipantBuild(this.projectDir, this.gradleHome, this.gradleDistribution, this.gradleVersion);
        }

        private void resetDistribution() {
            this.gradleHome = null;
            this.gradleDistribution = null;
            this.gradleVersion = null;
        }
    }
}

