/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationProcessor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArStaticLibraryArchiver
implements Compiler<StaticLibraryArchiverSpec> {
    private final CommandLineToolInvocationWorker commandLineToolInvocationWorker;
    private final ArgsTransformer<StaticLibraryArchiverSpec> argsTransformer = new ArchiverSpecToArguments();
    private final CommandLineToolContext invocationContext;
    private final BuildOperationProcessor buildOperationProcessor;

    ArStaticLibraryArchiver(BuildOperationProcessor buildOperationProcessor, CommandLineToolInvocationWorker commandLineToolInvocationWorker, CommandLineToolContext invocationContext) {
        this.buildOperationProcessor = buildOperationProcessor;
        this.commandLineToolInvocationWorker = commandLineToolInvocationWorker;
        this.invocationContext = invocationContext;
    }

    public WorkResult execute(final StaticLibraryArchiverSpec spec) {
        this.deletePreviousOutput(spec);
        List args = (List)this.argsTransformer.transform(spec);
        this.invocationContext.getArgAction().execute((Object)args);
        final CommandLineToolInvocation invocation = this.invocationContext.createInvocation(String.format("archiving %s", spec.getOutputFile().getName()), args, spec.getOperationLogger());
        this.buildOperationProcessor.run((BuildOperationWorker)this.commandLineToolInvocationWorker, (Action)new Action<BuildOperationQueue<CommandLineToolInvocation>>(){

            public void execute(BuildOperationQueue<CommandLineToolInvocation> buildQueue) {
                buildQueue.setLogLocation(spec.getOperationLogger().getLogLocation());
                buildQueue.add((BuildOperation)invocation);
            }
        });
        return new SimpleWorkResult(true);
    }

    private void deletePreviousOutput(StaticLibraryArchiverSpec spec) {
        if (!spec.getOutputFile().isFile()) {
            return;
        }
        if (!spec.getOutputFile().delete()) {
            throw new GradleException("Create static archive failed: could not delete previous archive");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArchiverSpecToArguments
    implements ArgsTransformer<StaticLibraryArchiverSpec> {
        private ArchiverSpecToArguments() {
        }

        public List<String> transform(StaticLibraryArchiverSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-rcs");
            args.addAll(spec.getAllArgs());
            args.add(spec.getOutputFile().getAbsolutePath());
            for (File file : spec.getObjectFiles()) {
                args.add(file.getAbsolutePath());
            }
            return args;
        }
    }
}

