/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core.rule.describe;

import com.google.common.base.Objects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.specs.Spec;
import org.gradle.model.internal.core.rule.describe.AbstractModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class MethodModelRuleDescriptor
extends AbstractModelRuleDescriptor {
    private static final Interner<MethodModelRuleDescriptor> INTERNER = Interners.newWeakInterner();
    private final WeaklyTypeReferencingMethod<?, ?> method;
    private String description;
    private int hashCode;

    public MethodModelRuleDescriptor(ModelType<?> target, ModelType<?> returnType, Method method) {
        this(WeaklyTypeReferencingMethod.of(target, returnType, method));
    }

    public MethodModelRuleDescriptor(WeaklyTypeReferencingMethod<?, ?> method) {
        this.method = method;
    }

    @Override
    public void describeTo(Appendable appendable) {
        try {
            appendable.append(this.getDescription());
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private String getDescription() {
        if (this.description == null) {
            this.description = STRING_INTERNER.intern(this.getClassName() + "#" + this.method.getName());
        }
        return this.description;
    }

    private String getClassName() {
        return this.method.getDeclaringType().getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodModelRuleDescriptor that = (MethodModelRuleDescriptor)o;
        return Objects.equal(this.method, that.method);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result != 0) {
            return result;
        }
        this.hashCode = result = Objects.hashCode((Object[])new Object[]{this.method});
        return result;
    }

    public static ModelRuleDescriptor of(Class<?> clazz, final String methodName) {
        List methodsOfName = CollectionUtils.filter((Object[])clazz.getDeclaredMethods(), (Spec)new Spec<Method>(){

            public boolean isSatisfiedBy(Method element) {
                return element.getName().equals(methodName);
            }
        });
        if (methodsOfName.isEmpty()) {
            throw new IllegalStateException("Class " + clazz.getName() + " has no method named '" + methodName + "'");
        }
        if (methodsOfName.size() > 1) {
            throw new IllegalStateException("Class " + clazz.getName() + " has more than one method named '" + methodName + "'");
        }
        Method method = (Method)methodsOfName.get(0);
        return MethodModelRuleDescriptor.of(clazz, method);
    }

    public static ModelRuleDescriptor of(Class<?> clazz, Method method) {
        return (ModelRuleDescriptor)INTERNER.intern((Object)new MethodModelRuleDescriptor(ModelType.of(clazz), ModelType.returnType(method), method));
    }

    public static <T, R> ModelRuleDescriptor of(WeaklyTypeReferencingMethod<T, R> method) {
        return (ModelRuleDescriptor)INTERNER.intern((Object)new MethodModelRuleDescriptor(method));
    }
}

