/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.List;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.ModelRuleExecutionException;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.AbstractModelCreationRuleExtractor;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodRuleAction;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmanagedModelCreationRuleExtractor
extends AbstractModelCreationRuleExtractor {
    @Override
    public boolean isSatisfiedBy(MethodRuleDefinition<?, ?> element) {
        return super.isSatisfiedBy(element) && !this.isVoidMethod(element);
    }

    @Override
    protected <R, S> ExtractedModelRule buildRule(ModelPath modelPath, MethodRuleDefinition<R, S> ruleDefinition) {
        return new ExtractedUnmanagedCreationRule<R, S>(modelPath, ruleDefinition);
    }

    @Override
    public String getDescription() {
        return String.format("%s and returning a model element", super.getDescription());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractedUnmanagedCreationRule<R, S>
    extends AbstractModelCreationRuleExtractor.ExtractedCreationRule<R, S> {
        public ExtractedUnmanagedCreationRule(ModelPath modelPath, MethodRuleDefinition<R, S> ruleDefinition) {
            super(modelPath, ruleDefinition);
        }

        @Override
        protected void buildRegistration(MethodModelRuleApplicationContext context, ModelRegistrations.Builder registration) {
            MethodRuleDefinition ruleDefinition = this.getRuleDefinition();
            ModelType modelType = ruleDefinition.getReturnType();
            List<ModelReference<?>> inputs = ruleDefinition.getReferences();
            ModelRuleDescriptor descriptor = ruleDefinition.getDescriptor();
            ModelReference<Object> subjectReference = ModelReference.of(this.modelPath);
            registration.action(ModelActionRole.Create, context.contextualize(new UnmanagedElementCreationAction(descriptor, subjectReference, inputs, modelType)));
            registration.withProjection(new UnmanagedModelProjection(modelType));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmanagedElementCreationAction<T>
    implements MethodRuleAction {
        private final ModelRuleDescriptor descriptor;
        private final ModelReference<?> subject;
        private final ModelType<T> type;
        private final List<ModelReference<?>> inputs;

        private UnmanagedElementCreationAction(ModelRuleDescriptor descriptor, ModelReference<?> subject, List<ModelReference<?>> inputs, ModelType<T> type) {
            this.subject = subject;
            this.inputs = inputs;
            this.descriptor = descriptor;
            this.type = type;
        }

        @Override
        public ModelReference<?> getSubject() {
            return this.subject;
        }

        @Override
        public List<? extends ModelReference<?>> getInputs() {
            return this.inputs;
        }

        @Override
        public void execute(ModelRuleInvoker<?> ruleInvoker, MutableModelNode modelNode, List<ModelView<?>> inputs) {
            Object instance;
            if (inputs.size() == 0) {
                instance = ruleInvoker.invoke(new Object[0]);
            } else {
                Object[] args = new Object[inputs.size()];
                for (int i = 0; i < inputs.size(); ++i) {
                    args[i] = inputs.get(i).getInstance();
                }
                instance = ruleInvoker.invoke(args);
            }
            if (instance == null) {
                throw new ModelRuleExecutionException(this.descriptor, "rule returned null");
            }
            Object value = Cast.uncheckedCast(instance);
            modelNode.setPrivateData(this.type, value);
        }
    }
}

