/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.configuration;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.configuration.JarSignatureFilter;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EnhancedClassloaderProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EnhancedClassloaderProvider.class);
    private static final String MODULES_DIRECTORY = "modules";
    public static final String PDFSAM_MODULES_DIRECTORY = "org.pdfsam.modules.directory";

    private EnhancedClassloaderProvider() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ClassLoader classLoader(ClassLoader classLoader) {
        RequireUtils.requireNotNull(classLoader, "Cannot enhance null class loader");
        try {
            Path modulesPath = Optional.ofNullable(EnhancedClassloaderProvider.getUserSpecifiedModulesPath()).orElse(EnhancedClassloaderProvider.getModulesPath());
            if (!Files.isDirectory(modulesPath, new LinkOption[0])) {
                LOG.info(DefaultI18nContext.getInstance().i18n("Modules directory {0} does not exist", modulesPath.toString()));
                return classLoader;
            }
            LOG.debug(DefaultI18nContext.getInstance().i18n("Loading modules from {0}", modulesPath.toString()));
            try (Stream<Path> files = Files.list(modulesPath);){
                Object[] modules = EnhancedClassloaderProvider.getUrls(files);
                if (modules.length > 0) {
                    LOG.trace(DefaultI18nContext.getInstance().i18n("Found modules jars {0}", Arrays.toString(modules)));
                    ClassLoader classLoader2 = AccessController.doPrivileged(() -> EnhancedClassloaderProvider.lambda$classLoader$0((URL[])modules, classLoader));
                    return classLoader2;
                }
            }
        }
        catch (IOException | URISyntaxException ex) {
            LOG.warn(DefaultI18nContext.getInstance().i18n("Error finding modules paths"), ex);
        }
        LOG.trace(DefaultI18nContext.getInstance().i18n("No module has been found"));
        return classLoader;
    }

    private static URL[] getUrls(Stream<Path> files) throws MalformedURLException {
        Set modules = ((Stream)files.parallel()).filter(new JarSignatureFilter()).map(Path::toUri).collect(Collectors.toSet());
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URI module : modules) {
            urls.add(module.toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static Path getModulesPath() throws URISyntaxException {
        URL jarLocation = EnhancedClassloaderProvider.class.getProtectionDomain().getCodeSource().getLocation();
        if (jarLocation != null) {
            Path jarPath = Paths.get(jarLocation.toURI());
            return Paths.get(jarPath.getParent().toString(), MODULES_DIRECTORY);
        }
        LOG.warn(DefaultI18nContext.getInstance().i18n("Unable to find modules location."));
        return null;
    }

    private static Path getUserSpecifiedModulesPath() {
        String userPath = System.getProperty(PDFSAM_MODULES_DIRECTORY);
        if (StringUtils.isNotBlank(userPath)) {
            LOG.debug("User specified modules location {}", (Object)userPath);
            return Paths.get(userPath, new String[0]);
        }
        return null;
    }

    private static /* synthetic */ URLClassLoader lambda$classLoader$0(URL[] modules, ClassLoader classLoader) {
        return new URLClassLoader(modules, classLoader);
    }
}

