/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.IOException;
import java.util.regex.Pattern;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.input.AbstractXrefStreamParser;
import org.sejda.sambox.input.AbstractXrefTableParser;
import org.sejda.sambox.input.COSParser;
import org.sejda.sambox.xref.XrefEntry;
import org.sejda.sambox.xref.XrefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XrefFullScanner {
    private static final Logger LOG = LoggerFactory.getLogger(XrefFullScanner.class);
    private COSDictionary trailer = new COSDictionary();
    private AbstractXrefStreamParser xrefStreamParser;
    private AbstractXrefTableParser xrefTableParser;
    private COSParser parser;
    private Pattern objectDefPatter = Pattern.compile("^(\\d+)[\\s](\\d+)[\\s]obj");
    private XrefScanOutcome outcome = XrefScanOutcome.NOT_FOUND;

    XrefFullScanner(COSParser parser) {
        this.parser = parser;
        this.xrefStreamParser = new AbstractXrefStreamParser(parser){

            @Override
            void onTrailerFound(COSDictionary found) {
                XrefFullScanner.this.trailer.merge(found);
            }

            @Override
            void onEntryFound(XrefEntry entry) {
                XrefFullScanner.this.addEntryIfValid(entry);
            }
        };
        this.xrefTableParser = new AbstractXrefTableParser(parser){

            @Override
            void onTrailerFound(COSDictionary found) {
                XrefFullScanner.this.trailer.merge(found);
            }

            @Override
            void onEntryFound(XrefEntry entry) {
                XrefFullScanner.this.addEntryIfValid(entry);
            }
        };
    }

    private void addEntryIfValid(XrefEntry entry) {
        if (this.isValidEntry(entry)) {
            this.parser.provider().addEntry(entry);
        } else {
            this.outcome = this.outcome.moveTo(XrefScanOutcome.WITH_ERRORS);
        }
    }

    XrefScanOutcome scan() {
        try {
            this.doScan();
        }
        catch (IOException e) {
            this.outcome = this.outcome.moveTo(XrefScanOutcome.WITH_ERRORS);
            LOG.warn("An error occurred while performing full scan looking for xrefs", e);
        }
        return this.outcome;
    }

    private void doScan() throws IOException {
        LOG.info("Performing full scan looking for xrefs");
        long savedPos = this.parser.position();
        this.parser.position(0L);
        this.parser.skipSpaces();
        while (this.parser.source().peek() != -1) {
            long offset = this.parser.position();
            String line = this.parser.readLine();
            if (line.startsWith("xref")) {
                this.outcome = this.outcome.moveTo(XrefScanOutcome.FOUND);
                this.parseFoundXrefTable(offset);
            }
            if (this.objectDefPatter.matcher(line).find()) {
                this.parseFoundObject(offset);
            }
            this.parser.skipSpaces();
        }
        this.parser.position(savedPos);
    }

    private void parseFoundXrefTable(long offset) throws IOException {
        LOG.debug("Found xref table at " + offset);
        this.xrefTableParser.parse(offset);
    }

    COSDictionary trailer() {
        return this.trailer;
    }

    private void parseFoundObject(long offset) throws IOException {
        this.parser.position(offset);
        this.parser.skipIndirectObjectDefinition();
        this.parser.skipSpaces();
        COSBase found = this.parser.nextParsedToken();
        if (found instanceof COSDictionary && COSName.XREF.equals(((COSDictionary)found).getItem(COSName.TYPE))) {
            LOG.debug("Found xref stream at " + offset);
            this.parseFoundXrefStream((COSDictionary)found);
        }
    }

    private void parseFoundXrefStream(COSDictionary trailer) throws IOException {
        this.outcome = this.outcome.moveTo(XrefScanOutcome.FOUND);
        try (COSStream xrefStream = this.parser.nextStream(trailer);){
            this.xrefStreamParser.onTrailerFound(trailer);
            this.xrefStreamParser.parseStream(xrefStream);
        }
        LOG.debug("Done parsing xref stream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidEntry(XrefEntry entry) {
        if (entry.getType() != XrefType.IN_USE) return true;
        try {
            long origin = this.parser.position();
            try {
                this.parser.position(entry.getByteOffset());
                this.parser.skipIndirectObjectDefinition();
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                LOG.warn("Xref entry points to an invalid object definition {}", (Object)entry);
                return false;
            }
            finally {
                this.parser.position(origin);
            }
        }
        catch (IOException e2) {
            LOG.error("Unable to change source position", e2);
        }
        return false;
    }

    public static enum XrefScanOutcome {
        NOT_FOUND,
        FOUND,
        WITH_ERRORS{

            @Override
            XrefScanOutcome moveTo(XrefScanOutcome newState) {
                return this;
            }
        };


        XrefScanOutcome moveTo(XrefScanOutcome newState) {
            if (newState != NOT_FOUND) {
                return newState;
            }
            return this;
        }
    }
}

