/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.sonatype.maven.polyglot.PolyglotModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ModelProcessor.class, hint="polyglot")
public class PolyglotModelProcessor
implements ModelProcessor {
    @Requirement
    protected Logger log;
    @Requirement
    private PolyglotModelManager manager;

    public File locatePom(File dir) {
        assert (this.manager != null);
        return this.manager.locatePom(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(File input, Map<String, ?> options) throws IOException, ModelParseException {
        Model model;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        try {
            model = this.read(reader, options);
            model.setPomFile(input);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return model;
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException, ModelParseException {
        return this.read(new InputStreamReader(input), options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException, ModelParseException {
        assert (this.manager != null);
        ModelReader reader = this.manager.getReaderFor(options);
        return reader.read(input, options);
    }
}

