/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.eventstudio;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sejda.eventstudio.Station;
import org.sejda.eventstudio.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Stations {
    private static final Logger LOG = LoggerFactory.getLogger(Stations.class);
    private ConcurrentMap<String, Station> stations = new ConcurrentHashMap<String, Station>();

    Stations() {
    }

    Station getStation(String stationName) {
        Station value;
        RequireUtils.requireNotBlank(stationName);
        Station station = (Station)this.stations.get(stationName);
        if (station == null && (station = this.stations.putIfAbsent(stationName, value = new Station(stationName))) == null) {
            station = value;
            LOG.debug("Created station {}", (Object)station);
        }
        return station;
    }

    Collection<Station> getStations() {
        return this.stations.values();
    }

    void clear(String station) {
        LOG.debug("Clearing station {}", (Object)station);
        this.stations.remove(station);
    }
}

