/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.color;

import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.pdmodel.graphics.color.PDCIEDictionaryBasedColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;

public final class PDCalGray
extends PDCIEDictionaryBasedColorSpace {
    private final PDColor initialColor = new PDColor(new float[]{0.0f}, (PDColorSpace)this);

    public PDCalGray() {
        super(COSName.CALGRAY);
    }

    public PDCalGray(COSArray array) {
        super(array);
    }

    @Override
    public String getName() {
        return COSName.CALGRAY.getName();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public float[] getDefaultDecode(int bitsPerComponent) {
        return new float[]{0.0f, 1.0f};
    }

    @Override
    public PDColor getInitialColor() {
        return this.initialColor;
    }

    @Override
    public float[] toRGB(float[] value) {
        if (this.wpX == 1.0f && this.wpY == 1.0f && this.wpZ == 1.0f) {
            float a = value[0];
            float gamma = this.getGamma();
            float powAG = (float)Math.pow(a, gamma);
            return this.convXYZtoRGB(powAG, powAG, powAG);
        }
        return new float[]{value[0], value[0], value[0]};
    }

    public float getGamma() {
        float retval = 1.0f;
        COSNumber gamma = (COSNumber)this.dictionary.getDictionaryObject(COSName.GAMMA);
        if (gamma != null) {
            retval = gamma.floatValue();
        }
        return retval;
    }

    public void setGamma(float value) {
        this.dictionary.setItem(COSName.GAMMA, (COSBase)new COSFloat(value));
    }
}

