/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.io;

import edu.berkeley.nlp.lm.ArrayEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.ArrayEncodedProbBackoffLm;
import edu.berkeley.nlp.lm.ConfigOptions;
import edu.berkeley.nlp.lm.ContextEncodedProbBackoffLm;
import edu.berkeley.nlp.lm.NgramLanguageModel;
import edu.berkeley.nlp.lm.StringWordIndexer;
import edu.berkeley.nlp.lm.StupidBackoffLm;
import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.array.LongArray;
import edu.berkeley.nlp.lm.collections.LongRepresentable;
import edu.berkeley.nlp.lm.io.ArpaLmReader;
import edu.berkeley.nlp.lm.io.ArpaLmReaderCallback;
import edu.berkeley.nlp.lm.io.FirstPassCallback;
import edu.berkeley.nlp.lm.io.GoogleLmReader;
import edu.berkeley.nlp.lm.io.IOUtils;
import edu.berkeley.nlp.lm.io.KneserNeyFileWritingLmReaderCallback;
import edu.berkeley.nlp.lm.io.KneserNeyLmReaderCallback;
import edu.berkeley.nlp.lm.io.LmReader;
import edu.berkeley.nlp.lm.io.NgramMapAddingCallback;
import edu.berkeley.nlp.lm.io.NgramOrderedLmReaderCallback;
import edu.berkeley.nlp.lm.io.TextReader;
import edu.berkeley.nlp.lm.map.AbstractNgramMap;
import edu.berkeley.nlp.lm.map.CompressedNgramMap;
import edu.berkeley.nlp.lm.map.ContextEncodedNgramMap;
import edu.berkeley.nlp.lm.map.HashNgramMap;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.map.NgramMapWrapper;
import edu.berkeley.nlp.lm.util.Logger;
import edu.berkeley.nlp.lm.util.LongRef;
import edu.berkeley.nlp.lm.values.CompressibleProbBackoffValueContainer;
import edu.berkeley.nlp.lm.values.CompressibleValueContainer;
import edu.berkeley.nlp.lm.values.CountValueContainer;
import edu.berkeley.nlp.lm.values.ProbBackoffPair;
import edu.berkeley.nlp.lm.values.ProbBackoffValueContainer;
import edu.berkeley.nlp.lm.values.UncompressedProbBackoffValueContainer;
import edu.berkeley.nlp.lm.values.UnrankedUncompressedProbBackoffValueContainer;
import edu.berkeley.nlp.lm.values.ValueContainer;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class LmReaders {
    public static ContextEncodedProbBackoffLm<String> readContextEncodedLmFromArpa(String lmFile) {
        return LmReaders.readContextEncodedLmFromArpa(lmFile, new StringWordIndexer());
    }

    public static <W> ContextEncodedProbBackoffLm<W> readContextEncodedLmFromArpa(String lmFile, WordIndexer<W> wordIndexer) {
        return LmReaders.readContextEncodedLmFromArpa(lmFile, wordIndexer, new ConfigOptions(), Integer.MAX_VALUE);
    }

    public static <W> ContextEncodedProbBackoffLm<W> readContextEncodedLmFromArpa(String lmFile, WordIndexer<W> wordIndexer, ConfigOptions opts, int lmOrder) {
        return LmReaders.readContextEncodedLmFromArpa(new ArpaLmReader<W>(lmFile, wordIndexer, lmOrder), wordIndexer, opts);
    }

    public static <W> ContextEncodedProbBackoffLm<W> readContextEncodedLmFromArpa(LmReader<ProbBackoffPair, ArpaLmReaderCallback<ProbBackoffPair>> lmFile, WordIndexer<W> wordIndexer, ConfigOptions opts) {
        FirstPassCallback<ProbBackoffPair> valueAddingCallback = LmReaders.firstPassArpa(lmFile, false);
        LongArray[] numNgramsForEachWord = valueAddingCallback.getNumNgramsForEachWord();
        return LmReaders.secondPassContextEncoded(opts, lmFile, wordIndexer, valueAddingCallback, numNgramsForEachWord);
    }

    public static ArrayEncodedProbBackoffLm<String> readArrayEncodedLmFromArpa(String lmFile, boolean compress) {
        return LmReaders.readArrayEncodedLmFromArpa(lmFile, compress, new StringWordIndexer());
    }

    public static <W> ArrayEncodedProbBackoffLm<W> readArrayEncodedLmFromArpa(String lmFile, boolean compress, WordIndexer<W> wordIndexer) {
        return LmReaders.readArrayEncodedLmFromArpa(lmFile, compress, wordIndexer, new ConfigOptions(), Integer.MAX_VALUE);
    }

    public static <W> ArrayEncodedProbBackoffLm<W> readArrayEncodedLmFromArpa(String lmFile, boolean compress, WordIndexer<W> wordIndexer, ConfigOptions opts, int lmOrder) {
        return LmReaders.readArrayEncodedLmFromArpa(new ArpaLmReader<W>(lmFile, wordIndexer, lmOrder), compress, wordIndexer, opts);
    }

    public static <W> ArrayEncodedProbBackoffLm<W> readArrayEncodedLmFromArpa(LmReader<ProbBackoffPair, ArpaLmReaderCallback<ProbBackoffPair>> lmFile, boolean compress, WordIndexer<W> wordIndexer, ConfigOptions opts) {
        boolean reverse = true;
        FirstPassCallback<ProbBackoffPair> valueAddingCallback = LmReaders.firstPassArpa(lmFile, true);
        LongArray[] numNgramsForEachWord = valueAddingCallback.getNumNgramsForEachWord();
        return LmReaders.secondPassArrayEncoded(opts, lmFile, wordIndexer, valueAddingCallback, numNgramsForEachWord, true, compress);
    }

    public static NgramMapWrapper<String, LongRef> readNgramMapFromGoogleNgramDir(String dir, boolean compress) {
        return LmReaders.readNgramMapFromGoogleNgramDir(dir, compress, new StringWordIndexer());
    }

    public static <W> NgramMapWrapper<W, LongRef> readNgramMapFromGoogleNgramDir(String dir, boolean compress, WordIndexer<W> wordIndexer) {
        StupidBackoffLm lm = (StupidBackoffLm)LmReaders.readLmFromGoogleNgramDir(dir, compress, false, wordIndexer, new ConfigOptions());
        return new NgramMapWrapper(lm.getNgramMap(), lm.getWordIndexer());
    }

    public static NgramMapWrapper<String, LongRef> readNgramMapFromBinary(String binary, String vocabFile) {
        return LmReaders.readNgramMapFromBinary(binary, vocabFile, new StringWordIndexer());
    }

    public static <W> NgramMapWrapper<W, LongRef> readNgramMapFromBinary(String binary, String sortedVocabFile, WordIndexer<W> wordIndexer) {
        GoogleLmReader.addToIndexer(wordIndexer, sortedVocabFile);
        wordIndexer.trimAndLock();
        NgramMap map = (NgramMap)IOUtils.readObjFileHard(binary);
        return new NgramMapWrapper(map, wordIndexer);
    }

    public static ArrayEncodedNgramLanguageModel<String> readLmFromGoogleNgramDir(String dir, boolean compress, boolean kneserNey) {
        return LmReaders.readLmFromGoogleNgramDir(dir, compress, kneserNey, new StringWordIndexer(), new ConfigOptions());
    }

    public static <W> ArrayEncodedNgramLanguageModel<W> readLmFromGoogleNgramDir(String dir, boolean compress, boolean kneserNey, WordIndexer<W> wordIndexer, ConfigOptions opts) {
        if (kneserNey) {
            int lmOrder = 5;
            KneserNeyLmReaderCallback<W> kneserNeyReader = new KneserNeyLmReaderCallback<W>(wordIndexer, 5, opts);
            new GoogleLmReader<W>(dir, wordIndexer, opts).parse(kneserNeyReader);
            return LmReaders.readArrayEncodedLmFromArpa(kneserNeyReader, compress, wordIndexer, opts);
        }
        FirstPassCallback<LongRef> valueAddingCallback = LmReaders.firstPassGoogle(dir, wordIndexer, opts);
        LongArray[] numNgramsForEachWord = valueAddingCallback.getNumNgramsForEachWord();
        return LmReaders.secondPassGoogle(opts, new GoogleLmReader<W>(dir, wordIndexer, opts), wordIndexer, valueAddingCallback, numNgramsForEachWord, compress);
    }

    public static <W> ContextEncodedProbBackoffLm<W> readContextEncodedKneserNeyLmFromTextFile(List<String> files, WordIndexer<W> wordIndexer, int lmOrder, ConfigOptions opts) {
        File tmpFile = LmReaders.getTempFile();
        return LmReaders.readContextEncodedKneserNeyLmFromTextFile(files, wordIndexer, lmOrder, opts, tmpFile);
    }

    public static <W> ArrayEncodedProbBackoffLm<W> readKneserNeyLmFromTextFile(List<String> files, WordIndexer<W> wordIndexer, int lmOrder, ConfigOptions opts, boolean compress) {
        File tmpFile = LmReaders.getTempFile();
        return LmReaders.readKneserNeyLmFromTextFile(files, wordIndexer, lmOrder, compress, opts, tmpFile);
    }

    public static <W> ContextEncodedProbBackoffLm<W> readContextEncodedKneserNeyLmFromTextFile(List<String> files, WordIndexer<W> wordIndexer, int lmOrder, ConfigOptions opts, File tmpFile) {
        LmReaders.createKneserNeyLmFromTextFiles(files, wordIndexer, lmOrder, tmpFile, opts);
        return LmReaders.readContextEncodedLmFromArpa(tmpFile.getPath(), wordIndexer, opts, lmOrder);
    }

    public static <W> ArrayEncodedProbBackoffLm<W> readKneserNeyLmFromTextFile(List<String> files, WordIndexer<W> wordIndexer, int lmOrder, boolean compress, ConfigOptions opts, File tmpFile) {
        LmReaders.createKneserNeyLmFromTextFiles(files, wordIndexer, lmOrder, tmpFile, opts);
        return LmReaders.readArrayEncodedLmFromArpa(tmpFile.getPath(), compress, wordIndexer, opts, lmOrder);
    }

    public static <W> void createKneserNeyLmFromTextFiles(List<String> files, WordIndexer<W> wordIndexer, int lmOrder, File arpaOutputFile, ConfigOptions opts) {
        TextReader<W> reader = new TextReader<W>(files, wordIndexer);
        KneserNeyLmReaderCallback<W> kneserNeyReader = new KneserNeyLmReaderCallback<W>(wordIndexer, lmOrder, opts);
        reader.parse(kneserNeyReader);
        kneserNeyReader.parse(new KneserNeyFileWritingLmReaderCallback<W>(arpaOutputFile, wordIndexer));
    }

    public static StupidBackoffLm<String> readGoogleLmBinary(String file, String sortedVocabFile) {
        return LmReaders.readGoogleLmBinary(file, new StringWordIndexer(), sortedVocabFile);
    }

    public static <W> StupidBackoffLm<W> readGoogleLmBinary(String file, WordIndexer<W> wordIndexer, String sortedVocabFile) {
        GoogleLmReader.addToIndexer(wordIndexer, sortedVocabFile);
        wordIndexer.trimAndLock();
        NgramMap map = (NgramMap)IOUtils.readObjFileHard(file);
        return new StupidBackoffLm<W>(map.getMaxNgramOrder(), wordIndexer, map, new ConfigOptions());
    }

    public static <W> NgramLanguageModel<W> readLmBinary(String file) {
        NgramLanguageModel lm = (NgramLanguageModel)IOUtils.readObjFileHard(file);
        return lm;
    }

    public static <W> void writeLmBinary(NgramLanguageModel<W> lm, String file) {
        IOUtils.writeObjFileHard(file, lm);
    }

    private static File getTempFile() {
        try {
            File tmpFile = File.createTempFile("berkeleylm", "arpa");
            tmpFile.deleteOnExit();
            return tmpFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static <W> ContextEncodedProbBackoffLm<W> secondPassContextEncoded(ConfigOptions opts, LmReader<ProbBackoffPair, ArpaLmReaderCallback<ProbBackoffPair>> lmFile, WordIndexer<W> wordIndexer, FirstPassCallback<ProbBackoffPair> valueAddingCallback, LongArray[] numNgramsForEachWord) {
        boolean contextEncoded = true;
        boolean reversed = false;
        boolean compress = false;
        NgramMap<ProbBackoffPair> map = LmReaders.buildMapArpa(opts, lmFile, wordIndexer, valueAddingCallback, numNgramsForEachWord, true, false, false);
        return new ContextEncodedProbBackoffLm<W>(map.getMaxNgramOrder(), wordIndexer, (ContextEncodedNgramMap)map, opts);
    }

    private static <W> ArrayEncodedProbBackoffLm<W> secondPassArrayEncoded(ConfigOptions opts, LmReader<ProbBackoffPair, ArpaLmReaderCallback<ProbBackoffPair>> lmReader, WordIndexer<W> wordIndexer, FirstPassCallback<ProbBackoffPair> valueAddingCallback, LongArray[] numNgramsForEachWord, boolean reversed, boolean compress) {
        boolean contextEncoded = false;
        NgramMap<ProbBackoffPair> map = LmReaders.buildMapArpa(opts, lmReader, wordIndexer, valueAddingCallback, numNgramsForEachWord, false, reversed, compress);
        return new ArrayEncodedProbBackoffLm<W>(map.getMaxNgramOrder(), wordIndexer, map, opts);
    }

    private static <W> StupidBackoffLm<W> secondPassGoogle(ConfigOptions opts, LmReader<LongRef, NgramOrderedLmReaderCallback<LongRef>> lmReader, WordIndexer<W> wordIndexer, FirstPassCallback<LongRef> valueAddingCallback, LongArray[] numNgramsForEachWord, boolean compress) {
        boolean contextEncoded = false;
        boolean reversed = true;
        CountValueContainer values = new CountValueContainer(valueAddingCallback.getValueCounter(), opts.valueRadix, false, new long[numNgramsForEachWord.length]);
        NgramMap<LongRef> map = LmReaders.buildMapCommon(opts, wordIndexer, numNgramsForEachWord, valueAddingCallback.getNumNgramsForEachOrder(), true, lmReader, values, compress);
        return new StupidBackoffLm<W>(numNgramsForEachWord.length, wordIndexer, map, opts);
    }

    private static <W> NgramMap<ProbBackoffPair> buildMapArpa(ConfigOptions opts, LmReader<ProbBackoffPair, ArpaLmReaderCallback<ProbBackoffPair>> lmReader, WordIndexer<W> wordIndexer, FirstPassCallback<ProbBackoffPair> valueAddingCallback, LongArray[] numNgramsForEachWord, boolean contextEncoded, boolean reversed, boolean compress) {
        ProbBackoffValueContainer values;
        ProbBackoffValueContainer probBackoffValueContainer = compress ? new CompressibleProbBackoffValueContainer(valueAddingCallback.getValueCounter(), opts.valueRadix, contextEncoded, valueAddingCallback.getNumNgramsForEachOrder()) : (values = opts.storeRankedProbBackoffs ? new UncompressedProbBackoffValueContainer(valueAddingCallback.getValueCounter(), opts.valueRadix, contextEncoded, valueAddingCallback.getNumNgramsForEachOrder()) : new UnrankedUncompressedProbBackoffValueContainer(contextEncoded, valueAddingCallback.getNumNgramsForEachOrder()));
        if (contextEncoded && compress) {
            throw new RuntimeException("Compression is not supported by context-encoded LMs");
        }
        NgramMap<ProbBackoffPair> map = LmReaders.buildMapCommon(opts, wordIndexer, numNgramsForEachWord, valueAddingCallback.getNumNgramsForEachOrder(), reversed, lmReader, values, compress);
        return map;
    }

    private static <W, V extends Comparable<V>> NgramMap<V> buildMapCommon(ConfigOptions opts, WordIndexer<W> wordIndexer, LongArray[] numNgramsForEachWord, long[] numNgramsForEachOrder, boolean reversed, LmReader<V, ? super NgramMapAddingCallback<V>> lmReader, ValueContainer<V> values, boolean compress) {
        Logger.startTrack("Adding n-grams", new Object[0]);
        AbstractNgramMap<V> map = LmReaders.createNgramMap(opts, numNgramsForEachWord, numNgramsForEachOrder, reversed, values, compress);
        List<int[]> failures = LmReaders.tryBuildingNgramMap(opts, wordIndexer, lmReader, map);
        Logger.endTrack();
        if (!failures.isEmpty()) {
            Logger.startTrack(failures.size() + " missing suffixes or prefixes were found, doing another pass to add n-grams", new Object[0]);
            for (int[] failure : failures) {
                int ngramOrder = failure.length - 1;
                int headWord = failure[reversed ? 0 : ngramOrder];
                int n = ngramOrder;
                numNgramsForEachOrder[n] = numNgramsForEachOrder[n] + 1L;
                numNgramsForEachWord[ngramOrder].incrementCount(headWord, 1L);
            }
            for (int ngramOrder = 0; ngramOrder < numNgramsForEachOrder.length; ++ngramOrder) {
                values.clearStorageForOrder(ngramOrder);
            }
            ValueContainer<V> newValues = values.createFreshValues(numNgramsForEachOrder);
            map.clearStorage();
            map = LmReaders.createNgramMap(opts, numNgramsForEachWord, numNgramsForEachOrder, reversed, newValues, compress);
            lmReader.parse(new NgramMapAddingCallback<V>(map, failures));
            Logger.endTrack();
        }
        return map;
    }

    private static <V, W> List<int[]> tryBuildingNgramMap(ConfigOptions opts, WordIndexer<W> wordIndexer, LmReader<V, ? super NgramMapAddingCallback<V>> lmReader, NgramMap<V> map) {
        NgramMapAddingCallback<V> ngramMapAddingCallback = new NgramMapAddingCallback<V>(map, null);
        lmReader.parse(ngramMapAddingCallback);
        if (opts.lockIndexer) {
            wordIndexer.trimAndLock();
        }
        List<int[]> failures = ngramMapAddingCallback.getFailures();
        return failures;
    }

    private static <V> AbstractNgramMap<V> createNgramMap(ConfigOptions opts, LongArray[] numNgramsForEachWord, long[] numNgramsForEachOrder, boolean reversed, ValueContainer<V> values, boolean compress) {
        return compress ? new CompressedNgramMap((CompressibleValueContainer)values, numNgramsForEachOrder, opts) : HashNgramMap.createImplicitWordHashNgramMap(values, opts, numNgramsForEachWord, reversed);
    }

    private static <W> FirstPassCallback<ProbBackoffPair> firstPassArpa(LmReader<ProbBackoffPair, ArpaLmReaderCallback<ProbBackoffPair>> arpaLmReader, boolean reverse) {
        FirstPassCallback<ProbBackoffPair> valueAddingCallback = LmReaders.firstPassCommon(arpaLmReader, reverse);
        return valueAddingCallback;
    }

    private static <W> FirstPassCallback<LongRef> firstPassGoogle(String rootDir, WordIndexer<W> wordIndexer, ConfigOptions opts) {
        GoogleLmReader<W> arpaLmReader = new GoogleLmReader<W>(rootDir, wordIndexer, opts);
        boolean reverse = true;
        FirstPassCallback<LongRef> valueAddingCallback = LmReaders.firstPassCommon(arpaLmReader, true);
        return valueAddingCallback;
    }

    private static <V extends LongRepresentable<V>> FirstPassCallback<V> firstPassCommon(LmReader<V, ? super FirstPassCallback<V>> arpaLmReader, boolean reverse) {
        Logger.startTrack("Counting values", new Object[0]);
        FirstPassCallback valueAddingCallback = new FirstPassCallback(reverse);
        arpaLmReader.parse(valueAddingCallback);
        Logger.endTrack();
        return valueAddingCallback;
    }
}

